/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.power;

import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.opengl.GLES10;
import android.util.FloatMath;
import android.util.Slog;
import android.view.DisplayInfo;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.SurfaceSession;
import com.android.server.display.DisplayManagerService;
import com.android.server.display.DisplayTransactionListener;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

final class ElectronBeam {
    private static final String TAG = "ElectronBeam";
    private static final boolean DEBUG = false;
    private static final int ELECTRON_BEAM_LAYER = 0x40000001;
    private static final float HSTRETCH_DURATION = 0.5f;
    private static final float VSTRETCH_DURATION = 0.5f;
    private static final int DEJANK_FRAMES = 3;
    private boolean mPrepared;
    private int mMode;
    private final DisplayManagerService mDisplayManager;
    private int mDisplayLayerStack;
    private int mDisplayWidth;
    private int mDisplayHeight;
    private SurfaceSession mSurfaceSession;
    private SurfaceControl mSurfaceControl;
    private Surface mSurface;
    private NaturalSurfaceLayout mSurfaceLayout;
    private EGLDisplay mEglDisplay;
    private EGLConfig mEglConfig;
    private EGLContext mEglContext;
    private EGLSurface mEglSurface;
    private boolean mSurfaceVisible;
    private float mSurfaceAlpha;
    private final int[] mTexNames = new int[1];
    private boolean mTexNamesGenerated;
    private final float[] mTexMatrix = new float[16];
    private final FloatBuffer mVertexBuffer = ElectronBeam.createNativeFloatBuffer(8);
    private final FloatBuffer mTexCoordBuffer = ElectronBeam.createNativeFloatBuffer(8);
    public static final int MODE_WARM_UP = 0;
    public static final int MODE_COOL_DOWN = 1;
    public static final int MODE_FADE = 2;

    public ElectronBeam(DisplayManagerService displayManager) {
        this.mDisplayManager = displayManager;
    }

    public boolean prepare(int mode) {
        this.mMode = mode;
        DisplayInfo displayInfo = this.mDisplayManager.getDisplayInfo(0);
        this.mDisplayLayerStack = displayInfo.layerStack;
        this.mDisplayWidth = displayInfo.getNaturalWidth();
        this.mDisplayHeight = displayInfo.getNaturalHeight();
        if (!this.tryPrepare()) {
            this.dismiss();
            return false;
        }
        this.mPrepared = true;
        if (mode == 1) {
            for (int i = 0; i < 3; ++i) {
                this.draw(1.0f);
            }
        }
        return true;
    }

    private boolean tryPrepare() {
        if (this.createSurface()) {
            if (this.mMode == 2) {
                return true;
            }
            return this.createEglContext() && this.createEglSurface() && this.captureScreenshotTextureAndSetViewport();
        }
        return false;
    }

    public void dismiss() {
        this.destroyScreenshotTexture();
        this.destroyEglSurface();
        this.destroySurface();
        this.mPrepared = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean draw(float level) {
        if (!this.mPrepared) {
            return false;
        }
        if (this.mMode == 2) {
            return this.showSurface(1.0f - level);
        }
        if (!this.attachEglContext()) {
            return false;
        }
        try {
            GLES10.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            GLES10.glClear(16384);
            if (level < 0.5f) {
                this.drawHStretch(1.0f - level / 0.5f);
            } else {
                this.drawVStretch(1.0f - (level - 0.5f) / 0.5f);
            }
            if (ElectronBeam.checkGlErrors("drawFrame")) {
                boolean bl = false;
                return bl;
            }
            EGL14.eglSwapBuffers(this.mEglDisplay, this.mEglSurface);
        }
        finally {
            this.detachEglContext();
        }
        return this.showSurface(1.0f);
    }

    private void drawVStretch(float stretch) {
        float ar = ElectronBeam.scurve(stretch, 7.5f);
        float ag = ElectronBeam.scurve(stretch, 8.0f);
        float ab = ElectronBeam.scurve(stretch, 8.5f);
        GLES10.glBlendFunc(1, 1);
        GLES10.glEnable(3042);
        GLES10.glVertexPointer(2, 5126, 0, this.mVertexBuffer);
        GLES10.glEnableClientState(32884);
        GLES10.glDisable(3553);
        GLES10.glEnable(36197);
        GLES10.glBindTexture(36197, this.mTexNames[0]);
        GLES10.glTexEnvx(8960, 8704, this.mMode == 0 ? 8448 : 7681);
        GLES10.glTexParameterx(36197, 10240, 9729);
        GLES10.glTexParameterx(36197, 10241, 9729);
        GLES10.glTexParameterx(36197, 10242, 33071);
        GLES10.glTexParameterx(36197, 10243, 33071);
        GLES10.glEnable(36197);
        GLES10.glTexCoordPointer(2, 5126, 0, this.mTexCoordBuffer);
        GLES10.glEnableClientState(32888);
        ElectronBeam.setVStretchQuad(this.mVertexBuffer, this.mDisplayWidth, this.mDisplayHeight, ar);
        GLES10.glColorMask(true, false, false, true);
        GLES10.glDrawArrays(6, 0, 4);
        ElectronBeam.setVStretchQuad(this.mVertexBuffer, this.mDisplayWidth, this.mDisplayHeight, ag);
        GLES10.glColorMask(false, true, false, true);
        GLES10.glDrawArrays(6, 0, 4);
        ElectronBeam.setVStretchQuad(this.mVertexBuffer, this.mDisplayWidth, this.mDisplayHeight, ab);
        GLES10.glColorMask(false, false, true, true);
        GLES10.glDrawArrays(6, 0, 4);
        GLES10.glDisable(36197);
        GLES10.glDisableClientState(32888);
        GLES10.glColorMask(true, true, true, true);
        if (this.mMode == 1) {
            GLES10.glColor4f(ag, ag, ag, 1.0f);
            GLES10.glDrawArrays(6, 0, 4);
        }
        GLES10.glDisableClientState(32884);
        GLES10.glDisable(3042);
    }

    private void drawHStretch(float stretch) {
        float ag = ElectronBeam.scurve(stretch, 8.0f);
        if (stretch < 1.0f) {
            GLES10.glVertexPointer(2, 5126, 0, this.mVertexBuffer);
            GLES10.glEnableClientState(32884);
            ElectronBeam.setHStretchQuad(this.mVertexBuffer, this.mDisplayWidth, this.mDisplayHeight, ag);
            GLES10.glColor4f(1.0f - ag * 0.75f, 1.0f - ag * 0.75f, 1.0f - ag * 0.75f, 1.0f);
            GLES10.glDrawArrays(6, 0, 4);
            GLES10.glDisableClientState(32884);
        }
    }

    private static void setVStretchQuad(FloatBuffer vtx, float dw, float dh, float a) {
        float w = dw + dw * a;
        float h = dh - dh * a;
        float x = (dw - w) * 0.5f;
        float y = (dh - h) * 0.5f;
        ElectronBeam.setQuad(vtx, x, y, w, h);
    }

    private static void setHStretchQuad(FloatBuffer vtx, float dw, float dh, float a) {
        float w = 2.0f * dw * (1.0f - a);
        float h = 1.0f;
        float x = (dw - w) * 0.5f;
        float y = (dh - 1.0f) * 0.5f;
        ElectronBeam.setQuad(vtx, x, y, w, 1.0f);
    }

    private static void setQuad(FloatBuffer vtx, float x, float y, float w, float h) {
        vtx.put(0, x);
        vtx.put(1, y);
        vtx.put(2, x);
        vtx.put(3, y + h);
        vtx.put(4, x + w);
        vtx.put(5, y + h);
        vtx.put(6, x + w);
        vtx.put(7, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean captureScreenshotTextureAndSetViewport() {
        if (!this.attachEglContext()) {
            return false;
        }
        try {
            if (!this.mTexNamesGenerated) {
                GLES10.glGenTextures(1, this.mTexNames, 0);
                if (ElectronBeam.checkGlErrors("glGenTextures")) {
                    boolean bl = false;
                    return bl;
                }
                this.mTexNamesGenerated = true;
            }
            SurfaceTexture st = new SurfaceTexture(this.mTexNames[0]);
            Surface s = new Surface(st);
            try {
                SurfaceControl.screenshot(SurfaceControl.getBuiltInDisplay(0), s);
            }
            finally {
                s.release();
            }
            st.updateTexImage();
            st.getTransformMatrix(this.mTexMatrix);
            this.mTexCoordBuffer.put(0, 0.0f);
            this.mTexCoordBuffer.put(1, 0.0f);
            this.mTexCoordBuffer.put(2, 0.0f);
            this.mTexCoordBuffer.put(3, 1.0f);
            this.mTexCoordBuffer.put(4, 1.0f);
            this.mTexCoordBuffer.put(5, 1.0f);
            this.mTexCoordBuffer.put(6, 1.0f);
            this.mTexCoordBuffer.put(7, 0.0f);
            GLES10.glViewport(0, 0, this.mDisplayWidth, this.mDisplayHeight);
            GLES10.glMatrixMode(5889);
            GLES10.glLoadIdentity();
            GLES10.glOrthof(0.0f, this.mDisplayWidth, 0.0f, this.mDisplayHeight, 0.0f, 1.0f);
            GLES10.glMatrixMode(5888);
            GLES10.glLoadIdentity();
            GLES10.glMatrixMode(5890);
            GLES10.glLoadIdentity();
            GLES10.glLoadMatrixf(this.mTexMatrix, 0);
        }
        finally {
            this.detachEglContext();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyScreenshotTexture() {
        if (this.mTexNamesGenerated) {
            this.mTexNamesGenerated = false;
            if (this.attachEglContext()) {
                try {
                    GLES10.glDeleteTextures(1, this.mTexNames, 0);
                    ElectronBeam.checkGlErrors("glDeleteTextures");
                }
                finally {
                    this.detachEglContext();
                }
            }
        }
    }

    private boolean createEglContext() {
        if (this.mEglDisplay == null) {
            this.mEglDisplay = EGL14.eglGetDisplay(0);
            if (this.mEglDisplay == EGL14.EGL_NO_DISPLAY) {
                ElectronBeam.logEglError("eglGetDisplay");
                return false;
            }
            int[] version = new int[2];
            if (!EGL14.eglInitialize(this.mEglDisplay, version, 0, version, 1)) {
                this.mEglDisplay = null;
                ElectronBeam.logEglError("eglInitialize");
                return false;
            }
        }
        if (this.mEglConfig == null) {
            int[] eglConfigAttribList = new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12344};
            EGLConfig[] eglConfigs = new EGLConfig[1];
            int[] numEglConfigs = new int[1];
            if (!EGL14.eglChooseConfig(this.mEglDisplay, eglConfigAttribList, 0, eglConfigs, 0, eglConfigs.length, numEglConfigs, 0)) {
                ElectronBeam.logEglError("eglChooseConfig");
                return false;
            }
            this.mEglConfig = eglConfigs[0];
        }
        if (this.mEglContext == null) {
            int[] eglContextAttribList = new int[]{12344};
            this.mEglContext = EGL14.eglCreateContext(this.mEglDisplay, this.mEglConfig, EGL14.EGL_NO_CONTEXT, eglContextAttribList, 0);
            if (this.mEglContext == null) {
                ElectronBeam.logEglError("eglCreateContext");
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createSurface() {
        if (this.mSurfaceSession == null) {
            this.mSurfaceSession = new SurfaceSession();
        }
        SurfaceControl.openTransaction();
        try {
            if (this.mSurfaceControl == null) {
                try {
                    int flags = this.mMode == 2 ? 131076 : 1028;
                    this.mSurfaceControl = new SurfaceControl(this.mSurfaceSession, TAG, this.mDisplayWidth, this.mDisplayHeight, -1, flags);
                }
                catch (Surface.OutOfResourcesException ex) {
                    Slog.e(TAG, "Unable to create surface.", ex);
                    boolean bl = false;
                    SurfaceControl.closeTransaction();
                    return bl;
                }
            }
            this.mSurfaceControl.setLayerStack(this.mDisplayLayerStack);
            this.mSurfaceControl.setSize(this.mDisplayWidth, this.mDisplayHeight);
            this.mSurface = new Surface();
            this.mSurface.copyFrom(this.mSurfaceControl);
            this.mSurfaceLayout = new NaturalSurfaceLayout(this.mDisplayManager, this.mSurfaceControl);
            this.mSurfaceLayout.onDisplayTransaction();
        }
        finally {
            SurfaceControl.closeTransaction();
        }
        return true;
    }

    private boolean createEglSurface() {
        if (this.mEglSurface == null) {
            int[] eglSurfaceAttribList = new int[]{12344};
            this.mEglSurface = EGL14.eglCreateWindowSurface(this.mEglDisplay, this.mEglConfig, this.mSurface, eglSurfaceAttribList, 0);
            if (this.mEglSurface == null) {
                ElectronBeam.logEglError("eglCreateWindowSurface");
                return false;
            }
        }
        return true;
    }

    private void destroyEglSurface() {
        if (this.mEglSurface != null) {
            if (!EGL14.eglDestroySurface(this.mEglDisplay, this.mEglSurface)) {
                ElectronBeam.logEglError("eglDestroySurface");
            }
            this.mEglSurface = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroySurface() {
        if (this.mSurfaceControl != null) {
            this.mSurfaceLayout.dispose();
            this.mSurfaceLayout = null;
            SurfaceControl.openTransaction();
            try {
                this.mSurfaceControl.destroy();
                this.mSurface.release();
            }
            finally {
                SurfaceControl.closeTransaction();
            }
            this.mSurfaceControl = null;
            this.mSurfaceVisible = false;
            this.mSurfaceAlpha = 0.0f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean showSurface(float alpha) {
        if (!this.mSurfaceVisible || this.mSurfaceAlpha != alpha) {
            SurfaceControl.openTransaction();
            try {
                this.mSurfaceControl.setLayer(0x40000001);
                this.mSurfaceControl.setAlpha(alpha);
                this.mSurfaceControl.show();
            }
            finally {
                SurfaceControl.closeTransaction();
            }
            this.mSurfaceVisible = true;
            this.mSurfaceAlpha = alpha;
        }
        return true;
    }

    private boolean attachEglContext() {
        if (this.mEglSurface == null) {
            return false;
        }
        if (!EGL14.eglMakeCurrent(this.mEglDisplay, this.mEglSurface, this.mEglSurface, this.mEglContext)) {
            ElectronBeam.logEglError("eglMakeCurrent");
            return false;
        }
        return true;
    }

    private void detachEglContext() {
        if (this.mEglDisplay != null) {
            EGL14.eglMakeCurrent(this.mEglDisplay, EGL14.EGL_NO_SURFACE, EGL14.EGL_NO_SURFACE, EGL14.EGL_NO_CONTEXT);
        }
    }

    private static float scurve(float value, float s) {
        float x = value - 0.5f;
        float y = ElectronBeam.sigmoid(x, s) - 0.5f;
        float v = ElectronBeam.sigmoid(0.5f, s) - 0.5f;
        return y / v * 0.5f + 0.5f;
    }

    private static float sigmoid(float x, float s) {
        return 1.0f / (1.0f + FloatMath.exp(-x * s));
    }

    private static FloatBuffer createNativeFloatBuffer(int size) {
        ByteBuffer bb = ByteBuffer.allocateDirect(size * 4);
        bb.order(ByteOrder.nativeOrder());
        return bb.asFloatBuffer();
    }

    private static void logEglError(String func) {
        Slog.e(TAG, func + " failed: error " + EGL14.eglGetError(), new Throwable());
    }

    private static boolean checkGlErrors(String func) {
        return ElectronBeam.checkGlErrors(func, true);
    }

    private static boolean checkGlErrors(String func, boolean log) {
        int error;
        boolean hadError = false;
        while ((error = GLES10.glGetError()) != 0) {
            if (log) {
                Slog.e(TAG, func + " failed: error " + error, new Throwable());
            }
            hadError = true;
        }
        return hadError;
    }

    public void dump(PrintWriter pw) {
        pw.println();
        pw.println("Electron Beam State:");
        pw.println("  mPrepared=" + this.mPrepared);
        pw.println("  mMode=" + this.mMode);
        pw.println("  mDisplayLayerStack=" + this.mDisplayLayerStack);
        pw.println("  mDisplayWidth=" + this.mDisplayWidth);
        pw.println("  mDisplayHeight=" + this.mDisplayHeight);
        pw.println("  mSurfaceVisible=" + this.mSurfaceVisible);
        pw.println("  mSurfaceAlpha=" + this.mSurfaceAlpha);
    }

    private static final class NaturalSurfaceLayout
    implements DisplayTransactionListener {
        private final DisplayManagerService mDisplayManager;
        private SurfaceControl mSurfaceControl;

        public NaturalSurfaceLayout(DisplayManagerService displayManager, SurfaceControl surfaceControl) {
            this.mDisplayManager = displayManager;
            this.mSurfaceControl = surfaceControl;
            this.mDisplayManager.registerDisplayTransactionListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            NaturalSurfaceLayout naturalSurfaceLayout = this;
            synchronized (naturalSurfaceLayout) {
                this.mSurfaceControl = null;
            }
            this.mDisplayManager.unregisterDisplayTransactionListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDisplayTransaction() {
            NaturalSurfaceLayout naturalSurfaceLayout = this;
            synchronized (naturalSurfaceLayout) {
                if (this.mSurfaceControl == null) {
                    return;
                }
                DisplayInfo displayInfo = this.mDisplayManager.getDisplayInfo(0);
                switch (displayInfo.rotation) {
                    case 0: {
                        this.mSurfaceControl.setPosition(0.0f, 0.0f);
                        this.mSurfaceControl.setMatrix(1.0f, 0.0f, 0.0f, 1.0f);
                        break;
                    }
                    case 1: {
                        this.mSurfaceControl.setPosition(0.0f, displayInfo.logicalHeight);
                        this.mSurfaceControl.setMatrix(0.0f, -1.0f, 1.0f, 0.0f);
                        break;
                    }
                    case 2: {
                        this.mSurfaceControl.setPosition(displayInfo.logicalWidth, displayInfo.logicalHeight);
                        this.mSurfaceControl.setMatrix(-1.0f, 0.0f, 0.0f, -1.0f);
                        break;
                    }
                    case 3: {
                        this.mSurfaceControl.setPosition(displayInfo.logicalWidth, 0.0f);
                        this.mSurfaceControl.setMatrix(0.0f, 1.0f, -1.0f, 0.0f);
                    }
                }
            }
        }
    }
}

