/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.pm.PackageUserState;
import android.util.SparseArray;
import com.android.server.pm.GrantedPermissions;
import com.android.server.pm.PackageKeySetData;
import com.android.server.pm.PackageSignatures;
import java.io.File;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PackageSettingBase
extends GrantedPermissions {
    static final int PKG_INSTALL_COMPLETE = 1;
    static final int PKG_INSTALL_INCOMPLETE = 0;
    final String name;
    final String realName;
    File codePath;
    String codePathString;
    File resourcePath;
    String resourcePathString;
    String nativeLibraryPathString;
    long timeStamp;
    long firstInstallTime;
    long lastUpdateTime;
    int versionCode;
    boolean uidError;
    PackageSignatures signatures = new PackageSignatures();
    boolean permissionsFixed;
    boolean haveGids;
    PackageKeySetData keySetData = new PackageKeySetData();
    private static final PackageUserState DEFAULT_USER_STATE = new PackageUserState();
    private final SparseArray<PackageUserState> userState = new SparseArray();
    int installStatus = 1;
    PackageSettingBase origPackage;
    String installerPackageName;

    PackageSettingBase(String name, String realName, File codePath, File resourcePath, String nativeLibraryPathString, int pVersionCode, int pkgFlags) {
        super(pkgFlags);
        this.name = name;
        this.realName = realName;
        this.init(codePath, resourcePath, nativeLibraryPathString, pVersionCode);
    }

    PackageSettingBase(PackageSettingBase base) {
        super(base);
        this.name = base.name;
        this.realName = base.realName;
        this.codePath = base.codePath;
        this.codePathString = base.codePathString;
        this.resourcePath = base.resourcePath;
        this.resourcePathString = base.resourcePathString;
        this.nativeLibraryPathString = base.nativeLibraryPathString;
        this.timeStamp = base.timeStamp;
        this.firstInstallTime = base.firstInstallTime;
        this.lastUpdateTime = base.lastUpdateTime;
        this.versionCode = base.versionCode;
        this.uidError = base.uidError;
        this.signatures = new PackageSignatures(base.signatures);
        this.permissionsFixed = base.permissionsFixed;
        this.haveGids = base.haveGids;
        this.userState.clear();
        for (int i = 0; i < base.userState.size(); ++i) {
            this.userState.put(base.userState.keyAt(i), new PackageUserState(base.userState.valueAt(i)));
        }
        this.installStatus = base.installStatus;
        this.origPackage = base.origPackage;
        this.installerPackageName = base.installerPackageName;
        this.keySetData = new PackageKeySetData(base.keySetData);
    }

    void init(File codePath, File resourcePath, String nativeLibraryPathString, int pVersionCode) {
        this.codePath = codePath;
        this.codePathString = codePath.toString();
        this.resourcePath = resourcePath;
        this.resourcePathString = resourcePath.toString();
        this.nativeLibraryPathString = nativeLibraryPathString;
        this.versionCode = pVersionCode;
    }

    public void setInstallerPackageName(String packageName) {
        this.installerPackageName = packageName;
    }

    String getInstallerPackageName() {
        return this.installerPackageName;
    }

    public void setInstallStatus(int newStatus) {
        this.installStatus = newStatus;
    }

    public int getInstallStatus() {
        return this.installStatus;
    }

    public void setTimeStamp(long newStamp) {
        this.timeStamp = newStamp;
    }

    public void copyFrom(PackageSettingBase base) {
        this.grantedPermissions = base.grantedPermissions;
        this.gids = base.gids;
        this.timeStamp = base.timeStamp;
        this.firstInstallTime = base.firstInstallTime;
        this.lastUpdateTime = base.lastUpdateTime;
        this.signatures = base.signatures;
        this.permissionsFixed = base.permissionsFixed;
        this.haveGids = base.haveGids;
        this.userState.clear();
        for (int i = 0; i < base.userState.size(); ++i) {
            this.userState.put(base.userState.keyAt(i), base.userState.valueAt(i));
        }
        this.installStatus = base.installStatus;
        this.keySetData = base.keySetData;
    }

    private PackageUserState modifyUserState(int userId) {
        PackageUserState state = this.userState.get(userId);
        if (state == null) {
            state = new PackageUserState();
            this.userState.put(userId, state);
        }
        return state;
    }

    public PackageUserState readUserState(int userId) {
        PackageUserState state = this.userState.get(userId);
        if (state != null) {
            return state;
        }
        return DEFAULT_USER_STATE;
    }

    void setEnabled(int state, int userId, String callingPackage) {
        PackageUserState st = this.modifyUserState(userId);
        st.enabled = state;
        st.lastDisableAppCaller = callingPackage;
    }

    int getEnabled(int userId) {
        return this.readUserState((int)userId).enabled;
    }

    String getLastDisabledAppCaller(int userId) {
        return this.readUserState((int)userId).lastDisableAppCaller;
    }

    void setInstalled(boolean inst, int userId) {
        this.modifyUserState((int)userId).installed = inst;
    }

    boolean getInstalled(int userId) {
        return this.readUserState((int)userId).installed;
    }

    boolean isAnyInstalled(int[] users) {
        for (int user : users) {
            if (!this.readUserState((int)user).installed) continue;
            return true;
        }
        return false;
    }

    int[] queryInstalledUsers(int[] users, boolean installed) {
        int num = 0;
        for (int user : users) {
            if (this.getInstalled(user) != installed) continue;
            ++num;
        }
        int[] res = new int[num];
        num = 0;
        for (int user : users) {
            if (this.getInstalled(user) != installed) continue;
            res[num] = user;
            ++num;
        }
        return res;
    }

    boolean getStopped(int userId) {
        return this.readUserState((int)userId).stopped;
    }

    void setStopped(boolean stop, int userId) {
        this.modifyUserState((int)userId).stopped = stop;
    }

    boolean getNotLaunched(int userId) {
        return this.readUserState((int)userId).notLaunched;
    }

    void setNotLaunched(boolean stop, int userId) {
        this.modifyUserState((int)userId).notLaunched = stop;
    }

    boolean getBlocked(int userId) {
        return this.readUserState((int)userId).blocked;
    }

    void setBlocked(boolean blocked, int userId) {
        this.modifyUserState((int)userId).blocked = blocked;
    }

    void setUserState(int userId, int enabled, boolean installed, boolean stopped, boolean notLaunched, boolean blocked, String lastDisableAppCaller, HashSet<String> enabledComponents, HashSet<String> disabledComponents) {
        PackageUserState state = this.modifyUserState(userId);
        state.enabled = enabled;
        state.installed = installed;
        state.stopped = stopped;
        state.notLaunched = notLaunched;
        state.blocked = blocked;
        state.lastDisableAppCaller = lastDisableAppCaller;
        state.enabledComponents = enabledComponents;
        state.disabledComponents = disabledComponents;
    }

    HashSet<String> getEnabledComponents(int userId) {
        return this.readUserState((int)userId).enabledComponents;
    }

    HashSet<String> getDisabledComponents(int userId) {
        return this.readUserState((int)userId).disabledComponents;
    }

    void setEnabledComponents(HashSet<String> components, int userId) {
        this.modifyUserState((int)userId).enabledComponents = components;
    }

    void setDisabledComponents(HashSet<String> components, int userId) {
        this.modifyUserState((int)userId).disabledComponents = components;
    }

    void setEnabledComponentsCopy(HashSet<String> components, int userId) {
        this.modifyUserState((int)userId).enabledComponents = components != null ? new HashSet<String>(components) : null;
    }

    void setDisabledComponentsCopy(HashSet<String> components, int userId) {
        this.modifyUserState((int)userId).disabledComponents = components != null ? new HashSet<String>(components) : null;
    }

    PackageUserState modifyUserStateComponents(int userId, boolean disabled, boolean enabled) {
        PackageUserState state = this.modifyUserState(userId);
        if (disabled && state.disabledComponents == null) {
            state.disabledComponents = new HashSet(1);
        }
        if (enabled && state.enabledComponents == null) {
            state.enabledComponents = new HashSet(1);
        }
        return state;
    }

    void addDisabledComponent(String componentClassName, int userId) {
        this.modifyUserStateComponents((int)userId, (boolean)true, (boolean)false).disabledComponents.add(componentClassName);
    }

    void addEnabledComponent(String componentClassName, int userId) {
        this.modifyUserStateComponents((int)userId, (boolean)false, (boolean)true).enabledComponents.add(componentClassName);
    }

    boolean enableComponentLPw(String componentClassName, int userId) {
        PackageUserState state = this.modifyUserStateComponents(userId, false, true);
        boolean changed = state.disabledComponents != null ? state.disabledComponents.remove(componentClassName) : false;
        return changed |= state.enabledComponents.add(componentClassName);
    }

    boolean disableComponentLPw(String componentClassName, int userId) {
        PackageUserState state = this.modifyUserStateComponents(userId, true, false);
        boolean changed = state.enabledComponents != null ? state.enabledComponents.remove(componentClassName) : false;
        return changed |= state.disabledComponents.add(componentClassName);
    }

    boolean restoreComponentLPw(String componentClassName, int userId) {
        PackageUserState state = this.modifyUserStateComponents(userId, true, true);
        boolean changed = state.disabledComponents != null ? state.disabledComponents.remove(componentClassName) : false;
        return changed |= state.enabledComponents != null ? state.enabledComponents.remove(componentClassName) : false;
    }

    int getCurrentEnabledStateLPr(String componentName, int userId) {
        PackageUserState state = this.readUserState(userId);
        if (state.enabledComponents != null && state.enabledComponents.contains(componentName)) {
            return 1;
        }
        if (state.disabledComponents != null && state.disabledComponents.contains(componentName)) {
            return 2;
        }
        return 0;
    }

    void removeUser(int userId) {
        this.userState.delete(userId);
    }
}

