/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageKeySetData {
    private long[] mSigningKeySets;
    private long[] mDefinedKeySets;
    private final Map<String, Long> mKeySetAliases;

    PackageKeySetData() {
        this.mSigningKeySets = new long[0];
        this.mDefinedKeySets = new long[0];
        this.mKeySetAliases = new HashMap<String, Long>();
    }

    PackageKeySetData(PackageKeySetData original) {
        this.mSigningKeySets = (long[])original.getSigningKeySets().clone();
        this.mDefinedKeySets = (long[])original.getDefinedKeySets().clone();
        this.mKeySetAliases = new HashMap<String, Long>();
        this.mKeySetAliases.putAll(original.getAliases());
    }

    public void addSigningKeySet(long ks) {
        for (long knownKeySet : this.mSigningKeySets) {
            if (ks != knownKeySet) continue;
            return;
        }
        int end = this.mSigningKeySets.length;
        this.mSigningKeySets = Arrays.copyOf(this.mSigningKeySets, end + 1);
        this.mSigningKeySets[end] = ks;
    }

    public void removeSigningKeySet(long ks) {
        if (this.packageIsSignedBy(ks)) {
            long[] keysets = new long[this.mSigningKeySets.length - 1];
            int index = 0;
            for (long signingKeySet : this.mSigningKeySets) {
                if (signingKeySet == ks) continue;
                keysets[index] = signingKeySet;
                ++index;
            }
            this.mSigningKeySets = keysets;
        }
    }

    public void addDefinedKeySet(long ks, String alias) {
        for (long knownKeySet : this.mDefinedKeySets) {
            if (ks != knownKeySet) continue;
            return;
        }
        int end = this.mDefinedKeySets.length;
        this.mDefinedKeySets = Arrays.copyOf(this.mDefinedKeySets, end + 1);
        this.mDefinedKeySets[end] = ks;
        this.mKeySetAliases.put(alias, ks);
    }

    public void removeDefinedKeySet(long ks) {
        if (this.mKeySetAliases.containsValue(ks)) {
            long[] keysets = new long[this.mDefinedKeySets.length - 1];
            int index = 0;
            for (long definedKeySet : this.mDefinedKeySets) {
                if (definedKeySet == ks) continue;
                keysets[index] = definedKeySet;
                ++index;
            }
            this.mDefinedKeySets = keysets;
            for (String alias : this.mKeySetAliases.keySet()) {
                if (this.mKeySetAliases.get(alias) != ks) continue;
                this.mKeySetAliases.remove(alias);
                break;
            }
        }
    }

    public boolean packageIsSignedBy(long ks) {
        for (long signingKeySet : this.mSigningKeySets) {
            if (ks != signingKeySet) continue;
            return true;
        }
        return false;
    }

    public long[] getSigningKeySets() {
        return this.mSigningKeySets;
    }

    public long[] getDefinedKeySets() {
        return this.mDefinedKeySets;
    }

    public Map<String, Long> getAliases() {
        return this.mKeySetAliases;
    }
}

