/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.RemoteException;
import android.os.WorkSource;
import android.util.Log;
import com.android.internal.location.ILocationProvider;
import com.android.internal.location.ProviderProperties;
import com.android.internal.location.ProviderRequest;
import com.android.server.LocationManagerService;
import com.android.server.ServiceWatcher;
import com.android.server.location.LocationProviderInterface;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class LocationProviderProxy
implements LocationProviderInterface {
    private static final String TAG = "LocationProviderProxy";
    private static final boolean D = LocationManagerService.D;
    private final Context mContext;
    private final String mName;
    private final ServiceWatcher mServiceWatcher;
    private Object mLock = new Object();
    private ProviderProperties mProperties;
    private boolean mEnabled = false;
    private ProviderRequest mRequest = null;
    private WorkSource mWorksource = new WorkSource();
    private Runnable mNewServiceWork = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ILocationProvider service;
            WorkSource source;
            ProviderRequest request;
            boolean enabled;
            if (D) {
                Log.d(LocationProviderProxy.TAG, "applying state to connected service");
            }
            ProviderProperties properties = null;
            Object object = LocationProviderProxy.this.mLock;
            synchronized (object) {
                enabled = LocationProviderProxy.this.mEnabled;
                request = LocationProviderProxy.this.mRequest;
                source = LocationProviderProxy.this.mWorksource;
                service = LocationProviderProxy.this.getService();
            }
            if (service == null) {
                return;
            }
            try {
                properties = service.getProperties();
                if (properties == null) {
                    Log.e(LocationProviderProxy.TAG, LocationProviderProxy.this.mServiceWatcher.getBestPackageName() + " has invalid locatino provider properties");
                }
                if (enabled) {
                    service.enable();
                    if (request != null) {
                        service.setRequest(request, source);
                    }
                }
            }
            catch (RemoteException e) {
                Log.w(LocationProviderProxy.TAG, e);
            }
            catch (Exception e) {
                Log.e(LocationProviderProxy.TAG, "Exception from " + LocationProviderProxy.this.mServiceWatcher.getBestPackageName(), e);
            }
            object = LocationProviderProxy.this.mLock;
            synchronized (object) {
                LocationProviderProxy.this.mProperties = properties;
            }
        }
    };

    public static LocationProviderProxy createAndBind(Context context, String name, String action, int overlaySwitchResId, int defaultServicePackageNameResId, int initialPackageNamesResId, Handler handler) {
        LocationProviderProxy proxy = new LocationProviderProxy(context, name, action, overlaySwitchResId, defaultServicePackageNameResId, initialPackageNamesResId, handler);
        if (proxy.bind()) {
            return proxy;
        }
        return null;
    }

    private LocationProviderProxy(Context context, String name, String action, int overlaySwitchResId, int defaultServicePackageNameResId, int initialPackageNamesResId, Handler handler) {
        this.mContext = context;
        this.mName = name;
        this.mServiceWatcher = new ServiceWatcher(this.mContext, "LocationProviderProxy-" + name, action, overlaySwitchResId, defaultServicePackageNameResId, initialPackageNamesResId, this.mNewServiceWork, handler);
    }

    private boolean bind() {
        return this.mServiceWatcher.start();
    }

    private ILocationProvider getService() {
        return ILocationProvider.Stub.asInterface(this.mServiceWatcher.getBinder());
    }

    public String getConnectedPackageName() {
        return this.mServiceWatcher.getBestPackageName();
    }

    public String getName() {
        return this.mName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProviderProperties getProperties() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable() {
        Object object = this.mLock;
        synchronized (object) {
            this.mEnabled = true;
        }
        ILocationProvider service = this.getService();
        if (service == null) {
            return;
        }
        try {
            service.enable();
        }
        catch (RemoteException e) {
            Log.w(TAG, e);
        }
        catch (Exception e) {
            Log.e(TAG, "Exception from " + this.mServiceWatcher.getBestPackageName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        Object object = this.mLock;
        synchronized (object) {
            this.mEnabled = false;
        }
        ILocationProvider service = this.getService();
        if (service == null) {
            return;
        }
        try {
            service.disable();
        }
        catch (RemoteException e) {
            Log.w(TAG, e);
        }
        catch (Exception e) {
            Log.e(TAG, "Exception from " + this.mServiceWatcher.getBestPackageName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequest(ProviderRequest request, WorkSource source) {
        Object object = this.mLock;
        synchronized (object) {
            this.mRequest = request;
            this.mWorksource = source;
        }
        ILocationProvider service = this.getService();
        if (service == null) {
            return;
        }
        try {
            service.setRequest(request, source);
        }
        catch (RemoteException e) {
            Log.w(TAG, e);
        }
        catch (Exception e) {
            Log.e(TAG, "Exception from " + this.mServiceWatcher.getBestPackageName(), e);
        }
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.append("REMOTE SERVICE");
        pw.append(" name=").append(this.mName);
        pw.append(" pkg=").append(this.mServiceWatcher.getBestPackageName());
        pw.append(" version=").append("" + this.mServiceWatcher.getBestVersion());
        pw.append('\n');
        ILocationProvider service = this.getService();
        if (service == null) {
            pw.println("service down (null)");
            return;
        }
        pw.flush();
        try {
            service.asBinder().dump(fd, args);
        }
        catch (RemoteException e) {
            pw.println("service down (RemoteException)");
            Log.w(TAG, e);
        }
        catch (Exception e) {
            pw.println("service down (Exception)");
            Log.e(TAG, "Exception from " + this.mServiceWatcher.getBestPackageName(), e);
        }
    }

    public int getStatus(Bundle extras) {
        ILocationProvider service = this.getService();
        if (service == null) {
            return 1;
        }
        try {
            return service.getStatus(extras);
        }
        catch (RemoteException e) {
            Log.w(TAG, e);
        }
        catch (Exception e) {
            Log.e(TAG, "Exception from " + this.mServiceWatcher.getBestPackageName(), e);
        }
        return 1;
    }

    public long getStatusUpdateTime() {
        ILocationProvider service = this.getService();
        if (service == null) {
            return 0L;
        }
        try {
            return service.getStatusUpdateTime();
        }
        catch (RemoteException e) {
            Log.w(TAG, e);
        }
        catch (Exception e) {
            Log.e(TAG, "Exception from " + this.mServiceWatcher.getBestPackageName(), e);
        }
        return 0L;
    }

    public boolean sendExtraCommand(String command, Bundle extras) {
        ILocationProvider service = this.getService();
        if (service == null) {
            return false;
        }
        try {
            return service.sendExtraCommand(command, extras);
        }
        catch (RemoteException e) {
            Log.w(TAG, e);
        }
        catch (Exception e) {
            Log.e(TAG, "Exception from " + this.mServiceWatcher.getBestPackageName(), e);
        }
        return false;
    }
}

