/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.content.Context;
import android.hardware.location.IFusedLocationHardware;
import android.hardware.location.IFusedLocationHardwareSink;
import android.location.FusedBatchOptions;
import android.os.RemoteException;

public class FusedLocationHardwareSecure
extends IFusedLocationHardware.Stub {
    private final IFusedLocationHardware mLocationHardware;
    private final Context mContext;
    private final String mPermissionId;

    public FusedLocationHardwareSecure(IFusedLocationHardware locationHardware, Context context, String permissionId) {
        this.mLocationHardware = locationHardware;
        this.mContext = context;
        this.mPermissionId = permissionId;
    }

    private void checkPermissions() {
        this.mContext.enforceCallingPermission(this.mPermissionId, String.format("Permission '%s' not granted to access FusedLocationHardware", this.mPermissionId));
    }

    public void registerSink(IFusedLocationHardwareSink eventSink) throws RemoteException {
        this.checkPermissions();
        this.mLocationHardware.registerSink(eventSink);
    }

    public void unregisterSink(IFusedLocationHardwareSink eventSink) throws RemoteException {
        this.checkPermissions();
        this.mLocationHardware.unregisterSink(eventSink);
    }

    public int getSupportedBatchSize() throws RemoteException {
        this.checkPermissions();
        return this.mLocationHardware.getSupportedBatchSize();
    }

    public void startBatching(int id2, FusedBatchOptions batchOptions) throws RemoteException {
        this.checkPermissions();
        this.mLocationHardware.startBatching(id2, batchOptions);
    }

    public void stopBatching(int id2) throws RemoteException {
        this.checkPermissions();
        this.mLocationHardware.stopBatching(id2);
    }

    public void updateBatchingOptions(int id2, FusedBatchOptions batchoOptions) throws RemoteException {
        this.checkPermissions();
        this.mLocationHardware.updateBatchingOptions(id2, batchoOptions);
    }

    public void requestBatchOfLocations(int batchSizeRequested) throws RemoteException {
        this.checkPermissions();
        this.mLocationHardware.requestBatchOfLocations(batchSizeRequested);
    }

    public boolean supportsDiagnosticDataInjection() throws RemoteException {
        this.checkPermissions();
        return this.mLocationHardware.supportsDiagnosticDataInjection();
    }

    public void injectDiagnosticData(String data) throws RemoteException {
        this.checkPermissions();
        this.mLocationHardware.injectDiagnosticData(data);
    }

    public boolean supportsDeviceContextInjection() throws RemoteException {
        this.checkPermissions();
        return this.mLocationHardware.supportsDeviceContextInjection();
    }

    public void injectDeviceContext(int deviceEnabledContext) throws RemoteException {
        this.checkPermissions();
        this.mLocationHardware.injectDeviceContext(deviceEnabledContext);
    }
}

