/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display;

import android.content.Context;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.SystemProperties;
import android.util.SparseArray;
import android.view.DisplayEventReceiver;
import android.view.SurfaceControl;
import com.android.server.display.DisplayAdapter;
import com.android.server.display.DisplayDevice;
import com.android.server.display.DisplayDeviceInfo;
import com.android.server.display.DisplayManagerService;
import java.io.PrintWriter;

final class LocalDisplayAdapter
extends DisplayAdapter {
    private static final String TAG = "LocalDisplayAdapter";
    private static final int[] BUILT_IN_DISPLAY_IDS_TO_SCAN = new int[]{0, 1};
    private final SparseArray<LocalDisplayDevice> mDevices = new SparseArray();
    private HotplugDisplayEventReceiver mHotplugReceiver;
    private final SurfaceControl.PhysicalDisplayInfo mTempPhys = new SurfaceControl.PhysicalDisplayInfo();

    public LocalDisplayAdapter(DisplayManagerService.SyncRoot syncRoot, Context context, Handler handler, DisplayAdapter.Listener listener) {
        super(syncRoot, context, handler, listener, TAG);
    }

    public void registerLocked() {
        super.registerLocked();
        this.mHotplugReceiver = new HotplugDisplayEventReceiver(this.getHandler().getLooper());
        for (int builtInDisplayId : BUILT_IN_DISPLAY_IDS_TO_SCAN) {
            this.tryConnectDisplayLocked(builtInDisplayId);
        }
    }

    private void tryConnectDisplayLocked(int builtInDisplayId) {
        IBinder displayToken = SurfaceControl.getBuiltInDisplay(builtInDisplayId);
        if (displayToken != null && SurfaceControl.getDisplayInfo(displayToken, this.mTempPhys)) {
            LocalDisplayDevice device = this.mDevices.get(builtInDisplayId);
            if (device == null) {
                device = new LocalDisplayDevice(displayToken, builtInDisplayId, this.mTempPhys);
                this.mDevices.put(builtInDisplayId, device);
                this.sendDisplayDeviceEventLocked(device, 1);
            } else if (device.updatePhysicalDisplayInfoLocked(this.mTempPhys)) {
                this.sendDisplayDeviceEventLocked(device, 2);
            }
        }
    }

    private void tryDisconnectDisplayLocked(int builtInDisplayId) {
        LocalDisplayDevice device = this.mDevices.get(builtInDisplayId);
        if (device != null) {
            this.mDevices.remove(builtInDisplayId);
            this.sendDisplayDeviceEventLocked(device, 3);
        }
    }

    private final class HotplugDisplayEventReceiver
    extends DisplayEventReceiver {
        public HotplugDisplayEventReceiver(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onHotplug(long timestampNanos, int builtInDisplayId, boolean connected) {
            DisplayManagerService.SyncRoot syncRoot = LocalDisplayAdapter.this.getSyncRoot();
            synchronized (syncRoot) {
                if (connected) {
                    LocalDisplayAdapter.this.tryConnectDisplayLocked(builtInDisplayId);
                } else {
                    LocalDisplayAdapter.this.tryDisconnectDisplayLocked(builtInDisplayId);
                }
            }
        }
    }

    private final class LocalDisplayDevice
    extends DisplayDevice {
        private final int mBuiltInDisplayId;
        private final SurfaceControl.PhysicalDisplayInfo mPhys;
        private DisplayDeviceInfo mInfo;
        private boolean mHavePendingChanges;
        private boolean mBlanked;

        public LocalDisplayDevice(IBinder displayToken, int builtInDisplayId, SurfaceControl.PhysicalDisplayInfo phys) {
            super(LocalDisplayAdapter.this, displayToken);
            this.mBuiltInDisplayId = builtInDisplayId;
            this.mPhys = new SurfaceControl.PhysicalDisplayInfo(phys);
        }

        public boolean updatePhysicalDisplayInfoLocked(SurfaceControl.PhysicalDisplayInfo phys) {
            if (!this.mPhys.equals(phys)) {
                this.mPhys.copyFrom(phys);
                this.mHavePendingChanges = true;
                return true;
            }
            return false;
        }

        public void applyPendingDisplayDeviceInfoChangesLocked() {
            if (this.mHavePendingChanges) {
                this.mInfo = null;
                this.mHavePendingChanges = false;
            }
        }

        public DisplayDeviceInfo getDisplayDeviceInfoLocked() {
            if (this.mInfo == null) {
                this.mInfo = new DisplayDeviceInfo();
                this.mInfo.width = this.mPhys.width;
                this.mInfo.height = this.mPhys.height;
                this.mInfo.refreshRate = this.mPhys.refreshRate;
                if (this.mPhys.secure) {
                    this.mInfo.flags = 12;
                }
                if (this.mBuiltInDisplayId == 0) {
                    this.mInfo.name = LocalDisplayAdapter.this.getContext().getResources().getString(17040713);
                    this.mInfo.flags |= 3;
                    this.mInfo.type = 1;
                    this.mInfo.densityDpi = (int)(this.mPhys.density * 160.0f + 0.5f);
                    this.mInfo.xDpi = this.mPhys.xDpi;
                    this.mInfo.yDpi = this.mPhys.yDpi;
                    this.mInfo.touch = 1;
                } else {
                    this.mInfo.type = 2;
                    this.mInfo.flags |= 0x40;
                    this.mInfo.name = LocalDisplayAdapter.this.getContext().getResources().getString(17040714);
                    this.mInfo.touch = 2;
                    this.mInfo.setAssumedDensityForExternalDisplay(this.mPhys.width, this.mPhys.height);
                    if ("portrait".equals(SystemProperties.get("persist.demo.hdmirotation"))) {
                        this.mInfo.rotation = 3;
                    }
                }
            }
            return this.mInfo;
        }

        public void blankLocked() {
            this.mBlanked = true;
            SurfaceControl.blankDisplay(this.getDisplayTokenLocked());
        }

        public void unblankLocked() {
            this.mBlanked = false;
            SurfaceControl.unblankDisplay(this.getDisplayTokenLocked());
        }

        public void dumpLocked(PrintWriter pw) {
            super.dumpLocked(pw);
            pw.println("mBuiltInDisplayId=" + this.mBuiltInDisplayId);
            pw.println("mPhys=" + this.mPhys);
            pw.println("mBlanked=" + this.mBlanked);
        }
    }
}

