/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.UriPermission;
import java.util.HashSet;
import java.util.Iterator;

final class UriPermissionOwner {
    final ActivityManagerService service;
    final Object owner;
    Binder externalToken;
    HashSet<UriPermission> readUriPermissions;
    HashSet<UriPermission> writeUriPermissions;

    UriPermissionOwner(ActivityManagerService _service, Object _owner) {
        this.service = _service;
        this.owner = _owner;
    }

    Binder getExternalTokenLocked() {
        if (this.externalToken == null) {
            this.externalToken = new ExternalToken();
        }
        return this.externalToken;
    }

    static UriPermissionOwner fromExternalToken(IBinder token) {
        if (token instanceof ExternalToken) {
            return ((ExternalToken)token).getOwner();
        }
        return null;
    }

    void removeUriPermissionsLocked() {
        this.removeUriPermissionsLocked(3);
    }

    void removeUriPermissionsLocked(int mode) {
        if ((mode & 1) != 0 && this.readUriPermissions != null) {
            for (UriPermission perm : this.readUriPermissions) {
                perm.removeReadOwner(this);
                this.service.removeUriPermissionIfNeededLocked(perm);
            }
            this.readUriPermissions = null;
        }
        if ((mode & 2) != 0 && this.writeUriPermissions != null) {
            for (UriPermission perm : this.writeUriPermissions) {
                perm.removeWriteOwner(this);
                this.service.removeUriPermissionIfNeededLocked(perm);
            }
            this.writeUriPermissions = null;
        }
    }

    void removeUriPermissionLocked(Uri uri, int mode) {
        UriPermission perm;
        Iterator<UriPermission> it;
        if ((mode & 1) != 0 && this.readUriPermissions != null) {
            it = this.readUriPermissions.iterator();
            while (it.hasNext()) {
                perm = it.next();
                if (!uri.equals(perm.uri)) continue;
                perm.removeReadOwner(this);
                this.service.removeUriPermissionIfNeededLocked(perm);
                it.remove();
            }
            if (this.readUriPermissions.size() == 0) {
                this.readUriPermissions = null;
            }
        }
        if ((mode & 2) != 0 && this.writeUriPermissions != null) {
            it = this.writeUriPermissions.iterator();
            while (it.hasNext()) {
                perm = it.next();
                if (!uri.equals(perm.uri)) continue;
                perm.removeWriteOwner(this);
                this.service.removeUriPermissionIfNeededLocked(perm);
                it.remove();
            }
            if (this.writeUriPermissions.size() == 0) {
                this.writeUriPermissions = null;
            }
        }
    }

    public void addReadPermission(UriPermission perm) {
        if (this.readUriPermissions == null) {
            this.readUriPermissions = new HashSet();
        }
        this.readUriPermissions.add(perm);
    }

    public void addWritePermission(UriPermission perm) {
        if (this.writeUriPermissions == null) {
            this.writeUriPermissions = new HashSet();
        }
        this.writeUriPermissions.add(perm);
    }

    public void removeReadPermission(UriPermission perm) {
        this.readUriPermissions.remove(perm);
        if (this.readUriPermissions.size() == 0) {
            this.readUriPermissions = null;
        }
    }

    public void removeWritePermission(UriPermission perm) {
        this.writeUriPermissions.remove(perm);
        if (this.writeUriPermissions.size() == 0) {
            this.writeUriPermissions = null;
        }
    }

    public String toString() {
        return this.owner.toString();
    }

    class ExternalToken
    extends Binder {
        ExternalToken() {
        }

        UriPermissionOwner getOwner() {
            return UriPermissionOwner.this;
        }
    }
}

