/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Bundle;
import android.provider.Settings;
import android.util.Log;
import com.android.server.am.ActivityManagerService;
import java.util.HashMap;
import java.util.Map;

final class CoreSettingsObserver
extends ContentObserver {
    private static final String LOG_TAG = CoreSettingsObserver.class.getSimpleName();
    private static final Map<String, Class<?>> sCoreSettingToTypeMap = new HashMap();
    private final Bundle mCoreSettings = new Bundle();
    private final ActivityManagerService mActivityManagerService;

    public CoreSettingsObserver(ActivityManagerService activityManagerService) {
        super(activityManagerService.mHandler);
        this.mActivityManagerService = activityManagerService;
        this.beginObserveCoreSettings();
        this.sendCoreSettings();
    }

    public Bundle getCoreSettingsLocked() {
        return (Bundle)this.mCoreSettings.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChange(boolean selfChange) {
        ActivityManagerService activityManagerService = this.mActivityManagerService;
        synchronized (activityManagerService) {
            this.sendCoreSettings();
        }
    }

    private void sendCoreSettings() {
        this.populateCoreSettings(this.mCoreSettings);
        this.mActivityManagerService.onCoreSettingsChange(this.mCoreSettings);
    }

    private void beginObserveCoreSettings() {
        for (String setting : sCoreSettingToTypeMap.keySet()) {
            Uri uri = Settings.Secure.getUriFor(setting);
            this.mActivityManagerService.mContext.getContentResolver().registerContentObserver(uri, false, this);
        }
    }

    private void populateCoreSettings(Bundle snapshot) {
        Context context = this.mActivityManagerService.mContext;
        for (Map.Entry<String, Class<?>> entry : sCoreSettingToTypeMap.entrySet()) {
            String setting = entry.getKey();
            Class<?> type = entry.getValue();
            try {
                if (type == String.class) {
                    String value = Settings.Secure.getString(context.getContentResolver(), setting);
                    snapshot.putString(setting, value);
                    continue;
                }
                if (type == Integer.TYPE) {
                    int value = Settings.Secure.getInt(context.getContentResolver(), setting);
                    snapshot.putInt(setting, value);
                    continue;
                }
                if (type == Float.TYPE) {
                    float value = Settings.Secure.getFloat(context.getContentResolver(), setting);
                    snapshot.putFloat(setting, value);
                    continue;
                }
                if (type != Long.TYPE) continue;
                long value = Settings.Secure.getLong(context.getContentResolver(), setting);
                snapshot.putLong(setting, value);
            }
            catch (Settings.SettingNotFoundException snfe) {
                Log.w(LOG_TAG, "Cannot find setting \"" + setting + "\"", snfe);
            }
        }
    }

    static {
        sCoreSettingToTypeMap.put("long_press_timeout", Integer.TYPE);
    }
}

