/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.LinkCapabilities;
import android.net.LinkProperties;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.UserHandle;
import android.telephony.CellInfo;
import android.telephony.CellLocation;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.text.TextUtils;
import com.android.internal.app.IBatteryStats;
import com.android.internal.telephony.DefaultPhoneNotifier;
import com.android.internal.telephony.IPhoneStateListener;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.server.am.BatteryStatsService;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TelephonyRegistry
extends ITelephonyRegistry.Stub {
    private static final String TAG = "TelephonyRegistry";
    private static final boolean DBG = false;
    private static final boolean DBG_LOC = false;
    private final Context mContext;
    private final ArrayList<IBinder> mRemoveList = new ArrayList();
    private final ArrayList<Record> mRecords = new ArrayList();
    private final IBatteryStats mBatteryStats;
    private int mCallState = 0;
    private String mCallIncomingNumber = "";
    private ServiceState mServiceState = new ServiceState();
    private SignalStrength mSignalStrength = new SignalStrength();
    private boolean mMessageWaiting = false;
    private boolean mCallForwarding = false;
    private int mDataActivity = 0;
    private int mDataConnectionState = -1;
    private boolean mDataConnectionPossible = false;
    private String mDataConnectionReason = "";
    private String mDataConnectionApn = "";
    private ArrayList<String> mConnectedApns;
    private LinkProperties mDataConnectionLinkProperties;
    private LinkCapabilities mDataConnectionLinkCapabilities;
    private Bundle mCellLocation = new Bundle();
    private int mDataConnectionNetworkType;
    private int mOtaspMode = 1;
    private List<CellInfo> mCellInfo = null;
    static final int PHONE_STATE_PERMISSION_MASK = 236;
    private static final int MSG_USER_SWITCHED = 1;
    private final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    TelephonyRegistry.this.notifyCellLocation(TelephonyRegistry.this.mCellLocation);
                }
            }
        }
    };
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.USER_SWITCHED".equals(action)) {
                TelephonyRegistry.this.mHandler.sendMessage(TelephonyRegistry.this.mHandler.obtainMessage(1, intent.getIntExtra("android.intent.extra.user_handle", 0), 0));
            }
        }
    };

    TelephonyRegistry(Context context) {
        CellLocation location = CellLocation.getEmpty();
        if (location != null) {
            location.fillInNotifierBundle(this.mCellLocation);
        }
        this.mContext = context;
        this.mBatteryStats = BatteryStatsService.getService();
        this.mConnectedApns = new ArrayList();
    }

    public void systemRunning() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.USER_SWITCHED");
        filter.addAction("android.intent.action.USER_REMOVED");
        this.mContext.registerReceiver(this.mBroadcastReceiver, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void listen(String pkgForDebug, IPhoneStateListener callback, int events, boolean notifyNow) {
        int callerUid = UserHandle.getCallingUserId();
        int myUid = UserHandle.myUserId();
        if (events != 0) {
            this.checkListenerPermission(events);
            ArrayList<Record> arrayList = this.mRecords;
            synchronized (arrayList) {
                Record r;
                block40: {
                    r = null;
                    IBinder b = callback.asBinder();
                    int N = this.mRecords.size();
                    for (int i = 0; i < N; ++i) {
                        r = this.mRecords.get(i);
                        if (b != r.binder) {
                            continue;
                        }
                        break block40;
                    }
                    r = new Record();
                    r.binder = b;
                    r.callback = callback;
                    r.pkgForDebug = pkgForDebug;
                    r.callerUid = callerUid;
                    this.mRecords.add(r);
                }
                int send = events & (events ^ r.events);
                r.events = events;
                if (notifyNow) {
                    if ((events & 1) != 0) {
                        try {
                            r.callback.onServiceStateChanged(new ServiceState(this.mServiceState));
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 2) != 0) {
                        try {
                            int gsmSignalStrength = this.mSignalStrength.getGsmSignalStrength();
                            r.callback.onSignalStrengthChanged(gsmSignalStrength == 99 ? -1 : gsmSignalStrength);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 4) != 0) {
                        try {
                            r.callback.onMessageWaitingIndicatorChanged(this.mMessageWaiting);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 8) != 0) {
                        try {
                            r.callback.onCallForwardingIndicatorChanged(this.mCallForwarding);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if (this.validateEventsAndUserLocked(r, 16)) {
                        try {
                            r.callback.onCellLocationChanged(new Bundle(this.mCellLocation));
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x20) != 0) {
                        try {
                            r.callback.onCallStateChanged(this.mCallState, this.mCallIncomingNumber);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x40) != 0) {
                        try {
                            r.callback.onDataConnectionStateChanged(this.mDataConnectionState, this.mDataConnectionNetworkType);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x80) != 0) {
                        try {
                            r.callback.onDataActivity(this.mDataActivity);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x100) != 0) {
                        try {
                            r.callback.onSignalStrengthsChanged(this.mSignalStrength);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x200) != 0) {
                        try {
                            r.callback.onOtaspChanged(this.mOtaspMode);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if (this.validateEventsAndUserLocked(r, 1024)) {
                        try {
                            r.callback.onCellInfoChanged(this.mCellInfo);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                }
            }
        }
        this.remove(callback.asBinder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(IBinder binder) {
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            int recordCount = this.mRecords.size();
            for (int i = 0; i < recordCount; ++i) {
                if (this.mRecords.get((int)i).binder != binder) continue;
                this.mRecords.remove(i);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyCallState(int state, String incomingNumber) {
        if (!this.checkNotifyPermission("notifyCallState()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            this.mCallState = state;
            this.mCallIncomingNumber = incomingNumber;
            for (Record r : this.mRecords) {
                if ((r.events & 0x20) == 0) continue;
                try {
                    r.callback.onCallStateChanged(state, incomingNumber);
                }
                catch (RemoteException ex) {
                    this.mRemoveList.add(r.binder);
                }
            }
            this.handleRemoveListLocked();
        }
        this.broadcastCallStateChanged(state, incomingNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyServiceState(ServiceState state) {
        if (!this.checkNotifyPermission("notifyServiceState()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            this.mServiceState = state;
            for (Record r : this.mRecords) {
                if ((r.events & 1) == 0) continue;
                try {
                    r.callback.onServiceStateChanged(new ServiceState(state));
                }
                catch (RemoteException ex) {
                    this.mRemoveList.add(r.binder);
                }
            }
            this.handleRemoveListLocked();
        }
        this.broadcastServiceStateChanged(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifySignalStrength(SignalStrength signalStrength) {
        if (!this.checkNotifyPermission("notifySignalStrength()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            this.mSignalStrength = signalStrength;
            for (Record r : this.mRecords) {
                if ((r.events & 0x100) != 0) {
                    try {
                        r.callback.onSignalStrengthsChanged(new SignalStrength(signalStrength));
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
                if ((r.events & 2) == 0) continue;
                try {
                    int gsmSignalStrength = signalStrength.getGsmSignalStrength();
                    r.callback.onSignalStrengthChanged(gsmSignalStrength == 99 ? -1 : gsmSignalStrength);
                }
                catch (RemoteException ex) {
                    this.mRemoveList.add(r.binder);
                }
            }
            this.handleRemoveListLocked();
        }
        this.broadcastSignalStrengthChanged(signalStrength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyCellInfo(List<CellInfo> cellInfo) {
        if (!this.checkNotifyPermission("notifyCellInfo()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            this.mCellInfo = cellInfo;
            for (Record r : this.mRecords) {
                if (!this.validateEventsAndUserLocked(r, 1024)) continue;
                try {
                    r.callback.onCellInfoChanged(cellInfo);
                }
                catch (RemoteException ex) {
                    this.mRemoveList.add(r.binder);
                }
            }
            this.handleRemoveListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyMessageWaitingChanged(boolean mwi) {
        if (!this.checkNotifyPermission("notifyMessageWaitingChanged()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            this.mMessageWaiting = mwi;
            for (Record r : this.mRecords) {
                if ((r.events & 4) == 0) continue;
                try {
                    r.callback.onMessageWaitingIndicatorChanged(mwi);
                }
                catch (RemoteException ex) {
                    this.mRemoveList.add(r.binder);
                }
            }
            this.handleRemoveListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyCallForwardingChanged(boolean cfi) {
        if (!this.checkNotifyPermission("notifyCallForwardingChanged()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            this.mCallForwarding = cfi;
            for (Record r : this.mRecords) {
                if ((r.events & 8) == 0) continue;
                try {
                    r.callback.onCallForwardingIndicatorChanged(cfi);
                }
                catch (RemoteException ex) {
                    this.mRemoveList.add(r.binder);
                }
            }
            this.handleRemoveListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyDataActivity(int state) {
        if (!this.checkNotifyPermission("notifyDataActivity()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            this.mDataActivity = state;
            for (Record r : this.mRecords) {
                if ((r.events & 0x80) == 0) continue;
                try {
                    r.callback.onDataActivity(state);
                }
                catch (RemoteException ex) {
                    this.mRemoveList.add(r.binder);
                }
            }
            this.handleRemoveListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyDataConnection(int state, boolean isDataConnectivityPossible, String reason, String apn, String apnType, LinkProperties linkProperties, LinkCapabilities linkCapabilities, int networkType, boolean roaming) {
        if (!this.checkNotifyPermission("notifyDataConnection()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            boolean modified = false;
            if (state == 2) {
                if (!this.mConnectedApns.contains(apnType)) {
                    this.mConnectedApns.add(apnType);
                    if (this.mDataConnectionState != state) {
                        this.mDataConnectionState = state;
                        modified = true;
                    }
                }
            } else if (this.mConnectedApns.remove(apnType) && this.mConnectedApns.isEmpty()) {
                this.mDataConnectionState = state;
                modified = true;
            }
            this.mDataConnectionPossible = isDataConnectivityPossible;
            this.mDataConnectionReason = reason;
            this.mDataConnectionLinkProperties = linkProperties;
            this.mDataConnectionLinkCapabilities = linkCapabilities;
            if (this.mDataConnectionNetworkType != networkType) {
                this.mDataConnectionNetworkType = networkType;
                modified = true;
            }
            if (modified) {
                for (Record r : this.mRecords) {
                    if ((r.events & 0x40) == 0) continue;
                    try {
                        r.callback.onDataConnectionStateChanged(this.mDataConnectionState, this.mDataConnectionNetworkType);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
                this.handleRemoveListLocked();
            }
        }
        this.broadcastDataConnectionStateChanged(state, isDataConnectivityPossible, reason, apn, apnType, linkProperties, linkCapabilities, roaming);
    }

    @Override
    public void notifyDataConnectionFailed(String reason, String apnType) {
        if (!this.checkNotifyPermission("notifyDataConnectionFailed()")) {
            return;
        }
        this.broadcastDataConnectionFailed(reason, apnType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyCellLocation(Bundle cellLocation) {
        if (!this.checkNotifyPermission("notifyCellLocation()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            this.mCellLocation = cellLocation;
            for (Record r : this.mRecords) {
                if (!this.validateEventsAndUserLocked(r, 16)) continue;
                try {
                    r.callback.onCellLocationChanged(new Bundle(cellLocation));
                }
                catch (RemoteException ex) {
                    this.mRemoveList.add(r.binder);
                }
            }
            this.handleRemoveListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOtaspChanged(int otaspMode) {
        if (!this.checkNotifyPermission("notifyOtaspChanged()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            this.mOtaspMode = otaspMode;
            for (Record r : this.mRecords) {
                if ((r.events & 0x200) == 0) continue;
                try {
                    r.callback.onOtaspChanged(otaspMode);
                }
                catch (RemoteException ex) {
                    this.mRemoveList.add(r.binder);
                }
            }
            this.handleRemoveListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump telephony.registry from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            int recordCount = this.mRecords.size();
            pw.println("last known state:");
            pw.println("  mCallState=" + this.mCallState);
            pw.println("  mCallIncomingNumber=" + this.mCallIncomingNumber);
            pw.println("  mServiceState=" + this.mServiceState);
            pw.println("  mSignalStrength=" + this.mSignalStrength);
            pw.println("  mMessageWaiting=" + this.mMessageWaiting);
            pw.println("  mCallForwarding=" + this.mCallForwarding);
            pw.println("  mDataActivity=" + this.mDataActivity);
            pw.println("  mDataConnectionState=" + this.mDataConnectionState);
            pw.println("  mDataConnectionPossible=" + this.mDataConnectionPossible);
            pw.println("  mDataConnectionReason=" + this.mDataConnectionReason);
            pw.println("  mDataConnectionApn=" + this.mDataConnectionApn);
            pw.println("  mDataConnectionLinkProperties=" + this.mDataConnectionLinkProperties);
            pw.println("  mDataConnectionLinkCapabilities=" + this.mDataConnectionLinkCapabilities);
            pw.println("  mCellLocation=" + this.mCellLocation);
            pw.println("  mCellInfo=" + this.mCellInfo);
            pw.println("registrations: count=" + recordCount);
            for (Record r : this.mRecords) {
                pw.println("  " + r.pkgForDebug + " 0x" + Integer.toHexString(r.events));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void broadcastServiceStateChanged(ServiceState state) {
        block4: {
            long ident = Binder.clearCallingIdentity();
            try {
                try {
                    this.mBatteryStats.notePhoneState(state.getState());
                }
                catch (RemoteException re) {
                    Object var6_4 = null;
                    Binder.restoreCallingIdentity(ident);
                    break block4;
                }
                Object var6_3 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
        }
        Intent intent = new Intent("android.intent.action.SERVICE_STATE");
        Bundle data = new Bundle();
        state.fillInNotifierBundle(data);
        intent.putExtras(data);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void broadcastSignalStrengthChanged(SignalStrength signalStrength) {
        block4: {
            long ident = Binder.clearCallingIdentity();
            try {
                try {
                    this.mBatteryStats.notePhoneSignalStrength(signalStrength);
                }
                catch (RemoteException e) {
                    Object var6_4 = null;
                    Binder.restoreCallingIdentity(ident);
                    break block4;
                }
                Object var6_3 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
        }
        Intent intent = new Intent("android.intent.action.SIG_STR");
        intent.addFlags(0x20000000);
        Bundle data = new Bundle();
        signalStrength.fillInNotifierBundle(data);
        intent.putExtras(data);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void broadcastCallStateChanged(int state, String incomingNumber) {
        block8: {
            long ident = Binder.clearCallingIdentity();
            try {
                try {
                    if (state == 0) {
                        this.mBatteryStats.notePhoneOff();
                    } else {
                        this.mBatteryStats.notePhoneOn();
                    }
                }
                catch (RemoteException e) {
                    Object var7_5 = null;
                    Binder.restoreCallingIdentity(ident);
                    break block8;
                }
                Object var7_4 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
        }
        Intent intent = new Intent("android.intent.action.PHONE_STATE");
        intent.putExtra("state", DefaultPhoneNotifier.convertCallState(state).toString());
        if (!TextUtils.isEmpty(incomingNumber)) {
            intent.putExtra("incoming_number", incomingNumber);
        }
        this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL, "android.permission.READ_PHONE_STATE");
    }

    private void broadcastDataConnectionStateChanged(int state, boolean isDataConnectivityPossible, String reason, String apn, String apnType, LinkProperties linkProperties, LinkCapabilities linkCapabilities, boolean roaming) {
        Intent intent = new Intent("android.intent.action.ANY_DATA_STATE");
        intent.putExtra("state", DefaultPhoneNotifier.convertDataState(state).toString());
        if (!isDataConnectivityPossible) {
            intent.putExtra("networkUnvailable", true);
        }
        if (reason != null) {
            intent.putExtra("reason", reason);
        }
        if (linkProperties != null) {
            intent.putExtra("linkProperties", linkProperties);
            String iface = linkProperties.getInterfaceName();
            if (iface != null) {
                intent.putExtra("iface", iface);
            }
        }
        if (linkCapabilities != null) {
            intent.putExtra("linkCapabilities", linkCapabilities);
        }
        if (roaming) {
            intent.putExtra("networkRoaming", true);
        }
        intent.putExtra("apn", apn);
        intent.putExtra("apnType", apnType);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    private void broadcastDataConnectionFailed(String reason, String apnType) {
        Intent intent = new Intent("android.intent.action.DATA_CONNECTION_FAILED");
        intent.putExtra("reason", reason);
        intent.putExtra("apnType", apnType);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    private boolean checkNotifyPermission(String method) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE") == 0) {
            return true;
        }
        String msg = "Modify Phone State Permission Denial: " + method + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid();
        return false;
    }

    private void checkListenerPermission(int events) {
        if ((events & 0x10) != 0) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_COARSE_LOCATION", null);
        }
        if ((events & 0x400) != 0) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_COARSE_LOCATION", null);
        }
        if ((events & 0xEC) != 0) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PHONE_STATE", null);
        }
    }

    private void handleRemoveListLocked() {
        if (this.mRemoveList.size() > 0) {
            for (IBinder b : this.mRemoveList) {
                this.remove(b);
            }
            this.mRemoveList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateEventsAndUserLocked(Record r, int events) {
        long callingIdentity = Binder.clearCallingIdentity();
        boolean valid = false;
        try {
            int foregroundUser = ActivityManager.getCurrentUser();
            valid = r.callerUid == foregroundUser && (r.events & events) != 0;
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            Binder.restoreCallingIdentity(callingIdentity);
            throw throwable;
        }
        Binder.restoreCallingIdentity(callingIdentity);
        return valid;
    }

    private static class Record {
        String pkgForDebug;
        IBinder binder;
        IPhoneStateListener callback;
        int callerUid;
        int events;

        private Record() {
        }

        public String toString() {
            return "{pkgForDebug=" + this.pkgForDebug + " callerUid=" + this.callerUid + " events=" + Integer.toHexString(this.events) + "}";
        }
    }
}

