/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.ContentObserver;
import android.net.nsd.DnsSdTxtRecord;
import android.net.nsd.INsdManager;
import android.net.nsd.NsdServiceInfo;
import android.os.Binder;
import android.os.Message;
import android.os.Messenger;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.util.AsyncChannel;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import com.android.server.INativeDaemonConnectorCallbacks;
import com.android.server.NativeDaemonConnector;
import com.android.server.NativeDaemonConnectorException;
import com.android.server.NativeDaemonEvent;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;

public class NsdService
extends INsdManager.Stub {
    private static final String TAG = "NsdService";
    private static final String MDNS_TAG = "mDnsConnector";
    private static final boolean DBG = true;
    private Context mContext;
    private ContentResolver mContentResolver;
    private NsdStateMachine mNsdStateMachine;
    private HashMap<Messenger, ClientInfo> mClients = new HashMap();
    private SparseArray<ClientInfo> mIdToClientInfoMap = new SparseArray();
    private AsyncChannel mReplyChannel = new AsyncChannel();
    private int INVALID_ID = 0;
    private int mUniqueId = 1;
    private static final int BASE = 393216;
    private static final int CMD_TO_STRING_COUNT = 19;
    private static String[] sCmdToString = new String[19];
    private NativeDaemonConnector mNativeConnector;
    private final CountDownLatch mNativeDaemonConnected = new CountDownLatch(1);

    private static String cmdToString(int cmd) {
        if ((cmd -= 393216) >= 0 && cmd < sCmdToString.length) {
            return sCmdToString[cmd];
        }
        return null;
    }

    private NsdService(Context context) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        this.mNativeConnector = new NativeDaemonConnector(new NativeCallbackReceiver(), "mdns", 10, MDNS_TAG, 25);
        this.mNsdStateMachine = new NsdStateMachine(TAG);
        this.mNsdStateMachine.start();
        Thread th = new Thread((Runnable)this.mNativeConnector, MDNS_TAG);
        th.start();
    }

    public static NsdService create(Context context) throws InterruptedException {
        NsdService service = new NsdService(context);
        service.mNativeDaemonConnected.await();
        return service;
    }

    public Messenger getMessenger() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INTERNET", TAG);
        return new Messenger(this.mNsdStateMachine.getHandler());
    }

    public void setEnabled(boolean enable) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        Settings.Global.putInt(this.mContentResolver, "nsd_on", enable ? 1 : 0);
        if (enable) {
            this.mNsdStateMachine.sendMessage(393240);
        } else {
            this.mNsdStateMachine.sendMessage(393241);
        }
    }

    private void sendNsdStateChangeBroadcast(boolean enabled) {
        Intent intent = new Intent("android.net.nsd.STATE_CHANGED");
        intent.addFlags(0x4000000);
        if (enabled) {
            intent.putExtra("nsd_state", 2);
        } else {
            intent.putExtra("nsd_state", 1);
        }
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    private boolean isNsdEnabled() {
        boolean ret = Settings.Global.getInt(this.mContentResolver, "nsd_on", 1) == 1;
        Slog.d(TAG, "Network service discovery enabled " + ret);
        return ret;
    }

    private int getUniqueId() {
        if (++this.mUniqueId == this.INVALID_ID) {
            return ++this.mUniqueId;
        }
        return this.mUniqueId;
    }

    private boolean startMDnsDaemon() {
        Slog.d(TAG, "startMDnsDaemon");
        try {
            this.mNativeConnector.execute("mdnssd", "start-service");
        }
        catch (NativeDaemonConnectorException e) {
            Slog.e(TAG, "Failed to start daemon" + e);
            return false;
        }
        return true;
    }

    private boolean stopMDnsDaemon() {
        Slog.d(TAG, "stopMDnsDaemon");
        try {
            this.mNativeConnector.execute("mdnssd", "stop-service");
        }
        catch (NativeDaemonConnectorException e) {
            Slog.e(TAG, "Failed to start daemon" + e);
            return false;
        }
        return true;
    }

    private boolean registerService(int regId, NsdServiceInfo service) {
        Slog.d(TAG, "registerService: " + regId + " " + service);
        try {
            this.mNativeConnector.execute("mdnssd", "register", regId, service.getServiceName(), service.getServiceType(), service.getPort());
        }
        catch (NativeDaemonConnectorException e) {
            Slog.e(TAG, "Failed to execute registerService " + e);
            return false;
        }
        return true;
    }

    private boolean unregisterService(int regId) {
        Slog.d(TAG, "unregisterService: " + regId);
        try {
            this.mNativeConnector.execute("mdnssd", "stop-register", regId);
        }
        catch (NativeDaemonConnectorException e) {
            Slog.e(TAG, "Failed to execute unregisterService " + e);
            return false;
        }
        return true;
    }

    private boolean updateService(int regId, DnsSdTxtRecord t) {
        Slog.d(TAG, "updateService: " + regId + " " + t);
        try {
            if (t == null) {
                return false;
            }
            this.mNativeConnector.execute("mdnssd", "update", regId, t.size(), t.getRawData());
        }
        catch (NativeDaemonConnectorException e) {
            Slog.e(TAG, "Failed to updateServices " + e);
            return false;
        }
        return true;
    }

    private boolean discoverServices(int discoveryId, String serviceType) {
        Slog.d(TAG, "discoverServices: " + discoveryId + " " + serviceType);
        try {
            this.mNativeConnector.execute("mdnssd", "discover", discoveryId, serviceType);
        }
        catch (NativeDaemonConnectorException e) {
            Slog.e(TAG, "Failed to discoverServices " + e);
            return false;
        }
        return true;
    }

    private boolean stopServiceDiscovery(int discoveryId) {
        Slog.d(TAG, "stopServiceDiscovery: " + discoveryId);
        try {
            this.mNativeConnector.execute("mdnssd", "stop-discover", discoveryId);
        }
        catch (NativeDaemonConnectorException e) {
            Slog.e(TAG, "Failed to stopServiceDiscovery " + e);
            return false;
        }
        return true;
    }

    private boolean resolveService(int resolveId, NsdServiceInfo service) {
        Slog.d(TAG, "resolveService: " + resolveId + " " + service);
        try {
            this.mNativeConnector.execute("mdnssd", "resolve", resolveId, service.getServiceName(), service.getServiceType(), "local.");
        }
        catch (NativeDaemonConnectorException e) {
            Slog.e(TAG, "Failed to resolveService " + e);
            return false;
        }
        return true;
    }

    private boolean stopResolveService(int resolveId) {
        Slog.d(TAG, "stopResolveService: " + resolveId);
        try {
            this.mNativeConnector.execute("mdnssd", "stop-resolve", resolveId);
        }
        catch (NativeDaemonConnectorException e) {
            Slog.e(TAG, "Failed to stop resolve " + e);
            return false;
        }
        return true;
    }

    private boolean getAddrInfo(int resolveId, String hostname) {
        Slog.d(TAG, "getAdddrInfo: " + resolveId);
        try {
            this.mNativeConnector.execute("mdnssd", "getaddrinfo", resolveId, hostname);
        }
        catch (NativeDaemonConnectorException e) {
            Slog.e(TAG, "Failed to getAddrInfo " + e);
            return false;
        }
        return true;
    }

    private boolean stopGetAddrInfo(int resolveId) {
        Slog.d(TAG, "stopGetAdddrInfo: " + resolveId);
        try {
            this.mNativeConnector.execute("mdnssd", "stop-getaddrinfo", resolveId);
        }
        catch (NativeDaemonConnectorException e) {
            Slog.e(TAG, "Failed to stopGetAddrInfo " + e);
            return false;
        }
        return true;
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump ServiceDiscoverService from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        for (ClientInfo client : this.mClients.values()) {
            pw.println("Client Info");
            pw.println(client);
        }
        this.mNsdStateMachine.dump(fd, pw, args);
    }

    private Message obtainMessage(Message srcMsg) {
        Message msg = Message.obtain();
        msg.arg2 = srcMsg.arg2;
        return msg;
    }

    private void replyToMessage(Message msg, int what) {
        if (msg.replyTo == null) {
            return;
        }
        Message dstMsg = this.obtainMessage(msg);
        dstMsg.what = what;
        this.mReplyChannel.replyToMessage(msg, dstMsg);
    }

    private void replyToMessage(Message msg, int what, int arg1) {
        if (msg.replyTo == null) {
            return;
        }
        Message dstMsg = this.obtainMessage(msg);
        dstMsg.what = what;
        dstMsg.arg1 = arg1;
        this.mReplyChannel.replyToMessage(msg, dstMsg);
    }

    private void replyToMessage(Message msg, int what, Object obj) {
        if (msg.replyTo == null) {
            return;
        }
        Message dstMsg = this.obtainMessage(msg);
        dstMsg.what = what;
        dstMsg.obj = obj;
        this.mReplyChannel.replyToMessage(msg, dstMsg);
    }

    static {
        NsdService.sCmdToString[1] = "DISCOVER";
        NsdService.sCmdToString[6] = "STOP-DISCOVER";
        NsdService.sCmdToString[9] = "REGISTER";
        NsdService.sCmdToString[12] = "UNREGISTER";
        NsdService.sCmdToString[18] = "RESOLVE";
    }

    private class ClientInfo {
        private static final int MAX_LIMIT = 10;
        private final AsyncChannel mChannel;
        private final Messenger mMessenger;
        private NsdServiceInfo mResolvedService;
        private SparseArray<Integer> mClientIds = new SparseArray();

        private ClientInfo(AsyncChannel c, Messenger m) {
            this.mChannel = c;
            this.mMessenger = m;
            Slog.d(NsdService.TAG, "New client, channel: " + c + " messenger: " + m);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("mChannel ").append(this.mChannel).append("\n");
            sb.append("mMessenger ").append(this.mMessenger).append("\n");
            sb.append("mResolvedService ").append(this.mResolvedService).append("\n");
            for (int i = 0; i < this.mClientIds.size(); ++i) {
                sb.append("clientId ").append(this.mClientIds.keyAt(i));
                sb.append(" mDnsId ").append(this.mClientIds.valueAt(i)).append("\n");
            }
            return sb.toString();
        }
    }

    class NativeCallbackReceiver
    implements INativeDaemonConnectorCallbacks {
        NativeCallbackReceiver() {
        }

        public void onDaemonConnected() {
            NsdService.this.mNativeDaemonConnected.countDown();
        }

        public boolean onEvent(int code, String raw2, String[] cooked) {
            NativeEvent event = new NativeEvent(code, raw2);
            NsdService.this.mNsdStateMachine.sendMessage(393242, event);
            return true;
        }
    }

    private class NativeEvent {
        final int code;
        final String raw;

        NativeEvent(int code, String raw2) {
            this.code = code;
            this.raw = raw2;
        }
    }

    class NativeResponseCode {
        public static final int SERVICE_DISCOVERY_FAILED = 602;
        public static final int SERVICE_FOUND = 603;
        public static final int SERVICE_LOST = 604;
        public static final int SERVICE_REGISTRATION_FAILED = 605;
        public static final int SERVICE_REGISTERED = 606;
        public static final int SERVICE_RESOLUTION_FAILED = 607;
        public static final int SERVICE_RESOLVED = 608;
        public static final int SERVICE_UPDATED = 609;
        public static final int SERVICE_UPDATE_FAILED = 610;
        public static final int SERVICE_GET_ADDR_FAILED = 611;
        public static final int SERVICE_GET_ADDR_SUCCESS = 612;

        NativeResponseCode() {
        }
    }

    private class NsdStateMachine
    extends StateMachine {
        private final DefaultState mDefaultState;
        private final DisabledState mDisabledState;
        private final EnabledState mEnabledState;

        protected String getWhatToString(int what) {
            return NsdService.cmdToString(what);
        }

        private void registerForNsdSetting() {
            ContentObserver contentObserver = new ContentObserver(this.getHandler()){

                public void onChange(boolean selfChange) {
                    if (NsdService.this.isNsdEnabled()) {
                        NsdService.this.mNsdStateMachine.sendMessage(393240);
                    } else {
                        NsdService.this.mNsdStateMachine.sendMessage(393241);
                    }
                }
            };
            NsdService.this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("nsd_on"), false, contentObserver);
        }

        NsdStateMachine(String name) {
            super(name);
            this.mDefaultState = new DefaultState();
            this.mDisabledState = new DisabledState();
            this.mEnabledState = new EnabledState();
            this.addState(this.mDefaultState);
            this.addState(this.mDisabledState, this.mDefaultState);
            this.addState(this.mEnabledState, this.mDefaultState);
            if (NsdService.this.isNsdEnabled()) {
                this.setInitialState(this.mEnabledState);
            } else {
                this.setInitialState(this.mDisabledState);
            }
            this.setLogRecSize(25);
            this.registerForNsdSetting();
        }

        class EnabledState
        extends State {
            EnabledState() {
            }

            public void enter() {
                NsdService.this.sendNsdStateChangeBroadcast(true);
                if (NsdService.this.mClients.size() > 0) {
                    NsdService.this.startMDnsDaemon();
                }
            }

            public void exit() {
                if (NsdService.this.mClients.size() > 0) {
                    NsdService.this.stopMDnsDaemon();
                }
            }

            private boolean requestLimitReached(ClientInfo clientInfo) {
                if (clientInfo.mClientIds.size() >= 10) {
                    Slog.d(NsdService.TAG, "Exceeded max outstanding requests " + clientInfo);
                    return true;
                }
                return false;
            }

            private void storeRequestMap(int clientId, int globalId, ClientInfo clientInfo) {
                clientInfo.mClientIds.put(clientId, globalId);
                NsdService.this.mIdToClientInfoMap.put(globalId, clientInfo);
            }

            private void removeRequestMap(int clientId, int globalId, ClientInfo clientInfo) {
                clientInfo.mClientIds.remove(clientId);
                NsdService.this.mIdToClientInfoMap.remove(globalId);
            }

            public boolean processMessage(Message msg) {
                boolean result = true;
                switch (msg.what) {
                    case 69632: {
                        if (msg.arg1 == 0 && NsdService.this.mClients.size() == 0) {
                            NsdService.this.startMDnsDaemon();
                        }
                        result = false;
                        break;
                    }
                    case 69636: {
                        if (NsdService.this.mClients.size() == 1) {
                            NsdService.this.stopMDnsDaemon();
                        }
                        result = false;
                        break;
                    }
                    case 393241: {
                        NsdStateMachine.this.transitionTo(NsdStateMachine.this.mDisabledState);
                        break;
                    }
                    case 393217: {
                        Slog.d(NsdService.TAG, "Discover services");
                        NsdServiceInfo servInfo = (NsdServiceInfo)msg.obj;
                        ClientInfo clientInfo = (ClientInfo)NsdService.this.mClients.get(msg.replyTo);
                        if (this.requestLimitReached(clientInfo)) {
                            NsdService.this.replyToMessage(msg, 393219, 4);
                            break;
                        }
                        int id2 = NsdService.this.getUniqueId();
                        if (NsdService.this.discoverServices(id2, servInfo.getServiceType())) {
                            Slog.d(NsdService.TAG, "Discover " + msg.arg2 + " " + id2 + servInfo.getServiceType());
                            this.storeRequestMap(msg.arg2, id2, clientInfo);
                            NsdService.this.replyToMessage(msg, 393218, servInfo);
                            break;
                        }
                        NsdService.this.stopServiceDiscovery(id2);
                        NsdService.this.replyToMessage(msg, 393219, 0);
                        break;
                    }
                    case 393222: {
                        int id2;
                        Slog.d(NsdService.TAG, "Stop service discovery");
                        ClientInfo clientInfo = (ClientInfo)NsdService.this.mClients.get(msg.replyTo);
                        try {
                            id2 = (Integer)clientInfo.mClientIds.get(msg.arg2);
                        }
                        catch (NullPointerException e) {
                            NsdService.this.replyToMessage(msg, 393223, 0);
                            break;
                        }
                        this.removeRequestMap(msg.arg2, id2, clientInfo);
                        if (NsdService.this.stopServiceDiscovery(id2)) {
                            NsdService.this.replyToMessage(msg, 393224);
                            break;
                        }
                        NsdService.this.replyToMessage(msg, 393223, 0);
                        break;
                    }
                    case 393225: {
                        Slog.d(NsdService.TAG, "Register service");
                        ClientInfo clientInfo = (ClientInfo)NsdService.this.mClients.get(msg.replyTo);
                        if (this.requestLimitReached(clientInfo)) {
                            NsdService.this.replyToMessage(msg, 393226, 4);
                            break;
                        }
                        int id2 = NsdService.this.getUniqueId();
                        if (NsdService.this.registerService(id2, (NsdServiceInfo)msg.obj)) {
                            Slog.d(NsdService.TAG, "Register " + msg.arg2 + " " + id2);
                            this.storeRequestMap(msg.arg2, id2, clientInfo);
                            break;
                        }
                        NsdService.this.unregisterService(id2);
                        NsdService.this.replyToMessage(msg, 393226, 0);
                        break;
                    }
                    case 393228: {
                        int id2;
                        Slog.d(NsdService.TAG, "unregister service");
                        ClientInfo clientInfo = (ClientInfo)NsdService.this.mClients.get(msg.replyTo);
                        try {
                            id2 = (Integer)clientInfo.mClientIds.get(msg.arg2);
                        }
                        catch (NullPointerException e) {
                            NsdService.this.replyToMessage(msg, 393229, 0);
                            break;
                        }
                        this.removeRequestMap(msg.arg2, id2, clientInfo);
                        if (NsdService.this.unregisterService(id2)) {
                            NsdService.this.replyToMessage(msg, 393230);
                            break;
                        }
                        NsdService.this.replyToMessage(msg, 393229, 0);
                        break;
                    }
                    case 393234: {
                        Slog.d(NsdService.TAG, "Resolve service");
                        NsdServiceInfo servInfo = (NsdServiceInfo)msg.obj;
                        ClientInfo clientInfo = (ClientInfo)NsdService.this.mClients.get(msg.replyTo);
                        if (clientInfo.mResolvedService != null) {
                            NsdService.this.replyToMessage(msg, 393235, 3);
                            break;
                        }
                        int id2 = NsdService.this.getUniqueId();
                        if (NsdService.this.resolveService(id2, servInfo)) {
                            clientInfo.mResolvedService = new NsdServiceInfo();
                            this.storeRequestMap(msg.arg2, id2, clientInfo);
                            break;
                        }
                        NsdService.this.replyToMessage(msg, 393235, 0);
                        break;
                    }
                    case 393242: {
                        NativeEvent event = (NativeEvent)msg.obj;
                        if (this.handleNativeEvent(event.code, event.raw, NativeDaemonEvent.unescapeArgs(event.raw))) break;
                        result = false;
                        break;
                    }
                    default: {
                        result = false;
                    }
                }
                return result;
            }

            private boolean handleNativeEvent(int code, String raw2, String[] cooked) {
                boolean handled = true;
                int id2 = Integer.parseInt(cooked[1]);
                ClientInfo clientInfo = (ClientInfo)NsdService.this.mIdToClientInfoMap.get(id2);
                if (clientInfo == null) {
                    Slog.e(NsdService.TAG, "Unique id with no client mapping: " + id2);
                    handled = false;
                    return handled;
                }
                int clientId = -1;
                int keyId = clientInfo.mClientIds.indexOfValue(id2);
                if (keyId == -1) {
                    Slog.d(NsdService.TAG, "Notification for a listener that is no longer active: " + id2);
                    handled = false;
                    return handled;
                }
                clientId = clientInfo.mClientIds.keyAt(keyId);
                switch (code) {
                    case 603: {
                        Slog.d(NsdService.TAG, "SERVICE_FOUND Raw: " + raw2);
                        NsdServiceInfo servInfo = new NsdServiceInfo(cooked[2], cooked[3], null);
                        clientInfo.mChannel.sendMessage(393220, 0, clientId, servInfo);
                        break;
                    }
                    case 604: {
                        Slog.d(NsdService.TAG, "SERVICE_LOST Raw: " + raw2);
                        NsdServiceInfo servInfo = new NsdServiceInfo(cooked[2], cooked[3], null);
                        clientInfo.mChannel.sendMessage(393221, 0, clientId, servInfo);
                        break;
                    }
                    case 602: {
                        Slog.d(NsdService.TAG, "SERVICE_DISC_FAILED Raw: " + raw2);
                        clientInfo.mChannel.sendMessage(393219, 0, clientId);
                        break;
                    }
                    case 606: {
                        Slog.d(NsdService.TAG, "SERVICE_REGISTERED Raw: " + raw2);
                        NsdServiceInfo servInfo = new NsdServiceInfo(cooked[2], null, null);
                        clientInfo.mChannel.sendMessage(393227, id2, clientId, servInfo);
                        break;
                    }
                    case 605: {
                        Slog.d(NsdService.TAG, "SERVICE_REGISTER_FAILED Raw: " + raw2);
                        clientInfo.mChannel.sendMessage(393226, 0, clientId);
                        break;
                    }
                    case 609: {
                        break;
                    }
                    case 610: {
                        break;
                    }
                    case 608: {
                        Slog.d(NsdService.TAG, "SERVICE_RESOLVED Raw: " + raw2);
                        int index = cooked[2].indexOf(".");
                        if (index == -1) {
                            Slog.e(NsdService.TAG, "Invalid service found " + raw2);
                            break;
                        }
                        String name = cooked[2].substring(0, index);
                        String rest = cooked[2].substring(index);
                        String type = rest.replace(".local.", "");
                        clientInfo.mResolvedService.setServiceName(name);
                        clientInfo.mResolvedService.setServiceType(type);
                        clientInfo.mResolvedService.setPort(Integer.parseInt(cooked[4]));
                        NsdService.this.stopResolveService(id2);
                        if (NsdService.this.getAddrInfo(id2, cooked[3])) break;
                        clientInfo.mChannel.sendMessage(393235, 0, clientId);
                        this.removeRequestMap(clientId, id2, clientInfo);
                        clientInfo.mResolvedService = null;
                        break;
                    }
                    case 607: {
                        Slog.d(NsdService.TAG, "SERVICE_RESOLVE_FAILED Raw: " + raw2);
                        NsdService.this.stopResolveService(id2);
                        this.removeRequestMap(clientId, id2, clientInfo);
                        clientInfo.mResolvedService = null;
                        clientInfo.mChannel.sendMessage(393235, 0, clientId);
                        break;
                    }
                    case 611: {
                        NsdService.this.stopGetAddrInfo(id2);
                        this.removeRequestMap(clientId, id2, clientInfo);
                        clientInfo.mResolvedService = null;
                        Slog.d(NsdService.TAG, "SERVICE_RESOLVE_FAILED Raw: " + raw2);
                        clientInfo.mChannel.sendMessage(393235, 0, clientId);
                        break;
                    }
                    case 612: {
                        Slog.d(NsdService.TAG, "SERVICE_GET_ADDR_SUCCESS Raw: " + raw2);
                        try {
                            clientInfo.mResolvedService.setHost(InetAddress.getByName(cooked[4]));
                            clientInfo.mChannel.sendMessage(393236, 0, clientId, clientInfo.mResolvedService);
                        }
                        catch (UnknownHostException e) {
                            clientInfo.mChannel.sendMessage(393235, 0, clientId);
                        }
                        NsdService.this.stopGetAddrInfo(id2);
                        this.removeRequestMap(clientId, id2, clientInfo);
                        clientInfo.mResolvedService = null;
                        break;
                    }
                    default: {
                        handled = false;
                    }
                }
                return handled;
            }
        }

        class DisabledState
        extends State {
            DisabledState() {
            }

            public void enter() {
                NsdService.this.sendNsdStateChangeBroadcast(false);
            }

            public boolean processMessage(Message msg) {
                switch (msg.what) {
                    case 393240: {
                        NsdStateMachine.this.transitionTo(NsdStateMachine.this.mEnabledState);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
        }

        class DefaultState
        extends State {
            DefaultState() {
            }

            public boolean processMessage(Message msg) {
                switch (msg.what) {
                    case 69632: {
                        if (msg.arg1 == 0) {
                            AsyncChannel c = (AsyncChannel)msg.obj;
                            Slog.d(NsdService.TAG, "New client listening to asynchronous messages");
                            c.sendMessage(69634);
                            ClientInfo cInfo = new ClientInfo(c, msg.replyTo);
                            NsdService.this.mClients.put(msg.replyTo, cInfo);
                            break;
                        }
                        Slog.e(NsdService.TAG, "Client connection failure, error=" + msg.arg1);
                        break;
                    }
                    case 69636: {
                        if (msg.arg1 == 2) {
                            Slog.e(NsdService.TAG, "Send failed, client connection lost");
                        } else {
                            Slog.d(NsdService.TAG, "Client connection lost with reason: " + msg.arg1);
                        }
                        NsdService.this.mClients.remove(msg.replyTo);
                        break;
                    }
                    case 69633: {
                        AsyncChannel ac = new AsyncChannel();
                        ac.connect(NsdService.this.mContext, NsdStateMachine.this.getHandler(), msg.replyTo);
                        break;
                    }
                    case 393217: {
                        NsdService.this.replyToMessage(msg, 393219, 0);
                        break;
                    }
                    case 393222: {
                        NsdService.this.replyToMessage(msg, 393223, 0);
                        break;
                    }
                    case 393225: {
                        NsdService.this.replyToMessage(msg, 393226, 0);
                        break;
                    }
                    case 393228: {
                        NsdService.this.replyToMessage(msg, 393229, 0);
                        break;
                    }
                    case 393234: {
                        NsdService.this.replyToMessage(msg, 393235, 0);
                        break;
                    }
                    default: {
                        Slog.e(NsdService.TAG, "Unhandled " + msg);
                        return false;
                    }
                }
                return true;
            }
        }
    }
}

