/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.os.SystemProperties;
import android.util.Log;
import android.util.Slog;
import dalvik.system.SocketTagger;
import java.io.FileDescriptor;
import java.net.SocketException;

public final class NetworkManagementSocketTagger
extends SocketTagger {
    private static final String TAG = "NetworkManagementSocketTagger";
    private static final boolean LOGD = false;
    public static final String PROP_QTAGUID_ENABLED = "net.qtaguid_enabled";
    private static ThreadLocal<SocketTags> threadSocketTags = new ThreadLocal<SocketTags>(){

        @Override
        protected SocketTags initialValue() {
            return new SocketTags();
        }
    };

    public static void install() {
        SocketTagger.set(new NetworkManagementSocketTagger());
    }

    public static void setThreadSocketStatsTag(int tag) {
        NetworkManagementSocketTagger.threadSocketTags.get().statsTag = tag;
    }

    public static int getThreadSocketStatsTag() {
        return NetworkManagementSocketTagger.threadSocketTags.get().statsTag;
    }

    public static void setThreadSocketStatsUid(int uid) {
        NetworkManagementSocketTagger.threadSocketTags.get().statsUid = uid;
    }

    public void tag(FileDescriptor fd) throws SocketException {
        SocketTags options = threadSocketTags.get();
        this.tagSocketFd(fd, options.statsTag, options.statsUid);
    }

    private void tagSocketFd(FileDescriptor fd, int tag, int uid) {
        int errno;
        if (tag == -1 && uid == -1) {
            return;
        }
        if (SystemProperties.getBoolean(PROP_QTAGUID_ENABLED, false) && (errno = NetworkManagementSocketTagger.native_tagSocketFd(fd, tag, uid)) < 0) {
            Log.i(TAG, "tagSocketFd(" + fd.getInt$() + ", " + tag + ", " + uid + ") failed with errno" + errno);
        }
    }

    public void untag(FileDescriptor fd) throws SocketException {
        this.unTagSocketFd(fd);
    }

    private void unTagSocketFd(FileDescriptor fd) {
        int errno;
        SocketTags options = threadSocketTags.get();
        if (options.statsTag == -1 && options.statsUid == -1) {
            return;
        }
        if (SystemProperties.getBoolean(PROP_QTAGUID_ENABLED, false) && (errno = NetworkManagementSocketTagger.native_untagSocketFd(fd)) < 0) {
            Log.w(TAG, "untagSocket(" + fd.getInt$() + ") failed with errno " + errno);
        }
    }

    public static void setKernelCounterSet(int uid, int counterSet) {
        int errno;
        if (SystemProperties.getBoolean(PROP_QTAGUID_ENABLED, false) && (errno = NetworkManagementSocketTagger.native_setCounterSet(counterSet, uid)) < 0) {
            Log.w(TAG, "setKernelCountSet(" + uid + ", " + counterSet + ") failed with errno " + errno);
        }
    }

    public static void resetKernelUidStats(int uid) {
        int errno;
        if (SystemProperties.getBoolean(PROP_QTAGUID_ENABLED, false) && (errno = NetworkManagementSocketTagger.native_deleteTagData(0, uid)) < 0) {
            Slog.w(TAG, "problem clearing counters for uid " + uid + " : errno " + errno);
        }
    }

    public static int kernelToTag(String string2) {
        int length = string2.length();
        if (length > 10) {
            return Long.decode(string2.substring(0, length - 8)).intValue();
        }
        return 0;
    }

    private static native int native_tagSocketFd(FileDescriptor var0, int var1, int var2);

    private static native int native_untagSocketFd(FileDescriptor var0);

    private static native int native_setCounterSet(int var0, int var1);

    private static native int native_deleteTagData(int var0, int var1);

    public static class SocketTags {
        public int statsTag = -1;
        public int statsUid = -1;
    }
}

