/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.UserInfo;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import android.os.Binder;
import android.os.Environment;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os.UserManager;
import android.provider.Settings;
import android.security.KeyStore;
import android.text.TextUtils;
import android.util.Log;
import android.util.Slog;
import com.android.internal.widget.ILockSettings;
import com.android.internal.widget.LockPatternUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.List;

public class LockSettingsService
extends ILockSettings.Stub {
    private static final String PERMISSION = "android.permission.ACCESS_KEYGUARD_SECURE_STORAGE";
    private final DatabaseHelper mOpenHelper;
    private static final String TAG = "LockSettingsService";
    private static final String TABLE = "locksettings";
    private static final String COLUMN_KEY = "name";
    private static final String COLUMN_USERID = "user";
    private static final String COLUMN_VALUE = "value";
    private static final String[] COLUMNS_FOR_QUERY = new String[]{"value"};
    private static final String SYSTEM_DIRECTORY = "/system/";
    private static final String LOCK_PATTERN_FILE = "gesture.key";
    private static final String LOCK_PASSWORD_FILE = "password.key";
    private final Context mContext;
    private LockPatternUtils mLockPatternUtils;
    private static final String[] VALID_SETTINGS = new String[]{"lockscreen.lockedoutpermanently", "lockscreen.lockoutattemptdeadline", "lockscreen.patterneverchosen", "lockscreen.password_type", "lockscreen.password_type_alternate", "lockscreen.password_salt", "lockscreen.disabled", "lockscreen.options", "lockscreen.biometric_weak_fallback", "lockscreen.biometricweakeverchosen", "lockscreen.power_button_instantly_locks", "lockscreen.passwordhistory", "lock_pattern_autolock", "lock_biometric_weak_flags", "lock_pattern_visible_pattern", "lock_pattern_tactile_feedback_enabled"};
    private static final String[] READ_PROFILE_PROTECTED_SETTINGS = new String[]{"lock_screen_owner_info_enabled", "lock_screen_owner_info"};

    public LockSettingsService(Context context) {
        this.mContext = context;
        this.mOpenHelper = new DatabaseHelper(this.mContext);
        this.mLockPatternUtils = new LockPatternUtils(context);
    }

    public void systemReady() {
        this.migrateOldData();
    }

    private void migrateOldData() {
        block8: {
            try {
                if (this.getString("migrated", null, 0) == null) {
                    ContentResolver cr = this.mContext.getContentResolver();
                    for (String validSetting : VALID_SETTINGS) {
                        String value = Settings.Secure.getString(cr, validSetting);
                        if (value == null) continue;
                        this.setString(validSetting, value, 0);
                    }
                    this.setString("migrated", "true", 0);
                    Slog.i(TAG, "Migrated lock settings to new location");
                }
                if (this.getString("migrated_user_specific", null, 0) != null) break block8;
                UserManager um = (UserManager)this.mContext.getSystemService(COLUMN_USERID);
                ContentResolver cr = this.mContext.getContentResolver();
                List<UserInfo> users = um.getUsers();
                for (int user = 0; user < users.size(); ++user) {
                    int userId;
                    block9: {
                        userId = users.get((int)user).id;
                        String OWNER_INFO = "lock_screen_owner_info";
                        String ownerInfo = Settings.Secure.getStringForUser(cr, "lock_screen_owner_info", userId);
                        if (ownerInfo != null) {
                            this.setString("lock_screen_owner_info", ownerInfo, userId);
                            Settings.Secure.putStringForUser(cr, ownerInfo, "", userId);
                        }
                        String OWNER_INFO_ENABLED = "lock_screen_owner_info_enabled";
                        try {
                            int ivalue = Settings.Secure.getIntForUser(cr, "lock_screen_owner_info_enabled", userId);
                            boolean enabled = ivalue != 0;
                            this.setLong("lock_screen_owner_info_enabled", enabled ? 1L : 0L, userId);
                        }
                        catch (Settings.SettingNotFoundException e) {
                            if (TextUtils.isEmpty(ownerInfo)) break block9;
                            this.setLong("lock_screen_owner_info_enabled", 1L, userId);
                        }
                    }
                    Settings.Secure.putIntForUser(cr, "lock_screen_owner_info_enabled", 0, userId);
                }
                this.setString("migrated_user_specific", "true", 0);
                Slog.i(TAG, "Migrated per-user lock settings to new location");
            }
            catch (RemoteException re) {
                Slog.e(TAG, "Unable to migrate old data", re);
            }
        }
    }

    private final void checkWritePermission(int userId) {
        this.mContext.checkCallingOrSelfPermission(PERMISSION);
    }

    private final void checkPasswordReadPermission(int userId) {
        this.mContext.checkCallingOrSelfPermission(PERMISSION);
    }

    private final void checkReadPermission(String requestedKey, int userId) {
        int callingUid = Binder.getCallingUid();
        for (int i = 0; i < READ_PROFILE_PROTECTED_SETTINGS.length; ++i) {
            String key = READ_PROFILE_PROTECTED_SETTINGS[i];
            if (!key.equals(requestedKey) || this.mContext.checkCallingOrSelfPermission("android.permission.READ_PROFILE") == 0) continue;
            throw new SecurityException("uid=" + callingUid + " needs permission " + "android.permission.READ_PROFILE" + " to read " + requestedKey + " for user " + userId);
        }
    }

    public void setBoolean(String key, boolean value, int userId) throws RemoteException {
        this.checkWritePermission(userId);
        this.writeToDb(key, value ? "1" : "0", userId);
    }

    public void setLong(String key, long value, int userId) throws RemoteException {
        this.checkWritePermission(userId);
        this.writeToDb(key, Long.toString(value), userId);
    }

    public void setString(String key, String value, int userId) throws RemoteException {
        this.checkWritePermission(userId);
        this.writeToDb(key, value, userId);
    }

    public boolean getBoolean(String key, boolean defaultValue, int userId) throws RemoteException {
        this.checkReadPermission(key, userId);
        String value = this.readFromDb(key, null, userId);
        return TextUtils.isEmpty(value) ? defaultValue : value.equals("1") || value.equals("true");
    }

    public long getLong(String key, long defaultValue, int userId) throws RemoteException {
        this.checkReadPermission(key, userId);
        String value = this.readFromDb(key, null, userId);
        return TextUtils.isEmpty(value) ? defaultValue : Long.parseLong(value);
    }

    public String getString(String key, String defaultValue, int userId) throws RemoteException {
        this.checkReadPermission(key, userId);
        return this.readFromDb(key, defaultValue, userId);
    }

    private String getLockPatternFilename(int userId) {
        String dataSystemDirectory = Environment.getDataDirectory().getAbsolutePath() + SYSTEM_DIRECTORY;
        if (userId == 0) {
            return dataSystemDirectory + LOCK_PATTERN_FILE;
        }
        return new File(Environment.getUserSystemDirectory(userId), LOCK_PATTERN_FILE).getAbsolutePath();
    }

    private String getLockPasswordFilename(int userId) {
        String dataSystemDirectory = Environment.getDataDirectory().getAbsolutePath() + SYSTEM_DIRECTORY;
        if (userId == 0) {
            return dataSystemDirectory + LOCK_PASSWORD_FILE;
        }
        return new File(Environment.getUserSystemDirectory(userId), LOCK_PASSWORD_FILE).getAbsolutePath();
    }

    public boolean havePassword(int userId) throws RemoteException {
        return new File(this.getLockPasswordFilename(userId)).length() > 0L;
    }

    public boolean havePattern(int userId) throws RemoteException {
        return new File(this.getLockPatternFilename(userId)).length() > 0L;
    }

    private void maybeUpdateKeystore(String password, int userId) {
        if (userId == 0) {
            KeyStore keyStore = KeyStore.getInstance();
            if (TextUtils.isEmpty(password) && keyStore.isEmpty()) {
                keyStore.reset();
            } else {
                keyStore.password(password);
            }
        }
    }

    public void setLockPattern(String pattern, int userId) throws RemoteException {
        this.checkWritePermission(userId);
        this.maybeUpdateKeystore(pattern, userId);
        byte[] hash = LockPatternUtils.patternToHash(LockPatternUtils.stringToPattern(pattern));
        this.writeFile(this.getLockPatternFilename(userId), hash);
    }

    public void setLockPassword(String password, int userId) throws RemoteException {
        this.checkWritePermission(userId);
        this.maybeUpdateKeystore(password, userId);
        this.writeFile(this.getLockPasswordFilename(userId), this.mLockPatternUtils.passwordToHash(password));
    }

    public boolean checkPattern(String pattern, int userId) throws RemoteException {
        this.checkPasswordReadPermission(userId);
        try {
            RandomAccessFile raf = new RandomAccessFile(this.getLockPatternFilename(userId), "r");
            byte[] stored = new byte[(int)raf.length()];
            int got = raf.read(stored, 0, stored.length);
            raf.close();
            if (got <= 0) {
                return true;
            }
            byte[] hash = LockPatternUtils.patternToHash(LockPatternUtils.stringToPattern(pattern));
            boolean matched = Arrays.equals(stored, hash);
            if (matched && !TextUtils.isEmpty(pattern)) {
                this.maybeUpdateKeystore(pattern, userId);
            }
            return matched;
        }
        catch (FileNotFoundException fnfe) {
            Slog.e(TAG, "Cannot read file " + fnfe);
        }
        catch (IOException ioe) {
            Slog.e(TAG, "Cannot read file " + ioe);
        }
        return true;
    }

    public boolean checkPassword(String password, int userId) throws RemoteException {
        this.checkPasswordReadPermission(userId);
        try {
            RandomAccessFile raf = new RandomAccessFile(this.getLockPasswordFilename(userId), "r");
            byte[] stored = new byte[(int)raf.length()];
            int got = raf.read(stored, 0, stored.length);
            raf.close();
            if (got <= 0) {
                return true;
            }
            byte[] hash = this.mLockPatternUtils.passwordToHash(password);
            boolean matched = Arrays.equals(stored, hash);
            if (matched && !TextUtils.isEmpty(password)) {
                this.maybeUpdateKeystore(password, userId);
            }
            return matched;
        }
        catch (FileNotFoundException fnfe) {
            Slog.e(TAG, "Cannot read file " + fnfe);
        }
        catch (IOException ioe) {
            Slog.e(TAG, "Cannot read file " + ioe);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUser(int userId) {
        this.checkWritePermission(userId);
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        try {
            File file = new File(this.getLockPasswordFilename(userId));
            if (file.exists()) {
                file.delete();
            }
            if ((file = new File(this.getLockPatternFilename(userId))).exists()) {
                file.delete();
            }
            db.beginTransaction();
            db.delete(TABLE, "user='" + userId + "'", null);
            db.setTransactionSuccessful();
            Object var5_4 = null;
            db.endTransaction();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            db.endTransaction();
            throw throwable;
        }
    }

    private void writeFile(String name, byte[] hash) {
        try {
            RandomAccessFile raf = new RandomAccessFile(name, "rw");
            if (hash == null || hash.length == 0) {
                raf.setLength(0L);
            } else {
                raf.write(hash, 0, hash.length);
            }
            raf.close();
        }
        catch (IOException ioe) {
            Slog.e(TAG, "Error writing to file " + ioe);
        }
    }

    private void writeToDb(String key, String value, int userId) {
        this.writeToDb(this.mOpenHelper.getWritableDatabase(), key, value, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToDb(SQLiteDatabase db, String key, String value, int userId) {
        ContentValues cv = new ContentValues();
        cv.put(COLUMN_KEY, key);
        cv.put(COLUMN_USERID, userId);
        cv.put(COLUMN_VALUE, value);
        db.beginTransaction();
        try {
            db.delete(TABLE, "name=? AND user=?", new String[]{key, Integer.toString(userId)});
            db.insert(TABLE, null, cv);
            db.setTransactionSuccessful();
            Object var7_6 = null;
            db.endTransaction();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            db.endTransaction();
            throw throwable;
        }
    }

    private String readFromDb(String key, String defaultValue, int userId) {
        String result = defaultValue;
        SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
        Cursor cursor = db.query(TABLE, COLUMNS_FOR_QUERY, "user=? AND name=?", new String[]{Integer.toString(userId), key}, null, null, null);
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                result = cursor.getString(0);
            }
            cursor.close();
        }
        return result;
    }

    class DatabaseHelper
    extends SQLiteOpenHelper {
        private static final String TAG = "LockSettingsDB";
        private static final String DATABASE_NAME = "locksettings.db";
        private static final int DATABASE_VERSION = 2;

        public DatabaseHelper(Context context) {
            super(context, DATABASE_NAME, null, 2);
            this.setWriteAheadLoggingEnabled(true);
        }

        private void createTable(SQLiteDatabase db) {
            db.execSQL("CREATE TABLE locksettings (_id INTEGER PRIMARY KEY AUTOINCREMENT,name TEXT,user INTEGER,value TEXT);");
        }

        public void onCreate(SQLiteDatabase db) {
            this.createTable(db);
            this.initializeDefaults(db);
        }

        private void initializeDefaults(SQLiteDatabase db) {
            boolean lockScreenDisable = SystemProperties.getBoolean("ro.lockscreen.disable.default", false);
            if (lockScreenDisable) {
                LockSettingsService.this.writeToDb(db, "lockscreen.disabled", "1", 0);
            }
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int currentVersion) {
            int upgradeVersion = oldVersion;
            if (upgradeVersion == 1) {
                this.maybeEnableWidgetSettingForUsers(db);
                upgradeVersion = 2;
            }
            if (upgradeVersion != 2) {
                Log.w(TAG, "Failed to upgrade database!");
            }
        }

        private void maybeEnableWidgetSettingForUsers(SQLiteDatabase db) {
            UserManager um = (UserManager)LockSettingsService.this.mContext.getSystemService(LockSettingsService.COLUMN_USERID);
            ContentResolver cr = LockSettingsService.this.mContext.getContentResolver();
            List<UserInfo> users = um.getUsers();
            for (int i = 0; i < users.size(); ++i) {
                int userId = users.get((int)i).id;
                boolean enabled = LockSettingsService.this.mLockPatternUtils.hasWidgetsEnabledInKeyguard(userId);
                Log.v(TAG, "Widget upgrade uid=" + userId + ", enabled=" + enabled + ", w[]=" + LockSettingsService.this.mLockPatternUtils.getAppWidgets());
                this.loadSetting(db, "lockscreen.widgets_enabled", userId, enabled);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void loadSetting(SQLiteDatabase db, String key, int userId, boolean value) {
            SQLiteStatement stmt = null;
            try {
                stmt = db.compileStatement("INSERT OR REPLACE INTO locksettings(name,user,value) VALUES(?,?,?);");
                stmt.bindString(1, key);
                stmt.bindLong(2, userId);
                stmt.bindLong(3, value ? 1L : 0L);
                stmt.execute();
                Object var7_6 = null;
                if (stmt == null) return;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            stmt.close();
        }
    }
}

