/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.os.Binder;
import android.os.FileUtils;
import android.provider.Settings;
import android.util.Slog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import libcore.io.IoUtils;

public class CertBlacklister
extends Binder {
    private static final String TAG = "CertBlacklister";
    private static final String BLACKLIST_ROOT = System.getenv("ANDROID_DATA") + "/misc/keychain/";
    public static final String PUBKEY_PATH = BLACKLIST_ROOT + "pubkey_blacklist.txt";
    public static final String SERIAL_PATH = BLACKLIST_ROOT + "serial_blacklist.txt";
    public static final String PUBKEY_BLACKLIST_KEY = "pubkey_blacklist";
    public static final String SERIAL_BLACKLIST_KEY = "serial_blacklist";

    public CertBlacklister(Context context) {
        this.registerObservers(context.getContentResolver());
    }

    private BlacklistObserver buildPubkeyObserver(ContentResolver cr) {
        return new BlacklistObserver(PUBKEY_BLACKLIST_KEY, "pubkey", PUBKEY_PATH, cr);
    }

    private BlacklistObserver buildSerialObserver(ContentResolver cr) {
        return new BlacklistObserver(SERIAL_BLACKLIST_KEY, "serial", SERIAL_PATH, cr);
    }

    private void registerObservers(ContentResolver cr) {
        cr.registerContentObserver(Settings.Secure.getUriFor(PUBKEY_BLACKLIST_KEY), true, this.buildPubkeyObserver(cr));
        cr.registerContentObserver(Settings.Secure.getUriFor(SERIAL_BLACKLIST_KEY), true, this.buildSerialObserver(cr));
    }

    private static class BlacklistObserver
    extends ContentObserver {
        private final String mKey;
        private final String mName;
        private final String mPath;
        private final File mTmpDir;
        private final ContentResolver mContentResolver;

        public BlacklistObserver(String key, String name, String path, ContentResolver cr) {
            super(null);
            this.mKey = key;
            this.mName = name;
            this.mPath = path;
            this.mTmpDir = new File(this.mPath).getParentFile();
            this.mContentResolver = cr;
        }

        public void onChange(boolean selfChange) {
            super.onChange(selfChange);
            this.writeBlacklist();
        }

        public String getValue() {
            return Settings.Secure.getString(this.mContentResolver, this.mKey);
        }

        private void writeBlacklist() {
            new Thread("BlacklistUpdater"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    File file = BlacklistObserver.this.mTmpDir;
                    synchronized (file) {
                        block6: {
                            String blacklist = BlacklistObserver.this.getValue();
                            if (blacklist == null) return;
                            Slog.i(CertBlacklister.TAG, "Certificate blacklist changed, updating...");
                            FileOutputStream out = null;
                            try {
                                try {
                                    File tmp = File.createTempFile("journal", "", BlacklistObserver.this.mTmpDir);
                                    tmp.setReadable(true, false);
                                    out = new FileOutputStream(tmp);
                                    out.write(blacklist.getBytes());
                                    FileUtils.sync(out);
                                    tmp.renameTo(new File(BlacklistObserver.this.mPath));
                                    Slog.i(CertBlacklister.TAG, "Certificate blacklist updated");
                                }
                                catch (IOException e) {
                                    Slog.e(CertBlacklister.TAG, "Failed to write blacklist", e);
                                    Object var6_7 = null;
                                    IoUtils.closeQuietly(out);
                                    break block6;
                                }
                                Object var6_6 = null;
                            }
                            catch (Throwable throwable) {
                                Object var6_8 = null;
                                IoUtils.closeQuietly(out);
                                throw throwable;
                            }
                            IoUtils.closeQuietly(out);
                        }
                        return;
                    }
                }
            }.start();
        }
    }
}

