/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.AlarmManager;
import android.app.AppGlobals;
import android.app.PendingIntent;
import android.appwidget.AppWidgetProviderInfo;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ActivityInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Point;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.AtomicFile;
import android.util.AttributeSet;
import android.util.Pair;
import android.util.Slog;
import android.util.TypedValue;
import android.util.Xml;
import android.view.Display;
import android.view.WindowManager;
import android.widget.RemoteViews;
import com.android.internal.R;
import com.android.internal.appwidget.IAppWidgetHost;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.widget.IRemoteViewsAdapterConnection;
import com.android.internal.widget.IRemoteViewsFactory;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AppWidgetServiceImpl {
    private static final String KEYGUARD_HOST_PACKAGE = "com.android.keyguard";
    private static final int KEYGUARD_HOST_ID = 1262836039;
    private static final String TAG = "AppWidgetServiceImpl";
    private static final String SETTINGS_FILENAME = "appwidgets.xml";
    private static final int MIN_UPDATE_PERIOD = 1800000;
    private static final int CURRENT_VERSION = 1;
    private static boolean DBG = false;
    private final HashMap<Pair<Integer, Intent.FilterComparison>, ServiceConnection> mBoundRemoteViewsServices = new HashMap();
    private final HashMap<Intent.FilterComparison, HashSet<Integer>> mRemoteViewsServicesAppWidgets = new HashMap();
    final Context mContext;
    final IPackageManager mPm;
    final AlarmManager mAlarmManager;
    final ArrayList<Provider> mInstalledProviders = new ArrayList();
    final int mUserId;
    final boolean mHasFeature;
    Locale mLocale;
    int mNextAppWidgetId = 1;
    final ArrayList<AppWidgetId> mAppWidgetIds = new ArrayList();
    final ArrayList<Host> mHosts = new ArrayList();
    final HashSet<String> mPackagesWithBindWidgetPermission = new HashSet();
    boolean mSafeMode;
    boolean mStateLoaded;
    int mMaxWidgetBitmapMemory;
    private final Handler mSaveStateHandler;
    ArrayList<Provider> mDeletedProviders = new ArrayList();
    ArrayList<Host> mDeletedHosts = new ArrayList();
    private final Runnable mSaveStateRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ArrayList<AppWidgetId> arrayList = AppWidgetServiceImpl.this.mAppWidgetIds;
            synchronized (arrayList) {
                AppWidgetServiceImpl.this.ensureStateLoadedLocked();
                AppWidgetServiceImpl.this.saveStateLocked();
            }
        }
    };

    AppWidgetServiceImpl(Context context, int userId, Handler saveStateHandler) {
        this.mContext = context;
        this.mPm = AppGlobals.getPackageManager();
        this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        this.mUserId = userId;
        this.mSaveStateHandler = saveStateHandler;
        this.mHasFeature = context.getPackageManager().hasSystemFeature("android.software.app_widgets");
        this.computeMaximumWidgetBitmapMemory();
    }

    void computeMaximumWidgetBitmapMemory() {
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        Point size = new Point();
        display.getRealSize(size);
        this.mMaxWidgetBitmapMemory = 6 * size.x * size.y;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady(boolean safeMode) {
        this.mSafeMode = safeMode;
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
        }
    }

    private void log(String msg) {
        Slog.i(TAG, "u=" + this.mUserId + ": " + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onConfigurationChanged() {
        Locale revised;
        if (DBG) {
            this.log("Got onConfigurationChanged()");
        }
        if ((revised = Locale.getDefault()) == null || this.mLocale == null || !revised.equals(this.mLocale)) {
            this.mLocale = revised;
            ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
            synchronized (arrayList) {
                this.ensureStateLoadedLocked();
                ArrayList<Provider> installedProviders = new ArrayList<Provider>(this.mInstalledProviders);
                HashSet<ComponentName> removedProviders = new HashSet<ComponentName>();
                int N = installedProviders.size();
                for (int i = N - 1; i >= 0; --i) {
                    Provider p = installedProviders.get(i);
                    ComponentName cn = p.info.provider;
                    if (removedProviders.contains(cn)) continue;
                    this.updateProvidersForPackageLocked(cn.getPackageName(), removedProviders);
                }
                this.saveStateAsync();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onBroadcastReceived(Intent intent) {
        Object uri;
        if (DBG) {
            this.log("onBroadcast " + intent);
        }
        String action = intent.getAction();
        boolean added = false;
        boolean changed = false;
        boolean providersModified = false;
        String[] pkgList = null;
        if ("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE".equals(action)) {
            pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
            added = true;
        } else if ("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(action)) {
            pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
            added = false;
        } else {
            uri = intent.getData();
            if (uri == null) {
                return;
            }
            String pkgName = ((Uri)uri).getSchemeSpecificPart();
            if (pkgName == null) {
                return;
            }
            pkgList = new String[]{pkgName};
            added = "android.intent.action.PACKAGE_ADDED".equals(action);
            changed = "android.intent.action.PACKAGE_CHANGED".equals(action);
        }
        if (pkgList == null || pkgList.length == 0) {
            return;
        }
        if (added || changed) {
            uri = this.mAppWidgetIds;
            synchronized (uri) {
                this.ensureStateLoadedLocked();
                Bundle extras = intent.getExtras();
                if (changed || extras != null && extras.getBoolean("android.intent.extra.REPLACING", false)) {
                    for (String pkgName : pkgList) {
                        providersModified |= this.updateProvidersForPackageLocked(pkgName, null);
                    }
                } else {
                    for (String pkgName : pkgList) {
                        providersModified |= this.addProvidersForPackageLocked(pkgName);
                    }
                }
                this.saveStateAsync();
            }
        }
        Bundle extras = intent.getExtras();
        if (extras == null || !extras.getBoolean("android.intent.extra.REPLACING", false)) {
            ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
            synchronized (arrayList) {
                this.ensureStateLoadedLocked();
                for (String pkgName : pkgList) {
                    providersModified |= this.removeProvidersForPackageLocked(pkgName);
                    this.saveStateAsync();
                }
            }
        }
        if (providersModified) {
            ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
            synchronized (arrayList) {
                this.ensureStateLoadedLocked();
                this.notifyHostsForProvidersChangedLocked();
            }
        }
    }

    private void dumpProvider(Provider p, int index, PrintWriter pw) {
        AppWidgetProviderInfo info = p.info;
        pw.print("  [");
        pw.print(index);
        pw.print("] provider ");
        pw.print(info.provider.flattenToShortString());
        pw.println(':');
        pw.print("    min=(");
        pw.print(info.minWidth);
        pw.print("x");
        pw.print(info.minHeight);
        pw.print(")   minResize=(");
        pw.print(info.minResizeWidth);
        pw.print("x");
        pw.print(info.minResizeHeight);
        pw.print(") updatePeriodMillis=");
        pw.print(info.updatePeriodMillis);
        pw.print(" resizeMode=");
        pw.print(info.resizeMode);
        pw.print(info.widgetCategory);
        pw.print(" autoAdvanceViewId=");
        pw.print(info.autoAdvanceViewId);
        pw.print(" initialLayout=#");
        pw.print(Integer.toHexString(info.initialLayout));
        pw.print(" uid=");
        pw.print(p.uid);
        pw.print(" zombie=");
        pw.println(p.zombie);
    }

    private void dumpHost(Host host, int index, PrintWriter pw) {
        pw.print("  [");
        pw.print(index);
        pw.print("] hostId=");
        pw.print(host.hostId);
        pw.print(' ');
        pw.print(host.packageName);
        pw.print('/');
        pw.print(host.uid);
        pw.println(':');
        pw.print("    callbacks=");
        pw.println(host.callbacks);
        pw.print("    instances.size=");
        pw.print(host.instances.size());
        pw.print(" zombie=");
        pw.println(host.zombie);
    }

    private void dumpAppWidgetId(AppWidgetId id2, int index, PrintWriter pw) {
        pw.print("  [");
        pw.print(index);
        pw.print("] id=");
        pw.println(id2.appWidgetId);
        pw.print("    hostId=");
        pw.print(id2.host.hostId);
        pw.print(' ');
        pw.print(id2.host.packageName);
        pw.print('/');
        pw.println(id2.host.uid);
        if (id2.provider != null) {
            pw.print("    provider=");
            pw.println(id2.provider.info.provider.flattenToShortString());
        }
        if (id2.host != null) {
            pw.print("    host.callbacks=");
            pw.println(id2.host.callbacks);
        }
        if (id2.views != null) {
            pw.print("    views=");
            pw.println(id2.views);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            int i;
            int N = this.mInstalledProviders.size();
            pw.println("Providers:");
            for (i = 0; i < N; ++i) {
                this.dumpProvider(this.mInstalledProviders.get(i), i, pw);
            }
            N = this.mAppWidgetIds.size();
            pw.println(" ");
            pw.println("AppWidgetIds:");
            for (i = 0; i < N; ++i) {
                this.dumpAppWidgetId(this.mAppWidgetIds.get(i), i, pw);
            }
            N = this.mHosts.size();
            pw.println(" ");
            pw.println("Hosts:");
            for (i = 0; i < N; ++i) {
                this.dumpHost(this.mHosts.get(i), i, pw);
            }
            N = this.mDeletedProviders.size();
            pw.println(" ");
            pw.println("Deleted Providers:");
            for (i = 0; i < N; ++i) {
                this.dumpProvider(this.mDeletedProviders.get(i), i, pw);
            }
            N = this.mDeletedHosts.size();
            pw.println(" ");
            pw.println("Deleted Hosts:");
            for (i = 0; i < N; ++i) {
                this.dumpHost(this.mDeletedHosts.get(i), i, pw);
            }
        }
    }

    private void ensureStateLoadedLocked() {
        if (!this.mStateLoaded) {
            if (!this.mHasFeature) {
                return;
            }
            this.loadAppWidgetListLocked();
            this.loadStateLocked();
            this.mStateLoaded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int allocateAppWidgetId(String packageName, int hostId) {
        int callingUid = this.enforceSystemOrCallingUid(packageName);
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            if (!this.mHasFeature) {
                return -1;
            }
            this.ensureStateLoadedLocked();
            int appWidgetId = this.mNextAppWidgetId++;
            Host host = this.lookupOrAddHostLocked(callingUid, packageName, hostId);
            AppWidgetId id2 = new AppWidgetId();
            id2.appWidgetId = appWidgetId;
            id2.host = host;
            host.instances.add(id2);
            this.mAppWidgetIds.add(id2);
            this.saveStateAsync();
            if (DBG) {
                this.log("Allocating AppWidgetId for " + packageName + " host=" + hostId + " id=" + appWidgetId);
            }
            return appWidgetId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAppWidgetId(int appWidgetId) {
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            if (!this.mHasFeature) {
                return;
            }
            this.ensureStateLoadedLocked();
            AppWidgetId id2 = this.lookupAppWidgetIdLocked(appWidgetId);
            if (id2 != null) {
                this.deleteAppWidgetLocked(id2);
                this.saveStateAsync();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteHost(int hostId) {
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            if (!this.mHasFeature) {
                return;
            }
            this.ensureStateLoadedLocked();
            int callingUid = Binder.getCallingUid();
            Host host = this.lookupHostLocked(callingUid, hostId);
            if (host != null) {
                this.deleteHostLocked(host);
                this.saveStateAsync();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllHosts() {
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            if (!this.mHasFeature) {
                return;
            }
            this.ensureStateLoadedLocked();
            int callingUid = Binder.getCallingUid();
            int N = this.mHosts.size();
            boolean changed = false;
            for (int i = N - 1; i >= 0; --i) {
                Host host = this.mHosts.get(i);
                if (!host.uidMatches(callingUid)) continue;
                this.deleteHostLocked(host);
                changed = true;
            }
            if (changed) {
                this.saveStateAsync();
            }
        }
    }

    void deleteHostLocked(Host host) {
        int N = host.instances.size();
        for (int i = N - 1; i >= 0; --i) {
            AppWidgetId id2 = host.instances.get(i);
            this.deleteAppWidgetLocked(id2);
        }
        host.instances.clear();
        this.mHosts.remove(host);
        this.mDeletedHosts.add(host);
        host.callbacks = null;
    }

    void deleteAppWidgetLocked(AppWidgetId id2) {
        this.unbindAppWidgetRemoteViewsServicesLocked(id2);
        Host host = id2.host;
        host.instances.remove(id2);
        this.pruneHostLocked(host);
        this.mAppWidgetIds.remove(id2);
        Provider p = id2.provider;
        if (p != null) {
            p.instances.remove(id2);
            if (!p.zombie) {
                Intent intent = new Intent("android.appwidget.action.APPWIDGET_DELETED");
                intent.setComponent(p.info.provider);
                intent.putExtra("appWidgetId", id2.appWidgetId);
                this.mContext.sendBroadcastAsUser(intent, new UserHandle(this.mUserId));
                if (p.instances.size() == 0) {
                    this.cancelBroadcasts(p);
                    intent = new Intent("android.appwidget.action.APPWIDGET_DISABLED");
                    intent.setComponent(p.info.provider);
                    this.mContext.sendBroadcastAsUser(intent, new UserHandle(this.mUserId));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelBroadcasts(Provider p) {
        if (DBG) {
            this.log("cancelBroadcasts for " + p);
        }
        if (p.broadcast != null) {
            this.mAlarmManager.cancel(p.broadcast);
            long token = Binder.clearCallingIdentity();
            try {
                p.broadcast.cancel();
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            p.broadcast = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindAppWidgetIdImpl(int appWidgetId, ComponentName provider, Bundle options) {
        if (DBG) {
            this.log("bindAppWidgetIdImpl appwid=" + appWidgetId + " provider=" + provider);
        }
        long ident = Binder.clearCallingIdentity();
        try {
            ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
            synchronized (arrayList) {
                block16: {
                    if (this.mHasFeature) break block16;
                    return;
                }
                options = this.cloneIfLocalBinder(options);
                this.ensureStateLoadedLocked();
                AppWidgetId id2 = this.lookupAppWidgetIdLocked(appWidgetId);
                if (id2 == null) {
                    throw new IllegalArgumentException("bad appWidgetId");
                }
                if (id2.provider != null) {
                    throw new IllegalArgumentException("appWidgetId " + appWidgetId + " already bound to " + id2.provider.info.provider);
                }
                Provider p = this.lookupProviderLocked(provider);
                if (p == null) {
                    throw new IllegalArgumentException("not a appwidget provider: " + provider);
                }
                if (p.zombie) {
                    throw new IllegalArgumentException("can't bind to a 3rd party provider in safe mode: " + provider);
                }
                id2.provider = p;
                if (options == null) {
                    options = new Bundle();
                }
                id2.options = options;
                if (!options.containsKey("appWidgetCategory")) {
                    options.putInt("appWidgetCategory", 1);
                }
                p.instances.add(id2);
                int instancesSize = p.instances.size();
                if (instancesSize == 1) {
                    this.sendEnableIntentLocked(p);
                }
                this.sendUpdateIntentLocked(p, new int[]{appWidgetId});
                this.registerForBroadcastsLocked(p, AppWidgetServiceImpl.getAppWidgetIds(p));
                this.saveStateAsync();
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    public void bindAppWidgetId(int appWidgetId, ComponentName provider, Bundle options) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_APPWIDGET", "bindAppWidgetId appWidgetId=" + appWidgetId + " provider=" + provider);
        this.bindAppWidgetIdImpl(appWidgetId, provider, options);
    }

    public boolean bindAppWidgetIdIfAllowed(String packageName, int appWidgetId, ComponentName provider, Bundle options) {
        block3: {
            if (!this.mHasFeature) {
                return false;
            }
            try {
                this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_APPWIDGET", null);
            }
            catch (SecurityException se) {
                if (this.callerHasBindAppWidgetPermission(packageName)) break block3;
                return false;
            }
        }
        this.bindAppWidgetIdImpl(appWidgetId, provider, options);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean callerHasBindAppWidgetPermission(String packageName) {
        int callingUid = Binder.getCallingUid();
        try {
            if (!UserHandle.isSameApp(callingUid, this.getUidForPackage(packageName))) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
            return this.mPackagesWithBindWidgetPermission.contains(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasBindAppWidgetPermission(String packageName) {
        if (!this.mHasFeature) {
            return false;
        }
        this.mContext.enforceCallingPermission("android.permission.MODIFY_APPWIDGET_BIND_PERMISSIONS", "hasBindAppWidgetPermission packageName=" + packageName);
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
            return this.mPackagesWithBindWidgetPermission.contains(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBindAppWidgetPermission(String packageName, boolean permission2) {
        if (!this.mHasFeature) {
            return;
        }
        this.mContext.enforceCallingPermission("android.permission.MODIFY_APPWIDGET_BIND_PERMISSIONS", "setBindAppWidgetPermission packageName=" + packageName);
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
            if (permission2) {
                this.mPackagesWithBindWidgetPermission.add(packageName);
            } else {
                this.mPackagesWithBindWidgetPermission.remove(packageName);
            }
            this.saveStateAsync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindRemoteViewsService(int appWidgetId, Intent intent, IBinder connection) {
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            int userId;
            if (!this.mHasFeature) {
                return;
            }
            this.ensureStateLoadedLocked();
            AppWidgetId id2 = this.lookupAppWidgetIdLocked(appWidgetId);
            if (id2 == null) {
                throw new IllegalArgumentException("bad appWidgetId");
            }
            ComponentName componentName = intent.getComponent();
            try {
                ServiceInfo si = AppGlobals.getPackageManager().getServiceInfo(componentName, 4096, this.mUserId);
                if (!"android.permission.BIND_REMOTEVIEWS".equals(si.permission)) {
                    throw new SecurityException("Selected service does not require android.permission.BIND_REMOTEVIEWS: " + componentName);
                }
            }
            catch (RemoteException e) {
                throw new IllegalArgumentException("Unknown component " + componentName);
            }
            ServiceConnectionProxy conn = null;
            Intent.FilterComparison fc = new Intent.FilterComparison(intent);
            Pair<Integer, Intent.FilterComparison> key = Pair.create(appWidgetId, fc);
            if (this.mBoundRemoteViewsServices.containsKey(key)) {
                conn = (ServiceConnectionProxy)this.mBoundRemoteViewsServices.get(key);
                conn.disconnect();
                this.mContext.unbindService(conn);
                this.mBoundRemoteViewsServices.remove(key);
            }
            if ((userId = UserHandle.getUserId(id2.provider.uid)) != this.mUserId) {
                Slog.w(TAG, "AppWidgetServiceImpl of user " + this.mUserId + " binding to provider on user " + userId);
            }
            long token = Binder.clearCallingIdentity();
            try {
                conn = new ServiceConnectionProxy(key, connection);
                this.mContext.bindServiceAsUser(intent, conn, 1, new UserHandle(userId));
                this.mBoundRemoteViewsServices.put(key, conn);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            this.incrementAppWidgetServiceRefCount(appWidgetId, fc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindRemoteViewsService(int appWidgetId, Intent intent) {
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            if (!this.mHasFeature) {
                return;
            }
            this.ensureStateLoadedLocked();
            Pair<Integer, Intent.FilterComparison> key = Pair.create(appWidgetId, new Intent.FilterComparison(intent));
            if (this.mBoundRemoteViewsServices.containsKey(key)) {
                AppWidgetId id2 = this.lookupAppWidgetIdLocked(appWidgetId);
                if (id2 == null) {
                    throw new IllegalArgumentException("bad appWidgetId");
                }
                ServiceConnectionProxy conn = (ServiceConnectionProxy)this.mBoundRemoteViewsServices.get(key);
                conn.disconnect();
                this.mContext.unbindService(conn);
                this.mBoundRemoteViewsServices.remove(key);
            }
        }
    }

    private void unbindAppWidgetRemoteViewsServicesLocked(AppWidgetId id2) {
        int appWidgetId = id2.appWidgetId;
        Iterator<Pair<Integer, Intent.FilterComparison>> it = this.mBoundRemoteViewsServices.keySet().iterator();
        while (it.hasNext()) {
            Pair<Integer, Intent.FilterComparison> key = it.next();
            if ((Integer)key.first != appWidgetId) continue;
            ServiceConnectionProxy conn = (ServiceConnectionProxy)this.mBoundRemoteViewsServices.get(key);
            conn.disconnect();
            this.mContext.unbindService(conn);
            it.remove();
        }
        this.decrementAppWidgetServiceRefCount(id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyRemoteViewsService(final Intent intent, AppWidgetId id2) {
        ServiceConnection conn = new ServiceConnection(){

            public void onServiceConnected(ComponentName name, IBinder service) {
                IRemoteViewsFactory cb = IRemoteViewsFactory.Stub.asInterface(service);
                try {
                    cb.onDestroy(intent);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
                AppWidgetServiceImpl.this.mContext.unbindService(this);
            }

            public void onServiceDisconnected(ComponentName name) {
            }
        };
        int userId = UserHandle.getUserId(id2.provider.uid);
        long token = Binder.clearCallingIdentity();
        try {
            this.mContext.bindServiceAsUser(intent, conn, 1, new UserHandle(userId));
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private void incrementAppWidgetServiceRefCount(int appWidgetId, Intent.FilterComparison fc) {
        HashSet<Object> appWidgetIds = null;
        if (this.mRemoteViewsServicesAppWidgets.containsKey(fc)) {
            appWidgetIds = this.mRemoteViewsServicesAppWidgets.get(fc);
        } else {
            appWidgetIds = new HashSet();
            this.mRemoteViewsServicesAppWidgets.put(fc, appWidgetIds);
        }
        appWidgetIds.add(appWidgetId);
    }

    private void decrementAppWidgetServiceRefCount(AppWidgetId id2) {
        Iterator<Intent.FilterComparison> it = this.mRemoteViewsServicesAppWidgets.keySet().iterator();
        while (it.hasNext()) {
            Intent.FilterComparison key = it.next();
            HashSet<Integer> ids = this.mRemoteViewsServicesAppWidgets.get(key);
            if (!ids.remove(id2.appWidgetId) || !ids.isEmpty()) continue;
            this.destroyRemoteViewsService(key.getIntent(), id2);
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppWidgetProviderInfo getAppWidgetInfo(int appWidgetId) {
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            if (!this.mHasFeature) {
                return null;
            }
            this.ensureStateLoadedLocked();
            AppWidgetId id2 = this.lookupAppWidgetIdLocked(appWidgetId);
            if (id2 != null && id2.provider != null && !id2.provider.zombie) {
                return this.cloneIfLocalBinder(id2.provider.info);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteViews getAppWidgetViews(int appWidgetId) {
        if (DBG) {
            this.log("getAppWidgetViews id=" + appWidgetId);
        }
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            if (!this.mHasFeature) {
                return null;
            }
            this.ensureStateLoadedLocked();
            AppWidgetId id2 = this.lookupAppWidgetIdLocked(appWidgetId);
            if (id2 != null) {
                return this.cloneIfLocalBinder(id2.views);
            }
            if (DBG) {
                this.log("   couldn't find appwidgetid");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AppWidgetProviderInfo> getInstalledProviders(int categoryFilter) {
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            if (!this.mHasFeature) {
                return new ArrayList<AppWidgetProviderInfo>(0);
            }
            this.ensureStateLoadedLocked();
            int N = this.mInstalledProviders.size();
            ArrayList<AppWidgetProviderInfo> result = new ArrayList<AppWidgetProviderInfo>(N);
            for (int i = 0; i < N; ++i) {
                Provider p = this.mInstalledProviders.get(i);
                if (p.zombie || (p.info.widgetCategory & categoryFilter) == 0) continue;
                result.add(this.cloneIfLocalBinder(p.info));
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAppWidgetIds(int[] appWidgetIds, RemoteViews views) {
        if (!this.mHasFeature) {
            return;
        }
        if (appWidgetIds == null) {
            return;
        }
        if (DBG) {
            this.log("updateAppWidgetIds views: " + views);
        }
        int bitmapMemoryUsage = 0;
        if (views != null) {
            bitmapMemoryUsage = views.estimateMemoryUsage();
        }
        if (bitmapMemoryUsage > this.mMaxWidgetBitmapMemory) {
            throw new IllegalArgumentException("RemoteViews for widget update exceeds maximum bitmap memory usage (used: " + bitmapMemoryUsage + ", max: " + this.mMaxWidgetBitmapMemory + ") The total memory cannot exceed that required to" + " fill the device's screen once.");
        }
        if (appWidgetIds.length == 0) {
            return;
        }
        int N = appWidgetIds.length;
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
            for (int i = 0; i < N; ++i) {
                AppWidgetId id2 = this.lookupAppWidgetIdLocked(appWidgetIds[i]);
                this.updateAppWidgetInstanceLocked(id2, views);
            }
        }
    }

    private void saveStateAsync() {
        this.mSaveStateHandler.post(this.mSaveStateRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAppWidgetOptions(int appWidgetId, Bundle options) {
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            if (!this.mHasFeature) {
                return;
            }
            options = this.cloneIfLocalBinder(options);
            this.ensureStateLoadedLocked();
            AppWidgetId id2 = this.lookupAppWidgetIdLocked(appWidgetId);
            if (id2 == null) {
                return;
            }
            Provider p = id2.provider;
            id2.options.putAll(options);
            Intent intent = new Intent("android.appwidget.action.APPWIDGET_UPDATE_OPTIONS");
            intent.setComponent(p.info.provider);
            intent.putExtra("appWidgetId", id2.appWidgetId);
            intent.putExtra("appWidgetOptions", id2.options);
            this.mContext.sendBroadcastAsUser(intent, new UserHandle(this.mUserId));
            this.saveStateAsync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle getAppWidgetOptions(int appWidgetId) {
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            if (!this.mHasFeature) {
                return Bundle.EMPTY;
            }
            this.ensureStateLoadedLocked();
            AppWidgetId id2 = this.lookupAppWidgetIdLocked(appWidgetId);
            if (id2 != null && id2.options != null) {
                return this.cloneIfLocalBinder(id2.options);
            }
            return Bundle.EMPTY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void partiallyUpdateAppWidgetIds(int[] appWidgetIds, RemoteViews views) {
        if (!this.mHasFeature) {
            return;
        }
        if (appWidgetIds == null) {
            return;
        }
        if (appWidgetIds.length == 0) {
            return;
        }
        int N = appWidgetIds.length;
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
            for (int i = 0; i < N; ++i) {
                AppWidgetId id2 = this.lookupAppWidgetIdLocked(appWidgetIds[i]);
                if (id2 == null) {
                    Slog.w(TAG, "widget id " + appWidgetIds[i] + " not found!");
                    continue;
                }
                if (id2.views == null) continue;
                this.updateAppWidgetInstanceLocked(id2, views, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAppWidgetViewDataChanged(int[] appWidgetIds, int viewId) {
        if (!this.mHasFeature) {
            return;
        }
        if (appWidgetIds == null) {
            return;
        }
        if (appWidgetIds.length == 0) {
            return;
        }
        int N = appWidgetIds.length;
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
            for (int i = 0; i < N; ++i) {
                AppWidgetId id2 = this.lookupAppWidgetIdLocked(appWidgetIds[i]);
                this.notifyAppWidgetViewDataChangedInstanceLocked(id2, viewId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAppWidgetProvider(ComponentName provider, RemoteViews views) {
        if (!this.mHasFeature) {
            return;
        }
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
            Provider p = this.lookupProviderLocked(provider);
            if (p == null) {
                Slog.w(TAG, "updateAppWidgetProvider: provider doesn't exist: " + provider);
                return;
            }
            ArrayList<AppWidgetId> instances = p.instances;
            int callingUid = Binder.getCallingUid();
            int N = instances.size();
            for (int i = 0; i < N; ++i) {
                AppWidgetId id2 = instances.get(i);
                if (!this.canAccessAppWidgetId(id2, callingUid)) continue;
                this.updateAppWidgetInstanceLocked(id2, views);
            }
        }
    }

    void updateAppWidgetInstanceLocked(AppWidgetId id2, RemoteViews views) {
        this.updateAppWidgetInstanceLocked(id2, views, false);
    }

    void updateAppWidgetInstanceLocked(AppWidgetId id2, RemoteViews views, boolean isPartialUpdate) {
        if (id2 != null && id2.provider != null && !id2.provider.zombie && !id2.host.zombie) {
            if (!isPartialUpdate) {
                id2.views = views;
            } else {
                id2.views.mergeRemoteViews(views);
            }
            if (id2.host.callbacks != null) {
                try {
                    id2.host.callbacks.updateAppWidget(id2.appWidgetId, views, this.mUserId);
                }
                catch (RemoteException e) {
                    id2.host.callbacks = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAppWidgetViewDataChangedInstanceLocked(AppWidgetId id2, int viewId) {
        if (id2 != null && id2.provider != null && !id2.provider.zombie && !id2.host.zombie) {
            if (id2.host.callbacks != null) {
                try {
                    id2.host.callbacks.viewDataChanged(id2.appWidgetId, viewId, this.mUserId);
                }
                catch (RemoteException e) {
                    id2.host.callbacks = null;
                }
            }
            if (id2.host.callbacks == null) {
                Set<Intent.FilterComparison> keys = this.mRemoteViewsServicesAppWidgets.keySet();
                for (Intent.FilterComparison key : keys) {
                    if (!this.mRemoteViewsServicesAppWidgets.get(key).contains(id2.appWidgetId)) continue;
                    Intent intent = key.getIntent();
                    ServiceConnection conn = new ServiceConnection(){

                        public void onServiceConnected(ComponentName name, IBinder service) {
                            IRemoteViewsFactory cb = IRemoteViewsFactory.Stub.asInterface(service);
                            try {
                                cb.onDataSetChangedAsync();
                            }
                            catch (RemoteException e) {
                                e.printStackTrace();
                            }
                            catch (RuntimeException e) {
                                e.printStackTrace();
                            }
                            AppWidgetServiceImpl.this.mContext.unbindService(this);
                        }

                        public void onServiceDisconnected(ComponentName name) {
                        }
                    };
                    int userId = UserHandle.getUserId(id2.provider.uid);
                    long token = Binder.clearCallingIdentity();
                    try {
                        this.mContext.bindServiceAsUser(intent, conn, 1, new UserHandle(userId));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            }
        }
    }

    private boolean isLocalBinder() {
        return Process.myPid() == Binder.getCallingPid();
    }

    private RemoteViews cloneIfLocalBinder(RemoteViews rv) {
        if (this.isLocalBinder() && rv != null) {
            return rv.clone();
        }
        return rv;
    }

    private AppWidgetProviderInfo cloneIfLocalBinder(AppWidgetProviderInfo info) {
        if (this.isLocalBinder() && info != null) {
            return info.clone();
        }
        return info;
    }

    private Bundle cloneIfLocalBinder(Bundle bundle) {
        if (this.isLocalBinder() && bundle != null) {
            return (Bundle)bundle.clone();
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] startListening(IAppWidgetHost callbacks, String packageName, int hostId, List<RemoteViews> updatedViews) {
        if (!this.mHasFeature) {
            return new int[0];
        }
        int callingUid = this.enforceCallingUid(packageName);
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
            Host host = this.lookupOrAddHostLocked(callingUid, packageName, hostId);
            host.callbacks = callbacks;
            updatedViews.clear();
            ArrayList<AppWidgetId> instances = host.instances;
            int N = instances.size();
            int[] updatedIds = new int[N];
            for (int i = 0; i < N; ++i) {
                AppWidgetId id2 = instances.get(i);
                updatedIds[i] = id2.appWidgetId;
                updatedViews.add(this.cloneIfLocalBinder(id2.views));
            }
            return updatedIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopListening(int hostId) {
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            if (!this.mHasFeature) {
                return;
            }
            this.ensureStateLoadedLocked();
            Host host = this.lookupHostLocked(Binder.getCallingUid(), hostId);
            if (host != null) {
                host.callbacks = null;
                this.pruneHostLocked(host);
            }
        }
    }

    boolean canAccessAppWidgetId(AppWidgetId id2, int callingUid) {
        if (id2.host.uidMatches(callingUid)) {
            return true;
        }
        if (id2.provider != null && id2.provider.uid == callingUid) {
            return true;
        }
        return this.mContext.checkCallingOrSelfPermission("android.permission.BIND_APPWIDGET") == 0;
    }

    AppWidgetId lookupAppWidgetIdLocked(int appWidgetId) {
        int callingUid = Binder.getCallingUid();
        int N = this.mAppWidgetIds.size();
        for (int i = 0; i < N; ++i) {
            AppWidgetId id2 = this.mAppWidgetIds.get(i);
            if (id2.appWidgetId != appWidgetId || !this.canAccessAppWidgetId(id2, callingUid)) continue;
            return id2;
        }
        return null;
    }

    Provider lookupProviderLocked(ComponentName provider) {
        int N = this.mInstalledProviders.size();
        for (int i = 0; i < N; ++i) {
            Provider p = this.mInstalledProviders.get(i);
            if (!p.info.provider.equals(provider)) continue;
            return p;
        }
        return null;
    }

    Host lookupHostLocked(int uid, int hostId) {
        int N = this.mHosts.size();
        for (int i = 0; i < N; ++i) {
            Host h = this.mHosts.get(i);
            if (!h.uidMatches(uid) || h.hostId != hostId) continue;
            return h;
        }
        return null;
    }

    Host lookupOrAddHostLocked(int uid, String packageName, int hostId) {
        int N = this.mHosts.size();
        for (int i = 0; i < N; ++i) {
            Host h = this.mHosts.get(i);
            if (h.hostId != hostId || !h.packageName.equals(packageName)) continue;
            return h;
        }
        Host host = new Host();
        host.packageName = packageName;
        host.uid = uid;
        host.hostId = hostId;
        this.mHosts.add(host);
        return host;
    }

    void pruneHostLocked(Host host) {
        if (host.instances.size() == 0 && host.callbacks == null) {
            this.mHosts.remove(host);
        }
    }

    void loadAppWidgetListLocked() {
        Intent intent = new Intent("android.appwidget.action.APPWIDGET_UPDATE");
        try {
            List<ResolveInfo> broadcastReceivers = this.mPm.queryIntentReceivers(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), 128, this.mUserId);
            int N = broadcastReceivers == null ? 0 : broadcastReceivers.size();
            for (int i = 0; i < N; ++i) {
                ResolveInfo ri = broadcastReceivers.get(i);
                this.addProviderLocked(ri);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    boolean addProviderLocked(ResolveInfo ri) {
        if ((ri.activityInfo.applicationInfo.flags & 0x40000) != 0) {
            return false;
        }
        if (!ri.activityInfo.isEnabled()) {
            return false;
        }
        Provider p = this.parseProviderInfoXml(new ComponentName(ri.activityInfo.packageName, ri.activityInfo.name), ri);
        if (p != null) {
            this.mInstalledProviders.add(p);
            return true;
        }
        return false;
    }

    void removeProviderLocked(int index, Provider p) {
        int N = p.instances.size();
        for (int i = 0; i < N; ++i) {
            AppWidgetId id2 = p.instances.get(i);
            this.updateAppWidgetInstanceLocked(id2, null);
            this.cancelBroadcasts(p);
            id2.host.instances.remove(id2);
            this.mAppWidgetIds.remove(id2);
            id2.provider = null;
            this.pruneHostLocked(id2.host);
            id2.host = null;
        }
        p.instances.clear();
        this.mInstalledProviders.remove(index);
        this.mDeletedProviders.add(p);
        this.cancelBroadcasts(p);
    }

    void sendEnableIntentLocked(Provider p) {
        Intent intent = new Intent("android.appwidget.action.APPWIDGET_ENABLED");
        intent.setComponent(p.info.provider);
        this.mContext.sendBroadcastAsUser(intent, new UserHandle(this.mUserId));
    }

    void sendUpdateIntentLocked(Provider p, int[] appWidgetIds) {
        if (appWidgetIds != null && appWidgetIds.length > 0) {
            Intent intent = new Intent("android.appwidget.action.APPWIDGET_UPDATE");
            intent.putExtra("appWidgetIds", appWidgetIds);
            intent.setComponent(p.info.provider);
            this.mContext.sendBroadcastAsUser(intent, new UserHandle(this.mUserId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerForBroadcastsLocked(Provider p, int[] appWidgetIds) {
        if (p.info.updatePeriodMillis > 0) {
            boolean alreadyRegistered = p.broadcast != null;
            Intent intent = new Intent("android.appwidget.action.APPWIDGET_UPDATE");
            intent.putExtra("appWidgetIds", appWidgetIds);
            intent.setComponent(p.info.provider);
            long token = Binder.clearCallingIdentity();
            try {
                p.broadcast = PendingIntent.getBroadcastAsUser(this.mContext, 1, intent, 0x8000000, new UserHandle(this.mUserId));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            if (!alreadyRegistered) {
                long period = p.info.updatePeriodMillis;
                if (period < 1800000L) {
                    period = 1800000L;
                }
                this.mAlarmManager.setInexactRepeating(2, SystemClock.elapsedRealtime() + period, period, p.broadcast);
            }
        }
    }

    static int[] getAppWidgetIds(Provider p) {
        int instancesSize = p.instances.size();
        int[] appWidgetIds = new int[instancesSize];
        for (int i = 0; i < instancesSize; ++i) {
            appWidgetIds[i] = p.instances.get((int)i).appWidgetId;
        }
        return appWidgetIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getAppWidgetIds(ComponentName provider) {
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
            Provider p = this.lookupProviderLocked(provider);
            if (p != null && Binder.getCallingUid() == p.uid) {
                return AppWidgetServiceImpl.getAppWidgetIds(p);
            }
            return new int[0];
        }
    }

    static int[] getAppWidgetIds(Host h) {
        int instancesSize = h.instances.size();
        int[] appWidgetIds = new int[instancesSize];
        for (int i = 0; i < instancesSize; ++i) {
            appWidgetIds[i] = h.instances.get((int)i).appWidgetId;
        }
        return appWidgetIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getAppWidgetIdsForHost(int hostId) {
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
            int callingUid = Binder.getCallingUid();
            Host host = this.lookupHostLocked(callingUid, hostId);
            if (host != null) {
                return AppWidgetServiceImpl.getAppWidgetIds(host);
            }
            return new int[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Provider parseProviderInfoXml(ComponentName component, ResolveInfo ri) {
        Provider p = null;
        ActivityInfo activityInfo = ri.activityInfo;
        XmlResourceParser parser = null;
        try {
            int type;
            parser = activityInfo.loadXmlMetaData(this.mContext.getPackageManager(), "android.appwidget.provider");
            if (parser == null) {
                Slog.w(TAG, "No android.appwidget.provider meta-data for AppWidget provider '" + component + '\'');
                Provider provider = null;
                return provider;
            }
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!"appwidget-provider".equals(nodeName)) {
                Slog.w(TAG, "Meta-data does not start with appwidget-provider tag for AppWidget provider '" + component + '\'');
                Provider provider = null;
                return provider;
            }
            p = new Provider();
            AppWidgetProviderInfo info = p.info = new AppWidgetProviderInfo();
            info.provider = component;
            p.uid = activityInfo.applicationInfo.uid;
            Resources res = this.mContext.getPackageManager().getResourcesForApplicationAsUser(activityInfo.packageName, this.mUserId);
            TypedArray sa = res.obtainAttributes(attrs, R.styleable.AppWidgetProviderInfo);
            TypedValue value = sa.peekValue(0);
            info.minWidth = value != null ? value.data : 0;
            value = sa.peekValue(1);
            info.minHeight = value != null ? value.data : 0;
            value = sa.peekValue(8);
            info.minResizeWidth = value != null ? value.data : info.minWidth;
            value = sa.peekValue(9);
            info.minResizeHeight = value != null ? value.data : info.minHeight;
            info.updatePeriodMillis = sa.getInt(2, 0);
            info.initialLayout = sa.getResourceId(3, 0);
            info.initialKeyguardLayout = sa.getResourceId(10, 0);
            String className = sa.getString(4);
            if (className != null) {
                info.configure = new ComponentName(component.getPackageName(), className);
            }
            info.label = ((Object)activityInfo.loadLabel(this.mContext.getPackageManager())).toString();
            info.icon = ri.getIconResource();
            info.previewImage = sa.getResourceId(5, 0);
            info.autoAdvanceViewId = sa.getResourceId(6, -1);
            info.resizeMode = sa.getInt(7, 0);
            info.widgetCategory = sa.getInt(11, 1);
            sa.recycle();
        }
        catch (Exception e) {
            Slog.w(TAG, "XML parsing failed for AppWidget provider '" + component + '\'', e);
            Provider provider = null;
            return provider;
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
        return p;
    }

    int getUidForPackage(String packageName) throws PackageManager.NameNotFoundException {
        PackageInfo pkgInfo = null;
        try {
            pkgInfo = this.mPm.getPackageInfo(packageName, 0, this.mUserId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (pkgInfo == null || pkgInfo.applicationInfo == null) {
            throw new PackageManager.NameNotFoundException();
        }
        return pkgInfo.applicationInfo.uid;
    }

    int enforceSystemOrCallingUid(String packageName) throws IllegalArgumentException {
        int callingUid = Binder.getCallingUid();
        if (UserHandle.getAppId(callingUid) == 1000 || callingUid == 0) {
            return callingUid;
        }
        return this.enforceCallingUid(packageName);
    }

    int enforceCallingUid(String packageName) throws IllegalArgumentException {
        int packageUid;
        int callingUid = Binder.getCallingUid();
        try {
            packageUid = this.getUidForPackage(packageName);
        }
        catch (PackageManager.NameNotFoundException ex) {
            throw new IllegalArgumentException("packageName and uid don't match packageName=" + packageName);
        }
        if (!UserHandle.isSameApp(callingUid, packageUid)) {
            throw new IllegalArgumentException("packageName and uid don't match packageName=" + packageName);
        }
        return callingUid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendInitialBroadcasts() {
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
            int N = this.mInstalledProviders.size();
            for (int i = 0; i < N; ++i) {
                Provider p = this.mInstalledProviders.get(i);
                if (p.instances.size() <= 0) continue;
                this.sendEnableIntentLocked(p);
                int[] appWidgetIds = AppWidgetServiceImpl.getAppWidgetIds(p);
                this.sendUpdateIntentLocked(p, appWidgetIds);
                this.registerForBroadcastsLocked(p, appWidgetIds);
            }
        }
    }

    void loadStateLocked() {
        AtomicFile file = this.savedStateFile();
        try {
            FileInputStream stream = file.openRead();
            this.readStateFromFileLocked(stream);
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    Slog.w(TAG, "Failed to close state FileInputStream " + e);
                }
            }
        }
        catch (FileNotFoundException e) {
            Slog.w(TAG, "Failed to read state: " + e);
        }
    }

    void saveStateLocked() {
        if (!this.mHasFeature) {
            return;
        }
        AtomicFile file = this.savedStateFile();
        try {
            FileOutputStream stream = file.startWrite();
            if (this.writeStateToFileLocked(stream)) {
                file.finishWrite(stream);
            } else {
                file.failWrite(stream);
                Slog.w(TAG, "Failed to save state, restoring backup.");
            }
        }
        catch (IOException e) {
            Slog.w(TAG, "Failed open state file for write: " + e);
        }
    }

    boolean writeStateToFileLocked(FileOutputStream stream) {
        try {
            int i;
            FastXmlSerializer out = new FastXmlSerializer();
            out.setOutput(stream, "utf-8");
            out.startDocument(null, true);
            out.startTag(null, "gs");
            out.attribute(null, "version", String.valueOf(1));
            int providerIndex = 0;
            int N = this.mInstalledProviders.size();
            for (i = 0; i < N; ++i) {
                Provider p = this.mInstalledProviders.get(i);
                if (p.instances.size() <= 0) continue;
                out.startTag(null, "p");
                out.attribute(null, "pkg", p.info.provider.getPackageName());
                out.attribute(null, "cl", p.info.provider.getClassName());
                out.endTag(null, "p");
                p.tag = providerIndex++;
            }
            N = this.mHosts.size();
            i = 0;
            while (i < N) {
                Host host = this.mHosts.get(i);
                out.startTag(null, "h");
                out.attribute(null, "pkg", host.packageName);
                out.attribute(null, "id", Integer.toHexString(host.hostId));
                out.endTag(null, "h");
                host.tag = i++;
            }
            N = this.mAppWidgetIds.size();
            for (i = 0; i < N; ++i) {
                AppWidgetId id2 = this.mAppWidgetIds.get(i);
                out.startTag(null, "g");
                out.attribute(null, "id", Integer.toHexString(id2.appWidgetId));
                out.attribute(null, "h", Integer.toHexString(id2.host.tag));
                if (id2.provider != null) {
                    out.attribute(null, "p", Integer.toHexString(id2.provider.tag));
                }
                if (id2.options != null) {
                    out.attribute(null, "min_width", Integer.toHexString(id2.options.getInt("appWidgetMinWidth")));
                    out.attribute(null, "min_height", Integer.toHexString(id2.options.getInt("appWidgetMinHeight")));
                    out.attribute(null, "max_width", Integer.toHexString(id2.options.getInt("appWidgetMaxWidth")));
                    out.attribute(null, "max_height", Integer.toHexString(id2.options.getInt("appWidgetMaxHeight")));
                    out.attribute(null, "host_category", Integer.toHexString(id2.options.getInt("appWidgetCategory")));
                }
                out.endTag(null, "g");
            }
            Iterator<String> it = this.mPackagesWithBindWidgetPermission.iterator();
            while (it.hasNext()) {
                out.startTag(null, "b");
                out.attribute(null, "packageName", it.next());
                out.endTag(null, "b");
            }
            out.endTag(null, "gs");
            out.endDocument();
            return true;
        }
        catch (IOException e) {
            Slog.w(TAG, "Failed to write state: " + e);
            return false;
        }
    }

    void readStateFromFileLocked(FileInputStream stream) {
        boolean success = false;
        int version = 0;
        try {
            int type;
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(stream, null);
            int providerIndex = 0;
            HashMap<Integer, Provider> loadedProviders = new HashMap<Integer, Provider>();
            do {
                String categoryString;
                String maxHeightString;
                String maxWidthString;
                String minHeightString;
                if ((type = parser.next()) != 2) continue;
                String tag = parser.getName();
                if ("gs".equals(tag)) {
                    String attributeValue = parser.getAttributeValue(null, "version");
                    try {
                        version = Integer.parseInt(attributeValue);
                    }
                    catch (NumberFormatException e) {
                        version = 0;
                    }
                    continue;
                }
                if ("p".equals(tag)) {
                    String pkg = parser.getAttributeValue(null, "pkg");
                    String cl = parser.getAttributeValue(null, "cl");
                    IPackageManager packageManager = AppGlobals.getPackageManager();
                    try {
                        packageManager.getReceiverInfo(new ComponentName(pkg, cl), 0, this.mUserId);
                    }
                    catch (RemoteException e) {
                        String[] pkgs = this.mContext.getPackageManager().currentToCanonicalPackageNames(new String[]{pkg});
                        pkg = pkgs[0];
                    }
                    Provider p = this.lookupProviderLocked(new ComponentName(pkg, cl));
                    if (p == null && this.mSafeMode) {
                        p = new Provider();
                        p.info = new AppWidgetProviderInfo();
                        p.info.provider = new ComponentName(pkg, cl);
                        p.zombie = true;
                        this.mInstalledProviders.add(p);
                    }
                    if (p != null) {
                        loadedProviders.put(providerIndex, p);
                    }
                    ++providerIndex;
                    continue;
                }
                if ("h".equals(tag)) {
                    Host host = new Host();
                    host.packageName = parser.getAttributeValue(null, "pkg");
                    try {
                        host.uid = this.getUidForPackage(host.packageName);
                    }
                    catch (PackageManager.NameNotFoundException ex) {
                        host.zombie = true;
                    }
                    if (host.zombie && !this.mSafeMode) continue;
                    host.hostId = Integer.parseInt(parser.getAttributeValue(null, "id"), 16);
                    this.mHosts.add(host);
                    continue;
                }
                if ("b".equals(tag)) {
                    String packageName = parser.getAttributeValue(null, "packageName");
                    if (packageName == null) continue;
                    this.mPackagesWithBindWidgetPermission.add(packageName);
                    continue;
                }
                if (!"g".equals(tag)) continue;
                AppWidgetId id2 = new AppWidgetId();
                id2.appWidgetId = Integer.parseInt(parser.getAttributeValue(null, "id"), 16);
                if (id2.appWidgetId >= this.mNextAppWidgetId) {
                    this.mNextAppWidgetId = id2.appWidgetId + 1;
                }
                Bundle options = new Bundle();
                String minWidthString = parser.getAttributeValue(null, "min_width");
                if (minWidthString != null) {
                    options.putInt("appWidgetMinWidth", Integer.parseInt(minWidthString, 16));
                }
                if ((minHeightString = parser.getAttributeValue(null, "min_height")) != null) {
                    options.putInt("appWidgetMinHeight", Integer.parseInt(minHeightString, 16));
                }
                if ((maxWidthString = parser.getAttributeValue(null, "max_width")) != null) {
                    options.putInt("appWidgetMaxWidth", Integer.parseInt(maxWidthString, 16));
                }
                if ((maxHeightString = parser.getAttributeValue(null, "max_height")) != null) {
                    options.putInt("appWidgetMaxHeight", Integer.parseInt(maxHeightString, 16));
                }
                if ((categoryString = parser.getAttributeValue(null, "host_category")) != null) {
                    options.putInt("appWidgetCategory", Integer.parseInt(categoryString, 16));
                }
                id2.options = options;
                String providerString = parser.getAttributeValue(null, "p");
                if (providerString != null) {
                    int pIndex = Integer.parseInt(providerString, 16);
                    id2.provider = (Provider)loadedProviders.get(pIndex);
                    if (id2.provider == null) continue;
                }
                int hIndex = Integer.parseInt(parser.getAttributeValue(null, "h"), 16);
                id2.host = this.mHosts.get(hIndex);
                if (id2.host == null) continue;
                if (id2.provider != null) {
                    id2.provider.instances.add(id2);
                }
                id2.host.instances.add(id2);
                this.mAppWidgetIds.add(id2);
            } while (type != 1);
            success = true;
        }
        catch (NullPointerException e) {
            Slog.w(TAG, "failed parsing " + e);
        }
        catch (NumberFormatException e) {
            Slog.w(TAG, "failed parsing " + e);
        }
        catch (XmlPullParserException e) {
            Slog.w(TAG, "failed parsing " + e);
        }
        catch (IOException e) {
            Slog.w(TAG, "failed parsing " + e);
        }
        catch (IndexOutOfBoundsException e) {
            Slog.w(TAG, "failed parsing " + e);
        }
        if (success) {
            for (int i = this.mHosts.size() - 1; i >= 0; --i) {
                this.pruneHostLocked(this.mHosts.get(i));
            }
            this.performUpgrade(version);
        } else {
            Slog.w(TAG, "Failed to read state, clearing widgets and hosts.");
            this.mAppWidgetIds.clear();
            this.mHosts.clear();
            int N = this.mInstalledProviders.size();
            for (int i = 0; i < N; ++i) {
                this.mInstalledProviders.get((int)i).instances.clear();
            }
        }
    }

    private void performUpgrade(int fromVersion) {
        int version;
        if (fromVersion < 1) {
            Slog.v(TAG, "Upgrading widget database from " + fromVersion + " to " + 1 + " for user " + this.mUserId);
        }
        if ((version = fromVersion) == 0) {
            for (int i = 0; i < this.mHosts.size(); ++i) {
                Host host = this.mHosts.get(i);
                if (host == null || !"android".equals(host.packageName) || host.hostId != 1262836039) continue;
                host.packageName = KEYGUARD_HOST_PACKAGE;
            }
            version = 1;
        }
        if (version != 1) {
            throw new IllegalStateException("Failed to upgrade widget database");
        }
    }

    static File getSettingsFile(int userId) {
        return new File(Environment.getUserSystemDirectory(userId), SETTINGS_FILENAME);
    }

    AtomicFile savedStateFile() {
        File dir = Environment.getUserSystemDirectory(this.mUserId);
        File settingsFile = AppWidgetServiceImpl.getSettingsFile(this.mUserId);
        if (!settingsFile.exists() && this.mUserId == 0) {
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File oldFile = new File("/data/system/appwidgets.xml");
            oldFile.renameTo(settingsFile);
        }
        return new AtomicFile(settingsFile);
    }

    void onUserStopping() {
        int N = this.mInstalledProviders.size();
        for (int i = N - 1; i >= 0; --i) {
            Provider p = this.mInstalledProviders.get(i);
            this.cancelBroadcasts(p);
        }
    }

    void onUserRemoved() {
        AppWidgetServiceImpl.getSettingsFile(this.mUserId).delete();
    }

    boolean addProvidersForPackageLocked(String pkgName) {
        List<ResolveInfo> broadcastReceivers;
        boolean providersAdded = false;
        Intent intent = new Intent("android.appwidget.action.APPWIDGET_UPDATE");
        intent.setPackage(pkgName);
        try {
            broadcastReceivers = this.mPm.queryIntentReceivers(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), 128, this.mUserId);
        }
        catch (RemoteException re) {
            return false;
        }
        int N = broadcastReceivers == null ? 0 : broadcastReceivers.size();
        for (int i = 0; i < N; ++i) {
            ResolveInfo ri = broadcastReceivers.get(i);
            ActivityInfo ai = ri.activityInfo;
            if ((ai.applicationInfo.flags & 0x40000) != 0 || !pkgName.equals(ai.packageName)) continue;
            this.addProviderLocked(ri);
            providersAdded = true;
        }
        return providersAdded;
    }

    boolean updateProvidersForPackageLocked(String pkgName, Set<ComponentName> removedProviders) {
        int i;
        List<ResolveInfo> broadcastReceivers;
        boolean providersUpdated = false;
        HashSet<String> keep = new HashSet<String>();
        Intent intent = new Intent("android.appwidget.action.APPWIDGET_UPDATE");
        intent.setPackage(pkgName);
        try {
            broadcastReceivers = this.mPm.queryIntentReceivers(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), 128, this.mUserId);
        }
        catch (RemoteException re) {
            return false;
        }
        int N = broadcastReceivers == null ? 0 : broadcastReceivers.size();
        for (i = 0; i < N; ++i) {
            ResolveInfo ri = broadcastReceivers.get(i);
            ActivityInfo ai = ri.activityInfo;
            if ((ai.applicationInfo.flags & 0x40000) != 0 || !pkgName.equals(ai.packageName)) continue;
            ComponentName component = new ComponentName(ai.packageName, ai.name);
            Provider p = this.lookupProviderLocked(component);
            if (p == null) {
                if (!this.addProviderLocked(ri)) continue;
                keep.add(ai.name);
                providersUpdated = true;
                continue;
            }
            Provider parsed = this.parseProviderInfoXml(component, ri);
            if (parsed == null) continue;
            keep.add(ai.name);
            p.info = parsed.info;
            int M = p.instances.size();
            if (M <= 0) continue;
            int[] appWidgetIds = AppWidgetServiceImpl.getAppWidgetIds(p);
            this.cancelBroadcasts(p);
            this.registerForBroadcastsLocked(p, appWidgetIds);
            for (int j = 0; j < M; ++j) {
                AppWidgetId id2 = p.instances.get(j);
                id2.views = null;
                if (id2.host == null || id2.host.callbacks == null) continue;
                try {
                    id2.host.callbacks.providerChanged(id2.appWidgetId, p.info, this.mUserId);
                    continue;
                }
                catch (RemoteException ex) {
                    id2.host.callbacks = null;
                }
            }
            this.sendUpdateIntentLocked(p, appWidgetIds);
            providersUpdated = true;
        }
        N = this.mInstalledProviders.size();
        for (i = N - 1; i >= 0; --i) {
            Provider p = this.mInstalledProviders.get(i);
            if (!pkgName.equals(p.info.provider.getPackageName()) || keep.contains(p.info.provider.getClassName())) continue;
            if (removedProviders != null) {
                removedProviders.add(p.info.provider);
            }
            this.removeProviderLocked(i, p);
            providersUpdated = true;
        }
        return providersUpdated;
    }

    boolean removeProvidersForPackageLocked(String pkgName) {
        int i;
        boolean providersRemoved = false;
        int N = this.mInstalledProviders.size();
        for (i = N - 1; i >= 0; --i) {
            Provider p = this.mInstalledProviders.get(i);
            if (!pkgName.equals(p.info.provider.getPackageName())) continue;
            this.removeProviderLocked(i, p);
            providersRemoved = true;
        }
        N = this.mHosts.size();
        for (i = N - 1; i >= 0; --i) {
            Host host = this.mHosts.get(i);
            if (!pkgName.equals(host.packageName)) continue;
            this.deleteHostLocked(host);
        }
        return providersRemoved;
    }

    void notifyHostsForProvidersChangedLocked() {
        int N = this.mHosts.size();
        for (int i = N - 1; i >= 0; --i) {
            Host host = this.mHosts.get(i);
            try {
                if (host.callbacks == null) continue;
                host.callbacks.providersChanged(this.mUserId);
                continue;
            }
            catch (RemoteException ex) {
                host.callbacks = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ServiceConnectionProxy
    implements ServiceConnection {
        private final IBinder mConnectionCb;

        ServiceConnectionProxy(Pair<Integer, Intent.FilterComparison> key, IBinder connectionCb) {
            this.mConnectionCb = connectionCb;
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            IRemoteViewsAdapterConnection cb = IRemoteViewsAdapterConnection.Stub.asInterface(this.mConnectionCb);
            try {
                cb.onServiceConnected(service);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            this.disconnect();
        }

        public void disconnect() {
            IRemoteViewsAdapterConnection cb = IRemoteViewsAdapterConnection.Stub.asInterface(this.mConnectionCb);
            try {
                cb.onServiceDisconnected();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static class AppWidgetId {
        int appWidgetId;
        Provider provider;
        RemoteViews views;
        Bundle options;
        Host host;

        AppWidgetId() {
        }
    }

    static class Host {
        int uid;
        int hostId;
        String packageName;
        ArrayList<AppWidgetId> instances = new ArrayList();
        IAppWidgetHost callbacks;
        boolean zombie;
        int tag;

        Host() {
        }

        boolean uidMatches(int callingUid) {
            if (UserHandle.getAppId(callingUid) == Process.myUid()) {
                return UserHandle.isSameApp(this.uid, callingUid);
            }
            return this.uid == callingUid;
        }
    }

    static class Provider {
        int uid;
        AppWidgetProviderInfo info;
        ArrayList<AppWidgetId> instances = new ArrayList();
        PendingIntent broadcast;
        boolean zombie;
        int tag;

        Provider() {
        }
    }
}

