/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.AbstractSessionContext;
import com.android.org.conscrypt.CipherSuite;
import com.android.org.conscrypt.ClientSessionContext;
import com.android.org.conscrypt.NativeCrypto;
import com.android.org.conscrypt.OpenSSLKey;
import com.android.org.conscrypt.OpenSSLSessionImpl;
import com.android.org.conscrypt.OpenSSLX509Certificate;
import com.android.org.conscrypt.SSLParametersImpl;
import com.android.org.conscrypt.SSLSessionImpl;
import com.android.org.conscrypt.TrustManagerImpl;
import dalvik.system.BlockGuard;
import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.InvalidKeyException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import libcore.io.ErrnoException;
import libcore.io.Libcore;
import libcore.io.OsConstants;
import libcore.io.Streams;
import libcore.io.StructTimeval;

public class OpenSSLSocketImpl
extends SSLSocket
implements NativeCrypto.SSLHandshakeCallbacks {
    private long sslNativePointer;
    private InputStream is;
    private OutputStream os;
    private final Object handshakeLock = new Object();
    private final Object readLock = new Object();
    private final Object writeLock = new Object();
    private SSLParametersImpl sslParameters;
    private byte[] npnProtocols;
    private byte[] alpnProtocols;
    private String[] enabledProtocols;
    private String[] enabledCipherSuites;
    private boolean useSessionTickets;
    private String hostname;
    private boolean channelIdEnabled;
    private OpenSSLKey channelIdPrivateKey;
    private OpenSSLSessionImpl sslSession;
    private final Socket socket;
    private boolean autoClose;
    private boolean handshakeStarted = false;
    private final CloseGuard guard = CloseGuard.get();
    private boolean handshakeCompleted = false;
    private ArrayList<HandshakeCompletedListener> listeners;
    private int readTimeoutMilliseconds = 0;
    private int writeTimeoutMilliseconds = 0;
    private int handshakeTimeoutMilliseconds = -1;
    private String wrappedHost;
    private int wrappedPort;

    protected OpenSSLSocketImpl(SSLParametersImpl sslParameters) throws IOException {
        this.socket = this;
        this.init(sslParameters);
    }

    protected OpenSSLSocketImpl(SSLParametersImpl sslParameters, String[] enabledProtocols, String[] enabledCipherSuites) throws IOException {
        this.socket = this;
        this.init(sslParameters, enabledProtocols, enabledCipherSuites);
    }

    protected OpenSSLSocketImpl(String host, int port, SSLParametersImpl sslParameters) throws IOException {
        super(host, port);
        this.socket = this;
        this.init(sslParameters);
    }

    protected OpenSSLSocketImpl(InetAddress address, int port, SSLParametersImpl sslParameters) throws IOException {
        super(address, port);
        this.socket = this;
        this.init(sslParameters);
    }

    protected OpenSSLSocketImpl(String host, int port, InetAddress clientAddress, int clientPort, SSLParametersImpl sslParameters) throws IOException {
        super(host, port, clientAddress, clientPort);
        this.socket = this;
        this.init(sslParameters);
    }

    protected OpenSSLSocketImpl(InetAddress address, int port, InetAddress clientAddress, int clientPort, SSLParametersImpl sslParameters) throws IOException {
        super(address, port, clientAddress, clientPort);
        this.socket = this;
        this.init(sslParameters);
    }

    protected OpenSSLSocketImpl(Socket socket, String host, int port, boolean autoClose, SSLParametersImpl sslParameters) throws IOException {
        this.socket = socket;
        this.wrappedHost = host;
        this.wrappedPort = port;
        this.autoClose = autoClose;
        this.init(sslParameters);
    }

    private void init(SSLParametersImpl sslParameters) throws IOException {
        this.init(sslParameters, NativeCrypto.getDefaultProtocols(), NativeCrypto.getDefaultCipherSuites());
    }

    private void init(SSLParametersImpl sslParameters, String[] enabledProtocols, String[] enabledCipherSuites) throws IOException {
        this.sslParameters = sslParameters;
        this.enabledProtocols = enabledProtocols;
        this.enabledCipherSuites = enabledCipherSuites;
    }

    private OpenSSLSessionImpl getCachedClientSession(ClientSessionContext sessionContext) {
        String hostName = this.getPeerHostName();
        int port = this.getPeerPort();
        if (hostName == null) {
            return null;
        }
        OpenSSLSessionImpl session = (OpenSSLSessionImpl)sessionContext.getSession(hostName, port);
        if (session == null) {
            return null;
        }
        String protocol = session.getProtocol();
        boolean protocolFound = false;
        for (String enabledProtocol : this.enabledProtocols) {
            if (!protocol.equals(enabledProtocol)) continue;
            protocolFound = true;
            break;
        }
        if (!protocolFound) {
            return null;
        }
        String cipherSuite = session.getCipherSuite();
        boolean cipherSuiteFound = false;
        for (String enabledCipherSuite : this.enabledCipherSuites) {
            if (!cipherSuite.equals(enabledCipherSuite)) continue;
            cipherSuiteFound = true;
            break;
        }
        if (!cipherSuiteFound) {
            return null;
        }
        return session;
    }

    private void checkOpen() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startHandshake() throws IOException {
        Object object = this.handshakeLock;
        synchronized (object) {
            this.checkOpen();
            if (this.handshakeStarted) {
                return;
            }
            this.handshakeStarted = true;
        }
        int seedLengthInBytes = 1024;
        SecureRandom secureRandom = this.sslParameters.getSecureRandomMember();
        if (secureRandom == null) {
            NativeCrypto.RAND_load_file("/dev/urandom", 1024L);
        } else {
            NativeCrypto.RAND_seed(secureRandom.generateSeed(1024));
        }
        boolean client = this.sslParameters.getUseClientMode();
        long sslCtxNativePointer = client ? this.sslParameters.getClientSessionContext().sslCtxNativePointer : this.sslParameters.getServerSessionContext().sslCtxNativePointer;
        this.sslNativePointer = 0L;
        boolean exception = true;
        try {
            int sslSessionNativePointer;
            OpenSSLSessionImpl sessionToReuse;
            AbstractSessionContext sessionContext;
            boolean enableSessionCreation;
            this.sslNativePointer = NativeCrypto.SSL_new(sslCtxNativePointer);
            this.guard.open("close");
            if (this.npnProtocols != null) {
                NativeCrypto.SSL_CTX_enable_npn(sslCtxNativePointer);
            }
            if (client && this.alpnProtocols != null) {
                NativeCrypto.SSL_CTX_set_alpn_protos(sslCtxNativePointer, this.alpnProtocols);
            }
            if (!client) {
                HashSet<String> keyTypes = new HashSet<String>();
                for (String enabledCipherSuite : this.enabledCipherSuites) {
                    String keyType;
                    if (enabledCipherSuite.equals("TLS_EMPTY_RENEGOTIATION_INFO_SCSV") || (keyType = CipherSuite.getByName(enabledCipherSuite).getServerKeyType()) == null) continue;
                    keyTypes.add(keyType);
                }
                for (String keyType : keyTypes) {
                    try {
                        this.setCertificate(this.sslParameters.getKeyManager().chooseServerAlias(keyType, null, this));
                    }
                    catch (CertificateEncodingException e) {
                        throw new IOException(e);
                    }
                }
            }
            NativeCrypto.setEnabledProtocols(this.sslNativePointer, this.enabledProtocols);
            NativeCrypto.setEnabledCipherSuites(this.sslNativePointer, this.enabledCipherSuites);
            if (this.useSessionTickets) {
                NativeCrypto.SSL_clear_options(this.sslNativePointer, 16384L);
            }
            if (this.hostname != null) {
                NativeCrypto.SSL_set_tlsext_host_name(this.sslNativePointer, this.hostname);
            }
            if (!(enableSessionCreation = this.sslParameters.getEnableSessionCreation())) {
                NativeCrypto.SSL_set_session_creation_enabled(this.sslNativePointer, enableSessionCreation);
            }
            if (client) {
                ClientSessionContext clientSessionContext = this.sslParameters.getClientSessionContext();
                sessionContext = clientSessionContext;
                sessionToReuse = this.getCachedClientSession(clientSessionContext);
                if (sessionToReuse != null) {
                    NativeCrypto.SSL_set_session(this.sslNativePointer, sessionToReuse.sslSessionNativePointer);
                }
            } else {
                sessionContext = this.sslParameters.getServerSessionContext();
                sessionToReuse = null;
            }
            if (!client) {
                X509TrustManager trustManager;
                X509Certificate[] issuers;
                boolean certRequested;
                if (this.sslParameters.getNeedClientAuth()) {
                    NativeCrypto.SSL_set_verify(this.sslNativePointer, 3);
                    certRequested = true;
                } else if (this.sslParameters.getWantClientAuth()) {
                    NativeCrypto.SSL_set_verify(this.sslNativePointer, 1);
                    certRequested = true;
                } else {
                    certRequested = false;
                }
                if (certRequested && (issuers = (trustManager = this.sslParameters.getTrustManager()).getAcceptedIssuers()) != null && issuers.length != 0) {
                    byte[][] issuersBytes;
                    try {
                        issuersBytes = OpenSSLSocketImpl.encodeIssuerX509Principals(issuers);
                    }
                    catch (CertificateEncodingException e) {
                        throw new IOException("Problem encoding principals", e);
                    }
                    NativeCrypto.SSL_set_client_CA_list(this.sslNativePointer, issuersBytes);
                }
            }
            int savedReadTimeoutMilliseconds = this.getSoTimeout();
            int savedWriteTimeoutMilliseconds = this.getSoWriteTimeout();
            if (this.handshakeTimeoutMilliseconds >= 0) {
                this.setSoTimeout(this.handshakeTimeoutMilliseconds);
                this.setSoWriteTimeout(this.handshakeTimeoutMilliseconds);
            }
            if (this.channelIdEnabled) {
                if (client) {
                    if (this.channelIdPrivateKey == null) {
                        throw new SSLHandshakeException("Invalid TLS channel ID key specified");
                    }
                    NativeCrypto.SSL_set1_tls_channel_id(this.sslNativePointer, this.channelIdPrivateKey.getPkeyContext());
                } else {
                    NativeCrypto.SSL_enable_tls_channel_id(this.sslNativePointer);
                }
            }
            try {
                sslSessionNativePointer = NativeCrypto.SSL_do_handshake(this.sslNativePointer, this.socket.getFileDescriptor$(), this, this.getSoTimeout(), client, this.npnProtocols, client ? null : this.alpnProtocols);
            }
            catch (CertificateException e) {
                SSLHandshakeException wrapper = new SSLHandshakeException(e.getMessage());
                wrapper.initCause(e);
                throw wrapper;
            }
            byte[] sessionId = NativeCrypto.SSL_SESSION_session_id(sslSessionNativePointer);
            if (sessionToReuse != null && Arrays.equals(sessionToReuse.getId(), sessionId)) {
                this.sslSession = sessionToReuse;
                this.sslSession.lastAccessedTime = System.currentTimeMillis();
                NativeCrypto.SSL_SESSION_free(sslSessionNativePointer);
            } else {
                if (!enableSessionCreation) {
                    throw new IllegalStateException("SSL Session may not be created");
                }
                X509Certificate[] localCertificates = OpenSSLSocketImpl.createCertChain(NativeCrypto.SSL_get_certificate(this.sslNativePointer));
                X509Certificate[] peerCertificates = OpenSSLSocketImpl.createCertChain(NativeCrypto.SSL_get_peer_cert_chain(this.sslNativePointer));
                this.sslSession = new OpenSSLSessionImpl(sslSessionNativePointer, localCertificates, peerCertificates, this.getPeerHostName(), this.getPeerPort(), sessionContext);
                if (this.handshakeCompleted) {
                    sessionContext.putSession(this.sslSession);
                }
            }
            if (this.handshakeTimeoutMilliseconds >= 0) {
                this.setSoTimeout(savedReadTimeoutMilliseconds);
                this.setSoWriteTimeout(savedWriteTimeoutMilliseconds);
            }
            if (this.handshakeCompleted) {
                this.notifyHandshakeCompletedListeners();
            }
            exception = false;
        }
        catch (SSLProtocolException e) {
            throw new SSLHandshakeException(e);
        }
        finally {
            if (exception) {
                this.close();
            }
        }
    }

    private static byte[][] encodeIssuerX509Principals(X509Certificate[] certificates) throws CertificateEncodingException {
        byte[][] principalBytes = new byte[certificates.length][];
        for (int i = 0; i < certificates.length; ++i) {
            principalBytes[i] = certificates[i].getIssuerX500Principal().getEncoded();
        }
        return principalBytes;
    }

    String getPeerHostName() {
        if (this.wrappedHost != null) {
            return this.wrappedHost;
        }
        InetAddress inetAddress = super.getInetAddress();
        if (inetAddress != null) {
            return inetAddress.getHostName();
        }
        return null;
    }

    int getPeerPort() {
        return this.wrappedHost == null ? super.getPort() : this.wrappedPort;
    }

    private static X509Certificate[] createCertChain(byte[][] certificatesBytes) throws IOException {
        if (certificatesBytes == null) {
            return null;
        }
        X509Certificate[] certificates = new X509Certificate[certificatesBytes.length];
        for (int i = 0; i < certificatesBytes.length; ++i) {
            certificates[i] = OpenSSLX509Certificate.fromX509Der(certificatesBytes[i]);
        }
        return certificates;
    }

    private void setCertificate(String alias) throws CertificateEncodingException, SSLException {
        if (alias == null) {
            return;
        }
        PrivateKey privateKey = this.sslParameters.getKeyManager().getPrivateKey(alias);
        if (privateKey == null) {
            return;
        }
        Certificate[] certificates = this.sslParameters.getKeyManager().getCertificateChain(alias);
        if (certificates == null) {
            return;
        }
        byte[][] certificateBytes = NativeCrypto.encodeCertificates(certificates);
        NativeCrypto.SSL_use_certificate(this.sslNativePointer, certificateBytes);
        try {
            OpenSSLKey key = OpenSSLKey.fromPrivateKey(privateKey);
            NativeCrypto.SSL_use_PrivateKey(this.sslNativePointer, key.getPkeyContext());
        }
        catch (InvalidKeyException e) {
            throw new SSLException(e);
        }
        NativeCrypto.SSL_check_private_key(this.sslNativePointer);
    }

    public void clientCertificateRequested(byte[] keyTypeBytes, byte[][] asn1DerEncodedPrincipals) throws CertificateEncodingException, SSLException {
        Principal[] issuers;
        String[] keyTypes = new String[keyTypeBytes.length];
        for (int i = 0; i < keyTypeBytes.length; ++i) {
            keyTypes[i] = CipherSuite.getClientKeyType(keyTypeBytes[i]);
        }
        if (asn1DerEncodedPrincipals == null) {
            issuers = null;
        } else {
            issuers = new X500Principal[asn1DerEncodedPrincipals.length];
            for (int i = 0; i < asn1DerEncodedPrincipals.length; ++i) {
                issuers[i] = new X500Principal(asn1DerEncodedPrincipals[i]);
            }
        }
        this.setCertificate(this.sslParameters.getKeyManager().chooseClientAlias(keyTypes, issuers, this));
    }

    public void handshakeCompleted() {
        this.handshakeCompleted = true;
        if (this.sslSession == null) {
            return;
        }
        this.sslSession.resetId();
        AbstractSessionContext sessionContext = this.sslParameters.getUseClientMode() ? this.sslParameters.getClientSessionContext() : this.sslParameters.getServerSessionContext();
        sessionContext.putSession(this.sslSession);
        this.notifyHandshakeCompletedListeners();
    }

    private void notifyHandshakeCompletedListeners() {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            HandshakeCompletedEvent event = new HandshakeCompletedEvent(this, this.sslSession);
            for (HandshakeCompletedListener listener : this.listeners) {
                try {
                    listener.handshakeCompleted(event);
                }
                catch (RuntimeException e) {
                    Thread thread = Thread.currentThread();
                    thread.getUncaughtExceptionHandler().uncaughtException(thread, e);
                }
            }
        }
    }

    public void verifyCertificateChain(byte[][] bytes, String authMethod) throws CertificateException {
        try {
            if (bytes == null || bytes.length == 0) {
                throw new SSLException("Peer sent no certificate");
            }
            X509Certificate[] peerCertificateChain = new X509Certificate[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                peerCertificateChain[i] = OpenSSLX509Certificate.fromX509Der(bytes[i]);
            }
            boolean client = this.sslParameters.getUseClientMode();
            if (client) {
                X509TrustManager x509tm = this.sslParameters.getTrustManager();
                if (x509tm instanceof TrustManagerImpl) {
                    TrustManagerImpl tm = (TrustManagerImpl)x509tm;
                    tm.checkServerTrusted(peerCertificateChain, authMethod, this.wrappedHost);
                } else {
                    x509tm.checkServerTrusted(peerCertificateChain, authMethod);
                }
            } else {
                String authType = peerCertificateChain[0].getPublicKey().getAlgorithm();
                this.sslParameters.getTrustManager().checkClientTrusted(peerCertificateChain, authType);
            }
        }
        catch (CertificateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CertificateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        this.checkOpen();
        OpenSSLSocketImpl openSSLSocketImpl = this;
        synchronized (openSSLSocketImpl) {
            if (this.is == null) {
                this.is = new SSLInputStream();
            }
            return this.is;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream getOutputStream() throws IOException {
        this.checkOpen();
        OpenSSLSocketImpl openSSLSocketImpl = this;
        synchronized (openSSLSocketImpl) {
            if (this.os == null) {
                this.os = new SSLOutputStream();
            }
            return this.os;
        }
    }

    public SSLSession getSession() {
        if (this.sslSession == null) {
            try {
                this.startHandshake();
            }
            catch (IOException e) {
                return SSLSessionImpl.getNullSession();
            }
        }
        return this.sslSession;
    }

    public void addHandshakeCompletedListener(HandshakeCompletedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Provided listener is null");
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Provided listener is null");
        }
        if (this.listeners == null) {
            throw new IllegalArgumentException("Provided listener is not registered");
        }
        if (!this.listeners.remove(listener)) {
            throw new IllegalArgumentException("Provided listener is not registered");
        }
    }

    public boolean getEnableSessionCreation() {
        return this.sslParameters.getEnableSessionCreation();
    }

    public void setEnableSessionCreation(boolean flag) {
        this.sslParameters.setEnableSessionCreation(flag);
    }

    public String[] getSupportedCipherSuites() {
        return NativeCrypto.getSupportedCipherSuites();
    }

    public String[] getEnabledCipherSuites() {
        return (String[])this.enabledCipherSuites.clone();
    }

    public void setEnabledCipherSuites(String[] suites) {
        this.enabledCipherSuites = NativeCrypto.checkEnabledCipherSuites(suites);
    }

    public String[] getSupportedProtocols() {
        return NativeCrypto.getSupportedProtocols();
    }

    public String[] getEnabledProtocols() {
        return (String[])this.enabledProtocols.clone();
    }

    public void setEnabledProtocols(String[] protocols) {
        this.enabledProtocols = NativeCrypto.checkEnabledProtocols(protocols);
    }

    public void setUseSessionTickets(boolean useSessionTickets) {
        this.useSessionTickets = useSessionTickets;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setChannelIdEnabled(boolean enabled) {
        if (this.getUseClientMode()) {
            throw new IllegalStateException("Client mode");
        }
        if (this.handshakeStarted) {
            throw new IllegalStateException("Could not enable/disable Channel ID after the initial handshake has begun.");
        }
        this.channelIdEnabled = enabled;
    }

    public byte[] getChannelId() throws SSLException {
        if (this.getUseClientMode()) {
            throw new IllegalStateException("Client mode");
        }
        if (!this.handshakeCompleted) {
            throw new IllegalStateException("Channel ID is only available after handshake completes");
        }
        return NativeCrypto.SSL_get_tls_channel_id(this.sslNativePointer);
    }

    public void setChannelIdPrivateKey(PrivateKey privateKey) {
        if (!this.getUseClientMode()) {
            throw new IllegalStateException("Server mode");
        }
        if (this.handshakeStarted) {
            throw new IllegalStateException("Could not change Channel ID private key after the initial handshake has begun.");
        }
        if (privateKey == null) {
            this.channelIdEnabled = false;
            this.channelIdPrivateKey = null;
        } else {
            this.channelIdEnabled = true;
            try {
                this.channelIdPrivateKey = OpenSSLKey.fromPrivateKey(privateKey);
            }
            catch (InvalidKeyException invalidKeyException) {
                // empty catch block
            }
        }
    }

    public boolean getUseClientMode() {
        return this.sslParameters.getUseClientMode();
    }

    public void setUseClientMode(boolean mode) {
        if (this.handshakeStarted) {
            throw new IllegalArgumentException("Could not change the mode after the initial handshake has begun.");
        }
        this.sslParameters.setUseClientMode(mode);
    }

    public boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    public boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    public void setNeedClientAuth(boolean need) {
        this.sslParameters.setNeedClientAuth(need);
    }

    public void setWantClientAuth(boolean want) {
        this.sslParameters.setWantClientAuth(want);
    }

    public void sendUrgentData(int data) throws IOException {
        throw new SocketException("Method sendUrgentData() is not supported.");
    }

    public void setOOBInline(boolean on) throws SocketException {
        throw new SocketException("Methods sendUrgentData, setOOBInline are not supported.");
    }

    public void setSoTimeout(int readTimeoutMilliseconds) throws SocketException {
        super.setSoTimeout(readTimeoutMilliseconds);
        this.readTimeoutMilliseconds = readTimeoutMilliseconds;
    }

    public int getSoTimeout() throws SocketException {
        return this.readTimeoutMilliseconds;
    }

    public void setSoWriteTimeout(int writeTimeoutMilliseconds) throws SocketException {
        this.writeTimeoutMilliseconds = writeTimeoutMilliseconds;
        StructTimeval tv = StructTimeval.fromMillis(writeTimeoutMilliseconds);
        try {
            Libcore.os.setsockoptTimeval(this.getFileDescriptor$(), OsConstants.SOL_SOCKET, OsConstants.SO_SNDTIMEO, tv);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsSocketException();
        }
    }

    public int getSoWriteTimeout() throws SocketException {
        return this.writeTimeoutMilliseconds;
    }

    public void setHandshakeTimeout(int handshakeTimeoutMilliseconds) throws SocketException {
        this.handshakeTimeoutMilliseconds = handshakeTimeoutMilliseconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.handshakeLock;
        synchronized (object) {
            if (!this.handshakeStarted) {
                this.handshakeStarted = true;
                OpenSSLSocketImpl openSSLSocketImpl = this;
                synchronized (openSSLSocketImpl) {
                    this.free();
                    if (this.socket != this) {
                        if (this.autoClose && !this.socket.isClosed()) {
                            this.socket.close();
                        }
                    } else if (!super.isClosed()) {
                        super.close();
                    }
                }
                return;
            }
        }
        object = this;
        synchronized (object) {
            NativeCrypto.SSL_interrupt(this.sslNativePointer);
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.readLock;
                synchronized (object3) {
                    try {
                        if (this.handshakeStarted) {
                            BlockGuard.getThreadPolicy().onNetwork();
                            NativeCrypto.SSL_shutdown(this.sslNativePointer, this.socket.getFileDescriptor$(), this);
                        }
                    }
                    catch (IOException ignored) {
                    }
                    finally {
                        this.free();
                        if (this.socket != this) {
                            if (this.autoClose && !this.socket.isClosed()) {
                                this.socket.close();
                            }
                        } else if (!super.isClosed()) {
                            super.close();
                        }
                    }
                }
            }
        }
    }

    private void free() {
        if (this.sslNativePointer == 0L) {
            return;
        }
        NativeCrypto.SSL_free(this.sslNativePointer);
        this.sslNativePointer = 0L;
        this.guard.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.guard != null) {
                this.guard.warnIfOpen();
            }
            this.free();
        }
        finally {
            super.finalize();
        }
    }

    public FileDescriptor getFileDescriptor$() {
        if (this.socket == this) {
            return super.getFileDescriptor$();
        }
        return this.socket.getFileDescriptor$();
    }

    public byte[] getNpnSelectedProtocol() {
        return NativeCrypto.SSL_get_npn_negotiated_protocol(this.sslNativePointer);
    }

    public byte[] getAlpnSelectedProtocol() {
        return NativeCrypto.SSL_get0_alpn_selected(this.sslNativePointer);
    }

    public void setNpnProtocols(byte[] npnProtocols) {
        if (npnProtocols != null && npnProtocols.length == 0) {
            throw new IllegalArgumentException("npnProtocols.length == 0");
        }
        this.npnProtocols = npnProtocols;
    }

    public void setAlpnProtocols(byte[] alpnProtocols) {
        if (alpnProtocols != null && alpnProtocols.length == 0) {
            throw new IllegalArgumentException("alpnProtocols.length == 0");
        }
        this.alpnProtocols = alpnProtocols;
    }

    private class SSLOutputStream
    extends OutputStream {
        SSLOutputStream() throws IOException {
            OpenSSLSocketImpl.this.startHandshake();
        }

        public void write(int oneByte) throws IOException {
            Streams.writeSingleByte(this, oneByte);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] buf, int offset, int byteCount) throws IOException {
            BlockGuard.getThreadPolicy().onNetwork();
            Object object = OpenSSLSocketImpl.this.writeLock;
            synchronized (object) {
                OpenSSLSocketImpl.this.checkOpen();
                Arrays.checkOffsetAndCount(buf.length, offset, byteCount);
                if (byteCount == 0) {
                    return;
                }
                NativeCrypto.SSL_write(OpenSSLSocketImpl.this.sslNativePointer, OpenSSLSocketImpl.this.socket.getFileDescriptor$(), OpenSSLSocketImpl.this, buf, offset, byteCount, OpenSSLSocketImpl.this.writeTimeoutMilliseconds);
            }
        }
    }

    private class SSLInputStream
    extends InputStream {
        SSLInputStream() throws IOException {
            OpenSSLSocketImpl.this.startHandshake();
        }

        public int read() throws IOException {
            return Streams.readSingleByte(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] buf, int offset, int byteCount) throws IOException {
            BlockGuard.getThreadPolicy().onNetwork();
            Object object = OpenSSLSocketImpl.this.readLock;
            synchronized (object) {
                OpenSSLSocketImpl.this.checkOpen();
                Arrays.checkOffsetAndCount(buf.length, offset, byteCount);
                if (byteCount == 0) {
                    return 0;
                }
                return NativeCrypto.SSL_read(OpenSSLSocketImpl.this.sslNativePointer, OpenSSLSocketImpl.this.socket.getFileDescriptor$(), OpenSSLSocketImpl.this, buf, offset, byteCount, OpenSSLSocketImpl.this.getSoTimeout());
            }
        }
    }
}

