/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.NativeCrypto;
import com.android.org.conscrypt.OpenSSLKey;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.spec.AlgorithmParameterSpec;

public class OpenSSLDSAParams
implements DSAParams,
AlgorithmParameterSpec {
    private OpenSSLKey key;
    private boolean fetchedParams;
    private BigInteger g;
    private BigInteger p;
    private BigInteger q;
    private BigInteger y;
    private BigInteger x;

    OpenSSLDSAParams(OpenSSLKey key) {
        this.key = key;
    }

    OpenSSLKey getOpenSSLKey() {
        return this.key;
    }

    private final synchronized void ensureReadParams() {
        if (this.fetchedParams) {
            return;
        }
        byte[][] params = NativeCrypto.get_DSA_params(this.key.getPkeyContext());
        if (params[0] != null) {
            this.g = new BigInteger(params[0]);
        }
        if (params[1] != null) {
            this.p = new BigInteger(params[1]);
        }
        if (params[2] != null) {
            this.q = new BigInteger(params[2]);
        }
        if (params[3] != null) {
            this.y = new BigInteger(params[3]);
        }
        if (params[4] != null) {
            this.x = new BigInteger(params[4]);
        }
        this.fetchedParams = true;
    }

    public BigInteger getG() {
        this.ensureReadParams();
        return this.g;
    }

    public BigInteger getP() {
        this.ensureReadParams();
        return this.p;
    }

    public BigInteger getQ() {
        this.ensureReadParams();
        return this.q;
    }

    boolean hasParams() {
        this.ensureReadParams();
        return this.g != null && this.p != null && this.q != null;
    }

    BigInteger getY() {
        this.ensureReadParams();
        return this.y;
    }

    BigInteger getX() {
        this.ensureReadParams();
        return this.x;
    }

    public boolean equals(Object o) {
        DSAParams other;
        if (o == this) {
            return true;
        }
        if (o instanceof OpenSSLDSAParams && this.key == ((OpenSSLDSAParams)(other = (OpenSSLDSAParams)o)).getOpenSSLKey()) {
            return true;
        }
        if (!(o instanceof DSAParams)) {
            return false;
        }
        this.ensureReadParams();
        other = (DSAParams)o;
        return this.g.equals(other.getG()) && this.p.equals(other.getP()) && this.q.equals(other.getQ());
    }

    public int hashCode() {
        this.ensureReadParams();
        return this.g.hashCode() ^ this.p.hashCode() ^ this.q.hashCode();
    }

    public String toString() {
        this.ensureReadParams();
        StringBuilder sb = new StringBuilder("OpenSSLDSAParams{");
        sb.append("G=");
        sb.append(this.g.toString(16));
        sb.append(",P=");
        sb.append(this.p.toString(16));
        sb.append(",Q=");
        sb.append(this.q.toString(16));
        sb.append('}');
        return sb.toString();
    }
}

