/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.AlertException;
import com.android.org.conscrypt.Appendable;
import com.android.org.conscrypt.DataStream;
import com.android.org.conscrypt.EndOfBufferException;
import com.android.org.conscrypt.SSLInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.net.ssl.SSLHandshakeException;

public class HandshakeIODataStream
extends SSLInputStream
implements Appendable,
DataStream {
    private static final MessageDigest md5;
    private static final MessageDigest sha;
    private int buff_size = 1024;
    private int inc_buff_size = 1024;
    private byte[] buffer = new byte[this.buff_size];
    private int read_pos;
    private int marked_pos;
    private int read_pos_end;
    private int write_pos;
    private int write_pos_beg;

    public int available() {
        return this.read_pos_end - this.read_pos;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int limit) {
        this.marked_pos = this.read_pos;
    }

    public void mark() {
        this.marked_pos = this.read_pos;
    }

    public void reset() {
        this.read_pos = this.marked_pos;
    }

    protected void removeFromMarkedPosition() {
        System.arraycopy(this.buffer, this.read_pos, this.buffer, this.marked_pos, this.read_pos_end - this.read_pos);
        this.read_pos_end -= this.read_pos - this.marked_pos;
        this.read_pos = this.marked_pos;
    }

    public int read() throws IOException {
        if (this.read_pos == this.read_pos_end) {
            throw new EndOfBufferException();
        }
        return this.buffer[this.read_pos++] & 0xFF;
    }

    public byte[] read(int length) throws IOException {
        if (length > this.available()) {
            throw new EndOfBufferException();
        }
        byte[] res = new byte[length];
        System.arraycopy(this.buffer, this.read_pos, res, 0, length);
        this.read_pos += length;
        return res;
    }

    public int read(byte[] dst, int offset, int length) throws IOException {
        if (length > this.available()) {
            throw new EndOfBufferException();
        }
        System.arraycopy(this.buffer, this.read_pos, dst, offset, length);
        this.read_pos += length;
        return length;
    }

    public void append(byte[] src) {
        this.append(src, 0, src.length);
    }

    private void append(byte[] src, int from, int length) {
        if (this.read_pos == this.read_pos_end) {
            if (this.write_pos_beg != this.write_pos) {
                throw new AlertException(10, new SSLHandshakeException("Handshake message has been received before the last oubound message had been sent."));
            }
            if (this.read_pos < this.write_pos) {
                this.read_pos_end = this.read_pos = this.write_pos;
            }
        }
        if (this.read_pos_end + length > this.buff_size) {
            this.enlargeBuffer(this.read_pos_end + length - this.buff_size);
        }
        System.arraycopy(src, from, this.buffer, this.read_pos_end, length);
        this.read_pos_end += length;
    }

    private void enlargeBuffer(int size) {
        this.buff_size = size < this.inc_buff_size ? this.buff_size + this.inc_buff_size : this.buff_size + size;
        byte[] new_buff = new byte[this.buff_size];
        System.arraycopy(this.buffer, 0, new_buff, 0, this.buffer.length);
        this.buffer = new_buff;
    }

    protected void clearBuffer() {
        this.read_pos = 0;
        this.marked_pos = 0;
        this.read_pos_end = 0;
        this.write_pos = 0;
        this.write_pos_beg = 0;
        Arrays.fill(this.buffer, (byte)0);
    }

    private void check(int length) {
        if (this.write_pos == this.write_pos_beg) {
            if (this.read_pos != this.read_pos_end) {
                throw new AlertException(80, new SSLHandshakeException("Data was not fully read: " + this.read_pos + " " + this.read_pos_end));
            }
            if (this.write_pos_beg < this.read_pos_end) {
                this.write_pos = this.write_pos_beg = this.read_pos_end;
            }
        }
        if (this.write_pos + length >= this.buff_size) {
            this.enlargeBuffer(length);
        }
    }

    public void write(byte b) {
        this.check(1);
        this.buffer[this.write_pos++] = b;
    }

    public void writeUint8(long n) {
        this.check(1);
        this.buffer[this.write_pos++] = (byte)(n & 0xFFL);
    }

    public void writeUint16(long n) {
        this.check(2);
        this.buffer[this.write_pos++] = (byte)((n & 0xFF00L) >> 8);
        this.buffer[this.write_pos++] = (byte)(n & 0xFFL);
    }

    public void writeUint24(long n) {
        this.check(3);
        this.buffer[this.write_pos++] = (byte)((n & 0xFF0000L) >> 16);
        this.buffer[this.write_pos++] = (byte)((n & 0xFF00L) >> 8);
        this.buffer[this.write_pos++] = (byte)(n & 0xFFL);
    }

    public void writeUint32(long n) {
        this.check(4);
        this.buffer[this.write_pos++] = (byte)((n & 0xFFFFFFFFFF000000L) >> 24);
        this.buffer[this.write_pos++] = (byte)((n & 0xFF0000L) >> 16);
        this.buffer[this.write_pos++] = (byte)((n & 0xFF00L) >> 8);
        this.buffer[this.write_pos++] = (byte)(n & 0xFFL);
    }

    public void writeUint64(long n) {
        this.check(8);
        this.buffer[this.write_pos++] = (byte)((n & 0xFF00000000000000L) >> 56);
        this.buffer[this.write_pos++] = (byte)((n & 0xFF000000000000L) >> 48);
        this.buffer[this.write_pos++] = (byte)((n & 0xFF0000000000L) >> 40);
        this.buffer[this.write_pos++] = (byte)((n & 0xFF00000000L) >> 32);
        this.buffer[this.write_pos++] = (byte)((n & 0xFFFFFFFFFF000000L) >> 24);
        this.buffer[this.write_pos++] = (byte)((n & 0xFF0000L) >> 16);
        this.buffer[this.write_pos++] = (byte)((n & 0xFF00L) >> 8);
        this.buffer[this.write_pos++] = (byte)(n & 0xFFL);
    }

    public void write(byte[] vector) {
        this.check(vector.length);
        System.arraycopy(vector, 0, this.buffer, this.write_pos, vector.length);
        this.write_pos += vector.length;
    }

    public boolean hasData() {
        return this.write_pos > this.write_pos_beg;
    }

    public byte[] getData(int length) {
        byte[] res;
        if (this.write_pos - this.write_pos_beg < length) {
            res = new byte[this.write_pos - this.write_pos_beg];
            System.arraycopy(this.buffer, this.write_pos_beg, res, 0, this.write_pos - this.write_pos_beg);
            this.write_pos_beg = this.write_pos;
        } else {
            res = new byte[length];
            System.arraycopy(this.buffer, this.write_pos_beg, res, 0, length);
            this.write_pos_beg += length;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getDigestMD5() {
        MessageDigest messageDigest = md5;
        synchronized (messageDigest) {
            int len = this.read_pos_end > this.write_pos ? this.read_pos_end : this.write_pos;
            md5.update(this.buffer, 0, len);
            return md5.digest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getDigestSHA() {
        MessageDigest messageDigest = sha;
        synchronized (messageDigest) {
            int len = this.read_pos_end > this.write_pos ? this.read_pos_end : this.write_pos;
            sha.update(this.buffer, 0, len);
            return sha.digest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getDigestMD5withoutLast() {
        MessageDigest messageDigest = md5;
        synchronized (messageDigest) {
            md5.update(this.buffer, 0, this.marked_pos);
            return md5.digest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getDigestSHAwithoutLast() {
        MessageDigest messageDigest = sha;
        synchronized (messageDigest) {
            sha.update(this.buffer, 0, this.marked_pos);
            return sha.digest();
        }
    }

    protected byte[] getMessages() {
        int len = this.read_pos_end > this.write_pos ? this.read_pos_end : this.write_pos;
        byte[] res = new byte[len];
        System.arraycopy(this.buffer, 0, res, 0, len);
        return res;
    }

    static {
        try {
            md5 = MessageDigest.getInstance("MD5");
            sha = MessageDigest.getInstance("SHA-1");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Could not initialize the Digest Algorithms.");
        }
    }
}

