/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.AlertException;
import com.android.org.conscrypt.CipherSuite;
import com.android.org.conscrypt.ConnectionState;
import com.android.org.conscrypt.PRF;
import com.android.org.conscrypt.SSLSessionImpl;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NullCipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLProtocolException;

public class ConnectionStateTLS
extends ConnectionState {
    private static byte[] KEY_EXPANSION_LABEL = new byte[]{107, 101, 121, 32, 101, 120, 112, 97, 110, 115, 105, 111, 110};
    private static byte[] CLIENT_WRITE_KEY_LABEL = new byte[]{99, 108, 105, 101, 110, 116, 32, 119, 114, 105, 116, 101, 32, 107, 101, 121};
    private static byte[] SERVER_WRITE_KEY_LABEL = new byte[]{115, 101, 114, 118, 101, 114, 32, 119, 114, 105, 116, 101, 32, 107, 101, 121};
    private static byte[] IV_BLOCK_LABEL = new byte[]{73, 86, 32, 98, 108, 111, 99, 107};
    private final Mac encMac;
    private final Mac decMac;
    private final byte[] mac_material_header = new byte[]{0, 3, 1, 0, 0};

    protected ConnectionStateTLS(SSLSessionImpl session) {
        try {
            CipherSuite cipherSuite = session.cipherSuite;
            this.hash_size = cipherSuite.getMACLength();
            boolean is_exportabe = cipherSuite.isExportable();
            int key_size = is_exportabe ? cipherSuite.keyMaterial : cipherSuite.expandedKeyMaterial;
            int iv_size = cipherSuite.ivSize;
            this.block_size = cipherSuite.getBlockSize();
            String algName = cipherSuite.getBulkEncryptionAlgorithm();
            String macName = cipherSuite.getHmacName();
            if (this.logger != null) {
                this.logger.println("ConnectionStateTLS.create:");
                this.logger.println("  cipher suite name: " + cipherSuite.getName());
                this.logger.println("  encryption alg name: " + algName);
                this.logger.println("  mac alg name: " + macName);
                this.logger.println("  hash size: " + this.hash_size);
                this.logger.println("  block size: " + this.block_size);
                this.logger.println("  IV size:" + iv_size);
                this.logger.println("  key size: " + key_size);
            }
            byte[] clientRandom = session.clientRandom;
            byte[] serverRandom = session.serverRandom;
            byte[] key_block = new byte[2 * this.hash_size + 2 * key_size + 2 * iv_size];
            byte[] seed = new byte[clientRandom.length + serverRandom.length];
            System.arraycopy(serverRandom, 0, seed, 0, serverRandom.length);
            System.arraycopy(clientRandom, 0, seed, serverRandom.length, clientRandom.length);
            PRF.computePRF(key_block, session.master_secret, KEY_EXPANSION_LABEL, seed);
            byte[] client_mac_secret = new byte[this.hash_size];
            byte[] server_mac_secret = new byte[this.hash_size];
            byte[] client_key = new byte[key_size];
            byte[] server_key = new byte[key_size];
            boolean is_client = !session.isServer;
            System.arraycopy(key_block, 0, client_mac_secret, 0, this.hash_size);
            System.arraycopy(key_block, this.hash_size, server_mac_secret, 0, this.hash_size);
            System.arraycopy(key_block, 2 * this.hash_size, client_key, 0, key_size);
            System.arraycopy(key_block, 2 * this.hash_size + key_size, server_key, 0, key_size);
            IvParameterSpec clientIV = null;
            IvParameterSpec serverIV = null;
            if (is_exportabe) {
                System.arraycopy(clientRandom, 0, seed, 0, clientRandom.length);
                System.arraycopy(serverRandom, 0, seed, clientRandom.length, serverRandom.length);
                byte[] final_client_key = new byte[cipherSuite.expandedKeyMaterial];
                byte[] final_server_key = new byte[cipherSuite.expandedKeyMaterial];
                PRF.computePRF(final_client_key, client_key, CLIENT_WRITE_KEY_LABEL, seed);
                PRF.computePRF(final_server_key, server_key, SERVER_WRITE_KEY_LABEL, seed);
                client_key = final_client_key;
                server_key = final_server_key;
                if (this.block_size != 0) {
                    byte[] iv_block = new byte[2 * iv_size];
                    PRF.computePRF(iv_block, null, IV_BLOCK_LABEL, seed);
                    clientIV = new IvParameterSpec(iv_block, 0, iv_size);
                    serverIV = new IvParameterSpec(iv_block, iv_size, iv_size);
                }
            } else if (this.block_size != 0) {
                clientIV = new IvParameterSpec(key_block, 2 * (this.hash_size + key_size), iv_size);
                serverIV = new IvParameterSpec(key_block, 2 * (this.hash_size + key_size) + iv_size, iv_size);
            }
            if (this.logger != null) {
                this.logger.println("is exportable: " + is_exportabe);
                this.logger.println("master_secret");
                this.logger.print(session.master_secret);
                this.logger.println("client_random");
                this.logger.print(clientRandom);
                this.logger.println("server_random");
                this.logger.print(serverRandom);
                this.logger.println("client_mac_secret");
                this.logger.print(client_mac_secret);
                this.logger.println("server_mac_secret");
                this.logger.print(server_mac_secret);
                this.logger.println("client_key");
                this.logger.print(client_key);
                this.logger.println("server_key");
                this.logger.print(server_key);
                if (clientIV == null) {
                    this.logger.println("no IV.");
                } else {
                    this.logger.println("client_iv");
                    this.logger.print(clientIV.getIV());
                    this.logger.println("server_iv");
                    this.logger.print(serverIV.getIV());
                }
            }
            if (algName == null) {
                this.encCipher = new NullCipher();
                this.decCipher = new NullCipher();
            } else {
                this.encCipher = Cipher.getInstance(algName);
                this.decCipher = Cipher.getInstance(algName);
                if (is_client) {
                    this.encCipher.init(1, (Key)new SecretKeySpec(client_key, algName), clientIV);
                    this.decCipher.init(2, (Key)new SecretKeySpec(server_key, algName), serverIV);
                } else {
                    this.encCipher.init(1, (Key)new SecretKeySpec(server_key, algName), serverIV);
                    this.decCipher.init(2, (Key)new SecretKeySpec(client_key, algName), clientIV);
                }
            }
            this.encMac = Mac.getInstance(macName);
            this.decMac = Mac.getInstance(macName);
            if (is_client) {
                this.encMac.init(new SecretKeySpec(client_mac_secret, macName));
                this.decMac.init(new SecretKeySpec(server_mac_secret, macName));
            } else {
                this.encMac.init(new SecretKeySpec(server_mac_secret, macName));
                this.decMac.init(new SecretKeySpec(client_mac_secret, macName));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AlertException(80, new SSLProtocolException("Error during computation of security parameters"));
        }
    }

    protected byte[] encrypt(byte type, byte[] fragment, int offset, int len) {
        try {
            int content_mac_length = len + this.hash_size;
            int padding_length = this.block_size == 0 ? 0 : this.getPaddingSize(++content_mac_length);
            byte[] res = new byte[content_mac_length + padding_length];
            System.arraycopy(fragment, offset, res, 0, len);
            this.mac_material_header[0] = type;
            this.mac_material_header[3] = (byte)((0xFF00 & len) >> 8);
            this.mac_material_header[4] = (byte)(0xFF & len);
            this.encMac.update(this.write_seq_num);
            this.encMac.update(this.mac_material_header);
            this.encMac.update(fragment, offset, len);
            this.encMac.doFinal(res, len);
            if (this.block_size != 0) {
                Arrays.fill(res, content_mac_length - 1, res.length, (byte)padding_length);
            }
            if (this.logger != null) {
                this.logger.println("SSLRecordProtocol.do_encryption: Generic" + (this.block_size != 0 ? "BlockCipher with padding[" + padding_length + "]:" : "StreamCipher:"));
                this.logger.print(res);
            }
            byte[] rez = new byte[this.encCipher.getOutputSize(res.length)];
            this.encCipher.update(res, 0, res.length, rez);
            ConnectionStateTLS.incSequenceNumber(this.write_seq_num);
            return rez;
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
            throw new AlertException(80, new SSLProtocolException("Error during the encryption"));
        }
    }

    protected byte[] decrypt(byte type, byte[] fragment, int offset, int len) {
        byte[] content;
        int i;
        byte[] data = this.decCipher.update(fragment, offset, len);
        if (this.block_size != 0) {
            int padding_length = data[data.length - 1] & 0xFF;
            for (i = 0; i < padding_length; ++i) {
                if ((data[data.length - 2 - i] & 0xFF) == padding_length) continue;
                throw new AlertException(21, new SSLProtocolException("Received message has bad padding"));
            }
            content = new byte[data.length - this.hash_size - padding_length - 1];
        } else {
            content = new byte[data.length - this.hash_size];
        }
        this.mac_material_header[0] = type;
        this.mac_material_header[3] = (byte)((0xFF00 & content.length) >> 8);
        this.mac_material_header[4] = (byte)(0xFF & content.length);
        this.decMac.update(this.read_seq_num);
        this.decMac.update(this.mac_material_header);
        this.decMac.update(data, 0, content.length);
        byte[] mac_value = this.decMac.doFinal();
        if (this.logger != null) {
            this.logger.println("Decrypted:");
            this.logger.print(data);
            this.logger.println("Expected mac value:");
            this.logger.print(mac_value);
        }
        for (i = 0; i < this.hash_size; ++i) {
            if (mac_value[i] == data[i + content.length]) continue;
            throw new AlertException(20, new SSLProtocolException("Bad record MAC"));
        }
        System.arraycopy(data, 0, content, 0, content.length);
        ConnectionStateTLS.incSequenceNumber(this.read_seq_num);
        return content;
    }
}

