/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.net;

import android.content.Context;
import com.android.org.chromium.base.CalledByNative;
import com.android.org.chromium.base.JNINamespace;
import com.android.org.chromium.base.NativeClassQualifiedName;
import com.android.org.chromium.base.ObserverList;
import com.android.org.chromium.net.NetworkChangeNotifierAutoDetect;
import java.util.ArrayList;

@JNINamespace(value="net")
public class NetworkChangeNotifier {
    public static final int CONNECTION_UNKNOWN = 0;
    public static final int CONNECTION_ETHERNET = 1;
    public static final int CONNECTION_WIFI = 2;
    public static final int CONNECTION_2G = 3;
    public static final int CONNECTION_3G = 4;
    public static final int CONNECTION_4G = 5;
    public static final int CONNECTION_NONE = 6;
    private final Context mContext;
    private final ArrayList<Integer> mNativeChangeNotifiers;
    private final ObserverList<ConnectionTypeObserver> mConnectionTypeObservers;
    private NetworkChangeNotifierAutoDetect mAutoDetector;
    private int mCurrentConnectionType = 0;
    private static NetworkChangeNotifier sInstance;

    private NetworkChangeNotifier(Context context) {
        this.mContext = context;
        this.mNativeChangeNotifiers = new ArrayList();
        this.mConnectionTypeObservers = new ObserverList();
    }

    @CalledByNative
    public static NetworkChangeNotifier init(Context context) {
        if (sInstance == null) {
            sInstance = new NetworkChangeNotifier(context);
        }
        return sInstance;
    }

    public static boolean isInitialized() {
        return sInstance != null;
    }

    static void resetInstanceForTests(Context context) {
        sInstance = new NetworkChangeNotifier(context);
    }

    @CalledByNative
    public int getCurrentConnectionType() {
        return this.mCurrentConnectionType;
    }

    @CalledByNative
    public void addNativeObserver(int nativeChangeNotifier) {
        this.mNativeChangeNotifiers.add(nativeChangeNotifier);
    }

    @CalledByNative
    public void removeNativeObserver(int nativeChangeNotifier) {
        this.mNativeChangeNotifiers.remove((Object)nativeChangeNotifier);
    }

    public static NetworkChangeNotifier getInstance() {
        assert (sInstance != null);
        return sInstance;
    }

    public static void setAutoDetectConnectivityState(boolean shouldAutoDetect) {
        NetworkChangeNotifier.getInstance().setAutoDetectConnectivityStateInternal(shouldAutoDetect);
    }

    private void destroyAutoDetector() {
        if (this.mAutoDetector != null) {
            this.mAutoDetector.destroy();
            this.mAutoDetector = null;
        }
    }

    private void setAutoDetectConnectivityStateInternal(boolean shouldAutoDetect) {
        if (shouldAutoDetect) {
            if (this.mAutoDetector == null) {
                this.mAutoDetector = new NetworkChangeNotifierAutoDetect(new NetworkChangeNotifierAutoDetect.Observer(){

                    public void onConnectionTypeChanged(int newConnectionType) {
                        NetworkChangeNotifier.this.updateCurrentConnectionType(newConnectionType);
                    }
                }, this.mContext);
                this.mCurrentConnectionType = this.mAutoDetector.getCurrentConnectionType();
            }
        } else {
            this.destroyAutoDetector();
        }
    }

    @CalledByNative
    public static void forceConnectivityState(boolean networkAvailable) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().forceConnectivityStateInternal(networkAvailable);
    }

    private void forceConnectivityStateInternal(boolean forceOnline) {
        boolean connectionCurrentlyExists;
        boolean bl = connectionCurrentlyExists = this.mCurrentConnectionType != 6;
        if (connectionCurrentlyExists != forceOnline) {
            this.updateCurrentConnectionType(forceOnline ? 0 : 6);
        }
    }

    private void updateCurrentConnectionType(int newConnectionType) {
        this.mCurrentConnectionType = newConnectionType;
        this.notifyObserversOfConnectionTypeChange(newConnectionType);
    }

    void notifyObserversOfConnectionTypeChange(int newConnectionType) {
        for (Integer nativeChangeNotifier : this.mNativeChangeNotifiers) {
            this.nativeNotifyConnectionTypeChanged(nativeChangeNotifier, newConnectionType);
        }
        for (ConnectionTypeObserver observer : this.mConnectionTypeObservers) {
            observer.onConnectionTypeChanged(newConnectionType);
        }
    }

    public static void addConnectionTypeObserver(ConnectionTypeObserver observer) {
        NetworkChangeNotifier.getInstance().addConnectionTypeObserverInternal(observer);
    }

    private void addConnectionTypeObserverInternal(ConnectionTypeObserver observer) {
        if (!this.mConnectionTypeObservers.hasObserver(observer)) {
            this.mConnectionTypeObservers.addObserver(observer);
        }
    }

    public static void removeConnectionTypeObserver(ConnectionTypeObserver observer) {
        NetworkChangeNotifier.getInstance().removeConnectionTypeObserverInternal(observer);
    }

    private void removeConnectionTypeObserverInternal(ConnectionTypeObserver observer) {
        this.mConnectionTypeObservers.removeObserver(observer);
    }

    @NativeClassQualifiedName(value="NetworkChangeNotifierDelegateAndroid")
    private native void nativeNotifyConnectionTypeChanged(int var1, int var2);

    @NativeClassQualifiedName(value="NetworkChangeNotifierDelegateAndroid")
    private native int nativeGetConnectionType(int var1);

    public static NetworkChangeNotifierAutoDetect getAutoDetectorForTest() {
        return NetworkChangeNotifier.getInstance().mAutoDetector;
    }

    public static boolean isOnline() {
        int connectionType = NetworkChangeNotifier.getInstance().getCurrentConnectionType();
        return connectionType != 0 && connectionType != 6;
    }

    public static interface ConnectionTypeObserver {
        public void onConnectionTypeChanged(int var1);
    }
}

