/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.net;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.security.KeyChain;
import android.util.Log;
import com.android.org.chromium.base.CalledByNative;
import com.android.org.chromium.base.CalledByNativeUnchecked;
import com.android.org.chromium.net.X509Util;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URLConnection;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Enumeration;

class AndroidNetworkLibrary {
    private static final String TAG = "AndroidNetworkLibrary";

    AndroidNetworkLibrary() {
    }

    @CalledByNative
    public static boolean storeKeyPair(Context context, byte[] public_key, byte[] private_key) {
        try {
            Intent intent = KeyChain.createInstallIntent();
            intent.putExtra("PKEY", private_key);
            intent.putExtra("KEY", public_key);
            intent.addFlags(0x10000000);
            context.startActivity(intent);
            return true;
        }
        catch (ActivityNotFoundException e) {
            Log.w(TAG, "could not store key pair: " + e);
            return false;
        }
    }

    @CalledByNative
    public static boolean storeCertificate(Context context, int cert_type, byte[] data) {
        try {
            Intent intent = KeyChain.createInstallIntent();
            intent.addFlags(0x10000000);
            switch (cert_type) {
                case 1: 
                case 2: {
                    intent.putExtra("CERT", data);
                    break;
                }
                case 3: {
                    intent.putExtra("PKCS12", data);
                    break;
                }
                default: {
                    Log.w(TAG, "invalid certificate type: " + cert_type);
                    return false;
                }
            }
            context.startActivity(intent);
            return true;
        }
        catch (ActivityNotFoundException e) {
            Log.w(TAG, "could not store crypto file: " + e);
            return false;
        }
    }

    @CalledByNative
    public static String getMimeTypeFromExtension(String extension) {
        return URLConnection.guessContentTypeFromName("foo." + extension);
    }

    @CalledByNative
    public static boolean haveOnlyLoopbackAddresses() {
        Enumeration<NetworkInterface> list = null;
        try {
            list = NetworkInterface.getNetworkInterfaces();
            if (list == null) {
                return false;
            }
        }
        catch (Exception e) {
            Log.w(TAG, "could not get network interfaces: " + e);
            return false;
        }
        while (list.hasMoreElements()) {
            NetworkInterface netIf = list.nextElement();
            try {
                if (!netIf.isUp() || netIf.isLoopback()) continue;
                return false;
            }
            catch (SocketException e) {
            }
        }
        return true;
    }

    @CalledByNative
    public static String getNetworkList() {
        Enumeration<NetworkInterface> list = null;
        try {
            list = NetworkInterface.getNetworkInterfaces();
            if (list == null) {
                return "";
            }
        }
        catch (SocketException e) {
            Log.w(TAG, "Unable to get network interfaces: " + e);
            return "";
        }
        StringBuilder result = new StringBuilder();
        while (list.hasMoreElements()) {
            NetworkInterface netIf = list.nextElement();
            try {
                if (!netIf.isUp() || netIf.isLoopback()) continue;
                Enumeration<InetAddress> addressList = netIf.getInetAddresses();
                while (addressList.hasMoreElements()) {
                    InetAddress address = addressList.nextElement();
                    if (address.isLoopbackAddress()) continue;
                    StringBuilder addressString = new StringBuilder();
                    addressString.append(netIf.getName());
                    addressString.append(",");
                    String ipAddress = address.getHostAddress();
                    if (address instanceof Inet6Address && ipAddress.contains("%")) {
                        ipAddress = ipAddress.substring(0, ipAddress.lastIndexOf("%"));
                    }
                    addressString.append(ipAddress);
                    if (result.length() != 0) {
                        result.append(";");
                    }
                    result.append(addressString.toString());
                }
            }
            catch (SocketException e) {
            }
        }
        return result.toString();
    }

    @CalledByNative
    public static int verifyServerCertificates(byte[][] certChain, String authType) {
        try {
            return X509Util.verifyServerCertificates(certChain, authType);
        }
        catch (KeyStoreException e) {
            return -1;
        }
        catch (NoSuchAlgorithmException e) {
            return -1;
        }
    }

    @CalledByNativeUnchecked
    public static void addTestRootCertificate(byte[] rootCert) throws CertificateException, KeyStoreException, NoSuchAlgorithmException {
        X509Util.addTestRootCertificate(rootCert);
    }

    @CalledByNativeUnchecked
    public static void clearTestRootCertificates() throws NoSuchAlgorithmException, CertificateException, KeyStoreException {
        X509Util.clearTestRootCertificates();
    }
}

