/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.media;

import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.opengl.GLES20;
import android.os.Build;
import android.util.Log;
import android.view.WindowManager;
import com.android.org.chromium.base.CalledByNative;
import com.android.org.chromium.base.JNINamespace;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

@JNINamespace(value="media")
public class VideoCapture
implements Camera.PreviewCallback,
SurfaceTexture.OnFrameAvailableListener {
    private Camera mCamera;
    public ReentrantLock mPreviewBufferLock = new ReentrantLock();
    private int mImageFormat = 842094169;
    private byte[] mColorPlane = null;
    private Context mContext = null;
    private boolean mIsRunning = false;
    private static final int NUM_CAPTURE_BUFFERS = 3;
    private int mExpectedFrameSize = 0;
    private int mId = 0;
    private int mNativeVideoCaptureDeviceAndroid = 0;
    private int[] mGlTextures = null;
    private SurfaceTexture mSurfaceTexture = null;
    private static final int GL_TEXTURE_EXTERNAL_OES = 36197;
    private int mCameraOrientation = 0;
    private int mCameraFacing = 0;
    private int mDeviceOrientation = 0;
    CaptureCapability mCurrentCapability = null;
    private static final String TAG = "VideoCapture";

    @CalledByNative
    public static VideoCapture createVideoCapture(Context context, int id2, int nativeVideoCaptureDeviceAndroid) {
        return new VideoCapture(context, id2, nativeVideoCaptureDeviceAndroid);
    }

    public VideoCapture(Context context, int id2, int nativeVideoCaptureDeviceAndroid) {
        this.mContext = context;
        this.mId = id2;
        this.mNativeVideoCaptureDeviceAndroid = nativeVideoCaptureDeviceAndroid;
    }

    @CalledByNative
    public boolean allocate(int width, int height, int frameRate) {
        Log.d(TAG, "allocate: requested width=" + width + ", height=" + height + ", frameRate=" + frameRate);
        try {
            this.mCamera = Camera.open(this.mId);
        }
        catch (RuntimeException ex) {
            Log.e(TAG, "allocate:Camera.open: " + ex);
            return false;
        }
        try {
            Camera.CameraInfo camera_info = new Camera.CameraInfo();
            Camera.getCameraInfo(this.mId, camera_info);
            this.mCameraOrientation = camera_info.orientation;
            this.mCameraFacing = camera_info.facing;
            this.mDeviceOrientation = this.getDeviceOrientation();
            Log.d(TAG, "allocate: device orientation=" + this.mDeviceOrientation + ", camera orientation=" + this.mCameraOrientation + ", facing=" + this.mCameraFacing);
            Camera.Parameters parameters = this.mCamera.getParameters();
            List<int[]> listFpsRange = parameters.getSupportedPreviewFpsRange();
            if (listFpsRange == null || listFpsRange.size() == 0) {
                Log.e(TAG, "allocate: no fps range found");
                return false;
            }
            int frameRateInMs = frameRate * 1000;
            Iterator<int[]> itFpsRange = listFpsRange.iterator();
            int[] fpsRange = itFpsRange.next();
            int fpsMin = fpsRange[0];
            int fpsMax = fpsRange[1];
            int newFrameRate = (fpsMin + 999) / 1000;
            while (itFpsRange.hasNext()) {
                fpsRange = itFpsRange.next();
                if (fpsRange[0] > frameRateInMs || frameRateInMs > fpsRange[1]) continue;
                fpsMin = fpsRange[0];
                fpsMax = fpsRange[1];
                newFrameRate = frameRate;
                break;
            }
            frameRate = newFrameRate;
            Log.d(TAG, "allocate: fps set to " + frameRate);
            this.mCurrentCapability = new CaptureCapability();
            this.mCurrentCapability.mDesiredFps = frameRate;
            List<Camera.Size> listCameraSize = parameters.getSupportedPreviewSizes();
            int minDiff = Integer.MAX_VALUE;
            int matchedWidth = width;
            int matchedHeight = height;
            for (Camera.Size size : listCameraSize) {
                int diff = Math.abs(size.width - width) + Math.abs(size.height - height);
                Log.d(TAG, "allocate: support resolution (" + size.width + ", " + size.height + "), diff=" + diff);
                if (diff >= minDiff || size.width % 32 != 0) continue;
                minDiff = diff;
                matchedWidth = size.width;
                matchedHeight = size.height;
            }
            if (minDiff == Integer.MAX_VALUE) {
                Log.e(TAG, "allocate: can not find a resolution whose width is multiple of 32");
                return false;
            }
            this.mCurrentCapability.mWidth = matchedWidth;
            this.mCurrentCapability.mHeight = matchedHeight;
            Log.d(TAG, "allocate: matched width=" + matchedWidth + ", height=" + matchedHeight);
            this.calculateImageFormat(matchedWidth, matchedHeight);
            parameters.setPreviewSize(matchedWidth, matchedHeight);
            parameters.setPreviewFormat(this.mImageFormat);
            parameters.setPreviewFpsRange(fpsMin, fpsMax);
            this.mCamera.setParameters(parameters);
            this.mGlTextures = new int[1];
            GLES20.glGenTextures(1, this.mGlTextures, 0);
            GLES20.glBindTexture(36197, this.mGlTextures[0]);
            GLES20.glTexParameterf(36197, 10241, 9729.0f);
            GLES20.glTexParameterf(36197, 10240, 9729.0f);
            GLES20.glTexParameteri(36197, 10242, 33071);
            GLES20.glTexParameteri(36197, 10243, 33071);
            this.mSurfaceTexture = new SurfaceTexture(this.mGlTextures[0]);
            this.mSurfaceTexture.setOnFrameAvailableListener(null);
            this.mCamera.setPreviewTexture(this.mSurfaceTexture);
            int bufSize = matchedWidth * matchedHeight * ImageFormat.getBitsPerPixel(this.mImageFormat) / 8;
            for (int i = 0; i < 3; ++i) {
                byte[] buffer = new byte[bufSize];
                this.mCamera.addCallbackBuffer(buffer);
            }
            this.mExpectedFrameSize = bufSize;
        }
        catch (IOException ex) {
            Log.e(TAG, "allocate: " + ex);
            return false;
        }
        return true;
    }

    @CalledByNative
    public int queryWidth() {
        return this.mCurrentCapability.mWidth;
    }

    @CalledByNative
    public int queryHeight() {
        return this.mCurrentCapability.mHeight;
    }

    @CalledByNative
    public int queryFrameRate() {
        return this.mCurrentCapability.mDesiredFps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public int startCapture() {
        if (this.mCamera == null) {
            Log.e(TAG, "startCapture: camera is null");
            return -1;
        }
        this.mPreviewBufferLock.lock();
        try {
            if (this.mIsRunning) {
                int n = 0;
                return n;
            }
            this.mIsRunning = true;
        }
        finally {
            this.mPreviewBufferLock.unlock();
        }
        this.mCamera.setPreviewCallbackWithBuffer(this);
        this.mCamera.startPreview();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public int stopCapture() {
        if (this.mCamera == null) {
            Log.e(TAG, "stopCapture: camera is null");
            return 0;
        }
        this.mPreviewBufferLock.lock();
        try {
            if (!this.mIsRunning) {
                int n = 0;
                return n;
            }
            this.mIsRunning = false;
        }
        finally {
            this.mPreviewBufferLock.unlock();
        }
        this.mCamera.stopPreview();
        this.mCamera.setPreviewCallbackWithBuffer(null);
        return 0;
    }

    @CalledByNative
    public void deallocate() {
        if (this.mCamera == null) {
            return;
        }
        this.stopCapture();
        try {
            this.mCamera.setPreviewTexture(null);
            if (this.mGlTextures != null) {
                GLES20.glDeleteTextures(1, this.mGlTextures, 0);
            }
            this.mCurrentCapability = null;
            this.mCamera.release();
            this.mCamera = null;
        }
        catch (IOException ex) {
            Log.e(TAG, "deallocate: failed to deallocate camera, " + ex);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPreviewFrame(byte[] data, Camera camera) {
        this.mPreviewBufferLock.lock();
        try {
            if (!this.mIsRunning) {
                return;
            }
            if (data.length == this.mExpectedFrameSize) {
                int rotation = this.getDeviceOrientation();
                if (rotation != this.mDeviceOrientation) {
                    this.mDeviceOrientation = rotation;
                    Log.d(TAG, "onPreviewFrame: device orientation=" + this.mDeviceOrientation + ", camera orientation=" + this.mCameraOrientation);
                }
                boolean flipVertical = false;
                boolean flipHorizontal = false;
                if (this.mCameraFacing == 1) {
                    rotation = (this.mCameraOrientation + rotation) % 360;
                    flipVertical = flipHorizontal = (rotation = (360 - rotation) % 360) == 270 || rotation == 90;
                } else {
                    rotation = (this.mCameraOrientation - rotation + 360) % 360;
                }
                if (this.mImageFormat == 17) {
                    this.convertNV21ToYV12(data);
                }
                this.nativeOnFrameAvailable(this.mNativeVideoCaptureDeviceAndroid, data, this.mExpectedFrameSize, rotation, flipVertical, flipHorizontal);
            }
        }
        finally {
            this.mPreviewBufferLock.unlock();
            if (camera != null) {
                camera.addCallbackBuffer(data);
            }
        }
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
    }

    private native void nativeOnFrameAvailable(int var1, byte[] var2, int var3, int var4, boolean var5, boolean var6);

    private int getDeviceOrientation() {
        int orientation = 0;
        if (this.mContext != null) {
            WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
            switch (wm.getDefaultDisplay().getRotation()) {
                case 1: {
                    orientation = 90;
                    break;
                }
                case 2: {
                    orientation = 180;
                    break;
                }
                case 3: {
                    orientation = 270;
                    break;
                }
                default: {
                    orientation = 0;
                }
            }
        }
        return orientation;
    }

    private void calculateImageFormat(int width, int height) {
        this.mImageFormat = DeviceImageFormatHack.getImageFormat();
        if (this.mImageFormat == 17) {
            this.mColorPlane = new byte[width * height / 4];
        }
    }

    private void convertNV21ToYV12(byte[] data) {
        int ySize = this.mCurrentCapability.mWidth * this.mCurrentCapability.mHeight;
        int uvSize = ySize / 4;
        for (int i = 0; i < uvSize; ++i) {
            int index = ySize + i * 2;
            data[ySize + i] = data[index];
            this.mColorPlane[i] = data[index + 1];
        }
        System.arraycopy(this.mColorPlane, 0, data, ySize + uvSize, uvSize);
    }

    private static class ChromiumCameraInfo {
        private final int mId;
        private final Camera.CameraInfo mCameraInfo;

        private ChromiumCameraInfo(int index) {
            this.mId = index;
            this.mCameraInfo = new Camera.CameraInfo();
            Camera.getCameraInfo(index, this.mCameraInfo);
        }

        @CalledByNative(value="ChromiumCameraInfo")
        private static int getNumberOfCameras() {
            return Camera.getNumberOfCameras();
        }

        @CalledByNative(value="ChromiumCameraInfo")
        private static ChromiumCameraInfo getAt(int index) {
            return new ChromiumCameraInfo(index);
        }

        @CalledByNative(value="ChromiumCameraInfo")
        private int getId() {
            return this.mId;
        }

        @CalledByNative(value="ChromiumCameraInfo")
        private String getDeviceName() {
            return "camera " + this.mId + ", facing " + (this.mCameraInfo.facing == 1 ? "front" : "back");
        }

        @CalledByNative(value="ChromiumCameraInfo")
        private int getOrientation() {
            return this.mCameraInfo.orientation;
        }
    }

    private static class DeviceImageFormatHack {
        private static final String[] sBUGGY_DEVICE_LIST = new String[]{"SAMSUNG-SGH-I747"};

        private DeviceImageFormatHack() {
        }

        static int getImageFormat() {
            if (Build.VERSION.SDK_INT < 16) {
                return 17;
            }
            for (String buggyDevice : sBUGGY_DEVICE_LIST) {
                if (!buggyDevice.contentEquals(Build.MODEL)) continue;
                return 17;
            }
            return 842094169;
        }
    }

    static class CaptureCapability {
        public int mWidth = 0;
        public int mHeight = 0;
        public int mDesiredFps = 0;

        CaptureCapability() {
        }
    }
}

