/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.media;

import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import com.android.org.chromium.base.CalledByNative;
import com.android.org.chromium.base.JNINamespace;
import com.android.org.chromium.media.MediaPlayerBridge;

@JNINamespace(value="media")
class MediaPlayerListener
implements MediaPlayer.OnPreparedListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnSeekCompleteListener,
MediaPlayer.OnVideoSizeChangedListener,
MediaPlayer.OnErrorListener,
AudioManager.OnAudioFocusChangeListener {
    private static final int MEDIA_ERROR_FORMAT = 0;
    private static final int MEDIA_ERROR_DECODE = 1;
    private static final int MEDIA_ERROR_NOT_VALID_FOR_PROGRESSIVE_PLAYBACK = 2;
    private static final int MEDIA_ERROR_INVALID_CODE = 3;
    public static final int MEDIA_ERROR_MALFORMED = -1007;
    public static final int MEDIA_ERROR_TIMED_OUT = -110;
    private int mNativeMediaPlayerListener = 0;
    private final Context mContext;

    private MediaPlayerListener(int nativeMediaPlayerListener, Context context) {
        this.mNativeMediaPlayerListener = nativeMediaPlayerListener;
        this.mContext = context;
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        int errorType;
        block0 : switch (what) {
            case 1: {
                switch (extra) {
                    case -1007: {
                        errorType = 1;
                        break block0;
                    }
                    case -110: {
                        errorType = 3;
                        break block0;
                    }
                }
                errorType = 0;
                break;
            }
            case 100: {
                errorType = 1;
                break;
            }
            case 200: {
                errorType = 2;
                break;
            }
            default: {
                errorType = 3;
            }
        }
        this.nativeOnMediaError(this.mNativeMediaPlayerListener, errorType);
        return true;
    }

    public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
        this.nativeOnVideoSizeChanged(this.mNativeMediaPlayerListener, width, height);
    }

    public void onSeekComplete(MediaPlayer mp) {
        this.nativeOnSeekComplete(this.mNativeMediaPlayerListener);
    }

    public void onBufferingUpdate(MediaPlayer mp, int percent) {
        this.nativeOnBufferingUpdate(this.mNativeMediaPlayerListener, percent);
    }

    public void onCompletion(MediaPlayer mp) {
        this.nativeOnPlaybackComplete(this.mNativeMediaPlayerListener);
    }

    public void onPrepared(MediaPlayer mp) {
        this.nativeOnMediaPrepared(this.mNativeMediaPlayerListener);
    }

    public void onAudioFocusChange(int focusChange) {
        if (focusChange == -1 || focusChange == -2) {
            this.nativeOnMediaInterrupted(this.mNativeMediaPlayerListener);
        }
    }

    @CalledByNative
    public void releaseResources() {
        AudioManager am;
        if (this.mContext != null && (am = (AudioManager)this.mContext.getSystemService("audio")) != null) {
            am.abandonAudioFocus(this);
        }
    }

    @CalledByNative
    private static MediaPlayerListener create(int nativeMediaPlayerListener, Context context, MediaPlayerBridge mediaPlayerBridge) {
        MediaPlayerListener listener = new MediaPlayerListener(nativeMediaPlayerListener, context);
        mediaPlayerBridge.setOnBufferingUpdateListener(listener);
        mediaPlayerBridge.setOnCompletionListener(listener);
        mediaPlayerBridge.setOnErrorListener(listener);
        mediaPlayerBridge.setOnPreparedListener(listener);
        mediaPlayerBridge.setOnSeekCompleteListener(listener);
        mediaPlayerBridge.setOnVideoSizeChangedListener(listener);
        AudioManager am = (AudioManager)context.getSystemService("audio");
        am.requestAudioFocus(listener, 3, 3);
        return listener;
    }

    private native void nativeOnMediaError(int var1, int var2);

    private native void nativeOnVideoSizeChanged(int var1, int var2, int var3);

    private native void nativeOnBufferingUpdate(int var1, int var2);

    private native void nativeOnMediaPrepared(int var1);

    private native void nativeOnPlaybackComplete(int var1);

    private native void nativeOnSeekComplete(int var1);

    private native void nativeOnMediaInterrupted(int var1);
}

