/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.content.common;

import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;

public abstract class CommandLine {
    public static final String WAIT_FOR_JAVA_DEBUGGER = "wait-for-java-debugger";
    public static final String ADD_OFFICIAL_COMMAND_LINE = "add-official-command-line";
    public static final String ENABLE_TEST_INTENTS = "enable-test-intents";
    public static final String LOG_FPS = "log-fps";
    public static final String USE_MOBILE_UA = "use-mobile-user-agent";
    public static final String TABLET_UI = "tablet-ui";
    public static final String ACCESSIBILITY_JAVASCRIPT_URL = "accessibility-js-url";
    public static final String ACCESSIBILITY_DEBUG_BRAILLE_SERVICE = "debug-braille-service";
    public static final String NETWORK_COUNTRY_ISO = "network-country-iso";
    public static final String ENABLE_TOP_CONTROLS_POSITION_CALCULATION = "enable-top-controls-position-calculation";
    public static final String TOP_CONTROLS_HEIGHT = "top-controls-height";
    public static final String TOP_CONTROLS_SHOW_THRESHOLD = "top-controls-show-threshold";
    public static final String TOP_CONTROLS_HIDE_THRESHOLD = "top-controls-hide-threshold";
    public static final String ENABLE_INSTANT_EXTENDED_API = "enable-instant-extended-api";
    public static final String ENABLE_SPEECH_RECOGNITION = "enable-speech-recognition";
    public static final String DUMP_RENDER_TREE = "dump-render-tree";
    private static final AtomicReference<CommandLine> sCommandLine = new AtomicReference();
    private static final String TAG = "CommandLine";
    private static final String SWITCH_PREFIX = "--";
    private static final String SWITCH_TERMINATOR = "--";
    private static final String SWITCH_VALUE_SEPARATOR = "=";

    public abstract boolean hasSwitch(String var1);

    public abstract String getSwitchValue(String var1);

    public String getSwitchValue(String switchString, String defaultValue) {
        String value = this.getSwitchValue(switchString);
        return TextUtils.isEmpty(value) ? defaultValue : value;
    }

    public abstract void appendSwitch(String var1);

    public abstract void appendSwitchWithValue(String var1, String var2);

    public abstract void appendSwitchesAndArguments(String[] var1);

    public boolean isNativeImplementation() {
        return false;
    }

    public static boolean isInitialized() {
        return sCommandLine.get() != null;
    }

    public static CommandLine getInstance() {
        CommandLine commandLine = sCommandLine.get();
        assert (commandLine != null);
        return commandLine;
    }

    public static void init(String[] args) {
        CommandLine.setInstance(new JavaCommandLine(args));
    }

    public static void initFromFile(String file) {
        char[] buffer = CommandLine.readUtf8FileFully(file, 8192);
        CommandLine.init(buffer == null ? null : CommandLine.tokenizeQuotedAruments(buffer));
    }

    public static void reset() {
        CommandLine.setInstance(null);
    }

    public static String[] tokenizeQuotedAruments(char[] buffer) {
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder arg = null;
        boolean noQuote = false;
        int singleQuote = 39;
        int doubleQuote = 34;
        char currentQuote = '\u0000';
        for (char c : buffer) {
            if (currentQuote == '\u0000' && (c == '\'' || c == '\"') || c == currentQuote) {
                if (arg != null && arg.length() > 0 && arg.charAt(arg.length() - 1) == '\\') {
                    arg.setCharAt(arg.length() - 1, c);
                    continue;
                }
                currentQuote = currentQuote == '\u0000' ? c : (char)'\u0000';
                continue;
            }
            if (currentQuote == '\u0000' && Character.isWhitespace(c)) {
                if (arg == null) continue;
                args.add(arg.toString());
                arg = null;
                continue;
            }
            if (arg == null) {
                arg = new StringBuilder();
            }
            arg.append(c);
        }
        if (arg != null) {
            if (currentQuote != '\u0000') {
                Log.w(TAG, "Unterminated quoted string: " + arg);
            }
            args.add(arg.toString());
        }
        return args.toArray(new String[args.size()]);
    }

    public static void enableNativeProxy() {
        sCommandLine.set(new NativeCommandLine());
    }

    public static String[] getJavaSwitchesOrNull() {
        CommandLine commandLine = sCommandLine.get();
        if (commandLine != null) {
            assert (!commandLine.isNativeImplementation());
            return ((JavaCommandLine)commandLine).getCommandLineArguments();
        }
        return null;
    }

    private static void setInstance(CommandLine commandLine) {
        CommandLine oldCommandLine = sCommandLine.getAndSet(commandLine);
        if (oldCommandLine != null && oldCommandLine.isNativeImplementation()) {
            CommandLine.nativeReset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static char[] readUtf8FileFully(String fileName, int sizeLimit) {
        Reader reader = null;
        File f = new File(fileName);
        long fileLength = f.length();
        if (fileLength == 0L) {
            return null;
        }
        if (fileLength > (long)sizeLimit) {
            Log.w(TAG, "File " + fileName + " length " + fileLength + " exceeds limit " + sizeLimit);
            return null;
        }
        try {
            char[] buffer = new char[(int)fileLength];
            reader = new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8");
            int charsRead = reader.read(buffer);
            assert (!reader.ready());
            char[] cArray = charsRead < buffer.length ? Arrays.copyOfRange(buffer, 0, charsRead) : buffer;
            return cArray;
        }
        catch (FileNotFoundException e) {
            char[] cArray = null;
            return cArray;
        }
        catch (IOException e) {
            char[] cArray = null;
            return cArray;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                Log.e(TAG, "Unable to close file reader.", e);
            }
        }
    }

    private CommandLine() {
    }

    private static native void nativeReset();

    private static native boolean nativeHasSwitch(String var0);

    private static native String nativeGetSwitchValue(String var0);

    private static native void nativeAppendSwitch(String var0);

    private static native void nativeAppendSwitchWithValue(String var0, String var1);

    private static native void nativeAppendSwitchesAndArguments(String[] var0);

    private static class NativeCommandLine
    extends CommandLine {
        private NativeCommandLine() {
        }

        public boolean hasSwitch(String switchString) {
            return CommandLine.nativeHasSwitch(switchString);
        }

        public String getSwitchValue(String switchString) {
            return CommandLine.nativeGetSwitchValue(switchString);
        }

        public void appendSwitch(String switchString) {
            CommandLine.nativeAppendSwitch(switchString);
        }

        public void appendSwitchWithValue(String switchString, String value) {
            CommandLine.nativeAppendSwitchWithValue(switchString, value);
        }

        public void appendSwitchesAndArguments(String[] array2) {
            CommandLine.nativeAppendSwitchesAndArguments(array2);
        }

        public boolean isNativeImplementation() {
            return true;
        }
    }

    private static class JavaCommandLine
    extends CommandLine {
        private HashMap<String, String> mSwitches = new HashMap();
        private ArrayList<String> mArgs = new ArrayList();
        private int mArgsBegin = 1;

        JavaCommandLine(String[] args) {
            if (args == null || args.length == 0 || args[0] == null) {
                this.mArgs.add("");
            } else {
                this.mArgs.add(args[0]);
                this.appendSwitchesInternal(args, 1);
            }
            assert (this.mArgs.size() > 0);
        }

        private String[] getCommandLineArguments() {
            return this.mArgs.toArray(new String[this.mArgs.size()]);
        }

        public boolean hasSwitch(String switchString) {
            return this.mSwitches.containsKey(switchString);
        }

        public String getSwitchValue(String switchString) {
            String value = this.mSwitches.get(switchString);
            return value == null || value.isEmpty() ? null : value;
        }

        public void appendSwitch(String switchString) {
            this.appendSwitchWithValue(switchString, null);
        }

        public void appendSwitchWithValue(String switchString, String value) {
            this.mSwitches.put(switchString, value == null ? "" : value);
            String combinedSwitchString = "--" + switchString;
            if (value != null && !value.isEmpty()) {
                combinedSwitchString = combinedSwitchString + CommandLine.SWITCH_VALUE_SEPARATOR + value;
            }
            this.mArgs.add(this.mArgsBegin++, combinedSwitchString);
        }

        public void appendSwitchesAndArguments(String[] array2) {
            this.appendSwitchesInternal(array2, 0);
        }

        private void appendSwitchesInternal(String[] array2, int skipCount) {
            boolean parseSwitches = true;
            for (String arg : array2) {
                if (skipCount > 0) {
                    --skipCount;
                    continue;
                }
                if (arg.equals("--")) {
                    parseSwitches = false;
                }
                if (parseSwitches && arg.startsWith("--")) {
                    String[] parts = arg.split(CommandLine.SWITCH_VALUE_SEPARATOR, 2);
                    String value = parts.length > 1 ? parts[1] : null;
                    this.appendSwitchWithValue(parts[0].substring("--".length()), value);
                    continue;
                }
                this.mArgs.add(arg);
            }
        }
    }
}

