/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.content.browser;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Debug;
import android.util.Log;
import com.android.org.chromium.content.common.CommandLine;

public class HeapStatsLogger {
    private static final String TAG = "HeapStatsLogger";
    private static final String ACTION_LOG = "com.android.org.chromium.com.google.android.apps.chrome.LOG_HEAP_STATS";
    private static HeapStatsLogger sHeapStats;
    private HeapStatsLoggerReceiver mBroadcastReceiver;
    private HeapStatsLoggerIntentFilter mIntentFilter;

    public static void init(Context context) {
        if (CommandLine.getInstance().hasSwitch("enable-test-intents")) {
            sHeapStats = new HeapStatsLogger(context);
        }
    }

    private HeapStatsLogger(Context context) {
        Debug.startAllocCounting();
        this.mBroadcastReceiver = new HeapStatsLoggerReceiver();
        this.mIntentFilter = new HeapStatsLoggerIntentFilter();
        context.registerReceiver(this.mBroadcastReceiver, this.mIntentFilter);
    }

    private void log() {
        Log.i(TAG, "heap_stats gc_count=" + Debug.getGlobalGcInvocationCount() + " times " + "alloc_count=" + Debug.getGlobalAllocCount() + " times " + "alloc_size=" + Debug.getGlobalAllocSize() + " bytes " + "freed_count=" + Debug.getGlobalFreedCount() + " times " + "freed_size=" + Debug.getGlobalFreedSize() + " bytes");
    }

    private class HeapStatsLoggerReceiver
    extends BroadcastReceiver {
        private HeapStatsLoggerReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (HeapStatsLogger.ACTION_LOG.equals(intent.getAction())) {
                HeapStatsLogger.this.log();
            } else {
                Log.e(HeapStatsLogger.TAG, "Unexpected intent: " + intent);
            }
        }
    }

    private static class HeapStatsLoggerIntentFilter
    extends IntentFilter {
        HeapStatsLoggerIntentFilter() {
            this.addAction(HeapStatsLogger.ACTION_LOG);
        }
    }
}

