/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.content.browser;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Log;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import com.android.org.chromium.content.browser.LongPressDetector;
import com.android.org.chromium.content.browser.SnapScrollController;
import com.android.org.chromium.content.browser.TouchPoint;
import com.android.org.chromium.content.browser.ZoomManager;
import com.android.org.chromium.content.browser.third_party.GestureDetector;
import com.android.org.chromium.content.common.TraceEvent;
import java.util.ArrayDeque;
import java.util.Deque;

class ContentViewGestureHandler
implements LongPressDetector.LongPressDelegate {
    private static final String TAG = "ContentViewGestureHandler";
    static final String VELOCITY_X = "Velocity X";
    static final String VELOCITY_Y = "Velocity Y";
    static final String DISTANCE_X = "Distance X";
    static final String DISTANCE_Y = "Distance Y";
    static final String SHOW_PRESS = "ShowPress";
    static final String DELTA = "Delta";
    private final Bundle mExtraParamBundle;
    private GestureDetector mGestureDetector;
    private final ZoomManager mZoomManager;
    private LongPressDetector mLongPressDetector;
    private GestureDetector.OnGestureListener mListener;
    private MotionEvent mCurrentDownEvent;
    private final MotionEventDelegate mMotionEventDelegate;
    private final Deque<MotionEvent> mPendingMotionEvents = new ArrayDeque<MotionEvent>();
    private boolean mHasTouchHandlers = false;
    private boolean mNoTouchHandlerForGesture = false;
    private boolean mJavaScriptIsConsumingGesture = false;
    private boolean mShowPressIsCalled;
    private boolean mIgnoreSingleTap;
    private boolean mTouchScrolling;
    private boolean mFlingMayBeActive;
    private boolean mSeenFirstScrollEvent;
    private boolean mPinchInProgress = false;
    private boolean mTouchCancelEventSent = false;
    private MotionEvent mLastCancelledEvent = null;
    private static final int DOUBLE_TAP_TIMEOUT = ViewConfiguration.getDoubleTapTimeout();
    private int mSingleTapX;
    private int mSingleTapY;
    private int mDoubleTapDragMode = 0;
    private float mDoubleTapDragZoomAnchorX;
    private float mDoubleTapDragZoomAnchorY;
    private float mDoubleTapY;
    private static final float DOUBLE_TAP_DRAG_ZOOM_SPEED = 0.005f;
    private float mLastRawX = 0.0f;
    private float mLastRawY = 0.0f;
    private int mScaledTouchSlopSquare;
    private SnapScrollController mSnapScrollController;
    private float mAccumulatedScrollErrorX = 0.0f;
    private float mAccumulatedScrollErrorY = 0.0f;
    private final boolean mInputEventsDeliveredAtVSync;
    private MotionEvent mLastLongPressEvent;
    static final int GESTURE_SHOW_PRESSED_STATE = 0;
    static final int GESTURE_DOUBLE_TAP = 1;
    static final int GESTURE_SINGLE_TAP_UP = 2;
    static final int GESTURE_SINGLE_TAP_CONFIRMED = 3;
    static final int GESTURE_SINGLE_TAP_UNCONFIRMED = 4;
    static final int GESTURE_LONG_PRESS = 5;
    static final int GESTURE_SCROLL_START = 6;
    static final int GESTURE_SCROLL_BY = 7;
    static final int GESTURE_SCROLL_END = 8;
    static final int GESTURE_FLING_START = 9;
    static final int GESTURE_FLING_CANCEL = 10;
    static final int GESTURE_PINCH_BEGIN = 11;
    static final int GESTURE_PINCH_BY = 12;
    static final int GESTURE_PINCH_END = 13;
    static final int GESTURE_SHOW_PRESS_CANCEL = 14;
    static final int GESTURE_LONG_TAP = 15;
    static final int INPUT_EVENT_ACK_STATE_UNKNOWN = 0;
    static final int INPUT_EVENT_ACK_STATE_CONSUMED = 1;
    static final int INPUT_EVENT_ACK_STATE_NOT_CONSUMED = 2;
    static final int INPUT_EVENT_ACK_STATE_NO_CONSUMER_EXISTS = 3;
    static final int EVENT_FORWARDED_TO_NATIVE = 0;
    static final int EVENT_CONVERTED_TO_CANCEL = 1;
    static final int EVENT_NOT_FORWARDED = 2;
    private final float mPxToDp;
    static final int DOUBLE_TAP_DRAG_MODE_NONE = 0;
    static final int DOUBLE_TAP_DRAG_MODE_DETECTION_IN_PROGRESS = 1;
    static final int DOUBLE_TAP_DRAG_MODE_ZOOM = 2;
    static final int DOUBLE_TAP_DRAG_MODE_DISABLED = 3;
    private TouchEventTimeoutHandler mTouchEventTimeoutHandler = new TouchEventTimeoutHandler();

    ContentViewGestureHandler(Context context, MotionEventDelegate delegate, ZoomManager zoomManager, int inputEventDeliveryMode) {
        this.mExtraParamBundle = new Bundle();
        this.mLongPressDetector = new LongPressDetector(context, this);
        this.mMotionEventDelegate = delegate;
        this.mZoomManager = zoomManager;
        this.mSnapScrollController = new SnapScrollController(context, this.mZoomManager);
        this.mInputEventsDeliveredAtVSync = inputEventDeliveryMode == 1;
        this.mPxToDp = 1.0f / context.getResources().getDisplayMetrics().density;
        this.initGestureDetectors(context);
    }

    void setTestDependencies(LongPressDetector longPressDetector, GestureDetector gestureDetector, GestureDetector.OnGestureListener listener) {
        if (longPressDetector != null) {
            this.mLongPressDetector = longPressDetector;
        }
        if (gestureDetector != null) {
            this.mGestureDetector = gestureDetector;
        }
        if (listener != null) {
            this.mListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initGestureDetectors(Context context) {
        final int scaledTouchSlop = ViewConfiguration.get(context).getScaledTouchSlop();
        this.mScaledTouchSlopSquare = scaledTouchSlop * scaledTouchSlop;
        try {
            TraceEvent.begin();
            GestureDetector.SimpleOnGestureListener listener = new GestureDetector.SimpleOnGestureListener(){

                public boolean onDown(MotionEvent e) {
                    ContentViewGestureHandler.this.mShowPressIsCalled = false;
                    ContentViewGestureHandler.this.mIgnoreSingleTap = false;
                    ContentViewGestureHandler.this.mTouchScrolling = false;
                    ContentViewGestureHandler.this.mSeenFirstScrollEvent = false;
                    ContentViewGestureHandler.this.mSnapScrollController.resetSnapScrollMode();
                    ContentViewGestureHandler.this.mLastRawX = e.getRawX();
                    ContentViewGestureHandler.this.mLastRawY = e.getRawY();
                    ContentViewGestureHandler.this.mAccumulatedScrollErrorX = 0.0f;
                    ContentViewGestureHandler.this.mAccumulatedScrollErrorY = 0.0f;
                    return true;
                }

                public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                    if (!ContentViewGestureHandler.this.mSeenFirstScrollEvent) {
                        ContentViewGestureHandler.this.mSeenFirstScrollEvent = true;
                        double distance = Math.sqrt(distanceX * distanceX + distanceY * distanceY);
                        double epsilon = 0.001;
                        if (distance > epsilon) {
                            double ratio = Math.max(0.0, distance - (double)scaledTouchSlop) / distance;
                            distanceX = (float)((double)distanceX * ratio);
                            distanceY = (float)((double)distanceY * ratio);
                        }
                    }
                    ContentViewGestureHandler.this.mSnapScrollController.updateSnapScrollMode(distanceX, distanceY);
                    if (ContentViewGestureHandler.this.mSnapScrollController.isSnappingScrolls()) {
                        if (ContentViewGestureHandler.this.mSnapScrollController.isSnapHorizontal()) {
                            distanceY = 0.0f;
                        } else {
                            distanceX = 0.0f;
                        }
                    }
                    boolean didUIStealScroll = ContentViewGestureHandler.this.mMotionEventDelegate.didUIStealScroll(e2.getRawX() - ContentViewGestureHandler.this.mLastRawX, e2.getRawY() - ContentViewGestureHandler.this.mLastRawY);
                    ContentViewGestureHandler.this.mLastRawX = e2.getRawX();
                    ContentViewGestureHandler.this.mLastRawY = e2.getRawY();
                    if (didUIStealScroll) {
                        return true;
                    }
                    if (!ContentViewGestureHandler.this.mTouchScrolling) {
                        ContentViewGestureHandler.this.sendShowPressCancelIfNecessary(e1);
                        ContentViewGestureHandler.this.endFlingIfNecessary(e2.getEventTime());
                        if (ContentViewGestureHandler.this.sendMotionEventAsGesture(6, e1, null)) {
                            ContentViewGestureHandler.this.mTouchScrolling = true;
                        }
                    }
                    int x = (int)e2.getX();
                    int y = (int)e2.getY();
                    int dx = (int)(distanceX + ContentViewGestureHandler.this.mAccumulatedScrollErrorX);
                    int dy = (int)(distanceY + ContentViewGestureHandler.this.mAccumulatedScrollErrorY);
                    ContentViewGestureHandler.this.mAccumulatedScrollErrorX = distanceX + ContentViewGestureHandler.this.mAccumulatedScrollErrorX - (float)dx;
                    ContentViewGestureHandler.this.mAccumulatedScrollErrorY = distanceY + ContentViewGestureHandler.this.mAccumulatedScrollErrorY - (float)dy;
                    ContentViewGestureHandler.this.mExtraParamBundle.clear();
                    ContentViewGestureHandler.this.mExtraParamBundle.putInt(ContentViewGestureHandler.DISTANCE_X, dx);
                    ContentViewGestureHandler.this.mExtraParamBundle.putInt(ContentViewGestureHandler.DISTANCE_Y, dy);
                    if ((dx | dy) != 0) {
                        ContentViewGestureHandler.this.sendLastGestureForVSync(7, e2.getEventTime(), x, y, ContentViewGestureHandler.this.mExtraParamBundle);
                    }
                    ContentViewGestureHandler.this.mMotionEventDelegate.invokeZoomPicker();
                    return true;
                }

                public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                    if (ContentViewGestureHandler.this.mSnapScrollController.isSnappingScrolls()) {
                        if (ContentViewGestureHandler.this.mSnapScrollController.isSnapHorizontal()) {
                            velocityY = 0.0f;
                        } else {
                            velocityX = 0.0f;
                        }
                    }
                    ContentViewGestureHandler.this.fling(e1.getEventTime(), (int)e1.getX(0), (int)e1.getY(0), (int)velocityX, (int)velocityY);
                    return true;
                }

                public void onShowPress(MotionEvent e) {
                    ContentViewGestureHandler.this.mShowPressIsCalled = true;
                    ContentViewGestureHandler.this.sendMotionEventAsGesture(0, e, null);
                }

                public boolean onSingleTapUp(MotionEvent e) {
                    if (this.isDistanceBetweenDownAndUpTooLong(e.getRawX(), e.getRawY())) {
                        ContentViewGestureHandler.this.mIgnoreSingleTap = true;
                        return true;
                    }
                    if (!ContentViewGestureHandler.this.mIgnoreSingleTap && !ContentViewGestureHandler.this.mLongPressDetector.isInLongPress()) {
                        if (e.getEventTime() - e.getDownTime() > (long)DOUBLE_TAP_TIMEOUT) {
                            float x = e.getX();
                            float y = e.getY();
                            if (ContentViewGestureHandler.this.sendMotionEventAsGesture(2, e, null)) {
                                ContentViewGestureHandler.this.mIgnoreSingleTap = true;
                            }
                            ContentViewGestureHandler.this.setClickXAndY((int)x, (int)y);
                            return true;
                        }
                        if (ContentViewGestureHandler.this.mMotionEventDelegate.hasFixedPageScale()) {
                            float x = e.getX();
                            float y = e.getY();
                            ContentViewGestureHandler.this.mExtraParamBundle.clear();
                            ContentViewGestureHandler.this.mExtraParamBundle.putBoolean(ContentViewGestureHandler.SHOW_PRESS, ContentViewGestureHandler.this.mShowPressIsCalled);
                            if (ContentViewGestureHandler.this.sendMotionEventAsGesture(3, e, ContentViewGestureHandler.this.mExtraParamBundle)) {
                                ContentViewGestureHandler.this.mIgnoreSingleTap = true;
                            }
                            ContentViewGestureHandler.this.setClickXAndY((int)x, (int)y);
                        } else {
                            ContentViewGestureHandler.this.sendMotionEventAsGesture(4, e, null);
                        }
                    }
                    return ContentViewGestureHandler.this.triggerLongTapIfNeeded(e);
                }

                public boolean onSingleTapConfirmed(MotionEvent e) {
                    if (ContentViewGestureHandler.this.mLongPressDetector.isInLongPress() || ContentViewGestureHandler.this.mIgnoreSingleTap) {
                        return true;
                    }
                    int x = (int)e.getX();
                    int y = (int)e.getY();
                    ContentViewGestureHandler.this.mExtraParamBundle.clear();
                    ContentViewGestureHandler.this.mExtraParamBundle.putBoolean(ContentViewGestureHandler.SHOW_PRESS, ContentViewGestureHandler.this.mShowPressIsCalled);
                    ContentViewGestureHandler.this.sendMotionEventAsGesture(3, e, ContentViewGestureHandler.this.mExtraParamBundle);
                    ContentViewGestureHandler.this.setClickXAndY(x, y);
                    return true;
                }

                public boolean onDoubleTapEvent(MotionEvent e) {
                    if (ContentViewGestureHandler.this.isDoubleTapDragDisabled()) {
                        return false;
                    }
                    switch (e.getActionMasked()) {
                        case 0: {
                            ContentViewGestureHandler.this.sendShowPressCancelIfNecessary(e);
                            ContentViewGestureHandler.this.mDoubleTapDragZoomAnchorX = e.getX();
                            ContentViewGestureHandler.this.mDoubleTapDragZoomAnchorY = e.getY();
                            ContentViewGestureHandler.this.mDoubleTapDragMode = 1;
                            break;
                        }
                        case 2: {
                            if (ContentViewGestureHandler.this.mDoubleTapDragMode == 1) {
                                float distanceY;
                                float distanceX = ContentViewGestureHandler.this.mDoubleTapDragZoomAnchorX - e.getX();
                                if (!(distanceX * distanceX + (distanceY = ContentViewGestureHandler.this.mDoubleTapDragZoomAnchorY - e.getY()) * distanceY > (float)ContentViewGestureHandler.this.mScaledTouchSlopSquare)) break;
                                ContentViewGestureHandler.this.sendGesture(6, e.getEventTime(), (int)e.getX(), (int)e.getY(), null);
                                ContentViewGestureHandler.this.pinchBegin(e.getEventTime(), Math.round(ContentViewGestureHandler.this.mDoubleTapDragZoomAnchorX), Math.round(ContentViewGestureHandler.this.mDoubleTapDragZoomAnchorY));
                                ContentViewGestureHandler.this.mDoubleTapDragMode = 2;
                                break;
                            }
                            if (ContentViewGestureHandler.this.mDoubleTapDragMode != 2) break;
                            ContentViewGestureHandler.this.mExtraParamBundle.clear();
                            ContentViewGestureHandler.this.sendGesture(7, e.getEventTime(), (int)e.getX(), (int)e.getY(), ContentViewGestureHandler.this.mExtraParamBundle);
                            float dy = ContentViewGestureHandler.this.mDoubleTapY - e.getY();
                            ContentViewGestureHandler.this.pinchBy(e.getEventTime(), Math.round(ContentViewGestureHandler.this.mDoubleTapDragZoomAnchorX), Math.round(ContentViewGestureHandler.this.mDoubleTapDragZoomAnchorY), (float)Math.pow(dy > 0.0f ? (double)0.995f : (double)1.005f, Math.abs(dy * ContentViewGestureHandler.this.mPxToDp)));
                            break;
                        }
                        case 1: {
                            if (ContentViewGestureHandler.this.mDoubleTapDragMode != 2) {
                                ContentViewGestureHandler.this.sendMotionEventAsGesture(1, e, null);
                            }
                            ContentViewGestureHandler.this.endDoubleTapDragMode(e);
                            break;
                        }
                        case 3: {
                            ContentViewGestureHandler.this.endDoubleTapDragMode(e);
                            break;
                        }
                    }
                    ContentViewGestureHandler.this.mDoubleTapY = e.getY();
                    return true;
                }

                public void onLongPress(MotionEvent e) {
                    if (!ContentViewGestureHandler.this.mZoomManager.isScaleGestureDetectionInProgress() && (ContentViewGestureHandler.this.mDoubleTapDragMode == 0 || ContentViewGestureHandler.this.isDoubleTapDragDisabled())) {
                        ContentViewGestureHandler.this.mLastLongPressEvent = e;
                        ContentViewGestureHandler.this.sendMotionEventAsGesture(5, e, null);
                    }
                }

                private boolean isDistanceBetweenDownAndUpTooLong(float x, float y) {
                    double deltaY;
                    double deltaX = ContentViewGestureHandler.this.mLastRawX - x;
                    return deltaX * deltaX + (deltaY = (double)(ContentViewGestureHandler.this.mLastRawY - y)) * deltaY > (double)ContentViewGestureHandler.this.mScaledTouchSlopSquare;
                }
            };
            this.mListener = listener;
            this.mGestureDetector = new GestureDetector(context, listener);
            this.mGestureDetector.setIsLongpressEnabled(false);
        }
        finally {
            TraceEvent.end();
        }
    }

    LongPressDetector getLongPressDetector() {
        return this.mLongPressDetector;
    }

    public void onLongPress(MotionEvent event) {
        this.mListener.onLongPress(event);
    }

    void cancelLongPress() {
        this.mLongPressDetector.cancelLongPress();
    }

    void fling(long timeMs, int x, int y, int velocityX, int velocityY) {
        this.endFlingIfNecessary(timeMs);
        if (!this.mTouchScrolling) {
            this.sendGesture(6, timeMs, x, y, null);
        }
        this.endTouchScrollIfNecessary(timeMs, false);
        this.mFlingMayBeActive = true;
        this.mExtraParamBundle.clear();
        this.mExtraParamBundle.putInt(VELOCITY_X, velocityX);
        this.mExtraParamBundle.putInt(VELOCITY_Y, velocityY);
        this.sendGesture(9, timeMs, x, y, this.mExtraParamBundle);
    }

    void endFlingIfNecessary(long timeMs) {
        if (!this.mFlingMayBeActive) {
            return;
        }
        this.mFlingMayBeActive = false;
        this.sendGesture(10, timeMs, 0, 0, null);
    }

    void endDoubleTapDragMode(MotionEvent event) {
        if (this.isDoubleTapDragDisabled()) {
            return;
        }
        if (this.mDoubleTapDragMode == 2) {
            if (event == null) {
                event = this.obtainActionCancelMotionEvent();
            }
            this.pinchEnd(event.getEventTime());
            this.sendGesture(8, event.getEventTime(), (int)event.getX(), (int)event.getY(), null);
        }
        this.mDoubleTapDragMode = 0;
    }

    private void endTouchScrollIfNecessary(long timeMs, boolean sendScrollEndEvent) {
        if (!this.mTouchScrolling) {
            return;
        }
        this.mTouchScrolling = false;
        if (sendScrollEndEvent) {
            this.sendGesture(8, timeMs, 0, 0, null);
        }
    }

    boolean isNativeScrolling() {
        return this.mTouchScrolling;
    }

    boolean isNativePinching() {
        return this.mPinchInProgress;
    }

    void pinchBegin(long timeMs, int x, int y) {
        this.sendGesture(11, timeMs, x, y, null);
    }

    void pinchBy(long timeMs, int anchorX, int anchorY, float delta) {
        this.mExtraParamBundle.clear();
        this.mExtraParamBundle.putFloat(DELTA, delta);
        this.sendLastGestureForVSync(12, timeMs, anchorX, anchorY, this.mExtraParamBundle);
        this.mPinchInProgress = true;
    }

    void pinchEnd(long timeMs) {
        this.sendGesture(13, timeMs, 0, 0, null);
        this.mPinchInProgress = false;
    }

    void setIgnoreSingleTap(boolean value) {
        this.mIgnoreSingleTap = value;
    }

    private void setClickXAndY(int x, int y) {
        this.mSingleTapX = x;
        this.mSingleTapY = y;
    }

    public int getSingleTapX() {
        return this.mSingleTapX;
    }

    public int getSingleTapY() {
        return this.mSingleTapY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean onTouchEvent(MotionEvent event) {
        try {
            TraceEvent.begin("onTouchEvent");
            this.mLongPressDetector.cancelLongPressIfNeeded(event);
            this.mSnapScrollController.setSnapScrollingMode(event);
            if (event.getActionMasked() == 0) {
                this.mNoTouchHandlerForGesture = false;
                this.mJavaScriptIsConsumingGesture = false;
                this.endFlingIfNecessary(event.getEventTime());
            } else if (event.getActionMasked() == 5) {
                this.endDoubleTapDragMode(null);
            }
            if (this.offerTouchEventToJavaScript(event)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.processTouchEvent(event);
            return bl;
        }
        finally {
            TraceEvent.end("onTouchEvent");
        }
    }

    void onWindowFocusLost() {
        if (this.mLongPressDetector.isInLongPress() && this.mLastLongPressEvent != null) {
            this.sendShowPressCancelIfNecessary(this.mLastLongPressEvent);
        }
    }

    private MotionEvent obtainActionCancelMotionEvent() {
        return MotionEvent.obtain(SystemClock.uptimeMillis(), SystemClock.uptimeMillis(), 3, 0.0f, 0.0f, 0);
    }

    void resetGestureHandlers() {
        MotionEvent me = this.obtainActionCancelMotionEvent();
        me.setSource(2);
        this.mGestureDetector.onTouchEvent(me);
        this.mZoomManager.processTouchEvent(me);
        me.recycle();
        this.mLongPressDetector.cancelLongPress();
    }

    void hasTouchEventHandlers(boolean hasTouchHandlers) {
        this.mHasTouchHandlers = hasTouchHandlers;
        if (!this.mHasTouchHandlers) {
            this.mPendingMotionEvents.clear();
        }
    }

    private boolean offerTouchEventToJavaScript(MotionEvent event) {
        MotionEvent clone;
        this.mLongPressDetector.onOfferTouchEventToJavaScript(event);
        if (!this.mHasTouchHandlers || this.mNoTouchHandlerForGesture) {
            return false;
        }
        if (event.getActionMasked() == 2) {
            if (!this.mLongPressDetector.confirmOfferMoveEventToJavaScript(event)) {
                return true;
            }
            MotionEvent previousEvent = this.mPendingMotionEvents.peekLast();
            if (previousEvent != null && previousEvent != this.mPendingMotionEvents.peekFirst() && previousEvent.getActionMasked() == 2 && previousEvent.getPointerCount() == event.getPointerCount()) {
                TraceEvent.instant("offerTouchEventToJavaScript:EventCoalesced", "QueueSize = " + this.mPendingMotionEvents.size());
                MotionEvent.PointerCoords[] coords = new MotionEvent.PointerCoords[event.getPointerCount()];
                for (int i = 0; i < coords.length; ++i) {
                    coords[i] = new MotionEvent.PointerCoords();
                    event.getPointerCoords(i, coords[i]);
                }
                previousEvent.addBatch(event.getEventTime(), coords, event.getMetaState());
                return true;
            }
        }
        if (this.mPendingMotionEvents.isEmpty()) {
            clone = MotionEvent.obtain(event);
            this.mPendingMotionEvents.add(clone);
            int forward = this.sendPendingEventToNative();
            if (forward == 2) {
                this.mPendingMotionEvents.remove(clone);
            }
            return forward != 2;
        }
        TraceEvent.instant("offerTouchEventToJavaScript:EventQueued", "QueueSize = " + this.mPendingMotionEvents.size());
        clone = MotionEvent.obtain(event);
        this.mPendingMotionEvents.add(clone);
        return true;
    }

    private int sendPendingEventToNative() {
        MotionEvent event = this.mPendingMotionEvents.peekFirst();
        if (event == null) {
            assert (false) : "Cannot send from an empty pending event queue";
            return 2;
        }
        if (this.mTouchEventTimeoutHandler.hasTimeoutEvent()) {
            return 2;
        }
        TouchPoint[] pts = new TouchPoint[event.getPointerCount()];
        int type = TouchPoint.createTouchPoints(event, pts);
        if (type == -1) {
            return 2;
        }
        if (!this.mTouchScrolling && !this.mPinchInProgress) {
            this.mTouchCancelEventSent = false;
            if (this.mMotionEventDelegate.sendTouchEvent(event.getEventTime(), type, pts)) {
                if (!this.mJavaScriptIsConsumingGesture && event == this.mPendingMotionEvents.peekFirst() && event.getAction() != 1 && event.getAction() != 3) {
                    this.mTouchEventTimeoutHandler.start(event.getEventTime(), pts);
                }
                return 0;
            }
        } else if (!this.mTouchCancelEventSent) {
            this.mTouchCancelEventSent = true;
            MotionEvent previousCancelEvent = this.mLastCancelledEvent;
            this.mLastCancelledEvent = event;
            if (this.mMotionEventDelegate.sendTouchEvent(event.getEventTime(), TouchPoint.TOUCH_EVENT_TYPE_CANCEL, pts)) {
                return 1;
            }
            this.mLastCancelledEvent = previousCancelEvent;
        }
        return 2;
    }

    private boolean processTouchEvent(MotionEvent event) {
        boolean handled = false;
        boolean possiblyEndMovement = false;
        if (event.getAction() == 1 && this.mTouchScrolling) {
            possiblyEndMovement = true;
        }
        this.mLongPressDetector.cancelLongPressIfNeeded(event);
        this.mLongPressDetector.startLongPressTimerIfNeeded(event);
        if (this.canHandle(event)) {
            handled |= this.mGestureDetector.onTouchEvent(event);
            if (event.getAction() == 0) {
                this.mCurrentDownEvent = MotionEvent.obtain(event);
            }
        }
        if (possiblyEndMovement && !(handled |= this.mZoomManager.processTouchEvent(event))) {
            this.endTouchScrollIfNecessary(event.getEventTime(), true);
        }
        return handled;
    }

    void mockTouchEventTimeout() {
        this.mTouchEventTimeoutHandler.mockTimeout();
    }

    void confirmTouchEvent(int ackResult) {
        if (this.mTouchEventTimeoutHandler.confirmTouchEvent()) {
            return;
        }
        if (this.mPendingMotionEvents.isEmpty()) {
            Log.w(TAG, "confirmTouchEvent with Empty pending list!");
            return;
        }
        TraceEvent.begin("confirmTouchEvent");
        MotionEvent ackedEvent = this.mPendingMotionEvents.removeFirst();
        if (ackedEvent == this.mLastCancelledEvent) {
            ackResult = 3;
            TraceEvent.instant("confirmTouchEvent:CanceledEvent");
        }
        switch (ackResult) {
            case 0: {
                assert (false);
                break;
            }
            case 1: {
                this.mJavaScriptIsConsumingGesture = true;
                this.mZoomManager.passTouchEventThrough(ackedEvent);
                this.trySendPendingEventsToNative();
                break;
            }
            case 2: {
                if (!this.mJavaScriptIsConsumingGesture) {
                    this.processTouchEvent(ackedEvent);
                }
                this.trySendPendingEventsToNative();
                break;
            }
            case 3: {
                this.mNoTouchHandlerForGesture = true;
                this.processTouchEvent(ackedEvent);
                this.drainAllPendingEventsUntilNextDown();
                break;
            }
        }
        this.mLongPressDetector.cancelLongPressIfNeeded(this.mPendingMotionEvents.iterator());
        this.recycleEvent(ackedEvent);
        TraceEvent.end("confirmTouchEvent");
    }

    private void trySendPendingEventsToNative() {
        int forward;
        while (!this.mPendingMotionEvents.isEmpty() && (forward = this.sendPendingEventToNative()) == 2) {
            MotionEvent event = this.mPendingMotionEvents.removeFirst();
            if (!this.mJavaScriptIsConsumingGesture) {
                this.processTouchEvent(event);
            }
            this.recycleEvent(event);
        }
    }

    private void drainAllPendingEventsUntilNextDown() {
        MotionEvent nextEvent = this.mPendingMotionEvents.peekFirst();
        while (nextEvent != null && nextEvent.getActionMasked() != 0) {
            this.processTouchEvent(nextEvent);
            this.mPendingMotionEvents.removeFirst();
            this.recycleEvent(nextEvent);
            nextEvent = this.mPendingMotionEvents.peekFirst();
        }
        if (nextEvent == null) {
            return;
        }
        this.mNoTouchHandlerForGesture = false;
        this.trySendPendingEventsToNative();
    }

    private void recycleEvent(MotionEvent event) {
        if (event == this.mLastCancelledEvent) {
            this.mLastCancelledEvent = null;
        }
        event.recycle();
    }

    private boolean sendMotionEventAsGesture(int type, MotionEvent event, Bundle extraParams) {
        return this.mMotionEventDelegate.sendGesture(type, event.getEventTime(), (int)event.getX(), (int)event.getY(), false, extraParams);
    }

    private boolean sendGesture(int type, long timeMs, int x, int y, Bundle extraParams) {
        return this.mMotionEventDelegate.sendGesture(type, timeMs, x, y, false, extraParams);
    }

    private boolean sendLastGestureForVSync(int type, long timeMs, int x, int y, Bundle extraParams) {
        return this.mMotionEventDelegate.sendGesture(type, timeMs, x, y, this.mInputEventsDeliveredAtVSync, extraParams);
    }

    void sendShowPressCancelIfNecessary(MotionEvent e) {
        if (!this.mShowPressIsCalled) {
            return;
        }
        if (this.sendMotionEventAsGesture(14, e, null)) {
            this.mShowPressIsCalled = false;
            this.mLastLongPressEvent = null;
        }
    }

    boolean canHandle(MotionEvent ev) {
        return ev.getAction() == 0 || this.mCurrentDownEvent != null && this.mCurrentDownEvent.getDownTime() == ev.getDownTime();
    }

    boolean triggerLongTapIfNeeded(MotionEvent ev) {
        if (this.mLongPressDetector.isInLongPress() && ev.getAction() == 1 && !this.mZoomManager.isScaleGestureDetectionInProgress()) {
            this.sendShowPressCancelIfNecessary(ev);
            this.sendMotionEventAsGesture(15, ev, null);
            return true;
        }
        return false;
    }

    MotionEvent peekFirstInPendingMotionEventsForTesting() {
        return this.mPendingMotionEvents.peekFirst();
    }

    boolean isEventCancelledForTesting(MotionEvent event) {
        return event != null && event == this.mLastCancelledEvent;
    }

    int getNumberOfPendingMotionEventsForTesting() {
        return this.mPendingMotionEvents.size();
    }

    void sendShowPressedStateGestureForTesting() {
        if (this.mCurrentDownEvent == null) {
            return;
        }
        this.mListener.onShowPress(this.mCurrentDownEvent);
    }

    boolean hasScheduledTouchTimeoutEventForTesting() {
        return this.mTouchEventTimeoutHandler.hasScheduledTimeoutEventForTesting();
    }

    public void updateDoubleTapDragSupport(boolean supportDoubleTapDrag) {
        assert (this.mDoubleTapDragMode == 3 || this.mDoubleTapDragMode == 0);
        this.mDoubleTapDragMode = supportDoubleTapDrag ? 0 : 3;
    }

    private boolean isDoubleTapDragDisabled() {
        return this.mDoubleTapDragMode == 3;
    }

    public static interface MotionEventDelegate {
        public boolean sendTouchEvent(long var1, int var3, TouchPoint[] var4);

        public boolean sendGesture(int var1, long var2, int var4, int var5, boolean var6, Bundle var7);

        public boolean didUIStealScroll(float var1, float var2);

        public void invokeZoomPicker();

        public boolean hasFixedPageScale();
    }

    private class TouchEventTimeoutHandler
    implements Runnable {
        private static final int TOUCH_EVENT_TIMEOUT = 200;
        private static final int PENDING_ACK_NONE = 0;
        private static final int PENDING_ACK_ORIGINAL_EVENT = 1;
        private static final int PENDING_ACK_CANCEL_EVENT = 2;
        private long mEventTime;
        private TouchPoint[] mTouchPoints;
        private Handler mHandler = new Handler();
        private int mPendingAckState;

        private TouchEventTimeoutHandler() {
        }

        public void start(long eventTime, TouchPoint[] pts) {
            assert (this.mTouchPoints == null);
            assert (this.mPendingAckState == 0);
            this.mEventTime = eventTime;
            this.mTouchPoints = pts;
            this.mHandler.postDelayed(this, 200L);
        }

        public void run() {
            TraceEvent.begin("TouchEventTimeout");
            while (!ContentViewGestureHandler.this.mPendingMotionEvents.isEmpty()) {
                MotionEvent nextEvent = (MotionEvent)ContentViewGestureHandler.this.mPendingMotionEvents.removeFirst();
                ContentViewGestureHandler.this.processTouchEvent(nextEvent);
                ContentViewGestureHandler.this.recycleEvent(nextEvent);
            }
            this.mPendingAckState = 1;
            TraceEvent.end();
        }

        public boolean hasTimeoutEvent() {
            return this.mPendingAckState != 0;
        }

        public boolean confirmTouchEvent() {
            switch (this.mPendingAckState) {
                case 0: {
                    this.mHandler.removeCallbacks(this);
                    this.mTouchPoints = null;
                    return false;
                }
                case 1: {
                    TraceEvent.instant("TouchEventTimeout:ConfirmOriginalEvent");
                    this.mPendingAckState = 2;
                    ContentViewGestureHandler.this.mMotionEventDelegate.sendTouchEvent(this.mEventTime + 200L, TouchPoint.TOUCH_EVENT_TYPE_CANCEL, this.mTouchPoints);
                    this.mTouchPoints = null;
                    return true;
                }
                case 2: {
                    TraceEvent.instant("TouchEventTimeout:ConfirmCancelEvent");
                    this.mPendingAckState = 0;
                    ContentViewGestureHandler.this.drainAllPendingEventsUntilNextDown();
                    return true;
                }
            }
            assert (false) : "Never reached";
            return false;
        }

        public void mockTimeout() {
            assert (!this.hasTimeoutEvent());
            this.mHandler.removeCallbacks(this);
            this.run();
        }

        public boolean hasScheduledTimeoutEventForTesting() {
            return this.mTouchPoints != null && this.mPendingAckState == 0;
        }
    }
}

