/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.com.google.common.primitives;

import com.android.org.chromium.com.google.common.annotations.GwtCompatible;
import com.android.org.chromium.com.google.common.base.Preconditions;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public final class SignedBytes {
    public static final byte MAX_POWER_OF_TWO = 64;

    private SignedBytes() {
    }

    public static byte checkedCast(long value) {
        byte result = (byte)value;
        Preconditions.checkArgument((long)result == value, "Out of range: %s", value);
        return result;
    }

    public static byte saturatedCast(long value) {
        if (value > 127L) {
            return 127;
        }
        if (value < -128L) {
            return -128;
        }
        return (byte)value;
    }

    public static int compare(byte a, byte b) {
        return a - b;
    }

    public static byte min(byte ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        byte min = array2[0];
        for (int i = 1; i < array2.length; ++i) {
            if (array2[i] >= min) continue;
            min = array2[i];
        }
        return min;
    }

    public static byte max(byte ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        byte max = array2[0];
        for (int i = 1; i < array2.length; ++i) {
            if (array2[i] <= max) continue;
            max = array2[i];
        }
        return max;
    }

    public static String join(String separator, byte ... array2) {
        Preconditions.checkNotNull(separator);
        if (array2.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array2.length * 5);
        builder.append(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            builder.append(separator).append(array2[i]);
        }
        return builder.toString();
    }

    public static Comparator<byte[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LexicographicalComparator implements Comparator<byte[]>
    {
        INSTANCE;


        @Override
        public int compare(byte[] left, byte[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i = 0; i < minLength; ++i) {
                int result = SignedBytes.compare(left[i], right[i]);
                if (result == 0) continue;
                return result;
            }
            return left.length - right.length;
        }
    }
}

