/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.base;

import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import com.android.org.chromium.base.CalledByNative;

public class MemoryPressureListener {
    @CalledByNative
    private static void registerSystemCallback(Context context) {
        context.registerComponentCallbacks(new ComponentCallbacks2(){

            public void onTrimMemory(int level) {
                MemoryPressureListener.maybeNotifyMemoryPresure(level);
            }

            public void onLowMemory() {
                MemoryPressureListener.nativeOnMemoryPressure(2);
            }

            public void onConfigurationChanged(Configuration configuration) {
            }
        });
    }

    public static void simulateMemoryPressureSignal(int level) {
        MemoryPressureListener.maybeNotifyMemoryPresure(level);
    }

    private static void maybeNotifyMemoryPresure(int level) {
        if (level == 80) {
            MemoryPressureListener.nativeOnMemoryPressure(2);
        } else if (level >= 40 || level == 15) {
            MemoryPressureListener.nativeOnMemoryPressure(0);
        }
    }

    private static native void nativeOnMemoryPressure(int var0);
}

