/*
 * Decompiled with CFR 0.152.
 */
package com.android.okhttp.internal.spdy;

import com.android.okhttp.internal.Util;
import com.android.okhttp.internal.spdy.Settings;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SpdyReader
implements Closeable {
    static final byte[] DICTIONARY;
    private final DataInputStream in;
    private final DataInputStream nameValueBlockIn;
    private int compressedLimit;

    SpdyReader(InputStream in) {
        this.in = new DataInputStream(in);
        this.nameValueBlockIn = this.newNameValueBlockStream();
    }

    public boolean nextFrame(Handler handler) throws IOException {
        int w1;
        try {
            w1 = this.in.readInt();
        }
        catch (IOException e) {
            return false;
        }
        int w2 = this.in.readInt();
        boolean control = (w1 & Integer.MIN_VALUE) != 0;
        int flags = (w2 & 0xFF000000) >>> 24;
        int length = w2 & 0xFFFFFF;
        if (control) {
            int version = (w1 & 0x7FFF0000) >>> 16;
            int type = w1 & 0xFFFF;
            if (version != 3) {
                throw new ProtocolException("version != 3: " + version);
            }
            switch (type) {
                case 1: {
                    this.readSynStream(handler, flags, length);
                    return true;
                }
                case 2: {
                    this.readSynReply(handler, flags, length);
                    return true;
                }
                case 3: {
                    this.readRstStream(handler, flags, length);
                    return true;
                }
                case 4: {
                    this.readSettings(handler, flags, length);
                    return true;
                }
                case 5: {
                    if (length != 0) {
                        throw SpdyReader.ioException("TYPE_NOOP length: %d != 0", length);
                    }
                    handler.noop();
                    return true;
                }
                case 6: {
                    this.readPing(handler, flags, length);
                    return true;
                }
                case 7: {
                    this.readGoAway(handler, flags, length);
                    return true;
                }
                case 8: {
                    this.readHeaders(handler, flags, length);
                    return true;
                }
                case 9: {
                    this.readWindowUpdate(handler, flags, length);
                    return true;
                }
                case 16: {
                    Util.skipByReading(this.in, length);
                    throw new UnsupportedOperationException("TODO");
                }
            }
            throw new IOException("Unexpected frame");
        }
        int streamId = w1 & Integer.MAX_VALUE;
        handler.data(flags, streamId, this.in, length);
        return true;
    }

    private void readSynStream(Handler handler, int flags, int length) throws IOException {
        int w1 = this.in.readInt();
        int w2 = this.in.readInt();
        short s3 = this.in.readShort();
        int streamId = w1 & Integer.MAX_VALUE;
        int associatedStreamId = w2 & Integer.MAX_VALUE;
        int priority = (s3 & 0xE000) >>> 13;
        int slot = s3 & 0xFF;
        List<String> nameValueBlock = this.readNameValueBlock(length - 10);
        handler.synStream(flags, streamId, associatedStreamId, priority, slot, nameValueBlock);
    }

    private void readSynReply(Handler handler, int flags, int length) throws IOException {
        int w1 = this.in.readInt();
        int streamId = w1 & Integer.MAX_VALUE;
        List<String> nameValueBlock = this.readNameValueBlock(length - 4);
        handler.synReply(flags, streamId, nameValueBlock);
    }

    private void readRstStream(Handler handler, int flags, int length) throws IOException {
        if (length != 8) {
            throw SpdyReader.ioException("TYPE_RST_STREAM length: %d != 8", length);
        }
        int streamId = this.in.readInt() & Integer.MAX_VALUE;
        int statusCode = this.in.readInt();
        handler.rstStream(flags, streamId, statusCode);
    }

    private void readHeaders(Handler handler, int flags, int length) throws IOException {
        int w1 = this.in.readInt();
        int streamId = w1 & Integer.MAX_VALUE;
        List<String> nameValueBlock = this.readNameValueBlock(length - 4);
        handler.headers(flags, streamId, nameValueBlock);
    }

    private void readWindowUpdate(Handler handler, int flags, int length) throws IOException {
        if (length != 8) {
            throw SpdyReader.ioException("TYPE_WINDOW_UPDATE length: %d != 8", length);
        }
        int w1 = this.in.readInt();
        int w2 = this.in.readInt();
        int streamId = w1 & Integer.MAX_VALUE;
        int deltaWindowSize = w2 & Integer.MAX_VALUE;
        handler.windowUpdate(flags, streamId, deltaWindowSize);
    }

    private DataInputStream newNameValueBlockStream() {
        InputStream throttleStream = new InputStream(){

            public int read() throws IOException {
                return Util.readSingleByte(this);
            }

            public int read(byte[] buffer, int offset, int byteCount) throws IOException {
                byteCount = Math.min(byteCount, SpdyReader.this.compressedLimit);
                int consumed = SpdyReader.this.in.read(buffer, offset, byteCount);
                SpdyReader.this.compressedLimit -= consumed;
                return consumed;
            }

            public void close() throws IOException {
                SpdyReader.this.in.close();
            }
        };
        Inflater inflater = new Inflater(){

            public int inflate(byte[] buffer, int offset, int count) throws DataFormatException {
                int result = super.inflate(buffer, offset, count);
                if (result == 0 && this.needsDictionary()) {
                    this.setDictionary(DICTIONARY);
                    result = super.inflate(buffer, offset, count);
                }
                return result;
            }
        };
        return new DataInputStream(new InflaterInputStream(throttleStream, inflater));
    }

    private List<String> readNameValueBlock(int length) throws IOException {
        this.compressedLimit += length;
        try {
            int numberOfPairs = this.nameValueBlockIn.readInt();
            if (numberOfPairs < 0) {
                Logger.getLogger(this.getClass().getName()).warning("numberOfPairs < 0: " + numberOfPairs);
                throw SpdyReader.ioException("numberOfPairs < 0", new Object[0]);
            }
            ArrayList<String> entries = new ArrayList<String>(numberOfPairs * 2);
            for (int i = 0; i < numberOfPairs; ++i) {
                String name = this.readString();
                String values = this.readString();
                if (name.length() == 0) {
                    throw SpdyReader.ioException("name.length == 0", new Object[0]);
                }
                if (values.length() == 0) {
                    throw SpdyReader.ioException("values.length == 0", new Object[0]);
                }
                entries.add(name);
                entries.add(values);
            }
            if (this.compressedLimit != 0) {
                Logger.getLogger(this.getClass().getName()).warning("compressedLimit > 0: " + this.compressedLimit);
            }
            return entries;
        }
        catch (DataFormatException e) {
            throw new IOException(e.getMessage());
        }
    }

    private String readString() throws DataFormatException, IOException {
        int length = this.nameValueBlockIn.readInt();
        byte[] bytes = new byte[length];
        Util.readFully(this.nameValueBlockIn, bytes);
        return new String(bytes, 0, length, "UTF-8");
    }

    private void readPing(Handler handler, int flags, int length) throws IOException {
        if (length != 4) {
            throw SpdyReader.ioException("TYPE_PING length: %d != 4", length);
        }
        int id2 = this.in.readInt();
        handler.ping(flags, id2);
    }

    private void readGoAway(Handler handler, int flags, int length) throws IOException {
        if (length != 8) {
            throw SpdyReader.ioException("TYPE_GOAWAY length: %d != 8", length);
        }
        int lastGoodStreamId = this.in.readInt() & Integer.MAX_VALUE;
        int statusCode = this.in.readInt();
        handler.goAway(flags, lastGoodStreamId, statusCode);
    }

    private void readSettings(Handler handler, int flags, int length) throws IOException {
        int numberOfEntries = this.in.readInt();
        if (length != 4 + 8 * numberOfEntries) {
            throw SpdyReader.ioException("TYPE_SETTINGS length: %d != 4 + 8 * %d", length, numberOfEntries);
        }
        Settings settings = new Settings();
        for (int i = 0; i < numberOfEntries; ++i) {
            int w1 = this.in.readInt();
            int value = this.in.readInt();
            int idFlags = (w1 & 0xFF000000) >>> 24;
            int id2 = w1 & 0xFFFFFF;
            settings.set(id2, idFlags, value);
        }
        handler.settings(flags, settings);
    }

    private static IOException ioException(String message, Object ... args) throws IOException {
        throw new IOException(String.format(message, args));
    }

    @Override
    public void close() throws IOException {
        Util.closeAll(this.in, this.nameValueBlockIn);
    }

    static {
        try {
            DICTIONARY = "\u0000\u0000\u0000\u0007options\u0000\u0000\u0000\u0004head\u0000\u0000\u0000\u0004post\u0000\u0000\u0000\u0003put\u0000\u0000\u0000\u0006delete\u0000\u0000\u0000\u0005trace\u0000\u0000\u0000\u0006accept\u0000\u0000\u0000\u000eaccept-charset\u0000\u0000\u0000\u000faccept-encoding\u0000\u0000\u0000\u000faccept-language\u0000\u0000\u0000\raccept-ranges\u0000\u0000\u0000\u0003age\u0000\u0000\u0000\u0005allow\u0000\u0000\u0000\rauthorization\u0000\u0000\u0000\rcache-control\u0000\u0000\u0000\nconnection\u0000\u0000\u0000\fcontent-base\u0000\u0000\u0000\u0010content-encoding\u0000\u0000\u0000\u0010content-language\u0000\u0000\u0000\u000econtent-length\u0000\u0000\u0000\u0010content-location\u0000\u0000\u0000\u000bcontent-md5\u0000\u0000\u0000\rcontent-range\u0000\u0000\u0000\fcontent-type\u0000\u0000\u0000\u0004date\u0000\u0000\u0000\u0004etag\u0000\u0000\u0000\u0006expect\u0000\u0000\u0000\u0007expires\u0000\u0000\u0000\u0004from\u0000\u0000\u0000\u0004host\u0000\u0000\u0000\bif-match\u0000\u0000\u0000\u0011if-modified-since\u0000\u0000\u0000\rif-none-match\u0000\u0000\u0000\bif-range\u0000\u0000\u0000\u0013if-unmodified-since\u0000\u0000\u0000\rlast-modified\u0000\u0000\u0000\blocation\u0000\u0000\u0000\fmax-forwards\u0000\u0000\u0000\u0006pragma\u0000\u0000\u0000\u0012proxy-authenticate\u0000\u0000\u0000\u0013proxy-authorization\u0000\u0000\u0000\u0005range\u0000\u0000\u0000\u0007referer\u0000\u0000\u0000\u000bretry-after\u0000\u0000\u0000\u0006server\u0000\u0000\u0000\u0002te\u0000\u0000\u0000\u0007trailer\u0000\u0000\u0000\u0011transfer-encoding\u0000\u0000\u0000\u0007upgrade\u0000\u0000\u0000\nuser-agent\u0000\u0000\u0000\u0004vary\u0000\u0000\u0000\u0003via\u0000\u0000\u0000\u0007warning\u0000\u0000\u0000\u0010www-authenticate\u0000\u0000\u0000\u0006method\u0000\u0000\u0000\u0003get\u0000\u0000\u0000\u0006status\u0000\u0000\u0000\u0006200 OK\u0000\u0000\u0000\u0007version\u0000\u0000\u0000\bHTTP/1.1\u0000\u0000\u0000\u0003url\u0000\u0000\u0000\u0006public\u0000\u0000\u0000\nset-cookie\u0000\u0000\u0000\nkeep-alive\u0000\u0000\u0000\u0006origin100101201202205206300302303304305306307402405406407408409410411412413414415416417502504505203 Non-Authoritative Information204 No Content301 Moved Permanently400 Bad Request401 Unauthorized403 Forbidden404 Not Found500 Internal Server Error501 Not Implemented503 Service UnavailableJan Feb Mar Apr May Jun Jul Aug Sept Oct Nov Dec 00:00:00 Mon, Tue, Wed, Thu, Fri, Sat, Sun, GMTchunked,text/html,image/png,image/jpg,image/gif,application/xml,application/xhtml+xml,text/plain,text/javascript,publicprivatemax-age=gzip,deflate,sdchcharset=utf-8charset=iso-8859-1,utf-,*,enq=0.".getBytes(Util.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Handler {
        public void data(int var1, int var2, InputStream var3, int var4) throws IOException;

        public void synStream(int var1, int var2, int var3, int var4, int var5, List<String> var6);

        public void synReply(int var1, int var2, List<String> var3) throws IOException;

        public void headers(int var1, int var2, List<String> var3) throws IOException;

        public void rstStream(int var1, int var2, int var3);

        public void settings(int var1, Settings var2);

        public void noop();

        public void ping(int var1, int var2);

        public void goAway(int var1, int var2, int var3);

        public void windowUpdate(int var1, int var2, int var3);
    }
}

