/*
 * Decompiled with CFR 0.152.
 */
package com.android.okhttp.internal.http;

import com.android.okhttp.Connection;
import com.android.okhttp.OkHttpClient;
import com.android.okhttp.internal.Platform;
import com.android.okhttp.internal.Util;
import com.android.okhttp.internal.http.HttpAuthenticator;
import com.android.okhttp.internal.http.HttpEngine;
import com.android.okhttp.internal.http.HttpsEngine;
import com.android.okhttp.internal.http.Policy;
import com.android.okhttp.internal.http.RawHeaders;
import com.android.okhttp.internal.http.RetryableOutputStream;
import com.android.okhttp.internal.http.RouteSelector;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketPermission;
import java.net.URL;
import java.security.Permission;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLHandshakeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpURLConnectionImpl
extends HttpURLConnection
implements Policy {
    static final int HTTP_TEMP_REDIRECT = 307;
    private static final int MAX_REDIRECTS = 20;
    final OkHttpClient client;
    private final RawHeaders rawRequestHeaders = new RawHeaders();
    private long fixedContentLength = -1L;
    private int redirectionCount;
    protected IOException httpEngineFailure;
    protected HttpEngine httpEngine;
    private Proxy selectedProxy;

    public HttpURLConnectionImpl(URL url, OkHttpClient client) {
        super(url);
        this.client = client;
    }

    @Override
    public final void connect() throws IOException {
        boolean success;
        this.initHttpEngine();
        while (!(success = this.execute(false))) {
        }
    }

    @Override
    public final void disconnect() {
        if (this.httpEngine != null) {
            if (this.httpEngine.hasResponse()) {
                Util.closeQuietly(this.httpEngine.getResponseBody());
            }
            this.httpEngine.release(true);
        }
    }

    @Override
    public final InputStream getErrorStream() {
        try {
            HttpEngine response = this.getResponse();
            if (response.hasResponseBody() && response.getResponseCode() >= 400) {
                return response.getResponseBody();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public final String getHeaderField(int position) {
        try {
            return this.getResponse().getResponseHeaders().getHeaders().getValue(position);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public final String getHeaderField(String fieldName) {
        try {
            RawHeaders rawHeaders = this.getResponse().getResponseHeaders().getHeaders();
            return fieldName == null ? rawHeaders.getStatusLine() : rawHeaders.get(fieldName);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public final String getHeaderFieldKey(int position) {
        try {
            return this.getResponse().getResponseHeaders().getHeaders().getFieldName(position);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public final Map<String, List<String>> getHeaderFields() {
        try {
            return this.getResponse().getResponseHeaders().getHeaders().toMultimap(true);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public final Map<String, List<String>> getRequestProperties() {
        if (this.connected) {
            throw new IllegalStateException("Cannot access request header fields after connection is set");
        }
        return this.rawRequestHeaders.toMultimap(false);
    }

    @Override
    public final InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException("This protocol does not support input");
        }
        HttpEngine response = this.getResponse();
        if (this.getResponseCode() >= 400) {
            throw new FileNotFoundException(this.url.toString());
        }
        InputStream result = response.getResponseBody();
        if (result == null) {
            throw new ProtocolException("No response body exists; responseCode=" + this.getResponseCode());
        }
        return result;
    }

    @Override
    public final OutputStream getOutputStream() throws IOException {
        this.connect();
        OutputStream out = this.httpEngine.getRequestBody();
        if (out == null) {
            throw new ProtocolException("method does not support a request body: " + this.method);
        }
        if (this.httpEngine.hasResponse()) {
            throw new ProtocolException("cannot write request body after response has been read");
        }
        return out;
    }

    @Override
    public final Permission getPermission() throws IOException {
        String hostName = this.getURL().getHost();
        int hostPort = Util.getEffectivePort(this.getURL());
        if (this.usingProxy()) {
            InetSocketAddress proxyAddress = (InetSocketAddress)this.client.getProxy().address();
            hostName = proxyAddress.getHostName();
            hostPort = proxyAddress.getPort();
        }
        return new SocketPermission(hostName + ":" + hostPort, "connect, resolve");
    }

    @Override
    public final String getRequestProperty(String field) {
        if (field == null) {
            return null;
        }
        return this.rawRequestHeaders.get(field);
    }

    @Override
    public void setConnectTimeout(int timeoutMillis) {
        this.client.setConnectTimeout(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public int getConnectTimeout() {
        return this.client.getConnectTimeout();
    }

    @Override
    public void setReadTimeout(int timeoutMillis) {
        this.client.setReadTimeout(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public int getReadTimeout() {
        return this.client.getReadTimeout();
    }

    private void initHttpEngine() throws IOException {
        if (this.httpEngineFailure != null) {
            throw this.httpEngineFailure;
        }
        if (this.httpEngine != null) {
            return;
        }
        this.connected = true;
        try {
            if (this.doOutput) {
                if (this.method.equals("GET")) {
                    this.method = "POST";
                } else if (!this.method.equals("POST") && !this.method.equals("PUT")) {
                    throw new ProtocolException(this.method + " does not support writing");
                }
            }
            this.httpEngine = this.newHttpEngine(this.method, this.rawRequestHeaders, null, null);
        }
        catch (IOException e) {
            this.httpEngineFailure = e;
            throw e;
        }
    }

    @Override
    public HttpURLConnection getHttpConnectionToCache() {
        return this;
    }

    private HttpEngine newHttpEngine(String method, RawHeaders requestHeaders, Connection connection, RetryableOutputStream requestBody) throws IOException {
        if (this.url.getProtocol().equals("http")) {
            return new HttpEngine(this.client, this, method, requestHeaders, connection, requestBody);
        }
        if (this.url.getProtocol().equals("https")) {
            return new HttpsEngine(this.client, this, method, requestHeaders, connection, requestBody);
        }
        throw new AssertionError();
    }

    private HttpEngine getResponse() throws IOException {
        this.initHttpEngine();
        if (this.httpEngine.hasResponse()) {
            return this.httpEngine;
        }
        while (true) {
            if (!this.execute(true)) {
                continue;
            }
            Retry retry = this.processResponseHeaders();
            if (retry == Retry.NONE) {
                this.httpEngine.automaticallyReleaseConnectionToPool();
                return this.httpEngine;
            }
            String retryMethod = this.method;
            OutputStream requestBody = this.httpEngine.getRequestBody();
            int responseCode = this.getResponseCode();
            if (responseCode == 300 || responseCode == 301 || responseCode == 302 || responseCode == 303) {
                retryMethod = "GET";
                requestBody = null;
            }
            if (requestBody != null && !(requestBody instanceof RetryableOutputStream)) {
                throw new HttpRetryException("Cannot retry streamed HTTP body", this.httpEngine.getResponseCode());
            }
            if (retry == Retry.DIFFERENT_CONNECTION) {
                this.httpEngine.automaticallyReleaseConnectionToPool();
            }
            this.httpEngine.release(false);
            this.httpEngine = this.newHttpEngine(retryMethod, this.rawRequestHeaders, this.httpEngine.getConnection(), (RetryableOutputStream)requestBody);
        }
    }

    private boolean execute(boolean readResponse) throws IOException {
        try {
            this.httpEngine.sendRequest();
            if (readResponse) {
                this.httpEngine.readResponse();
            }
            return true;
        }
        catch (IOException e) {
            if (this.handleFailure(e)) {
                return false;
            }
            throw e;
        }
    }

    private boolean handleFailure(IOException e) throws IOException {
        OutputStream requestBody;
        boolean canRetryRequestBody;
        RouteSelector routeSelector = this.httpEngine.routeSelector;
        if (routeSelector != null && this.httpEngine.connection != null) {
            routeSelector.connectFailed(this.httpEngine.connection, e);
        }
        boolean bl = canRetryRequestBody = (requestBody = this.httpEngine.getRequestBody()) == null || requestBody instanceof RetryableOutputStream;
        if (routeSelector == null && this.httpEngine.connection == null || routeSelector != null && !routeSelector.hasNext() || !this.isRecoverable(e) || !canRetryRequestBody) {
            this.httpEngineFailure = e;
            return false;
        }
        this.httpEngine.release(true);
        RetryableOutputStream retryableOutputStream = (RetryableOutputStream)requestBody;
        this.httpEngine = this.newHttpEngine(this.method, this.rawRequestHeaders, null, retryableOutputStream);
        this.httpEngine.routeSelector = routeSelector;
        return true;
    }

    private boolean isRecoverable(IOException e) {
        boolean sslFailure = e instanceof SSLHandshakeException && e.getCause() instanceof CertificateException;
        boolean protocolFailure = e instanceof ProtocolException;
        return !sslFailure && !protocolFailure;
    }

    public HttpEngine getHttpEngine() {
        return this.httpEngine;
    }

    private Retry processResponseHeaders() throws IOException {
        Proxy selectedProxy = this.httpEngine.connection != null ? this.httpEngine.connection.getRoute().getProxy() : this.client.getProxy();
        int responseCode = this.getResponseCode();
        switch (responseCode) {
            case 407: {
                if (selectedProxy.type() != Proxy.Type.HTTP) {
                    throw new ProtocolException("Received HTTP_PROXY_AUTH (407) code while not using proxy");
                }
            }
            case 401: {
                boolean credentialsFound = HttpAuthenticator.processAuthHeader(this.client.getAuthenticator(), this.getResponseCode(), this.httpEngine.getResponseHeaders().getHeaders(), this.rawRequestHeaders, selectedProxy, this.url);
                return credentialsFound ? Retry.SAME_CONNECTION : Retry.NONE;
            }
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                boolean samePort;
                if (!this.getInstanceFollowRedirects()) {
                    return Retry.NONE;
                }
                if (++this.redirectionCount > 20) {
                    throw new ProtocolException("Too many redirects: " + this.redirectionCount);
                }
                if (responseCode == 307 && !this.method.equals("GET") && !this.method.equals("HEAD")) {
                    return Retry.NONE;
                }
                String location = this.getHeaderField("Location");
                if (location == null) {
                    return Retry.NONE;
                }
                URL previousUrl = this.url;
                this.url = new URL(previousUrl, location);
                if (!this.url.getProtocol().equals("https") && !this.url.getProtocol().equals("http")) {
                    return Retry.NONE;
                }
                boolean sameProtocol = previousUrl.getProtocol().equals(this.url.getProtocol());
                if (!sameProtocol && !this.client.getFollowProtocolRedirects()) {
                    return Retry.NONE;
                }
                boolean sameHost = previousUrl.getHost().equals(this.url.getHost());
                boolean bl = samePort = Util.getEffectivePort(previousUrl) == Util.getEffectivePort(this.url);
                if (sameHost && samePort && sameProtocol) {
                    return Retry.SAME_CONNECTION;
                }
                return Retry.DIFFERENT_CONNECTION;
            }
        }
        return Retry.NONE;
    }

    @Override
    public final long getFixedContentLength() {
        return this.fixedContentLength;
    }

    @Override
    public final int getChunkLength() {
        return this.chunkLength;
    }

    @Override
    public final boolean usingProxy() {
        if (this.selectedProxy != null) {
            return HttpURLConnectionImpl.isValidNonDirectProxy(this.selectedProxy);
        }
        return HttpURLConnectionImpl.isValidNonDirectProxy(this.client.getProxy());
    }

    private static final boolean isValidNonDirectProxy(Proxy proxy) {
        return proxy != null && proxy.type() != Proxy.Type.DIRECT;
    }

    @Override
    public String getResponseMessage() throws IOException {
        return this.getResponse().getResponseHeaders().getHeaders().getResponseMessage();
    }

    @Override
    public final int getResponseCode() throws IOException {
        return this.getResponse().getResponseCode();
    }

    @Override
    public final void setRequestProperty(String field, String newValue) {
        if (this.connected) {
            throw new IllegalStateException("Cannot set request property after connection is made");
        }
        if (field == null) {
            throw new NullPointerException("field == null");
        }
        if (newValue == null) {
            Platform.get().logW("Ignoring header " + field + " because its value was null.");
            return;
        }
        if ("X-Android-Transports".equals(field)) {
            this.setTransports(newValue, false);
        } else {
            this.rawRequestHeaders.set(field, newValue);
        }
    }

    @Override
    public final void addRequestProperty(String field, String value) {
        if (this.connected) {
            throw new IllegalStateException("Cannot add request property after connection is made");
        }
        if (field == null) {
            throw new NullPointerException("field == null");
        }
        if (value == null) {
            Platform.get().logW("Ignoring header " + field + " because its value was null.");
            return;
        }
        if ("X-Android-Transports".equals(field)) {
            this.setTransports(value, true);
        } else {
            this.rawRequestHeaders.add(field, value);
        }
    }

    private void setTransports(String transportsString, boolean append) {
        ArrayList<String> transportsList = new ArrayList<String>();
        if (append) {
            transportsList.addAll(this.client.getTransports());
        }
        for (String transport : transportsString.split(",", -1)) {
            transportsList.add(transport);
        }
        this.client.setTransports(transportsList);
    }

    @Override
    public void setFixedLengthStreamingMode(int contentLength) {
        this.setFixedLengthStreamingMode((long)contentLength);
    }

    @Override
    public void setFixedLengthStreamingMode(long contentLength) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (this.chunkLength > 0) {
            throw new IllegalStateException("Already in chunked mode");
        }
        if (contentLength < 0L) {
            throw new IllegalArgumentException("contentLength < 0");
        }
        this.fixedContentLength = contentLength;
        ((HttpURLConnection)this).fixedContentLength = (int)Math.min(contentLength, Integer.MAX_VALUE);
    }

    @Override
    public final void setSelectedProxy(Proxy proxy) {
        this.selectedProxy = proxy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Retry {
        NONE,
        SAME_CONNECTION,
        DIFFERENT_CONNECTION;

    }
}

