/*
 * Decompiled with CFR 0.152.
 */
package com.android.okhttp.internal.http;

import com.android.okhttp.OkAuthenticator;
import com.android.okhttp.internal.http.HeaderParser;
import com.android.okhttp.internal.http.RawHeaders;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpAuthenticator {
    public static final OkAuthenticator SYSTEM_DEFAULT = new OkAuthenticator(){

        @Override
        public OkAuthenticator.Credential authenticate(Proxy proxy, URL url, List<OkAuthenticator.Challenge> challenges) throws IOException {
            for (OkAuthenticator.Challenge challenge : challenges) {
                PasswordAuthentication auth;
                if (!"Basic".equals(challenge.getScheme()) || (auth = Authenticator.requestPasswordAuthentication(url.getHost(), this.getConnectToInetAddress(proxy, url), url.getPort(), url.getProtocol(), challenge.getRealm(), challenge.getScheme(), url, Authenticator.RequestorType.SERVER)) == null) continue;
                return OkAuthenticator.Credential.basic(auth.getUserName(), new String(auth.getPassword()));
            }
            return null;
        }

        @Override
        public OkAuthenticator.Credential authenticateProxy(Proxy proxy, URL url, List<OkAuthenticator.Challenge> challenges) throws IOException {
            for (OkAuthenticator.Challenge challenge : challenges) {
                InetSocketAddress proxyAddress;
                PasswordAuthentication auth;
                if (!"Basic".equals(challenge.getScheme()) || (auth = Authenticator.requestPasswordAuthentication((proxyAddress = (InetSocketAddress)proxy.address()).getHostName(), this.getConnectToInetAddress(proxy, url), proxyAddress.getPort(), url.getProtocol(), challenge.getRealm(), challenge.getScheme(), url, Authenticator.RequestorType.PROXY)) == null) continue;
                return OkAuthenticator.Credential.basic(auth.getUserName(), new String(auth.getPassword()));
            }
            return null;
        }

        private InetAddress getConnectToInetAddress(Proxy proxy, URL url) throws IOException {
            return proxy != null && proxy.type() != Proxy.Type.DIRECT ? ((InetSocketAddress)proxy.address()).getAddress() : InetAddress.getByName(url.getHost());
        }
    };

    private HttpAuthenticator() {
    }

    public static boolean processAuthHeader(OkAuthenticator authenticator, int responseCode, RawHeaders responseHeaders, RawHeaders successorRequestHeaders, Proxy proxy, URL url) throws IOException {
        OkAuthenticator.Credential credential;
        String requestField;
        String responseField;
        if (responseCode == 401) {
            responseField = "WWW-Authenticate";
            requestField = "Authorization";
        } else if (responseCode == 407) {
            responseField = "Proxy-Authenticate";
            requestField = "Proxy-Authorization";
        } else {
            throw new IllegalArgumentException();
        }
        List<OkAuthenticator.Challenge> challenges = HttpAuthenticator.parseChallenges(responseHeaders, responseField);
        if (challenges.isEmpty()) {
            return false;
        }
        OkAuthenticator.Credential credential2 = credential = responseHeaders.getResponseCode() == 407 ? authenticator.authenticateProxy(proxy, url, challenges) : authenticator.authenticate(proxy, url, challenges);
        if (credential == null) {
            return false;
        }
        successorRequestHeaders.set(requestField, credential.getHeaderValue());
        return true;
    }

    private static List<OkAuthenticator.Challenge> parseChallenges(RawHeaders responseHeaders, String challengeHeader) {
        ArrayList<OkAuthenticator.Challenge> result = new ArrayList<OkAuthenticator.Challenge>();
        block0: for (int h = 0; h < responseHeaders.length(); ++h) {
            if (!challengeHeader.equalsIgnoreCase(responseHeaders.getFieldName(h))) continue;
            String value = responseHeaders.getValue(h);
            int pos = 0;
            while (pos < value.length()) {
                int tokenStart = pos;
                pos = HeaderParser.skipUntil(value, pos, " ");
                String scheme = value.substring(tokenStart, pos).trim();
                if (!value.regionMatches(pos = HeaderParser.skipWhitespace(value, pos), "realm=\"", 0, "realm=\"".length())) continue block0;
                int realmStart = pos += "realm=\"".length();
                pos = HeaderParser.skipUntil(value, pos, "\"");
                String realm = value.substring(realmStart, pos);
                ++pos;
                pos = HeaderParser.skipUntil(value, pos, ",");
                ++pos;
                pos = HeaderParser.skipWhitespace(value, pos);
                result.add(new OkAuthenticator.Challenge(scheme, realm));
            }
        }
        return result;
    }
}

