/*
 * Decompiled with CFR 0.152.
 */
package com.android.okhttp.internal;

import com.android.org.conscrypt.OpenSSLSocketImpl;
import dalvik.system.SocketTagger;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.net.ssl.SSLSocket;

public final class Platform {
    private static final Platform PLATFORM = new Platform();
    private static final int DEFAULT_MTU = 1400;

    public static Platform get() {
        return PLATFORM;
    }

    public void logW(String warning) {
        System.logW((String)warning);
    }

    public void tagSocket(Socket socket) throws SocketException {
        SocketTagger.get().tag(socket);
    }

    public void untagSocket(Socket socket) throws SocketException {
        SocketTagger.get().untag(socket);
    }

    public URI toUriLenient(URL url) throws URISyntaxException {
        return url.toURILenient();
    }

    public void enableTlsExtensions(SSLSocket socket, String uriHost) {
        if (socket instanceof OpenSSLSocketImpl) {
            OpenSSLSocketImpl openSSLSocket = (OpenSSLSocketImpl)socket;
            openSSLSocket.setUseSessionTickets(true);
            openSSLSocket.setHostname(uriHost);
        }
    }

    public void supportTlsIntolerantServer(SSLSocket socket) {
        socket.setEnabledProtocols(new String[]{"SSLv3"});
    }

    public byte[] getNpnSelectedProtocol(SSLSocket socket) {
        return socket instanceof OpenSSLSocketImpl ? ((OpenSSLSocketImpl)socket).getNpnSelectedProtocol() : null;
    }

    public void setNpnProtocols(SSLSocket socket, byte[] npnProtocols) {
        if (socket instanceof OpenSSLSocketImpl) {
            ((OpenSSLSocketImpl)socket).setNpnProtocols(npnProtocols);
        }
    }

    public OutputStream newDeflaterOutputStream(OutputStream out, Deflater deflater, boolean syncFlush) {
        return new DeflaterOutputStream(out, deflater, syncFlush);
    }

    public int getMtu(Socket socket) {
        try {
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(socket.getLocalAddress());
            if (networkInterface != null) {
                return networkInterface.getMTU();
            }
            return 1400;
        }
        catch (SocketException exception) {
            return 1400;
        }
    }

    public void connectSocket(Socket socket, InetSocketAddress address, int connectTimeout) throws IOException {
        socket.connect(address, connectTimeout);
    }

    public String getPrefix() {
        return "X-Android";
    }
}

