/*
 * Decompiled with CFR 0.152.
 */
package com.android.okhttp;

import com.android.okhttp.Address;
import com.android.okhttp.Connection;
import com.android.okhttp.internal.Platform;
import com.android.okhttp.internal.Util;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionPool {
    private static final int MAX_CONNECTIONS_TO_CLEANUP = 2;
    private static final long DEFAULT_KEEP_ALIVE_DURATION_MS = 300000L;
    private static final ConnectionPool systemDefault;
    private final int maxIdleConnections;
    private final long keepAliveDurationNs;
    private final LinkedList<Connection> connections = new LinkedList();
    private final ExecutorService executorService = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Util.daemonThreadFactory("OkHttp ConnectionPool"));
    private final Callable<Void> connectionsCleanupCallable = new Callable<Void>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            ArrayList<Connection> expiredConnections = new ArrayList<Connection>(2);
            int idleConnectionCount = 0;
            ConnectionPool connectionPool = ConnectionPool.this;
            synchronized (connectionPool) {
                Connection connection;
                ListIterator i = ConnectionPool.this.connections.listIterator(ConnectionPool.this.connections.size());
                while (i.hasPrevious()) {
                    connection = (Connection)i.previous();
                    if (!connection.isAlive() || connection.isExpired(ConnectionPool.this.keepAliveDurationNs)) {
                        i.remove();
                        expiredConnections.add(connection);
                        if (expiredConnections.size() != 2) continue;
                        break;
                    }
                    if (!connection.isIdle()) continue;
                    ++idleConnectionCount;
                }
                i = ConnectionPool.this.connections.listIterator(ConnectionPool.this.connections.size());
                while (i.hasPrevious() && idleConnectionCount > ConnectionPool.this.maxIdleConnections) {
                    connection = (Connection)i.previous();
                    if (!connection.isIdle()) continue;
                    expiredConnections.add(connection);
                    i.remove();
                    --idleConnectionCount;
                }
            }
            for (Connection expiredConnection : expiredConnections) {
                Util.closeQuietly(expiredConnection);
            }
            return null;
        }
    };

    public ConnectionPool(int maxIdleConnections, long keepAliveDurationMs) {
        this.maxIdleConnections = maxIdleConnections;
        this.keepAliveDurationNs = keepAliveDurationMs * 1000L * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Connection> getConnections() {
        this.waitForCleanupCallableToRun();
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            return new ArrayList<Connection>(this.connections);
        }
    }

    private void waitForCleanupCallableToRun() {
        try {
            this.executorService.submit(new Runnable(){

                public void run() {
                }
            }).get();
        }
        catch (Exception e) {
            throw new AssertionError();
        }
    }

    public static ConnectionPool getDefault() {
        return systemDefault;
    }

    public synchronized int getConnectionCount() {
        return this.connections.size();
    }

    public synchronized int getSpdyConnectionCount() {
        int total = 0;
        for (Connection connection : this.connections) {
            if (!connection.isSpdy()) continue;
            ++total;
        }
        return total;
    }

    public synchronized int getHttpConnectionCount() {
        int total = 0;
        for (Connection connection : this.connections) {
            if (connection.isSpdy()) continue;
            ++total;
        }
        return total;
    }

    public synchronized Connection get(Address address) {
        Connection foundConnection = null;
        ListIterator<Connection> i = this.connections.listIterator(this.connections.size());
        while (i.hasPrevious()) {
            Connection connection = i.previous();
            if (!connection.getRoute().getAddress().equals(address) || !connection.isAlive() || System.nanoTime() - connection.getIdleStartTimeNs() >= this.keepAliveDurationNs) continue;
            i.remove();
            if (!connection.isSpdy()) {
                try {
                    Platform.get().tagSocket(connection.getSocket());
                }
                catch (SocketException e) {
                    Util.closeQuietly(connection);
                    Platform.get().logW("Unable to tagSocket(): " + e);
                    continue;
                }
            }
            foundConnection = connection;
            break;
        }
        if (foundConnection != null && foundConnection.isSpdy()) {
            this.connections.addFirst(foundConnection);
        }
        this.executorService.submit(this.connectionsCleanupCallable);
        return foundConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle(Connection connection) {
        if (connection.isSpdy()) {
            return;
        }
        if (!connection.isAlive()) {
            Util.closeQuietly(connection);
            return;
        }
        try {
            Platform.get().untagSocket(connection.getSocket());
        }
        catch (SocketException e) {
            Platform.get().logW("Unable to untagSocket(): " + e);
            Util.closeQuietly(connection);
            return;
        }
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            this.connections.addFirst(connection);
            connection.resetIdleStartTime();
        }
        this.executorService.submit(this.connectionsCleanupCallable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeShare(Connection connection) {
        this.executorService.submit(this.connectionsCleanupCallable);
        if (!connection.isSpdy()) {
            return;
        }
        if (connection.isAlive()) {
            ConnectionPool connectionPool = this;
            synchronized (connectionPool) {
                this.connections.addFirst(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictAll() {
        ArrayList<Connection> connections;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            connections = new ArrayList<Connection>(this.connections);
            this.connections.clear();
        }
        for (Connection connection : connections) {
            Util.closeQuietly(connection);
        }
    }

    static {
        long keepAliveDurationMs;
        String keepAlive = System.getProperty("http.keepAlive");
        String keepAliveDuration = System.getProperty("http.keepAliveDuration");
        String maxIdleConnections = System.getProperty("http.maxConnections");
        long l = keepAliveDurationMs = keepAliveDuration != null ? Long.parseLong(keepAliveDuration) : 300000L;
        systemDefault = keepAlive != null && !Boolean.parseBoolean(keepAlive) ? new ConnectionPool(0, keepAliveDurationMs) : (maxIdleConnections != null ? new ConnectionPool(Integer.parseInt(maxIdleConnections), keepAliveDurationMs) : new ConnectionPool(5, keepAliveDurationMs));
    }
}

