/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.app.ActionBarImpl;
import com.android.internal.widget.ActionBarContainer;
import com.android.internal.widget.ActionBarView;

public class ActionBarOverlayLayout
extends ViewGroup {
    private static final String TAG = "ActionBarOverlayLayout";
    private int mActionBarHeight;
    private ActionBarImpl mActionBar;
    private int mWindowVisibility = 0;
    private View mContent;
    private View mActionBarBottom;
    private ActionBarContainer mActionBarTop;
    private ActionBarView mActionBarView;
    private Drawable mWindowContentOverlay;
    private boolean mIgnoreWindowContentOverlay;
    private boolean mOverlayMode;
    private int mLastSystemUiVisibility;
    private final Rect mBaseContentInsets = new Rect();
    private final Rect mLastBaseContentInsets = new Rect();
    private final Rect mContentInsets = new Rect();
    private final Rect mBaseInnerInsets = new Rect();
    private final Rect mInnerInsets = new Rect();
    private final Rect mLastInnerInsets = new Rect();
    static final int[] ATTRS = new int[]{16843499, 16842841};

    public ActionBarOverlayLayout(Context context) {
        super(context);
        this.init(context);
    }

    public ActionBarOverlayLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        TypedArray ta = this.getContext().getTheme().obtainStyledAttributes(ATTRS);
        this.mActionBarHeight = ta.getDimensionPixelSize(0, 0);
        this.mWindowContentOverlay = ta.getDrawable(1);
        this.setWillNotDraw(this.mWindowContentOverlay == null);
        ta.recycle();
        this.mIgnoreWindowContentOverlay = context.getApplicationInfo().targetSdkVersion < 19;
    }

    public void setActionBar(ActionBarImpl impl) {
        this.mActionBar = impl;
        if (this.getWindowToken() != null) {
            this.mActionBar.setWindowVisibility(this.mWindowVisibility);
            if (this.mLastSystemUiVisibility != 0) {
                int newVis = this.mLastSystemUiVisibility;
                this.onWindowSystemUiVisibilityChanged(newVis);
                this.requestFitSystemWindows();
            }
        }
    }

    public void setOverlayMode(boolean overlayMode) {
        this.mOverlayMode = overlayMode;
        this.mIgnoreWindowContentOverlay = overlayMode && this.getContext().getApplicationInfo().targetSdkVersion < 19;
    }

    public void setShowingForActionMode(boolean showing) {
        if (showing) {
            if ((this.getWindowSystemUiVisibility() & 0x500) == 1280) {
                this.setDisabledSystemUiVisibility(4);
            }
        } else {
            this.setDisabledSystemUiVisibility(0);
        }
    }

    public void onWindowSystemUiVisibilityChanged(int visible) {
        boolean stable;
        super.onWindowSystemUiVisibilityChanged(visible);
        this.pullChildren();
        int diff = this.mLastSystemUiVisibility ^ visible;
        this.mLastSystemUiVisibility = visible;
        boolean barVisible = (visible & 4) == 0;
        boolean wasVisible = this.mActionBar != null ? this.mActionBar.isSystemShowing() : true;
        boolean bl = stable = (visible & 0x100) != 0;
        if (this.mActionBar != null) {
            this.mActionBar.enableContentAnimations(!stable);
            if (barVisible || !stable) {
                this.mActionBar.showForSystem();
            } else {
                this.mActionBar.hideForSystem();
            }
        }
        if ((diff & 0x100) != 0 && this.mActionBar != null) {
            this.requestFitSystemWindows();
        }
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.mWindowVisibility = visibility;
        if (this.mActionBar != null) {
            this.mActionBar.setWindowVisibility(visibility);
        }
    }

    private boolean applyInsets(View view, Rect insets, boolean left, boolean top, boolean bottom, boolean right) {
        boolean changed = false;
        LayoutParams lp = (LayoutParams)view.getLayoutParams();
        if (left && lp.leftMargin != insets.left) {
            changed = true;
            lp.leftMargin = insets.left;
        }
        if (top && lp.topMargin != insets.top) {
            changed = true;
            lp.topMargin = insets.top;
        }
        if (right && lp.rightMargin != insets.right) {
            changed = true;
            lp.rightMargin = insets.right;
        }
        if (bottom && lp.bottomMargin != insets.bottom) {
            changed = true;
            lp.bottomMargin = insets.bottom;
        }
        return changed;
    }

    protected boolean fitSystemWindows(Rect insets) {
        this.pullChildren();
        int vis = this.getWindowSystemUiVisibility();
        boolean stable = (vis & 0x100) != 0;
        boolean changed = this.applyInsets(this.mActionBarTop, insets, true, true, false, true);
        if (this.mActionBarBottom != null) {
            changed |= this.applyInsets(this.mActionBarBottom, insets, true, false, true, true);
        }
        this.mBaseInnerInsets.set(insets);
        this.computeFitSystemWindows(this.mBaseInnerInsets, this.mBaseContentInsets);
        if (!this.mLastBaseContentInsets.equals(this.mBaseContentInsets)) {
            changed = true;
            this.mLastBaseContentInsets.set(this.mBaseContentInsets);
        }
        if (changed) {
            this.requestLayout();
        }
        return true;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int vis;
        boolean stable;
        this.pullChildren();
        int maxHeight = 0;
        int maxWidth = 0;
        int childState = 0;
        int topInset = 0;
        int bottomInset = 0;
        this.measureChildWithMargins(this.mActionBarTop, widthMeasureSpec, 0, heightMeasureSpec, 0);
        LayoutParams lp = (LayoutParams)this.mActionBarTop.getLayoutParams();
        maxWidth = Math.max(maxWidth, this.mActionBarTop.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
        maxHeight = Math.max(maxHeight, this.mActionBarTop.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
        childState = ActionBarOverlayLayout.combineMeasuredStates(childState, this.mActionBarTop.getMeasuredState());
        if (this.mActionBarBottom != null) {
            this.measureChildWithMargins(this.mActionBarBottom, widthMeasureSpec, 0, heightMeasureSpec, 0);
            lp = (LayoutParams)this.mActionBarBottom.getLayoutParams();
            maxWidth = Math.max(maxWidth, this.mActionBarBottom.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
            maxHeight = Math.max(maxHeight, this.mActionBarBottom.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
            childState = ActionBarOverlayLayout.combineMeasuredStates(childState, this.mActionBarBottom.getMeasuredState());
        }
        boolean bl = stable = ((vis = this.getWindowSystemUiVisibility()) & 0x100) != 0;
        if (stable) {
            View tabs;
            topInset = this.mActionBarHeight;
            if (this.mActionBar != null && this.mActionBar.hasNonEmbeddedTabs() && (tabs = this.mActionBarTop.getTabContainer()) != null) {
                topInset += this.mActionBarHeight;
            }
        } else if (this.mActionBarTop.getVisibility() == 0) {
            topInset = this.mActionBarTop.getMeasuredHeight();
        }
        if (this.mActionBarView.isSplitActionBar() && this.mActionBarBottom != null) {
            bottomInset = stable ? this.mActionBarHeight : this.mActionBarBottom.getMeasuredHeight();
        }
        this.mContentInsets.set(this.mBaseContentInsets);
        this.mInnerInsets.set(this.mBaseInnerInsets);
        if (!this.mOverlayMode && !stable) {
            this.mContentInsets.top += topInset;
            this.mContentInsets.bottom += bottomInset;
        } else {
            this.mInnerInsets.top += topInset;
            this.mInnerInsets.bottom += bottomInset;
        }
        this.applyInsets(this.mContent, this.mContentInsets, true, true, true, true);
        if (!this.mLastInnerInsets.equals(this.mInnerInsets)) {
            this.mLastInnerInsets.set(this.mInnerInsets);
            super.fitSystemWindows(this.mInnerInsets);
        }
        this.measureChildWithMargins(this.mContent, widthMeasureSpec, 0, heightMeasureSpec, 0);
        lp = (LayoutParams)this.mContent.getLayoutParams();
        maxWidth = Math.max(maxWidth, this.mContent.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
        maxHeight = Math.max(maxHeight, this.mContent.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
        childState = ActionBarOverlayLayout.combineMeasuredStates(childState, this.mContent.getMeasuredState());
        maxWidth += this.getPaddingLeft() + this.getPaddingRight();
        maxHeight += this.getPaddingTop() + this.getPaddingBottom();
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(ActionBarOverlayLayout.resolveSizeAndState(maxWidth, widthMeasureSpec, childState), ActionBarOverlayLayout.resolveSizeAndState(maxHeight, heightMeasureSpec, childState << 16));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int count = this.getChildCount();
        int parentLeft = this.getPaddingLeft();
        int parentRight = right - left - this.getPaddingRight();
        int parentTop = this.getPaddingTop();
        int parentBottom = bottom - top - this.getPaddingBottom();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            int childLeft = parentLeft + lp.leftMargin;
            int childTop = child == this.mActionBarBottom ? parentBottom - height - lp.bottomMargin : parentTop + lp.topMargin;
            child.layout(childLeft, childTop, childLeft + width, childTop + height);
        }
    }

    public void draw(Canvas c) {
        super.draw(c);
        if (this.mWindowContentOverlay != null && !this.mIgnoreWindowContentOverlay) {
            int top = this.mActionBarTop.getVisibility() == 0 ? (int)((float)this.mActionBarTop.getBottom() + this.mActionBarTop.getTranslationY() + 0.5f) : 0;
            this.mWindowContentOverlay.setBounds(0, top, this.getWidth(), top + this.mWindowContentOverlay.getIntrinsicHeight());
            this.mWindowContentOverlay.draw(c);
        }
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    void pullChildren() {
        if (this.mContent == null) {
            this.mContent = this.findViewById(0x1020002);
            this.mActionBarTop = (ActionBarContainer)this.findViewById(16909073);
            this.mActionBarView = (ActionBarView)this.findViewById(16909074);
            this.mActionBarBottom = this.findViewById(16909076);
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }
    }
}

