/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.sip;

import android.os.SystemClock;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.UUSInfo;

abstract class SipConnectionBase
extends Connection {
    private static final String LOG_TAG = "SipConnBase";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private String mPostDialString;
    private int mNextPostDialChar;
    private long mCreateTime;
    private long mConnectTime;
    private long mDisconnectTime;
    private long mConnectTimeReal;
    private long mDuration = -1L;
    private long mHoldingStartTime;
    private Connection.DisconnectCause mCause = Connection.DisconnectCause.NOT_DISCONNECTED;
    private Connection.PostDialState mPostDialState = Connection.PostDialState.NOT_STARTED;

    SipConnectionBase(String dialString) {
        this.log("SipConnectionBase: ctor dialString=" + dialString);
        this.mPostDialString = PhoneNumberUtils.extractPostDialPortion(dialString);
        this.mCreateTime = System.currentTimeMillis();
    }

    protected void setState(Call.State state) {
        this.log("setState: state=" + (Object)((Object)state));
        switch (state) {
            case ACTIVE: {
                if (this.mConnectTime != 0L) break;
                this.mConnectTimeReal = SystemClock.elapsedRealtime();
                this.mConnectTime = System.currentTimeMillis();
                break;
            }
            case DISCONNECTED: {
                this.mDuration = this.getDurationMillis();
                this.mDisconnectTime = System.currentTimeMillis();
                break;
            }
            case HOLDING: {
                this.mHoldingStartTime = SystemClock.elapsedRealtime();
                break;
            }
        }
    }

    public long getCreateTime() {
        return this.mCreateTime;
    }

    public long getConnectTime() {
        return this.mConnectTime;
    }

    public long getDisconnectTime() {
        return this.mDisconnectTime;
    }

    public long getDurationMillis() {
        long dur = this.mConnectTimeReal == 0L ? 0L : (this.mDuration < 0L ? SystemClock.elapsedRealtime() - this.mConnectTimeReal : this.mDuration);
        return dur;
    }

    public long getHoldDurationMillis() {
        long dur = this.getState() != Call.State.HOLDING ? 0L : SystemClock.elapsedRealtime() - this.mHoldingStartTime;
        return dur;
    }

    public Connection.DisconnectCause getDisconnectCause() {
        return this.mCause;
    }

    void setDisconnectCause(Connection.DisconnectCause cause) {
        this.log("setDisconnectCause: prev=" + (Object)((Object)this.mCause) + " new=" + (Object)((Object)cause));
        this.mCause = cause;
    }

    public Connection.PostDialState getPostDialState() {
        return this.mPostDialState;
    }

    public void proceedAfterWaitChar() {
        this.log("proceedAfterWaitChar: ignore");
    }

    public void proceedAfterWildChar(String str) {
        this.log("proceedAfterWildChar: ignore");
    }

    public void cancelPostDial() {
        this.log("cancelPostDial: ignore");
    }

    protected abstract Phone getPhone();

    public String getRemainingPostDialString() {
        if (this.mPostDialState == Connection.PostDialState.CANCELLED || this.mPostDialState == Connection.PostDialState.COMPLETE || this.mPostDialString == null || this.mPostDialString.length() <= this.mNextPostDialChar) {
            this.log("getRemaingPostDialString: ret empty string");
            return "";
        }
        return this.mPostDialString.substring(this.mNextPostDialChar);
    }

    private void log(String msg) {
        Rlog.d(LOG_TAG, msg);
    }

    public int getNumberPresentation() {
        return PhoneConstants.PRESENTATION_ALLOWED;
    }

    public UUSInfo getUUSInfo() {
        return null;
    }
}

