/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.gsm.GsmCallTracker;
import com.android.internal.telephony.gsm.GsmConnection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GsmCall
extends Call {
    GsmCallTracker mOwner;

    static Call.State stateFromDCState(DriverCall.State dcState) {
        switch (dcState) {
            case ACTIVE: {
                return Call.State.ACTIVE;
            }
            case HOLDING: {
                return Call.State.HOLDING;
            }
            case DIALING: {
                return Call.State.DIALING;
            }
            case ALERTING: {
                return Call.State.ALERTING;
            }
            case INCOMING: {
                return Call.State.INCOMING;
            }
            case WAITING: {
                return Call.State.WAITING;
            }
        }
        throw new RuntimeException("illegal call state:" + (Object)((Object)dcState));
    }

    GsmCall(GsmCallTracker owner) {
        this.mOwner = owner;
    }

    public void dispose() {
    }

    @Override
    public List<Connection> getConnections() {
        return this.mConnections;
    }

    @Override
    public Phone getPhone() {
        return this.mOwner.mPhone;
    }

    @Override
    public boolean isMultiparty() {
        return this.mConnections.size() > 1;
    }

    @Override
    public void hangup() throws CallStateException {
        this.mOwner.hangup(this);
    }

    public String toString() {
        return this.mState.toString();
    }

    void attach(Connection conn, DriverCall dc) {
        this.mConnections.add(conn);
        this.mState = GsmCall.stateFromDCState(dc.state);
    }

    void attachFake(Connection conn, Call.State state) {
        this.mConnections.add(conn);
        this.mState = state;
    }

    boolean connectionDisconnected(GsmConnection conn) {
        if (this.mState != Call.State.DISCONNECTED) {
            boolean hasOnlyDisconnectedConnections = true;
            int s = this.mConnections.size();
            for (int i = 0; i < s; ++i) {
                if (((Connection)this.mConnections.get(i)).getState() == Call.State.DISCONNECTED) continue;
                hasOnlyDisconnectedConnections = false;
                break;
            }
            if (hasOnlyDisconnectedConnections) {
                this.mState = Call.State.DISCONNECTED;
                return true;
            }
        }
        return false;
    }

    void detach(GsmConnection conn) {
        this.mConnections.remove(conn);
        if (this.mConnections.size() == 0) {
            this.mState = Call.State.IDLE;
        }
    }

    boolean update(GsmConnection conn, DriverCall dc) {
        boolean changed = false;
        Call.State newState = GsmCall.stateFromDCState(dc.state);
        if (newState != this.mState) {
            this.mState = newState;
            changed = true;
        }
        return changed;
    }

    boolean isFull() {
        return this.mConnections.size() == 5;
    }

    void onHangupLocal() {
        int s = this.mConnections.size();
        for (int i = 0; i < s; ++i) {
            GsmConnection cn = (GsmConnection)this.mConnections.get(i);
            cn.onHangupLocal();
        }
        this.mState = Call.State.DISCONNECTING;
    }

    void clearDisconnected() {
        for (int i = this.mConnections.size() - 1; i >= 0; --i) {
            GsmConnection cn = (GsmConnection)this.mConnections.get(i);
            if (cn.getState() != Call.State.DISCONNECTED) continue;
            this.mConnections.remove(i);
        }
        if (this.mConnections.size() == 0) {
            this.mState = Call.State.IDLE;
        }
    }
}

