/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.NetworkUtils;
import android.net.RouteInfo;
import android.os.SystemProperties;
import android.telephony.Rlog;
import com.android.internal.telephony.dataconnection.DcFailCause;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class DataCallResponse {
    private final boolean DBG = true;
    private final String LOG_TAG = "DataCallResponse";
    public int version = 0;
    public int status = 0;
    public int cid = 0;
    public int active = 0;
    public String type = "";
    public String ifname = "";
    public String[] addresses = new String[0];
    public String[] dnses = new String[0];
    public String[] gateways = new String[0];
    public int suggestedRetryTime = -1;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("DataCallResponse: {").append("version=").append(this.version).append(" status=").append(this.status).append(" retry=").append(this.suggestedRetryTime).append(" cid=").append(this.cid).append(" active=").append(this.active).append(" type=").append(this.type).append("' ifname='").append(this.ifname);
        sb.append("' addresses=[");
        for (String addr : this.addresses) {
            sb.append(addr);
            sb.append(",");
        }
        if (this.addresses.length > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("] dnses=[");
        for (String addr : this.dnses) {
            sb.append(addr);
            sb.append(",");
        }
        if (this.dnses.length > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("] gateways=[");
        for (String addr : this.gateways) {
            sb.append(addr);
            sb.append(",");
        }
        if (this.gateways.length > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]}");
        return sb.toString();
    }

    public SetupResult setLinkProperties(LinkProperties linkProperties, boolean okToUseSystemPropertyDns) {
        SetupResult result;
        if (linkProperties == null) {
            linkProperties = new LinkProperties();
        } else {
            linkProperties.clear();
        }
        if (this.status == DcFailCause.NONE.getErrorCode()) {
            String propertyPrefix = "net." + this.ifname + ".";
            try {
                InetAddress ia;
                linkProperties.setInterfaceName(this.ifname);
                if (this.addresses != null && this.addresses.length > 0) {
                    for (String addr : this.addresses) {
                        InetAddress ia2;
                        int addrPrefixLen;
                        if ((addr = addr.trim()).isEmpty()) continue;
                        String[] ap = addr.split("/");
                        if (ap.length == 2) {
                            addr = ap[0];
                            addrPrefixLen = Integer.parseInt(ap[1]);
                        } else {
                            addrPrefixLen = 0;
                        }
                        try {
                            ia2 = NetworkUtils.numericToInetAddress(addr);
                        }
                        catch (IllegalArgumentException e) {
                            throw new UnknownHostException("Non-numeric ip addr=" + addr);
                        }
                        if (ia2.isAnyLocalAddress()) continue;
                        if (addrPrefixLen == 0) {
                            addrPrefixLen = ia2 instanceof Inet4Address ? 32 : 128;
                        }
                        Rlog.d("DataCallResponse", "addr/pl=" + addr + "/" + addrPrefixLen);
                        LinkAddress la = new LinkAddress(ia2, addrPrefixLen);
                        linkProperties.addLinkAddress(la);
                    }
                } else {
                    throw new UnknownHostException("no address for ifname=" + this.ifname);
                }
                if (this.dnses != null && this.dnses.length > 0) {
                    for (String addr : this.dnses) {
                        if ((addr = addr.trim()).isEmpty()) continue;
                        try {
                            ia = NetworkUtils.numericToInetAddress(addr);
                        }
                        catch (IllegalArgumentException e) {
                            throw new UnknownHostException("Non-numeric dns addr=" + addr);
                        }
                        if (ia.isAnyLocalAddress()) continue;
                        linkProperties.addDns(ia);
                    }
                } else if (okToUseSystemPropertyDns) {
                    String[] dnsServers = new String[]{SystemProperties.get(propertyPrefix + "dns1"), SystemProperties.get(propertyPrefix + "dns2")};
                    for (String dnsAddr : dnsServers) {
                        InetAddress ia3;
                        if ((dnsAddr = dnsAddr.trim()).isEmpty()) continue;
                        try {
                            ia3 = NetworkUtils.numericToInetAddress(dnsAddr);
                        }
                        catch (IllegalArgumentException e) {
                            throw new UnknownHostException("Non-numeric dns addr=" + dnsAddr);
                        }
                        if (ia3.isAnyLocalAddress()) continue;
                        linkProperties.addDns(ia3);
                    }
                } else {
                    throw new UnknownHostException("Empty dns response and no system default dns");
                }
                if (this.gateways == null || this.gateways.length == 0) {
                    String sysGateways = SystemProperties.get(propertyPrefix + "gw");
                    this.gateways = sysGateways != null ? sysGateways.split(" ") : new String[0];
                }
                for (String addr : this.gateways) {
                    if ((addr = addr.trim()).isEmpty()) continue;
                    try {
                        ia = NetworkUtils.numericToInetAddress(addr);
                    }
                    catch (IllegalArgumentException e) {
                        throw new UnknownHostException("Non-numeric gateway addr=" + addr);
                    }
                    linkProperties.addRoute(new RouteInfo(ia));
                }
                result = SetupResult.SUCCESS;
            }
            catch (UnknownHostException e) {
                Rlog.d("DataCallResponse", "setLinkProperties: UnknownHostException " + e);
                e.printStackTrace();
                result = SetupResult.ERR_UnacceptableParameter;
            }
        } else {
            result = this.version < 4 ? SetupResult.ERR_GetLastErrorFromRil : SetupResult.ERR_RilError;
        }
        if (result != SetupResult.SUCCESS) {
            Rlog.d("DataCallResponse", "setLinkProperties: error clearing LinkProperties status=" + this.status + " result=" + (Object)((Object)result));
            linkProperties.clear();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SetupResult {
        SUCCESS,
        ERR_BadCommand,
        ERR_UnacceptableParameter,
        ERR_GetLastErrorFromRil,
        ERR_Stale,
        ERR_RilError;

        public DcFailCause mFailCause = DcFailCause.fromInt(0);

        public String toString() {
            return this.name() + "  SetupResult.mFailCause=" + (Object)((Object)this.mFailCause);
        }
    }
}

