/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cat;

import android.content.res.Resources;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.cat.CatLog;
import com.android.internal.telephony.cat.CommandDetails;
import com.android.internal.telephony.cat.ComprehensionTlv;
import com.android.internal.telephony.cat.DeviceIdentities;
import com.android.internal.telephony.cat.Duration;
import com.android.internal.telephony.cat.FontSize;
import com.android.internal.telephony.cat.IconId;
import com.android.internal.telephony.cat.Item;
import com.android.internal.telephony.cat.ItemsIconId;
import com.android.internal.telephony.cat.ResultCode;
import com.android.internal.telephony.cat.ResultException;
import com.android.internal.telephony.cat.TextAlignment;
import com.android.internal.telephony.cat.TextAttribute;
import com.android.internal.telephony.cat.TextColor;
import com.android.internal.telephony.uicc.IccUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ValueParser {
    ValueParser() {
    }

    static CommandDetails retrieveCommandDetails(ComprehensionTlv ctlv) throws ResultException {
        CommandDetails cmdDet = new CommandDetails();
        byte[] rawValue = ctlv.getRawValue();
        int valueIndex = ctlv.getValueIndex();
        try {
            cmdDet.compRequired = ctlv.isComprehensionRequired();
            cmdDet.commandNumber = rawValue[valueIndex] & 0xFF;
            cmdDet.typeOfCommand = rawValue[valueIndex + 1] & 0xFF;
            cmdDet.commandQualifier = rawValue[valueIndex + 2] & 0xFF;
            return cmdDet;
        }
        catch (IndexOutOfBoundsException e) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        }
    }

    static DeviceIdentities retrieveDeviceIdentities(ComprehensionTlv ctlv) throws ResultException {
        DeviceIdentities devIds = new DeviceIdentities();
        byte[] rawValue = ctlv.getRawValue();
        int valueIndex = ctlv.getValueIndex();
        try {
            devIds.sourceId = rawValue[valueIndex] & 0xFF;
            devIds.destinationId = rawValue[valueIndex + 1] & 0xFF;
            return devIds;
        }
        catch (IndexOutOfBoundsException e) {
            throw new ResultException(ResultCode.REQUIRED_VALUES_MISSING);
        }
    }

    static Duration retrieveDuration(ComprehensionTlv ctlv) throws ResultException {
        int timeInterval = 0;
        Duration.TimeUnit timeUnit = Duration.TimeUnit.SECOND;
        byte[] rawValue = ctlv.getRawValue();
        int valueIndex = ctlv.getValueIndex();
        try {
            timeUnit = Duration.TimeUnit.values()[rawValue[valueIndex] & 0xFF];
            timeInterval = rawValue[valueIndex + 1] & 0xFF;
        }
        catch (IndexOutOfBoundsException e) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        }
        return new Duration(timeInterval, timeUnit);
    }

    static Item retrieveItem(ComprehensionTlv ctlv) throws ResultException {
        Item item = null;
        byte[] rawValue = ctlv.getRawValue();
        int valueIndex = ctlv.getValueIndex();
        int length = ctlv.getLength();
        if (length != 0) {
            int textLen = length - 1;
            try {
                int id2 = rawValue[valueIndex] & 0xFF;
                String text = IccUtils.adnStringFieldToString(rawValue, valueIndex + 1, textLen);
                item = new Item(id2, text);
            }
            catch (IndexOutOfBoundsException e) {
                throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
            }
        }
        return item;
    }

    static int retrieveItemId(ComprehensionTlv ctlv) throws ResultException {
        int id2 = 0;
        byte[] rawValue = ctlv.getRawValue();
        int valueIndex = ctlv.getValueIndex();
        try {
            id2 = rawValue[valueIndex] & 0xFF;
        }
        catch (IndexOutOfBoundsException e) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        }
        return id2;
    }

    static IconId retrieveIconId(ComprehensionTlv ctlv) throws ResultException {
        IconId id2 = new IconId();
        byte[] rawValue = ctlv.getRawValue();
        int valueIndex = ctlv.getValueIndex();
        try {
            id2.selfExplanatory = (rawValue[valueIndex++] & 0xFF) == 0;
            id2.recordNumber = rawValue[valueIndex] & 0xFF;
        }
        catch (IndexOutOfBoundsException e) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        }
        return id2;
    }

    static ItemsIconId retrieveItemsIconId(ComprehensionTlv ctlv) throws ResultException {
        CatLog.d("ValueParser", "retrieveItemsIconId:");
        ItemsIconId id2 = new ItemsIconId();
        byte[] rawValue = ctlv.getRawValue();
        int valueIndex = ctlv.getValueIndex();
        int numOfItems = ctlv.getLength() - 1;
        id2.recordNumbers = new int[numOfItems];
        try {
            id2.selfExplanatory = (rawValue[valueIndex++] & 0xFF) == 0;
            int index = 0;
            while (index < numOfItems) {
                id2.recordNumbers[index++] = rawValue[valueIndex++];
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        }
        return id2;
    }

    static List<TextAttribute> retrieveTextAttribute(ComprehensionTlv ctlv) throws ResultException {
        ArrayList<TextAttribute> lst = new ArrayList<TextAttribute>();
        byte[] rawValue = ctlv.getRawValue();
        int valueIndex = ctlv.getValueIndex();
        int length = ctlv.getLength();
        if (length != 0) {
            int itemCount = length / 4;
            try {
                int i = 0;
                while (i < itemCount) {
                    int start = rawValue[valueIndex] & 0xFF;
                    int textLength = rawValue[valueIndex + 1] & 0xFF;
                    int format = rawValue[valueIndex + 2] & 0xFF;
                    int colorValue = rawValue[valueIndex + 3] & 0xFF;
                    int alignValue = format & 3;
                    TextAlignment align = TextAlignment.fromInt(alignValue);
                    int sizeValue = format >> 2 & 3;
                    FontSize size = FontSize.fromInt(sizeValue);
                    if (size == null) {
                        size = FontSize.NORMAL;
                    }
                    boolean bold = (format & 0x10) != 0;
                    boolean italic = (format & 0x20) != 0;
                    boolean underlined = (format & 0x40) != 0;
                    boolean strikeThrough = (format & 0x80) != 0;
                    TextColor color2 = TextColor.fromInt(colorValue);
                    TextAttribute attr2 = new TextAttribute(start, textLength, align, size, bold, italic, underlined, strikeThrough, color2);
                    lst.add(attr2);
                    ++i;
                    valueIndex += 4;
                }
                return lst;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
            }
        }
        return null;
    }

    static String retrieveAlphaId(ComprehensionTlv ctlv) throws ResultException {
        if (ctlv != null) {
            byte[] rawValue = ctlv.getRawValue();
            int valueIndex = ctlv.getValueIndex();
            int length = ctlv.getLength();
            if (length != 0) {
                try {
                    return IccUtils.adnStringFieldToString(rawValue, valueIndex, length);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
                }
            }
            CatLog.d("ValueParser", "Alpha Id length=" + length);
            return null;
        }
        boolean noAlphaUsrCnf = false;
        Resources resource = Resources.getSystem();
        try {
            noAlphaUsrCnf = resource.getBoolean(17891416);
        }
        catch (Resources.NotFoundException e) {
            noAlphaUsrCnf = false;
        }
        return noAlphaUsrCnf ? null : "Default Message";
    }

    static String retrieveTextString(ComprehensionTlv ctlv) throws ResultException {
        byte[] rawValue = ctlv.getRawValue();
        int valueIndex = ctlv.getValueIndex();
        byte codingScheme = 0;
        String text = null;
        int textLen = ctlv.getLength();
        if (textLen == 0) {
            return text;
        }
        --textLen;
        try {
            codingScheme = (byte)(rawValue[valueIndex] & 0xC);
            if (codingScheme == 0) {
                text = GsmAlphabet.gsm7BitPackedToString(rawValue, valueIndex + 1, textLen * 8 / 7);
            } else if (codingScheme == 4) {
                text = GsmAlphabet.gsm8BitUnpackedToString(rawValue, valueIndex + 1, textLen);
            } else if (codingScheme == 8) {
                text = new String(rawValue, valueIndex + 1, textLen, "UTF-16");
            } else {
                throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
            }
            return text;
        }
        catch (IndexOutOfBoundsException e) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        }
        catch (UnsupportedEncodingException e) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        }
    }
}

