/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.AppOpsManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Process;
import android.provider.Settings;
import android.telephony.Rlog;
import android.telephony.TelephonyManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SmsApplication {
    static final String LOG_TAG = "SmsApplication";
    private static final String PHONE_PACKAGE_NAME = "com.android.phone";

    public static Collection<SmsApplicationData> getApplicationCollection(Context context) {
        String packageName;
        SmsApplicationData smsApplicationData;
        ActivityInfo activityInfo;
        SmsApplicationData smsApplicationData2;
        PackageManager packageManager = context.getPackageManager();
        Intent intent = new Intent("android.provider.Telephony.SMS_DELIVER");
        List<ResolveInfo> smsReceivers = packageManager.queryBroadcastReceivers(intent, 0);
        HashMap<String, SmsApplicationData> receivers = new HashMap<String, SmsApplicationData>();
        for (ResolveInfo resolveInfo : smsReceivers) {
            String packageName2;
            ActivityInfo activityInfo2 = resolveInfo.activityInfo;
            if (activityInfo2 == null || !"android.permission.BROADCAST_SMS".equals(activityInfo2.permission) || receivers.containsKey(packageName2 = activityInfo2.packageName)) continue;
            String applicationName = ((Object)resolveInfo.loadLabel(packageManager)).toString();
            smsApplicationData2 = new SmsApplicationData(applicationName, packageName2, activityInfo2.applicationInfo.uid);
            smsApplicationData2.mSmsReceiverClass = activityInfo2.name;
            receivers.put(packageName2, smsApplicationData2);
        }
        intent = new Intent("android.provider.Telephony.WAP_PUSH_DELIVER");
        intent.setDataAndType(null, "application/vnd.wap.mms-message");
        List<ResolveInfo> mmsReceivers = packageManager.queryBroadcastReceivers(intent, 0);
        for (ResolveInfo resolveInfo : mmsReceivers) {
            String packageName3;
            ActivityInfo activityInfo3 = resolveInfo.activityInfo;
            if (activityInfo3 == null || !"android.permission.BROADCAST_WAP_PUSH".equals(activityInfo3.permission) || (smsApplicationData2 = (SmsApplicationData)receivers.get(packageName3 = activityInfo3.packageName)) == null) continue;
            smsApplicationData2.mMmsReceiverClass = activityInfo3.name;
        }
        intent = new Intent("android.intent.action.RESPOND_VIA_MESSAGE", Uri.fromParts("smsto", "", null));
        List<ResolveInfo> respondServices = packageManager.queryIntentServices(intent, 0);
        for (ResolveInfo resolveInfo : respondServices) {
            String packageName4;
            SmsApplicationData smsApplicationData3;
            ServiceInfo serviceInfo = resolveInfo.serviceInfo;
            if (serviceInfo == null || !"android.permission.SEND_RESPOND_VIA_MESSAGE".equals(serviceInfo.permission) || (smsApplicationData3 = (SmsApplicationData)receivers.get(packageName4 = serviceInfo.packageName)) == null) continue;
            smsApplicationData3.mRespondViaMessageClass = serviceInfo.name;
        }
        intent = new Intent("android.intent.action.SENDTO", Uri.fromParts("smsto", "", null));
        List<ResolveInfo> sendToActivities = packageManager.queryIntentActivities(intent, 0);
        for (ResolveInfo resolveInfo : sendToActivities) {
            activityInfo = resolveInfo.activityInfo;
            if (activityInfo == null || (smsApplicationData = (SmsApplicationData)receivers.get(packageName = activityInfo.packageName)) == null) continue;
            smsApplicationData.mSendToClass = activityInfo.name;
        }
        for (ResolveInfo resolveInfo : smsReceivers) {
            activityInfo = resolveInfo.activityInfo;
            if (activityInfo == null || (smsApplicationData = (SmsApplicationData)receivers.get(packageName = activityInfo.packageName)) == null || smsApplicationData.isComplete()) continue;
            receivers.remove(packageName);
        }
        return receivers.values();
    }

    private static SmsApplicationData getApplicationForPackage(Collection<SmsApplicationData> applications, String packageName) {
        if (packageName == null) {
            return null;
        }
        for (SmsApplicationData application : applications) {
            if (!application.mPackageName.contentEquals(packageName)) continue;
            return application;
        }
        return null;
    }

    private static SmsApplicationData getApplication(Context context, boolean updateIfNeeded) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        if (tm.getPhoneType() == 0) {
            return null;
        }
        Collection<SmsApplicationData> applications = SmsApplication.getApplicationCollection(context);
        String defaultApplication = Settings.Secure.getString(context.getContentResolver(), "sms_default_application");
        SmsApplicationData applicationData = null;
        if (defaultApplication != null) {
            applicationData = SmsApplication.getApplicationForPackage(applications, defaultApplication);
        }
        if (updateIfNeeded && applicationData == null) {
            Resources r = context.getResources();
            String defaultPackage = r.getString(17039395);
            applicationData = SmsApplication.getApplicationForPackage(applications, defaultPackage);
            if (applicationData == null && applications.size() != 0) {
                applicationData = (SmsApplicationData)applications.toArray()[0];
            }
            if (applicationData != null) {
                SmsApplication.setDefaultApplication(applicationData.mPackageName, context);
            }
        }
        if (applicationData != null) {
            int mode;
            AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
            if ((updateIfNeeded || applicationData.mUid == Process.myUid()) && (mode = appOps.checkOp(15, applicationData.mUid, applicationData.mPackageName)) != 0) {
                Rlog.e(LOG_TAG, applicationData.mPackageName + " lost OP_WRITE_SMS: " + (updateIfNeeded ? " (fixing)" : " (no permission to fix)"));
                if (updateIfNeeded) {
                    appOps.setMode(15, applicationData.mUid, applicationData.mPackageName, 0);
                } else {
                    applicationData = null;
                }
            }
            if (updateIfNeeded) {
                PackageManager packageManager = context.getPackageManager();
                try {
                    PackageInfo info = packageManager.getPackageInfo(PHONE_PACKAGE_NAME, 0);
                    int mode2 = appOps.checkOp(15, info.applicationInfo.uid, PHONE_PACKAGE_NAME);
                    if (mode2 != 0) {
                        Rlog.e(LOG_TAG, "com.android.phone lost OP_WRITE_SMS:  (fixing)");
                        appOps.setMode(15, info.applicationInfo.uid, PHONE_PACKAGE_NAME, 0);
                    }
                }
                catch (PackageManager.NameNotFoundException e) {
                    Rlog.e(LOG_TAG, "Phone package not found: com.android.phone");
                    applicationData = null;
                }
            }
        }
        return applicationData;
    }

    public static void setDefaultApplication(String packageName, Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        if (tm.getPhoneType() == 0) {
            return;
        }
        String oldPackageName = Settings.Secure.getString(context.getContentResolver(), "sms_default_application");
        if (packageName != null && oldPackageName != null && packageName.equals(oldPackageName)) {
            return;
        }
        PackageManager packageManager = context.getPackageManager();
        Collection<SmsApplicationData> applications = SmsApplication.getApplicationCollection(context);
        SmsApplicationData applicationData = SmsApplication.getApplicationForPackage(applications, packageName);
        if (applicationData != null) {
            PackageInfo info;
            AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
            if (oldPackageName != null) {
                try {
                    info = packageManager.getPackageInfo(oldPackageName, 8192);
                    appOps.setMode(15, info.applicationInfo.uid, oldPackageName, 1);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Rlog.w(LOG_TAG, "Old SMS package not found: " + oldPackageName);
                }
            }
            Settings.Secure.putString(context.getContentResolver(), "sms_default_application", applicationData.mPackageName);
            appOps.setMode(15, applicationData.mUid, applicationData.mPackageName, 0);
            try {
                info = packageManager.getPackageInfo(PHONE_PACKAGE_NAME, 0);
                appOps.setMode(15, info.applicationInfo.uid, PHONE_PACKAGE_NAME, 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                Rlog.e(LOG_TAG, "Phone package not found: com.android.phone");
            }
        }
    }

    public static SmsApplicationData getSmsApplicationData(String packageName, Context context) {
        Collection<SmsApplicationData> applications = SmsApplication.getApplicationCollection(context);
        return SmsApplication.getApplicationForPackage(applications, packageName);
    }

    public static ComponentName getDefaultSmsApplication(Context context, boolean updateIfNeeded) {
        ComponentName component = null;
        SmsApplicationData smsApplicationData = SmsApplication.getApplication(context, updateIfNeeded);
        if (smsApplicationData != null) {
            component = new ComponentName(smsApplicationData.mPackageName, smsApplicationData.mSmsReceiverClass);
        }
        return component;
    }

    public static ComponentName getDefaultMmsApplication(Context context, boolean updateIfNeeded) {
        ComponentName component = null;
        SmsApplicationData smsApplicationData = SmsApplication.getApplication(context, updateIfNeeded);
        if (smsApplicationData != null) {
            component = new ComponentName(smsApplicationData.mPackageName, smsApplicationData.mMmsReceiverClass);
        }
        return component;
    }

    public static ComponentName getDefaultRespondViaMessageApplication(Context context, boolean updateIfNeeded) {
        ComponentName component = null;
        SmsApplicationData smsApplicationData = SmsApplication.getApplication(context, updateIfNeeded);
        if (smsApplicationData != null) {
            component = new ComponentName(smsApplicationData.mPackageName, smsApplicationData.mRespondViaMessageClass);
        }
        return component;
    }

    public static ComponentName getDefaultSendToApplication(Context context, boolean updateIfNeeded) {
        ComponentName component = null;
        SmsApplicationData smsApplicationData = SmsApplication.getApplication(context, updateIfNeeded);
        if (smsApplicationData != null) {
            component = new ComponentName(smsApplicationData.mPackageName, smsApplicationData.mSendToClass);
        }
        return component;
    }

    public static class SmsApplicationData {
        public String mApplicationName;
        public String mPackageName;
        public String mSmsReceiverClass;
        public String mMmsReceiverClass;
        public String mRespondViaMessageClass;
        public String mSendToClass;
        public int mUid;

        public boolean isComplete() {
            return this.mSmsReceiverClass != null && this.mMmsReceiverClass != null && this.mRespondViaMessageClass != null && this.mSendToClass != null;
        }

        public SmsApplicationData(String applicationName, String packageName, int uid) {
            this.mApplicationName = applicationName;
            this.mPackageName = packageName;
            this.mUid = uid;
        }
    }
}

