/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.telephony.Rlog;
import android.text.TextUtils;
import android.util.Pair;
import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetryManager {
    public static final String LOG_TAG = "RetryManager";
    public static final boolean DBG = false;
    public static final boolean VDBG = false;
    private ArrayList<RetryRec> mRetryArray = new ArrayList();
    private boolean mRetryForever;
    private int mMaxRetryCount;
    private int mCurMaxRetryCount;
    private int mRetryCount;
    private Random mRng = new Random();
    private String mConfig;

    public String toString() {
        String ret = "RetryManager: { forever=" + this.mRetryForever + " maxRetry=" + this.mMaxRetryCount + " curMaxRetry=" + this.mCurMaxRetryCount + " retry=" + this.mRetryCount + " config={" + this.mConfig + "} retryArray={";
        for (RetryRec r : this.mRetryArray) {
            ret = ret + r.mDelayTime + ":" + r.mRandomizationTime + " ";
        }
        ret = ret + "}}";
        return ret;
    }

    public boolean configure(int maxRetryCount, int retryTime, int randomizationTime) {
        if (!this.validateNonNegativeInt("maxRetryCount", maxRetryCount)) {
            return false;
        }
        if (!this.validateNonNegativeInt("retryTime", retryTime)) {
            return false;
        }
        if (!this.validateNonNegativeInt("randomizationTime", randomizationTime)) {
            return false;
        }
        this.mCurMaxRetryCount = this.mMaxRetryCount = maxRetryCount;
        this.resetRetryCount();
        this.mRetryArray.clear();
        this.mRetryArray.add(new RetryRec(retryTime, randomizationTime));
        return true;
    }

    public boolean configure(String configStr) {
        if (configStr.startsWith("\"") && configStr.endsWith("\"")) {
            configStr = configStr.substring(1, configStr.length() - 1);
        }
        this.mConfig = configStr;
        if (!TextUtils.isEmpty(configStr)) {
            int defaultRandomization = 0;
            this.mMaxRetryCount = 0;
            this.resetRetryCount();
            this.mRetryArray.clear();
            String[] strArray = configStr.split(",");
            for (int i = 0; i < strArray.length; ++i) {
                Pair<Boolean, Integer> value;
                String[] splitStr = strArray[i].split("=", 2);
                splitStr[0] = splitStr[0].trim();
                if (splitStr.length > 1) {
                    splitStr[1] = splitStr[1].trim();
                    if (TextUtils.equals(splitStr[0], "default_randomization")) {
                        value = this.parseNonNegativeInt(splitStr[0], splitStr[1]);
                        if (!((Boolean)value.first).booleanValue()) {
                            return false;
                        }
                        defaultRandomization = (Integer)value.second;
                        continue;
                    }
                    if (TextUtils.equals(splitStr[0], "max_retries")) {
                        if (TextUtils.equals("infinite", splitStr[1])) {
                            this.mRetryForever = true;
                            continue;
                        }
                        value = this.parseNonNegativeInt(splitStr[0], splitStr[1]);
                        if (!((Boolean)value.first).booleanValue()) {
                            return false;
                        }
                        this.mMaxRetryCount = (Integer)value.second;
                        continue;
                    }
                    Rlog.e(LOG_TAG, "Unrecognized configuration name value pair: " + strArray[i]);
                    return false;
                }
                splitStr = strArray[i].split(":", 2);
                splitStr[0] = splitStr[0].trim();
                RetryRec rr = new RetryRec(0, 0);
                value = this.parseNonNegativeInt("delayTime", splitStr[0]);
                if (!((Boolean)value.first).booleanValue()) {
                    return false;
                }
                rr.mDelayTime = (Integer)value.second;
                if (splitStr.length > 1) {
                    splitStr[1] = splitStr[1].trim();
                    value = this.parseNonNegativeInt("randomizationTime", splitStr[1]);
                    if (!((Boolean)value.first).booleanValue()) {
                        return false;
                    }
                    rr.mRandomizationTime = (Integer)value.second;
                } else {
                    rr.mRandomizationTime = defaultRandomization;
                }
                this.mRetryArray.add(rr);
            }
            if (this.mRetryArray.size() > this.mMaxRetryCount) {
                this.mMaxRetryCount = this.mRetryArray.size();
            }
            this.mCurMaxRetryCount = this.mMaxRetryCount;
            return true;
        }
        return false;
    }

    public boolean isRetryNeeded() {
        boolean retVal = this.mRetryForever || this.mRetryCount < this.mCurMaxRetryCount;
        return retVal;
    }

    public int getRetryTimer() {
        int index = this.mRetryCount < this.mRetryArray.size() ? this.mRetryCount : this.mRetryArray.size() - 1;
        int retVal = index >= 0 && index < this.mRetryArray.size() ? this.mRetryArray.get((int)index).mDelayTime + this.nextRandomizationTime(index) : 0;
        return retVal;
    }

    public int getRetryCount() {
        return this.mRetryCount;
    }

    public void increaseRetryCount() {
        ++this.mRetryCount;
        if (this.mRetryCount > this.mCurMaxRetryCount) {
            this.mRetryCount = this.mCurMaxRetryCount;
        }
    }

    public void setRetryCount(int count) {
        this.mRetryCount = count;
        if (this.mRetryCount > this.mCurMaxRetryCount) {
            this.mRetryCount = this.mCurMaxRetryCount;
        }
        if (this.mRetryCount < 0) {
            this.mRetryCount = 0;
        }
    }

    public void setCurMaxRetryCount(int count) {
        this.mCurMaxRetryCount = count;
        if (this.mCurMaxRetryCount < 0) {
            this.mCurMaxRetryCount = 0;
        }
        this.setRetryCount(this.mRetryCount);
    }

    public void restoreCurMaxRetryCount() {
        this.mCurMaxRetryCount = this.mMaxRetryCount;
        this.setRetryCount(this.mRetryCount);
    }

    public void setRetryForever(boolean retryForever) {
        this.mRetryForever = retryForever;
    }

    public void resetRetryCount() {
        this.mRetryCount = 0;
    }

    public void retryForeverUsingLastTimeout() {
        this.mRetryCount = this.mCurMaxRetryCount;
        this.mRetryForever = true;
    }

    public boolean isRetryForever() {
        return this.mRetryForever;
    }

    private Pair<Boolean, Integer> parseNonNegativeInt(String name, String stringValue) {
        Pair<Boolean, Integer> retVal;
        try {
            int value = Integer.parseInt(stringValue);
            retVal = new Pair<Boolean, Integer>(this.validateNonNegativeInt(name, value), value);
        }
        catch (NumberFormatException e) {
            Rlog.e(LOG_TAG, name + " bad value: " + stringValue, e);
            retVal = new Pair<Boolean, Integer>(false, 0);
        }
        return retVal;
    }

    private boolean validateNonNegativeInt(String name, int value) {
        boolean retVal;
        if (value < 0) {
            Rlog.e(LOG_TAG, name + " bad value: is < 0");
            retVal = false;
        } else {
            retVal = true;
        }
        return retVal;
    }

    private int nextRandomizationTime(int index) {
        int randomTime = this.mRetryArray.get((int)index).mRandomizationTime;
        if (randomTime == 0) {
            return 0;
        }
        return this.mRng.nextInt(randomTime);
    }

    private void log(String s) {
        Rlog.d(LOG_TAG, "[RM] " + s);
    }

    private static class RetryRec {
        int mDelayTime;
        int mRandomizationTime;

        RetryRec(int delayTime, int randomizationTime) {
            this.mDelayTime = delayTime;
            this.mRandomizationTime = randomizationTime;
        }
    }
}

