/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.SQLException;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Build;
import android.os.Message;
import android.os.PowerManager;
import android.os.SystemProperties;
import android.provider.Telephony;
import android.telephony.Rlog;
import android.telephony.SmsMessage;
import android.telephony.TelephonyManager;
import com.android.internal.telephony.InboundSmsTracker;
import com.android.internal.telephony.SmsApplication;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.SmsStorageMonitor;
import com.android.internal.telephony.WapPushOverSms;
import com.android.internal.util.HexDump;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public abstract class InboundSmsHandler
extends StateMachine {
    protected static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final String[] PDU_PROJECTION = new String[]{"pdu"};
    private static final String[] PDU_SEQUENCE_PORT_PROJECTION = new String[]{"pdu", "sequence", "destination_port"};
    static final int PDU_COLUMN = 0;
    static final int SEQUENCE_COLUMN = 1;
    static final int DESTINATION_PORT_COLUMN = 2;
    static final int DATE_COLUMN = 3;
    static final int REFERENCE_NUMBER_COLUMN = 4;
    static final int COUNT_COLUMN = 5;
    static final int ADDRESS_COLUMN = 6;
    static final int ID_COLUMN = 7;
    static final String SELECT_BY_ID = "_id=?";
    static final String SELECT_BY_REFERENCE = "address=? AND reference_number=? AND count=?";
    public static final int EVENT_NEW_SMS = 1;
    static final int EVENT_BROADCAST_SMS = 2;
    static final int EVENT_BROADCAST_COMPLETE = 3;
    static final int EVENT_RETURN_TO_IDLE = 4;
    static final int EVENT_RELEASE_WAKELOCK = 5;
    static final int EVENT_START_ACCEPTING_SMS = 6;
    private static final int WAKELOCK_TIMEOUT = 3000;
    private static final Uri sRawUri = Uri.withAppendedPath(Telephony.Sms.CONTENT_URI, "raw");
    protected final Context mContext;
    private final ContentResolver mResolver;
    private final WapPushOverSms mWapPush;
    final PowerManager.WakeLock mWakeLock;
    final DefaultState mDefaultState = new DefaultState();
    final StartupState mStartupState = new StartupState();
    final IdleState mIdleState = new IdleState();
    final DeliveringState mDeliveringState = new DeliveringState();
    final WaitingState mWaitingState = new WaitingState();
    protected final SmsStorageMonitor mStorageMonitor;
    private final boolean mSmsReceiveDisabled;

    protected InboundSmsHandler(String name, Context context, SmsStorageMonitor storageMonitor) {
        super(name);
        this.mContext = context;
        this.mStorageMonitor = storageMonitor;
        this.mResolver = context.getContentResolver();
        this.mWapPush = new WapPushOverSms(context);
        boolean smsCapable = this.mContext.getResources().getBoolean(17891386);
        this.mSmsReceiveDisabled = !SystemProperties.getBoolean("telephony.sms.receive", smsCapable);
        PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, name);
        this.mWakeLock.acquire();
        this.addState(this.mDefaultState);
        this.addState(this.mStartupState, this.mDefaultState);
        this.addState(this.mIdleState, this.mDefaultState);
        this.addState(this.mDeliveringState, this.mDefaultState);
        this.addState(this.mWaitingState, this.mDeliveringState);
        this.setInitialState(this.mStartupState);
        this.log("created InboundSmsHandler");
    }

    public void dispose() {
        this.quit();
    }

    protected void onQuitting() {
        this.mWapPush.dispose();
        while (this.mWakeLock.isHeld()) {
            this.mWakeLock.release();
        }
    }

    void handleNewSms(AsyncResult ar) {
        int result;
        if (ar.exception != null) {
            this.loge("Exception processing incoming SMS: " + ar.exception);
            return;
        }
        try {
            SmsMessage sms = (SmsMessage)ar.result;
            result = this.dispatchMessage(sms.mWrappedSmsMessage);
        }
        catch (RuntimeException ex) {
            this.loge("Exception dispatching message", ex);
            result = 2;
        }
        if (result != -1) {
            boolean handled = result == 1;
            this.notifyAndAcknowledgeLastIncomingSms(handled, result, null);
        }
    }

    public int dispatchMessage(SmsMessageBase smsb) {
        if (smsb == null) {
            this.loge("dispatchSmsMessage: message is null");
            return 2;
        }
        if (this.mSmsReceiveDisabled) {
            this.log("Received short message on device which doesn't support receiving SMS. Ignored.");
            return 1;
        }
        return this.dispatchMessageRadioSpecific(smsb);
    }

    protected abstract int dispatchMessageRadioSpecific(SmsMessageBase var1);

    protected abstract void acknowledgeLastIncomingSms(boolean var1, int var2, Message var3);

    void notifyAndAcknowledgeLastIncomingSms(boolean success, int result, Message response) {
        if (!success) {
            Intent intent = new Intent("android.provider.Telephony.SMS_REJECTED");
            intent.putExtra("result", result);
            this.mContext.sendBroadcast(intent, "android.permission.RECEIVE_SMS");
        }
        this.acknowledgeLastIncomingSms(success, result, response);
    }

    protected abstract boolean is3gpp2();

    protected int dispatchNormalMessage(SmsMessageBase sms) {
        InboundSmsTracker tracker;
        SmsHeader smsHeader = sms.getUserDataHeader();
        if (smsHeader == null || smsHeader.concatRef == null) {
            int destPort = -1;
            if (smsHeader != null && smsHeader.portAddrs != null) {
                destPort = smsHeader.portAddrs.destPort;
                this.log("destination port: " + destPort);
            }
            tracker = new InboundSmsTracker(sms.getPdu(), sms.getTimestampMillis(), destPort, this.is3gpp2(), false);
        } else {
            SmsHeader.ConcatRef concatRef = smsHeader.concatRef;
            SmsHeader.PortAddrs portAddrs = smsHeader.portAddrs;
            int destPort = portAddrs != null ? portAddrs.destPort : -1;
            tracker = new InboundSmsTracker(sms.getPdu(), sms.getTimestampMillis(), destPort, this.is3gpp2(), sms.getOriginatingAddress(), concatRef.refNumber, concatRef.seqNumber, concatRef.msgCount, false);
        }
        return this.addTrackerToRawTableAndSendMessage(tracker);
    }

    protected int addTrackerToRawTableAndSendMessage(InboundSmsTracker tracker) {
        switch (this.addTrackerToRawTable(tracker)) {
            case 1: {
                this.sendMessage(2, tracker);
                return 1;
            }
            case 5: {
                return 1;
            }
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processMessagePart(InboundSmsTracker tracker) {
        Intent intent;
        byte[][] pdus;
        int messageCount = tracker.getMessageCount();
        int destPort = tracker.getDestPort();
        if (messageCount == 1) {
            pdus = new byte[][]{tracker.getPdu()};
        } else {
            Cursor cursor = null;
            try {
                String address = tracker.getAddress();
                String refNumber = Integer.toString(tracker.getReferenceNumber());
                String count = Integer.toString(tracker.getMessageCount());
                String[] whereArgs = new String[]{address, refNumber, count};
                cursor = this.mResolver.query(sRawUri, PDU_SEQUENCE_PORT_PROJECTION, SELECT_BY_REFERENCE, whereArgs, null);
                int cursorCount = cursor.getCount();
                if (cursorCount < messageCount) {
                    boolean bl = false;
                    return bl;
                }
                pdus = new byte[messageCount][];
                while (cursor.moveToNext()) {
                    int index = cursor.getInt(1) - tracker.getIndexOffset();
                    pdus[index] = HexDump.hexStringToByteArray(cursor.getString(0));
                    if (index != 0 || cursor.isNull(2)) continue;
                    int port = cursor.getInt(2);
                    if ((port = InboundSmsTracker.getRealDestPort(port)) == -1) continue;
                    destPort = port;
                }
            }
            catch (SQLException e) {
                this.loge("Can't access multipart SMS database", e);
                boolean refNumber = false;
                return refNumber;
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        SmsBroadcastReceiver resultReceiver = new SmsBroadcastReceiver(tracker);
        if (destPort == 2948) {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            for (byte[] pdu : pdus) {
                if (!tracker.is3gpp2()) {
                    SmsMessage msg = SmsMessage.createFromPdu(pdu, "3gpp");
                    pdu = msg.getUserData();
                }
                output.write(pdu, 0, pdu.length);
            }
            int result = this.mWapPush.dispatchWapPdu(output.toByteArray(), resultReceiver, this);
            this.log("dispatchWapPdu() returned " + result);
            return result == -1;
        }
        if (destPort == -1) {
            intent = new Intent("android.provider.Telephony.SMS_DELIVER");
            ComponentName componentName = SmsApplication.getDefaultSmsApplication(this.mContext, true);
            if (componentName != null) {
                intent.setComponent(componentName);
                this.log("Delivering SMS to: " + componentName.getPackageName() + " " + componentName.getClassName());
            }
        } else {
            Uri uri = Uri.parse("sms://localhost:" + destPort);
            intent = new Intent("android.intent.action.DATA_SMS_RECEIVED", uri);
        }
        intent.putExtra("pdus", (Serializable)pdus);
        intent.putExtra("format", tracker.getFormat());
        this.dispatchIntent(intent, "android.permission.RECEIVE_SMS", 16, resultReceiver);
        return true;
    }

    void dispatchIntent(Intent intent, String permission2, int appOp, BroadcastReceiver resultReceiver) {
        intent.addFlags(0x8000000);
        this.mContext.sendOrderedBroadcast(intent, permission2, appOp, resultReceiver, this.getHandler(), -1, null, null);
    }

    void deleteFromRawTable(String deleteWhere, String[] deleteWhereArgs) {
        int rows = this.mResolver.delete(sRawUri, deleteWhere, deleteWhereArgs);
        if (rows == 0) {
            this.loge("No rows were deleted from raw table!");
        } else {
            this.log("Deleted " + rows + " rows from raw table.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addTrackerToRawTable(InboundSmsTracker tracker) {
        if (tracker.getMessageCount() != 1) {
            Cursor cursor = null;
            try {
                int sequence = tracker.getSequenceNumber();
                String address = tracker.getAddress();
                String refNumber = Integer.toString(tracker.getReferenceNumber());
                String count = Integer.toString(tracker.getMessageCount());
                String seqNumber = Integer.toString(sequence);
                String[] deleteWhereArgs = new String[]{address, refNumber, count};
                tracker.setDeleteWhere(SELECT_BY_REFERENCE, deleteWhereArgs);
                cursor = this.mResolver.query(sRawUri, PDU_PROJECTION, "address=? AND reference_number=? AND count=? AND sequence=?", new String[]{address, refNumber, count, seqNumber}, null);
                if (cursor.moveToNext()) {
                    this.loge("Discarding duplicate message segment, refNumber=" + refNumber + " seqNumber=" + seqNumber);
                    String oldPduString = cursor.getString(0);
                    byte[] pdu = tracker.getPdu();
                    byte[] oldPdu = HexDump.hexStringToByteArray(oldPduString);
                    if (!Arrays.equals(oldPdu, tracker.getPdu())) {
                        this.loge("Warning: dup message segment PDU of length " + pdu.length + " is different from existing PDU of length " + oldPdu.length);
                    }
                    int n = 5;
                    return n;
                }
                cursor.close();
            }
            catch (SQLException e) {
                this.loge("Can't access multipart SMS database", e);
                int address = 2;
                return address;
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        ContentValues values = tracker.getContentValues();
        Uri newUri = this.mResolver.insert(sRawUri, values);
        this.log("URI of new row -> " + newUri);
        try {
            long rowId = ContentUris.parseId(newUri);
            if (tracker.getMessageCount() == 1) {
                tracker.setDeleteWhere(SELECT_BY_ID, new String[]{Long.toString(rowId)});
            }
            return 1;
        }
        catch (Exception e) {
            this.loge("error parsing URI for new row: " + newUri, e);
            return 2;
        }
    }

    static boolean isCurrentFormat3gpp2() {
        int activePhone = TelephonyManager.getDefault().getCurrentPhoneType();
        return 2 == activePhone;
    }

    protected void log(String s) {
        Rlog.d(this.getName(), s);
    }

    protected void loge(String s) {
        Rlog.e(this.getName(), s);
    }

    protected void loge(String s, Throwable e) {
        Rlog.e(this.getName(), s, e);
    }

    private final class SmsBroadcastReceiver
    extends BroadcastReceiver {
        private final String mDeleteWhere;
        private final String[] mDeleteWhereArgs;
        private long mBroadcastTimeNano;

        SmsBroadcastReceiver(InboundSmsTracker tracker) {
            this.mDeleteWhere = tracker.getDeleteWhere();
            this.mDeleteWhereArgs = tracker.getDeleteWhereArgs();
            this.mBroadcastTimeNano = System.nanoTime();
        }

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.provider.Telephony.SMS_DELIVER")) {
                intent.setAction("android.provider.Telephony.SMS_RECEIVED");
                intent.setComponent(null);
                InboundSmsHandler.this.dispatchIntent(intent, "android.permission.RECEIVE_SMS", 16, this);
            } else if (action.equals("android.provider.Telephony.WAP_PUSH_DELIVER")) {
                intent.setAction("android.provider.Telephony.WAP_PUSH_RECEIVED");
                intent.setComponent(null);
                InboundSmsHandler.this.dispatchIntent(intent, "android.permission.RECEIVE_SMS", 16, this);
            } else {
                int rc;
                if (!("android.intent.action.DATA_SMS_RECEIVED".equals(action) || "android.intent.action.DATA_SMS_RECEIVED".equals(action) || "android.provider.Telephony.WAP_PUSH_RECEIVED".equals(action))) {
                    InboundSmsHandler.this.loge("unexpected BroadcastReceiver action: " + action);
                }
                if ((rc = this.getResultCode()) != -1 && rc != 1) {
                    InboundSmsHandler.this.loge("a broadcast receiver set the result code to " + rc + ", deleting from raw table anyway!");
                } else {
                    InboundSmsHandler.this.log("successful broadcast, deleting from raw table.");
                }
                InboundSmsHandler.this.deleteFromRawTable(this.mDeleteWhere, this.mDeleteWhereArgs);
                InboundSmsHandler.this.sendMessage(3);
                int durationMillis = (int)((System.nanoTime() - this.mBroadcastTimeNano) / 1000000L);
                if (durationMillis >= 5000) {
                    InboundSmsHandler.this.loge("Slow ordered broadcast completion time: " + durationMillis + " ms");
                } else {
                    InboundSmsHandler.this.log("ordered broadcast completed in: " + durationMillis + " ms");
                }
            }
        }
    }

    class WaitingState
    extends State {
        WaitingState() {
        }

        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    InboundSmsHandler.this.deferMessage(msg);
                    return true;
                }
                case 3: {
                    InboundSmsHandler.this.sendMessage(4);
                    InboundSmsHandler.this.transitionTo(InboundSmsHandler.this.mDeliveringState);
                    return true;
                }
                case 4: {
                    return true;
                }
            }
            return false;
        }
    }

    class DeliveringState
    extends State {
        DeliveringState() {
        }

        public void enter() {
            InboundSmsHandler.this.log("entering Delivering state");
        }

        public void exit() {
            InboundSmsHandler.this.log("leaving Delivering state");
        }

        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    InboundSmsHandler.this.handleNewSms((AsyncResult)msg.obj);
                    InboundSmsHandler.this.sendMessage(4);
                    return true;
                }
                case 2: {
                    if (InboundSmsHandler.this.processMessagePart((InboundSmsTracker)msg.obj)) {
                        InboundSmsHandler.this.transitionTo(InboundSmsHandler.this.mWaitingState);
                    }
                    return true;
                }
                case 4: {
                    InboundSmsHandler.this.transitionTo(InboundSmsHandler.this.mIdleState);
                    return true;
                }
                case 5: {
                    InboundSmsHandler.this.mWakeLock.release();
                    if (!InboundSmsHandler.this.mWakeLock.isHeld()) {
                        InboundSmsHandler.this.loge("mWakeLock released while delivering/broadcasting!");
                    }
                    return true;
                }
            }
            return false;
        }
    }

    class IdleState
    extends State {
        IdleState() {
        }

        public void enter() {
            InboundSmsHandler.this.log("entering Idle state");
            InboundSmsHandler.this.sendMessageDelayed(5, 3000L);
        }

        public void exit() {
            InboundSmsHandler.this.mWakeLock.acquire();
            InboundSmsHandler.this.log("acquired wakelock, leaving Idle state");
        }

        public boolean processMessage(Message msg) {
            InboundSmsHandler.this.log("Idle state processing message type " + msg.what);
            switch (msg.what) {
                case 1: 
                case 2: {
                    InboundSmsHandler.this.deferMessage(msg);
                    InboundSmsHandler.this.transitionTo(InboundSmsHandler.this.mDeliveringState);
                    return true;
                }
                case 5: {
                    InboundSmsHandler.this.mWakeLock.release();
                    if (InboundSmsHandler.this.mWakeLock.isHeld()) {
                        InboundSmsHandler.this.log("mWakeLock is still held after release");
                    } else {
                        InboundSmsHandler.this.log("mWakeLock released");
                    }
                    return true;
                }
                case 4: {
                    return true;
                }
            }
            return false;
        }
    }

    class StartupState
    extends State {
        StartupState() {
        }

        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 1: 
                case 2: {
                    InboundSmsHandler.this.deferMessage(msg);
                    return true;
                }
                case 6: {
                    InboundSmsHandler.this.transitionTo(InboundSmsHandler.this.mIdleState);
                    return true;
                }
            }
            return false;
        }
    }

    class DefaultState
    extends State {
        DefaultState() {
        }

        public boolean processMessage(Message msg) {
            String errorText = "processMessage: unhandled message type " + msg.what;
            if (Build.IS_DEBUGGABLE) {
                throw new RuntimeException(errorText);
            }
            InboundSmsHandler.this.loge(errorText);
            return true;
        }
    }
}

