/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.net.LinkCapabilities;
import android.net.LinkProperties;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.CellInfo;
import android.telephony.ServiceState;
import android.telephony.TelephonyManager;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneNotifier;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPhoneNotifier
implements PhoneNotifier {
    private ITelephonyRegistry mRegistry = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));

    DefaultPhoneNotifier() {
    }

    @Override
    public void notifyPhoneState(Phone sender) {
        Call ringingCall = sender.getRingingCall();
        String incomingNumber = "";
        if (ringingCall != null && ringingCall.getEarliestConnection() != null) {
            incomingNumber = ringingCall.getEarliestConnection().getAddress();
        }
        try {
            this.mRegistry.notifyCallState(DefaultPhoneNotifier.convertCallState(sender.getState()), incomingNumber);
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    @Override
    public void notifyServiceState(Phone sender) {
        ServiceState ss = sender.getServiceState();
        if (ss == null) {
            ss = new ServiceState();
            ss.setStateOutOfService();
        }
        try {
            this.mRegistry.notifyServiceState(ss);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifySignalStrength(Phone sender) {
        try {
            this.mRegistry.notifySignalStrength(sender.getSignalStrength());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyMessageWaitingChanged(Phone sender) {
        try {
            this.mRegistry.notifyMessageWaitingChanged(sender.getMessageWaitingIndicator());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyCallForwardingChanged(Phone sender) {
        try {
            this.mRegistry.notifyCallForwardingChanged(sender.getCallForwardingIndicator());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyDataActivity(Phone sender) {
        try {
            this.mRegistry.notifyDataActivity(DefaultPhoneNotifier.convertDataActivityState(sender.getDataActivityState()));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyDataConnection(Phone sender, String reason, String apnType, PhoneConstants.DataState state) {
        this.doNotifyDataConnection(sender, reason, apnType, state);
    }

    private void doNotifyDataConnection(Phone sender, String reason, String apnType, PhoneConstants.DataState state) {
        ServiceState ss;
        TelephonyManager telephony = TelephonyManager.getDefault();
        LinkProperties linkProperties = null;
        LinkCapabilities linkCapabilities = null;
        boolean roaming = false;
        if (state == PhoneConstants.DataState.CONNECTED) {
            linkProperties = sender.getLinkProperties(apnType);
            linkCapabilities = sender.getLinkCapabilities(apnType);
        }
        if ((ss = sender.getServiceState()) != null) {
            roaming = ss.getRoaming();
        }
        try {
            this.mRegistry.notifyDataConnection(DefaultPhoneNotifier.convertDataState(state), sender.isDataConnectivityPossible(apnType), reason, sender.getActiveApnHost(apnType), apnType, linkProperties, linkCapabilities, telephony != null ? telephony.getNetworkType() : 0, roaming);
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    @Override
    public void notifyDataConnectionFailed(Phone sender, String reason, String apnType) {
        try {
            this.mRegistry.notifyDataConnectionFailed(reason, apnType);
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    @Override
    public void notifyCellLocation(Phone sender) {
        Bundle data = new Bundle();
        sender.getCellLocation().fillInNotifierBundle(data);
        try {
            this.mRegistry.notifyCellLocation(data);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyCellInfo(Phone sender, List<CellInfo> cellInfo) {
        try {
            this.mRegistry.notifyCellInfo(cellInfo);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyOtaspChanged(Phone sender, int otaspMode) {
        try {
            this.mRegistry.notifyOtaspChanged(otaspMode);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public static int convertCallState(PhoneConstants.State state) {
        switch (state) {
            case RINGING: {
                return 1;
            }
            case OFFHOOK: {
                return 2;
            }
        }
        return 0;
    }

    public static PhoneConstants.State convertCallState(int state) {
        switch (state) {
            case 1: {
                return PhoneConstants.State.RINGING;
            }
            case 2: {
                return PhoneConstants.State.OFFHOOK;
            }
        }
        return PhoneConstants.State.IDLE;
    }

    public static int convertDataState(PhoneConstants.DataState state) {
        switch (state) {
            case CONNECTING: {
                return 1;
            }
            case CONNECTED: {
                return 2;
            }
            case SUSPENDED: {
                return 3;
            }
        }
        return 0;
    }

    public static PhoneConstants.DataState convertDataState(int state) {
        switch (state) {
            case 1: {
                return PhoneConstants.DataState.CONNECTING;
            }
            case 2: {
                return PhoneConstants.DataState.CONNECTED;
            }
            case 3: {
                return PhoneConstants.DataState.SUSPENDED;
            }
        }
        return PhoneConstants.DataState.DISCONNECTED;
    }

    public static int convertDataActivityState(Phone.DataActivityState state) {
        switch (state) {
            case DATAIN: {
                return 1;
            }
            case DATAOUT: {
                return 2;
            }
            case DATAINANDOUT: {
                return 3;
            }
            case DORMANT: {
                return 4;
            }
        }
        return 0;
    }

    public static Phone.DataActivityState convertDataActivityState(int state) {
        switch (state) {
            case 1: {
                return Phone.DataActivityState.DATAIN;
            }
            case 2: {
                return Phone.DataActivityState.DATAOUT;
            }
            case 3: {
                return Phone.DataActivityState.DATAINANDOUT;
            }
            case 4: {
                return Phone.DataActivityState.DORMANT;
            }
        }
        return Phone.DataActivityState.NONE;
    }
}

