/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.SystemProperties;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public abstract class CallTracker
extends Handler {
    private static final boolean DBG_POLL = false;
    static final int POLL_DELAY_MSEC = 250;
    protected int mPendingOperations;
    protected boolean mNeedsPoll;
    protected Message mLastRelevantPoll;
    public CommandsInterface mCi;
    protected static final int EVENT_POLL_CALLS_RESULT = 1;
    protected static final int EVENT_CALL_STATE_CHANGE = 2;
    protected static final int EVENT_REPOLL_AFTER_DELAY = 3;
    protected static final int EVENT_OPERATION_COMPLETE = 4;
    protected static final int EVENT_GET_LAST_CALL_FAIL_CAUSE = 5;
    protected static final int EVENT_SWITCH_RESULT = 8;
    protected static final int EVENT_RADIO_AVAILABLE = 9;
    protected static final int EVENT_RADIO_NOT_AVAILABLE = 10;
    protected static final int EVENT_CONFERENCE_RESULT = 11;
    protected static final int EVENT_SEPARATE_RESULT = 12;
    protected static final int EVENT_ECT_RESULT = 13;
    protected static final int EVENT_EXIT_ECM_RESPONSE_CDMA = 14;
    protected static final int EVENT_CALL_WAITING_INFO_CDMA = 15;
    protected static final int EVENT_THREE_WAY_DIAL_L2_RESULT_CDMA = 16;

    protected void pollCallsWhenSafe() {
        this.mNeedsPoll = true;
        if (this.checkNoOperationsPending()) {
            this.mLastRelevantPoll = this.obtainMessage(1);
            this.mCi.getCurrentCalls(this.mLastRelevantPoll);
        }
    }

    protected void pollCallsAfterDelay() {
        Message msg = this.obtainMessage();
        msg.what = 3;
        this.sendMessageDelayed(msg, 250L);
    }

    protected boolean isCommandExceptionRadioNotAvailable(Throwable e) {
        return e != null && e instanceof CommandException && ((CommandException)e).getCommandError() == CommandException.Error.RADIO_NOT_AVAILABLE;
    }

    protected abstract void handlePollCalls(AsyncResult var1);

    protected void handleRadioAvailable() {
        this.pollCallsWhenSafe();
    }

    protected Message obtainNoPollCompleteMessage(int what) {
        ++this.mPendingOperations;
        this.mLastRelevantPoll = null;
        return this.obtainMessage(what);
    }

    private boolean checkNoOperationsPending() {
        return this.mPendingOperations == 0;
    }

    protected String checkForTestEmergencyNumber(String dialString) {
        String testEn = SystemProperties.get("ril.test.emergencynumber");
        if (!TextUtils.isEmpty(testEn)) {
            String[] values = testEn.split(":");
            this.log("checkForTestEmergencyNumber: values.length=" + values.length);
            if (values.length == 2 && values[0].equals(PhoneNumberUtils.stripSeparators(dialString))) {
                this.mCi.testingEmergencyCall();
                this.log("checkForTestEmergencyNumber: remap " + dialString + " to " + values[1]);
                dialString = values[1];
            }
        }
        return dialString;
    }

    public abstract void handleMessage(Message var1);

    public abstract void registerForVoiceCallStarted(Handler var1, int var2, Object var3);

    public abstract void unregisterForVoiceCallStarted(Handler var1);

    public abstract void registerForVoiceCallEnded(Handler var1, int var2, Object var3);

    public abstract void unregisterForVoiceCallEnded(Handler var1);

    protected abstract void log(String var1);

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("CallTracker:");
        pw.println(" mPendingOperations=" + this.mPendingOperations);
        pw.println(" mNeedsPoll=" + this.mNeedsPoll);
        pw.println(" mLastRelevantPoll=" + this.mLastRelevantPoll);
    }
}

