/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Canvas;
import android.os.Handler;
import android.os.Message;
import android.os.Trace;
import android.util.AttributeSet;
import android.util.Xml;
import android.view.InflateException;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.FrameLayout;
import com.android.internal.R;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class LayoutInflater {
    private final boolean DEBUG = false;
    protected final Context mContext;
    private boolean mFactorySet;
    private Factory mFactory;
    private Factory2 mFactory2;
    private Factory2 mPrivateFactory;
    private Filter mFilter;
    final Object[] mConstructorArgs = new Object[2];
    static final Class<?>[] mConstructorSignature = new Class[]{Context.class, AttributeSet.class};
    private static final HashMap<String, Constructor<? extends View>> sConstructorMap = new HashMap();
    private HashMap<String, Boolean> mFilterMap;
    private static final String TAG_MERGE = "merge";
    private static final String TAG_INCLUDE = "include";
    private static final String TAG_1995 = "blink";
    private static final String TAG_REQUEST_FOCUS = "requestFocus";

    protected LayoutInflater(Context context) {
        this.mContext = context;
    }

    protected LayoutInflater(LayoutInflater original, Context newContext) {
        this.mContext = newContext;
        this.mFactory = original.mFactory;
        this.mFactory2 = original.mFactory2;
        this.mPrivateFactory = original.mPrivateFactory;
        this.mFilter = original.mFilter;
    }

    public static LayoutInflater from(Context context) {
        LayoutInflater LayoutInflater2 = (LayoutInflater)context.getSystemService("layout_inflater");
        if (LayoutInflater2 == null) {
            throw new AssertionError((Object)"LayoutInflater not found.");
        }
        return LayoutInflater2;
    }

    public abstract LayoutInflater cloneInContext(Context var1);

    public Context getContext() {
        return this.mContext;
    }

    public final Factory getFactory() {
        return this.mFactory;
    }

    public final Factory2 getFactory2() {
        return this.mFactory2;
    }

    public void setFactory(Factory factory) {
        if (this.mFactorySet) {
            throw new IllegalStateException("A factory has already been set on this LayoutInflater");
        }
        if (factory == null) {
            throw new NullPointerException("Given factory can not be null");
        }
        this.mFactorySet = true;
        this.mFactory = this.mFactory == null ? factory : new FactoryMerger(factory, null, this.mFactory, this.mFactory2);
    }

    public void setFactory2(Factory2 factory) {
        if (this.mFactorySet) {
            throw new IllegalStateException("A factory has already been set on this LayoutInflater");
        }
        if (factory == null) {
            throw new NullPointerException("Given factory can not be null");
        }
        this.mFactorySet = true;
        if (this.mFactory == null) {
            this.mFactory2 = factory;
            this.mFactory = this.mFactory2;
        } else {
            this.mFactory = new FactoryMerger(factory, factory, this.mFactory, this.mFactory2);
        }
    }

    public void setPrivateFactory(Factory2 factory) {
        this.mPrivateFactory = factory;
    }

    public Filter getFilter() {
        return this.mFilter;
    }

    public void setFilter(Filter filter) {
        this.mFilter = filter;
        if (filter != null) {
            this.mFilterMap = new HashMap();
        }
    }

    public View inflate(int resource, ViewGroup root) {
        return this.inflate(resource, root, root != null);
    }

    public View inflate(XmlPullParser parser, ViewGroup root) {
        return this.inflate(parser, root, root != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View inflate(int resource, ViewGroup root, boolean attachToRoot) {
        XmlResourceParser parser = this.getContext().getResources().getLayout(resource);
        try {
            View view = this.inflate(parser, root, attachToRoot);
            return view;
        }
        finally {
            parser.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View inflate(XmlPullParser parser, ViewGroup root, boolean attachToRoot) {
        Object[] objectArray = this.mConstructorArgs;
        synchronized (this.mConstructorArgs) {
            Trace.traceBegin(8L, "inflate");
            AttributeSet attrs = Xml.asAttributeSet(parser);
            Context lastContext = (Context)this.mConstructorArgs[0];
            this.mConstructorArgs[0] = this.mContext;
            View result = root;
            try {
                int type;
                while ((type = parser.next()) != 2 && type != 1) {
                }
                if (type != 2) {
                    throw new InflateException(parser.getPositionDescription() + ": No start tag found!");
                }
                String name = parser.getName();
                if (TAG_MERGE.equals(name)) {
                    if (root == null || !attachToRoot) {
                        throw new InflateException("<merge /> can be used only with a valid ViewGroup root and attachToRoot=true");
                    }
                    this.rInflate(parser, root, attrs, false);
                } else {
                    View temp = TAG_1995.equals(name) ? new BlinkLayout(this.mContext, attrs) : this.createViewFromTag(root, name, attrs);
                    ViewGroup.LayoutParams params = null;
                    if (root != null) {
                        params = root.generateLayoutParams(attrs);
                        if (!attachToRoot) {
                            temp.setLayoutParams(params);
                        }
                    }
                    this.rInflate(parser, temp, attrs, true);
                    if (root != null && attachToRoot) {
                        root.addView(temp, params);
                    }
                    if (root == null || !attachToRoot) {
                        result = temp;
                    }
                }
            }
            catch (XmlPullParserException e) {
                InflateException ex = new InflateException(e.getMessage());
                ex.initCause(e);
                throw ex;
            }
            catch (IOException e) {
                InflateException ex = new InflateException(parser.getPositionDescription() + ": " + e.getMessage());
                ex.initCause(e);
                throw ex;
            }
            finally {
                this.mConstructorArgs[0] = lastContext;
                this.mConstructorArgs[1] = null;
            }
            Trace.traceEnd(8L);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return result;
        }
    }

    public final View createView(String name, String prefix, AttributeSet attrs) throws ClassNotFoundException, InflateException {
        Constructor<? extends View> constructor = sConstructorMap.get(name);
        Class<View> clazz = null;
        try {
            Trace.traceBegin(8L, name);
            if (constructor == null) {
                boolean allowed;
                clazz = this.mContext.getClassLoader().loadClass(prefix != null ? prefix + name : name).asSubclass(View.class);
                if (this.mFilter != null && clazz != null && !(allowed = this.mFilter.onLoadClass(clazz))) {
                    this.failNotAllowed(name, prefix, attrs);
                }
                constructor = clazz.getConstructor(mConstructorSignature);
                sConstructorMap.put(name, constructor);
            } else if (this.mFilter != null) {
                Boolean allowedState = this.mFilterMap.get(name);
                if (allowedState == null) {
                    clazz = this.mContext.getClassLoader().loadClass(prefix != null ? prefix + name : name).asSubclass(View.class);
                    boolean allowed = clazz != null && this.mFilter.onLoadClass(clazz);
                    this.mFilterMap.put(name, allowed);
                    if (!allowed) {
                        this.failNotAllowed(name, prefix, attrs);
                    }
                } else if (allowedState.equals(Boolean.FALSE)) {
                    this.failNotAllowed(name, prefix, attrs);
                }
            }
            Object[] args = this.mConstructorArgs;
            args[1] = attrs;
            View view = constructor.newInstance(args);
            if (view instanceof ViewStub) {
                ViewStub viewStub = (ViewStub)view;
                viewStub.setLayoutInflater(this);
            }
            View view2 = view;
            return view2;
        }
        catch (NoSuchMethodException e) {
            InflateException ie = new InflateException(attrs.getPositionDescription() + ": Error inflating class " + (prefix != null ? prefix + name : name));
            ie.initCause(e);
            throw ie;
        }
        catch (ClassCastException e) {
            InflateException ie = new InflateException(attrs.getPositionDescription() + ": Class is not a View " + (prefix != null ? prefix + name : name));
            ie.initCause(e);
            throw ie;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            InflateException ie = new InflateException(attrs.getPositionDescription() + ": Error inflating class " + (clazz == null ? "<unknown>" : clazz.getName()));
            ie.initCause(e);
            throw ie;
        }
        finally {
            Trace.traceEnd(8L);
        }
    }

    private void failNotAllowed(String name, String prefix, AttributeSet attrs) {
        throw new InflateException(attrs.getPositionDescription() + ": Class not allowed to be inflated " + (prefix != null ? prefix + name : name));
    }

    protected View onCreateView(String name, AttributeSet attrs) throws ClassNotFoundException {
        return this.createView(name, "android.view.", attrs);
    }

    protected View onCreateView(View parent, String name, AttributeSet attrs) throws ClassNotFoundException {
        return this.onCreateView(name, attrs);
    }

    View createViewFromTag(View parent, String name, AttributeSet attrs) {
        if (name.equals("view")) {
            name = attrs.getAttributeValue(null, "class");
        }
        try {
            View view = this.mFactory2 != null ? this.mFactory2.onCreateView(parent, name, this.mContext, attrs) : (this.mFactory != null ? this.mFactory.onCreateView(name, this.mContext, attrs) : null);
            if (view == null && this.mPrivateFactory != null) {
                view = this.mPrivateFactory.onCreateView(parent, name, this.mContext, attrs);
            }
            if (view == null) {
                view = -1 == name.indexOf(46) ? this.onCreateView(parent, name, attrs) : this.createView(name, null, attrs);
            }
            return view;
        }
        catch (InflateException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            InflateException ie = new InflateException(attrs.getPositionDescription() + ": Error inflating class " + name);
            ie.initCause(e);
            throw ie;
        }
        catch (Exception e) {
            InflateException ie = new InflateException(attrs.getPositionDescription() + ": Error inflating class " + name);
            ie.initCause(e);
            throw ie;
        }
    }

    void rInflate(XmlPullParser parser, View parent, AttributeSet attrs, boolean finishInflate) throws XmlPullParserException, IOException {
        int type;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            ViewGroup.LayoutParams params;
            ViewGroup viewGroup;
            View view;
            if (type != 2) continue;
            String name = parser.getName();
            if (TAG_REQUEST_FOCUS.equals(name)) {
                this.parseRequestFocus(parser, parent);
                continue;
            }
            if (TAG_INCLUDE.equals(name)) {
                if (parser.getDepth() == 0) {
                    throw new InflateException("<include /> cannot be the root element");
                }
                this.parseInclude(parser, parent, attrs);
                continue;
            }
            if (TAG_MERGE.equals(name)) {
                throw new InflateException("<merge /> must be the root element");
            }
            if (TAG_1995.equals(name)) {
                view = new BlinkLayout(this.mContext, attrs);
                viewGroup = (ViewGroup)parent;
                params = viewGroup.generateLayoutParams(attrs);
                this.rInflate(parser, view, attrs, true);
                viewGroup.addView(view, params);
                continue;
            }
            view = this.createViewFromTag(parent, name, attrs);
            viewGroup = (ViewGroup)parent;
            params = viewGroup.generateLayoutParams(attrs);
            this.rInflate(parser, view, attrs, true);
            viewGroup.addView(view, params);
        }
        if (finishInflate) {
            parent.onFinishInflate();
        }
    }

    private void parseRequestFocus(XmlPullParser parser, View parent) throws XmlPullParserException, IOException {
        int type;
        parent.requestFocus();
        int currentDepth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > currentDepth) && type != 1) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseInclude(XmlPullParser parser, View parent, AttributeSet attrs) throws XmlPullParserException, IOException {
        int type;
        if (parent instanceof ViewGroup) {
            int layout2 = attrs.getAttributeResourceValue(null, "layout", 0);
            if (layout2 == 0) {
                String value = attrs.getAttributeValue(null, "layout");
                if (value == null) {
                    throw new InflateException("You must specifiy a layout in the include tag: <include layout=\"@layout/layoutID\" />");
                }
                throw new InflateException("You must specifiy a valid layout reference. The layout ID " + value + " is not valid.");
            }
            XmlResourceParser childParser = this.getContext().getResources().getLayout(layout2);
            try {
                AttributeSet childAttrs = Xml.asAttributeSet(childParser);
                while ((type = childParser.next()) != 2 && type != 1) {
                }
                if (type != 2) {
                    throw new InflateException(childParser.getPositionDescription() + ": No start tag found!");
                }
                String childName = childParser.getName();
                if (TAG_MERGE.equals(childName)) {
                    this.rInflate(childParser, parent, childAttrs, false);
                }
                View view = this.createViewFromTag(parent, childName, childAttrs);
                ViewGroup group = (ViewGroup)parent;
                ViewGroup.LayoutParams params = null;
                try {
                    params = group.generateLayoutParams(attrs);
                }
                catch (RuntimeException e) {
                    params = group.generateLayoutParams(childAttrs);
                }
                finally {
                    if (params != null) {
                        view.setLayoutParams(params);
                    }
                }
                this.rInflate(childParser, view, childAttrs, true);
                TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.View, 0, 0);
                int id2 = a.getResourceId(8, -1);
                int visibility = a.getInt(20, -1);
                a.recycle();
                if (id2 != -1) {
                    view.setId(id2);
                }
                switch (visibility) {
                    case 0: {
                        view.setVisibility(0);
                        break;
                    }
                    case 1: {
                        view.setVisibility(4);
                        break;
                    }
                    case 2: {
                        view.setVisibility(8);
                    }
                }
                group.addView(view);
            }
            finally {
                childParser.close();
            }
        } else {
            throw new InflateException("<include /> can only be used inside of a ViewGroup");
        }
        int currentDepth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > currentDepth) && type != 1) {
        }
    }

    private static class BlinkLayout
    extends FrameLayout {
        private static final int MESSAGE_BLINK = 66;
        private static final int BLINK_DELAY = 500;
        private boolean mBlink;
        private boolean mBlinkState;
        private final Handler mHandler = new Handler(new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                if (msg.what == 66) {
                    if (BlinkLayout.this.mBlink) {
                        BlinkLayout.this.mBlinkState = !BlinkLayout.this.mBlinkState;
                        BlinkLayout.this.makeBlink();
                    }
                    BlinkLayout.this.invalidate();
                    return true;
                }
                return false;
            }
        });

        public BlinkLayout(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        private void makeBlink() {
            Message message = this.mHandler.obtainMessage(66);
            this.mHandler.sendMessageDelayed(message, 500L);
        }

        protected void onAttachedToWindow() {
            super.onAttachedToWindow();
            this.mBlink = true;
            this.mBlinkState = true;
            this.makeBlink();
        }

        protected void onDetachedFromWindow() {
            super.onDetachedFromWindow();
            this.mBlink = false;
            this.mBlinkState = true;
            this.mHandler.removeMessages(66);
        }

        protected void dispatchDraw(Canvas canvas) {
            if (this.mBlinkState) {
                super.dispatchDraw(canvas);
            }
        }
    }

    private static class FactoryMerger
    implements Factory2 {
        private final Factory mF1;
        private final Factory mF2;
        private final Factory2 mF12;
        private final Factory2 mF22;

        FactoryMerger(Factory f1, Factory2 f12, Factory f2, Factory2 f22) {
            this.mF1 = f1;
            this.mF2 = f2;
            this.mF12 = f12;
            this.mF22 = f22;
        }

        public View onCreateView(String name, Context context, AttributeSet attrs) {
            View v = this.mF1.onCreateView(name, context, attrs);
            if (v != null) {
                return v;
            }
            return this.mF2.onCreateView(name, context, attrs);
        }

        public View onCreateView(View parent, String name, Context context, AttributeSet attrs) {
            View v;
            View view = v = this.mF12 != null ? this.mF12.onCreateView(parent, name, context, attrs) : this.mF1.onCreateView(name, context, attrs);
            if (v != null) {
                return v;
            }
            return this.mF22 != null ? this.mF22.onCreateView(parent, name, context, attrs) : this.mF2.onCreateView(name, context, attrs);
        }
    }

    public static interface Factory2
    extends Factory {
        public View onCreateView(View var1, String var2, Context var3, AttributeSet var4);
    }

    public static interface Factory {
        public View onCreateView(String var1, Context var2, AttributeSet var3);
    }

    public static interface Filter {
        public boolean onLoadClass(Class var1);
    }
}

