/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.opengl.GLUtils;
import android.opengl.ManagedEGLContext;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.DisplayList;
import android.view.GLES20Canvas;
import android.view.GLES20DisplayList;
import android.view.GLES20RenderLayer;
import android.view.GLES20TextureLayer;
import android.view.GraphicBuffer;
import android.view.HardwareCanvas;
import android.view.HardwareLayer;
import android.view.IAssetAtlas;
import android.view.Surface;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gles_jni.EGLImpl;
import java.io.File;
import java.io.PrintWriter;
import java.util.concurrent.locks.ReentrantLock;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL;

public abstract class HardwareRenderer {
    static final String LOG_TAG = "HardwareRenderer";
    private static final String CACHE_PATH_SHADERS = "com.android.opengl.shaders_cache";
    static final boolean RENDER_DIRTY_REGIONS = true;
    static final String RENDER_DIRTY_REGIONS_PROPERTY = "debug.hwui.render_dirty_regions";
    public static final String PROFILE_PROPERTY = "debug.hwui.profile";
    public static final String PROFILE_PROPERTY_VISUALIZE_BARS = "visual_bars";
    public static final String PROFILE_PROPERTY_VISUALIZE_LINES = "visual_lines";
    static final String PROFILE_MAXFRAMES_PROPERTY = "debug.hwui.profile.maxframes";
    static final String PRINT_CONFIG_PROPERTY = "debug.hwui.print_config";
    public static final String DEBUG_DIRTY_REGIONS_PROPERTY = "debug.hwui.show_dirty_regions";
    public static final String DEBUG_SHOW_LAYERS_UPDATES_PROPERTY = "debug.hwui.show_layers_updates";
    public static final String DEBUG_OVERDRAW_PROPERTY = "debug.hwui.overdraw";
    public static final String OVERDRAW_PROPERTY_SHOW = "show";
    public static final String OVERDRAW_PROPERTY_COUNT = "count";
    public static final String DEBUG_SHOW_NON_RECTANGULAR_CLIP_PROPERTY = "debug.hwui.show_non_rect_clip";
    public static boolean sRendererDisabled = false;
    public static boolean sSystemRendererDisabled = false;
    private static final int PROFILE_MAX_FRAMES = 128;
    private static final int PROFILE_FRAME_DATA_COUNT = 3;
    private boolean mEnabled;
    private boolean mRequested = true;

    public static void disable(boolean system) {
        sRendererDisabled = true;
        if (system) {
            sSystemRendererDisabled = true;
        }
    }

    public static boolean isAvailable() {
        return GLES20Canvas.isAvailable();
    }

    abstract void destroy(boolean var1);

    abstract boolean initialize(Surface var1) throws Surface.OutOfResourcesException;

    abstract void updateSurface(Surface var1) throws Surface.OutOfResourcesException;

    abstract void destroyLayers(View var1);

    abstract void destroyHardwareResources(View var1);

    abstract void invalidate(Surface var1);

    abstract boolean validate();

    abstract boolean safelyRun(Runnable var1);

    abstract void setup(int var1, int var2);

    abstract int getWidth();

    abstract int getHeight();

    abstract HardwareCanvas getCanvas();

    abstract void dumpGfxInfo(PrintWriter var1);

    abstract long getFrameCount();

    abstract boolean loadSystemProperties(Surface var1);

    private static native boolean nLoadProperties();

    public static void setupDiskCache(File cacheDir) {
        HardwareRenderer.nSetupShadersDiskCache(new File(cacheDir, CACHE_PATH_SHADERS).getAbsolutePath());
    }

    private static native void nSetupShadersDiskCache(String var0);

    static void beginFrame(int[] size) {
        HardwareRenderer.nBeginFrame(size);
    }

    private static native void nBeginFrame(int[] var0);

    static long getSystemTime() {
        return HardwareRenderer.nGetSystemTime();
    }

    private static native long nGetSystemTime();

    static boolean preserveBackBuffer() {
        return HardwareRenderer.nPreserveBackBuffer();
    }

    private static native boolean nPreserveBackBuffer();

    static boolean isBackBufferPreserved() {
        return HardwareRenderer.nIsBackBufferPreserved();
    }

    private static native boolean nIsBackBufferPreserved();

    abstract void pushLayerUpdate(HardwareLayer var1);

    abstract void cancelLayerUpdate(HardwareLayer var1);

    abstract void flushLayerUpdates();

    abstract void draw(View var1, View.AttachInfo var2, HardwareDrawCallbacks var3, Rect var4);

    public abstract DisplayList createDisplayList(String var1);

    abstract HardwareLayer createHardwareLayer(boolean var1);

    abstract HardwareLayer createHardwareLayer(int var1, int var2, boolean var3);

    abstract SurfaceTexture createSurfaceTexture(HardwareLayer var1);

    abstract void setSurfaceTexture(HardwareLayer var1, SurfaceTexture var2);

    abstract void detachFunctor(int var1);

    abstract boolean attachFunctor(View.AttachInfo var1, int var2);

    boolean initializeIfNeeded(int width, int height, Surface surface) throws Surface.OutOfResourcesException {
        if (this.isRequested() && !this.isEnabled() && this.initialize(surface)) {
            this.setup(width, height);
            return true;
        }
        return false;
    }

    abstract void setName(String var1);

    static HardwareRenderer createGlRenderer(int glVersion, boolean translucent) {
        switch (glVersion) {
            case 2: {
                return Gl20Renderer.create(translucent);
            }
        }
        throw new IllegalArgumentException("Unknown GL version: " + glVersion);
    }

    static void trimMemory(int level) {
        HardwareRenderer.startTrimMemory(level);
        HardwareRenderer.endTrimMemory();
    }

    static void startTrimMemory(int level) {
        Gl20Renderer.startTrimMemory(level);
    }

    static void endTrimMemory() {
        Gl20Renderer.endTrimMemory();
    }

    boolean isEnabled() {
        return this.mEnabled;
    }

    void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    boolean isRequested() {
        return this.mRequested;
    }

    void setRequested(boolean requested) {
        this.mRequested = requested;
    }

    static class Gl20Renderer
    extends GlRenderer {
        private GLES20Canvas mGlCanvas;
        private DisplayMetrics mDisplayMetrics;
        private static EGLSurface sPbuffer;
        private static final Object[] sPbufferLock;

        Gl20Renderer(boolean translucent) {
            super(2, translucent);
        }

        HardwareCanvas createCanvas() {
            this.mGlCanvas = new GLES20Canvas(this.mTranslucent);
            return this.mGlCanvas;
        }

        ManagedEGLContext createManagedContext(EGLContext eglContext) {
            return new Gl20RendererEglContext(this.mEglContext);
        }

        int[] getConfig(boolean dirtyRegions) {
            int stencilSize = GLES20Canvas.getStencilSize();
            int swapBehavior = dirtyRegions ? 1024 : 0;
            return new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12325, 0, 12327, 12344, 12326, stencilSize, 12339, 4 | swapBehavior, 12344};
        }

        void initCaches() {
            if (GLES20Canvas.initCaches()) {
                this.initAtlas();
            }
        }

        void initAtlas() {
            IBinder binder = ServiceManager.getService("assetatlas");
            if (binder == null) {
                return;
            }
            IAssetAtlas atlas = IAssetAtlas.Stub.asInterface(binder);
            try {
                GraphicBuffer buffer;
                if (atlas.isCompatible(Process.myPpid()) && (buffer = atlas.getBuffer()) != null) {
                    int[] map = atlas.getMap();
                    if (map != null) {
                        GLES20Canvas.initAtlas(buffer, map);
                    }
                    if (atlas.getClass() != binder.getClass()) {
                        buffer.destroy();
                    }
                }
            }
            catch (RemoteException e) {
                Log.w(HardwareRenderer.LOG_TAG, "Could not acquire atlas", e);
            }
        }

        boolean canDraw() {
            return super.canDraw() && this.mGlCanvas != null;
        }

        int onPreDraw(Rect dirty) {
            return this.mGlCanvas.onPreDraw(dirty);
        }

        void onPostDraw() {
            this.mGlCanvas.onPostDraw();
        }

        void drawProfileData(View.AttachInfo attachInfo) {
            if (this.mDebugDataProvider != null) {
                GraphDataProvider provider = this.mDebugDataProvider;
                this.initProfileDrawData(attachInfo, provider);
                int height = provider.getVerticalUnitSize();
                int margin = provider.getHorizontaUnitMargin();
                int width = provider.getHorizontalUnitSize();
                int x = 0;
                int count = 0;
                int current = 0;
                float[] data = provider.getData();
                int elementCount = provider.getElementCount();
                int graphType = provider.getGraphType();
                int totalCount = provider.getFrameCount() * elementCount;
                if (graphType == 1) {
                    totalCount -= elementCount;
                }
                for (int i = 0; i < totalCount && !(data[i] < 0.0f); i += elementCount) {
                    int index = count * 4;
                    if (i == provider.getCurrentFrame() * elementCount) {
                        current = index;
                    }
                    int x2 = (x += margin) + width;
                    int y2 = this.mHeight;
                    int y1 = (int)((float)y2 - data[i] * (float)height);
                    switch (graphType) {
                        case 0: {
                            float[] r;
                            int j;
                            for (j = 0; j < elementCount; ++j) {
                                r = this.mProfileShapes[j];
                                r[index] = x;
                                r[index + 1] = y1;
                                r[index + 2] = x2;
                                r[index + 3] = y2;
                                y2 = y1;
                                if (j >= elementCount - 1) continue;
                                y1 = (int)((float)y2 - data[i + j + 1] * (float)height);
                            }
                            break;
                        }
                        case 1: {
                            float[] r;
                            int j;
                            for (j = 0; j < elementCount; ++j) {
                                r = this.mProfileShapes[j];
                                r[index] = (float)(x + x2) * 0.5f;
                                r[index + 1] = index == 0 ? (float)y1 : r[index - 1];
                                r[index + 2] = r[index] + (float)width;
                                r[index + 3] = y1;
                                y2 = y1;
                                if (j >= elementCount - 1) continue;
                                y1 = (int)((float)y2 - data[i + j + 1] * (float)height);
                            }
                            break;
                        }
                    }
                    x += width;
                    ++count;
                }
                this.drawGraph(graphType, count);
                this.drawCurrentFrame(graphType, current);
                this.drawThreshold(x += margin, height);
            }
        }

        private void drawGraph(int graphType, int count) {
            block4: for (int i = 0; i < this.mProfileShapes.length; ++i) {
                this.mDebugDataProvider.setupGraphPaint(this.mProfilePaint, i);
                switch (graphType) {
                    case 0: {
                        this.mGlCanvas.drawRects(this.mProfileShapes[i], count * 4, this.mProfilePaint);
                        continue block4;
                    }
                    case 1: {
                        this.mGlCanvas.drawLines(this.mProfileShapes[i], 0, count * 4, this.mProfilePaint);
                    }
                }
            }
        }

        private void drawCurrentFrame(int graphType, int index) {
            if (index >= 0) {
                this.mDebugDataProvider.setupCurrentFramePaint(this.mProfilePaint);
                switch (graphType) {
                    case 0: {
                        this.mGlCanvas.drawRect(this.mProfileShapes[2][index], this.mProfileShapes[2][index + 1], this.mProfileShapes[2][index + 2], this.mProfileShapes[0][index + 3], this.mProfilePaint);
                        break;
                    }
                    case 1: {
                        this.mGlCanvas.drawLine(this.mProfileShapes[2][index], this.mProfileShapes[2][index + 1], this.mProfileShapes[2][index], this.mHeight, this.mProfilePaint);
                    }
                }
            }
        }

        private void drawThreshold(int x, int height) {
            float threshold = this.mDebugDataProvider.getThreshold();
            if (threshold > 0.0f) {
                this.mDebugDataProvider.setupThresholdPaint(this.mProfilePaint);
                int y = (int)((float)this.mHeight - threshold * (float)height);
                this.mGlCanvas.drawLine(0.0f, y, x, y, this.mProfilePaint);
            }
        }

        private void initProfileDrawData(View.AttachInfo attachInfo, GraphDataProvider provider) {
            if (this.mProfileShapes == null) {
                int elementCount = provider.getElementCount();
                int frameCount = provider.getFrameCount();
                this.mProfileShapes = new float[elementCount][];
                for (int i = 0; i < elementCount; ++i) {
                    this.mProfileShapes[i] = new float[frameCount * 4];
                }
                this.mProfilePaint = new Paint();
            }
            this.mProfilePaint.reset();
            if (provider.getGraphType() == 1) {
                this.mProfilePaint.setAntiAlias(true);
            }
            if (this.mDisplayMetrics == null) {
                this.mDisplayMetrics = new DisplayMetrics();
            }
            attachInfo.mDisplay.getMetrics(this.mDisplayMetrics);
            provider.prepare(this.mDisplayMetrics);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void destroy(boolean full) {
            try {
                super.destroy(full);
            }
            finally {
                if (full && this.mGlCanvas != null) {
                    this.mGlCanvas = null;
                }
            }
        }

        void pushLayerUpdate(HardwareLayer layer) {
            this.mGlCanvas.pushLayerUpdate(layer);
        }

        void cancelLayerUpdate(HardwareLayer layer) {
            this.mGlCanvas.cancelLayerUpdate(layer);
        }

        void flushLayerUpdates() {
            this.mGlCanvas.flushLayerUpdates();
        }

        public DisplayList createDisplayList(String name) {
            return new GLES20DisplayList(name);
        }

        HardwareLayer createHardwareLayer(boolean isOpaque) {
            return new GLES20TextureLayer(isOpaque);
        }

        public HardwareLayer createHardwareLayer(int width, int height, boolean isOpaque) {
            return new GLES20RenderLayer(width, height, isOpaque);
        }

        void countOverdraw(HardwareCanvas canvas) {
            ((GLES20Canvas)canvas).setCountOverdrawEnabled(true);
        }

        float getOverdraw(HardwareCanvas canvas) {
            return ((GLES20Canvas)canvas).getOverdraw();
        }

        public SurfaceTexture createSurfaceTexture(HardwareLayer layer) {
            return ((GLES20TextureLayer)layer).getSurfaceTexture();
        }

        void setSurfaceTexture(HardwareLayer layer, SurfaceTexture surfaceTexture) {
            ((GLES20TextureLayer)layer).setSurfaceTexture(surfaceTexture);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean safelyRun(Runnable action) {
            boolean needsContext;
            boolean bl = needsContext = !this.isEnabled() || this.checkRenderContext() == 0;
            if (needsContext) {
                Gl20RendererEglContext managedContext = (Gl20RendererEglContext)sEglContextStorage.get();
                if (managedContext == null) {
                    return false;
                }
                Gl20Renderer.usePbufferSurface(managedContext.getContext());
            }
            try {
                action.run();
            }
            finally {
                if (needsContext) {
                    sEgl.eglMakeCurrent(sEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                }
            }
            return true;
        }

        void destroyLayers(final View view) {
            if (view != null) {
                this.safelyRun(new Runnable(){

                    public void run() {
                        if (Gl20Renderer.this.mCanvas != null) {
                            Gl20Renderer.this.mCanvas.clearLayerUpdates();
                        }
                        Gl20Renderer.destroyHardwareLayer(view);
                        GLES20Canvas.flushCaches(0);
                    }
                });
            }
        }

        private static void destroyHardwareLayer(View view) {
            view.destroyLayer(true);
            if (view instanceof ViewGroup) {
                ViewGroup group = (ViewGroup)view;
                int count = group.getChildCount();
                for (int i = 0; i < count; ++i) {
                    Gl20Renderer.destroyHardwareLayer(group.getChildAt(i));
                }
            }
        }

        void destroyHardwareResources(final View view) {
            if (view != null) {
                this.safelyRun(new Runnable(){

                    public void run() {
                        if (Gl20Renderer.this.mCanvas != null) {
                            Gl20Renderer.this.mCanvas.clearLayerUpdates();
                        }
                        Gl20Renderer.destroyResources(view);
                        GLES20Canvas.flushCaches(0);
                    }
                });
            }
        }

        private static void destroyResources(View view) {
            view.destroyHardwareResources();
            if (view instanceof ViewGroup) {
                ViewGroup group = (ViewGroup)view;
                int count = group.getChildCount();
                for (int i = 0; i < count; ++i) {
                    Gl20Renderer.destroyResources(group.getChildAt(i));
                }
            }
        }

        static HardwareRenderer create(boolean translucent) {
            if (GLES20Canvas.isAvailable()) {
                return new Gl20Renderer(translucent);
            }
            return null;
        }

        static void startTrimMemory(int level) {
            if (sEgl == null || sEglConfig == null) {
                return;
            }
            Gl20RendererEglContext managedContext = (Gl20RendererEglContext)sEglContextStorage.get();
            if (managedContext == null) {
                return;
            }
            Gl20Renderer.usePbufferSurface(managedContext.getContext());
            if (level >= 80) {
                GLES20Canvas.flushCaches(2);
            } else if (level >= 20) {
                GLES20Canvas.flushCaches(1);
            }
        }

        static void endTrimMemory() {
            if (sEgl != null && sEglDisplay != null) {
                sEgl.eglMakeCurrent(sEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void usePbufferSurface(EGLContext eglContext) {
            Object[] objectArray = sPbufferLock;
            synchronized (sPbufferLock) {
                if (sPbuffer == null) {
                    sPbuffer = sEgl.eglCreatePbufferSurface(sEglDisplay, sEglConfig, new int[]{12375, 1, 12374, 1, 12344});
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                sEgl.eglMakeCurrent(sEglDisplay, sPbuffer, sPbuffer, eglContext);
                return;
            }
        }

        static {
            sPbufferLock = new Object[0];
        }

        static class Gl20RendererEglContext
        extends ManagedEGLContext {
            final Handler mHandler = new Handler();

            public Gl20RendererEglContext(EGLContext context) {
                super(context);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTerminate(final EGLContext eglContext) {
                if (this.mHandler.getLooper() != Looper.myLooper()) {
                    this.mHandler.post(new Runnable(){

                        public void run() {
                            Gl20RendererEglContext.this.onTerminate(eglContext);
                        }
                    });
                    return;
                }
                Object[] objectArray = GlRenderer.sEglLock;
                synchronized (GlRenderer.sEglLock) {
                    if (GlRenderer.sEgl == null) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                    if (EGLImpl.getInitCount(GlRenderer.sEglDisplay) == 1) {
                        Gl20Renderer.usePbufferSurface(eglContext);
                        GLES20Canvas.terminateCaches();
                        GlRenderer.sEgl.eglDestroyContext(GlRenderer.sEglDisplay, eglContext);
                        GlRenderer.sEglContextStorage.set(null);
                        GlRenderer.sEglContextStorage.remove();
                        GlRenderer.sEgl.eglDestroySurface(GlRenderer.sEglDisplay, sPbuffer);
                        GlRenderer.sEgl.eglMakeCurrent(GlRenderer.sEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                        GlRenderer.sEgl.eglReleaseThread();
                        GlRenderer.sEgl.eglTerminate(GlRenderer.sEglDisplay);
                        GlRenderer.sEgl = null;
                        GlRenderer.sEglDisplay = null;
                        GlRenderer.sEglConfig = null;
                        sPbuffer = null;
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        }
    }

    static abstract class GlRenderer
    extends HardwareRenderer {
        static final int SURFACE_STATE_ERROR = 0;
        static final int SURFACE_STATE_SUCCESS = 1;
        static final int SURFACE_STATE_UPDATED = 2;
        static final int FUNCTOR_PROCESS_DELAY = 4;
        private static final int PROFILE_DRAW_MARGIN = 0;
        private static final int PROFILE_DRAW_WIDTH = 3;
        private static final int[] PROFILE_DRAW_COLORS = new int[]{-817994036, -807651054, -806971392};
        private static final int PROFILE_DRAW_CURRENT_FRAME_COLOR = -815814067;
        private static final int PROFILE_DRAW_THRESHOLD_COLOR = -10507699;
        private static final int PROFILE_DRAW_THRESHOLD_STROKE_WIDTH = 2;
        private static final int PROFILE_DRAW_DP_PER_MS = 7;
        private static final String[] VISUALIZERS = new String[]{"visual_bars", "visual_lines"};
        private static final String[] OVERDRAW = new String[]{"show", "count"};
        private static final int OVERDRAW_TYPE_COUNT = 1;
        static EGL10 sEgl;
        static EGLDisplay sEglDisplay;
        static EGLConfig sEglConfig;
        static final Object[] sEglLock;
        int mWidth = -1;
        int mHeight = -1;
        static final ThreadLocal<ManagedEGLContext> sEglContextStorage;
        EGLContext mEglContext;
        Thread mEglThread;
        EGLSurface mEglSurface;
        GL mGl;
        HardwareCanvas mCanvas;
        String mName;
        long mFrameCount;
        Paint mDebugPaint;
        static boolean sDirtyRegions;
        static final boolean sDirtyRegionsRequested;
        boolean mDirtyRegionsEnabled;
        boolean mUpdateDirtyRegions;
        boolean mProfileEnabled;
        int mProfileVisualizerType = -1;
        float[] mProfileData;
        ReentrantLock mProfileLock;
        int mProfileCurrentFrame = -3;
        GraphDataProvider mDebugDataProvider;
        float[][] mProfileShapes;
        Paint mProfilePaint;
        boolean mDebugDirtyRegions;
        int mDebugOverdraw = -1;
        HardwareLayer mDebugOverdrawLayer;
        Paint mDebugOverdrawPaint;
        final int mGlVersion;
        final boolean mTranslucent;
        private boolean mDestroyed;
        private final Rect mRedrawClip = new Rect();
        private final int[] mSurfaceSize = new int[2];
        private final FunctorsRunnable mFunctorsRunnable = new FunctorsRunnable();
        private long mDrawDelta = Long.MAX_VALUE;

        GlRenderer(int glVersion, boolean translucent) {
            this.mGlVersion = glVersion;
            this.mTranslucent = translucent;
            this.loadSystemProperties(null);
        }

        boolean loadSystemProperties(Surface surface) {
            String overdraw;
            int debugOverdraw;
            boolean value;
            boolean changed = false;
            String profiling = SystemProperties.get(HardwareRenderer.PROFILE_PROPERTY);
            int graphType = GlRenderer.search(VISUALIZERS, profiling);
            boolean bl = value = graphType >= 0;
            if (graphType != this.mProfileVisualizerType) {
                changed = true;
                this.mProfileVisualizerType = graphType;
                this.mProfileShapes = null;
                this.mProfilePaint = null;
                this.mDebugDataProvider = value ? new DrawPerformanceDataProvider(graphType) : null;
            }
            if (!value) {
                value = Boolean.parseBoolean(profiling);
            }
            if (value != this.mProfileEnabled) {
                changed = true;
                this.mProfileEnabled = value;
                if (this.mProfileEnabled) {
                    Log.d(HardwareRenderer.LOG_TAG, "Profiling hardware renderer");
                    int maxProfileFrames = SystemProperties.getInt(HardwareRenderer.PROFILE_MAXFRAMES_PROPERTY, 128);
                    this.mProfileData = new float[maxProfileFrames * 3];
                    for (int i = 0; i < this.mProfileData.length; i += 3) {
                        this.mProfileData[i + 2] = -1.0f;
                        this.mProfileData[i + 1] = -1.0f;
                        this.mProfileData[i] = -1.0f;
                    }
                    this.mProfileLock = new ReentrantLock();
                } else {
                    this.mProfileData = null;
                    this.mProfileLock = null;
                    this.mProfileVisualizerType = -1;
                }
                this.mProfileCurrentFrame = -3;
            }
            if ((value = SystemProperties.getBoolean(HardwareRenderer.DEBUG_DIRTY_REGIONS_PROPERTY, false)) != this.mDebugDirtyRegions) {
                changed = true;
                this.mDebugDirtyRegions = value;
                if (this.mDebugDirtyRegions) {
                    Log.d(HardwareRenderer.LOG_TAG, "Debugging dirty regions");
                }
            }
            if ((debugOverdraw = GlRenderer.search(OVERDRAW, overdraw = SystemProperties.get(HardwareRenderer.DEBUG_OVERDRAW_PROPERTY))) != this.mDebugOverdraw) {
                changed = true;
                this.mDebugOverdraw = debugOverdraw;
                if (this.mDebugOverdraw != 1 && this.mDebugOverdrawLayer != null) {
                    this.mDebugOverdrawLayer.destroy();
                    this.mDebugOverdrawLayer = null;
                    this.mDebugOverdrawPaint = null;
                }
            }
            if (HardwareRenderer.nLoadProperties()) {
                changed = true;
            }
            return changed;
        }

        private static int search(String[] values, String value) {
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].equals(value)) continue;
                return i;
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dumpGfxInfo(PrintWriter pw) {
            if (this.mProfileEnabled) {
                pw.printf("\n\tDraw\tProcess\tExecute\n", new Object[0]);
                this.mProfileLock.lock();
                try {
                    for (int i = 0; i < this.mProfileData.length && !(this.mProfileData[i] < 0.0f); i += 3) {
                        pw.printf("\t%3.2f\t%3.2f\t%3.2f\n", Float.valueOf(this.mProfileData[i]), Float.valueOf(this.mProfileData[i + 1]), Float.valueOf(this.mProfileData[i + 2]));
                        this.mProfileData[i + 2] = -1.0f;
                        this.mProfileData[i + 1] = -1.0f;
                        this.mProfileData[i] = -1.0f;
                    }
                    this.mProfileCurrentFrame = this.mProfileData.length;
                }
                finally {
                    this.mProfileLock.unlock();
                }
            }
        }

        long getFrameCount() {
            return this.mFrameCount;
        }

        boolean hasDirtyRegions() {
            return this.mDirtyRegionsEnabled;
        }

        void checkEglErrors() {
            if (this.isEnabled()) {
                this.checkEglErrorsForced();
            }
        }

        private void checkEglErrorsForced() {
            int error = sEgl.eglGetError();
            if (error != 12288) {
                Log.w(HardwareRenderer.LOG_TAG, "EGL error: " + GLUtils.getEGLErrorString(error));
                this.fallback(error != 12302);
            }
        }

        private void fallback(boolean fallback) {
            this.destroy(true);
            if (fallback) {
                this.setRequested(false);
                Log.w(HardwareRenderer.LOG_TAG, "Mountain View, we've had a problem here. Switching back to software rendering.");
            }
        }

        boolean initialize(Surface surface) throws Surface.OutOfResourcesException {
            if (this.isRequested() && !this.isEnabled()) {
                boolean contextCreated = this.initializeEgl();
                this.mGl = this.createEglSurface(surface);
                this.mDestroyed = false;
                if (this.mGl != null) {
                    int err = sEgl.eglGetError();
                    if (err != 12288) {
                        this.destroy(true);
                        this.setRequested(false);
                    } else {
                        if (this.mCanvas == null) {
                            this.mCanvas = this.createCanvas();
                            this.mCanvas.setName(this.mName);
                        }
                        this.setEnabled(true);
                        if (contextCreated) {
                            this.initAtlas();
                        }
                    }
                    return this.mCanvas != null;
                }
            }
            return false;
        }

        void updateSurface(Surface surface) throws Surface.OutOfResourcesException {
            if (this.isRequested() && this.isEnabled()) {
                this.createEglSurface(surface);
            }
        }

        abstract HardwareCanvas createCanvas();

        abstract int[] getConfig(boolean var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean initializeEgl() {
            Object[] objectArray = sEglLock;
            synchronized (sEglLock) {
                if (sEgl == null && sEglConfig == null) {
                    sEgl = (EGL10)EGLContext.getEGL();
                    sEglDisplay = sEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
                    if (sEglDisplay == EGL10.EGL_NO_DISPLAY) {
                        throw new RuntimeException("eglGetDisplay failed " + GLUtils.getEGLErrorString(sEgl.eglGetError()));
                    }
                    int[] version = new int[2];
                    if (!sEgl.eglInitialize(sEglDisplay, version)) {
                        throw new RuntimeException("eglInitialize failed " + GLUtils.getEGLErrorString(sEgl.eglGetError()));
                    }
                    this.checkEglErrorsForced();
                    sEglConfig = this.loadEglConfig();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                ManagedEGLContext managedContext = sEglContextStorage.get();
                this.mEglContext = managedContext != null ? managedContext.getContext() : null;
                this.mEglThread = Thread.currentThread();
                if (this.mEglContext == null) {
                    this.mEglContext = this.createContext(sEgl, sEglDisplay, sEglConfig);
                    sEglContextStorage.set(this.createManagedContext(this.mEglContext));
                    return true;
                }
                return false;
            }
        }

        private EGLConfig loadEglConfig() {
            EGLConfig eglConfig = this.chooseEglConfig();
            if (eglConfig == null) {
                if (sDirtyRegions) {
                    sDirtyRegions = false;
                    eglConfig = this.chooseEglConfig();
                    if (eglConfig == null) {
                        throw new RuntimeException("eglConfig not initialized");
                    }
                } else {
                    throw new RuntimeException("eglConfig not initialized");
                }
            }
            return eglConfig;
        }

        abstract ManagedEGLContext createManagedContext(EGLContext var1);

        private EGLConfig chooseEglConfig() {
            EGLConfig[] configs = new EGLConfig[1];
            int[] configsCount = new int[1];
            int[] configSpec = this.getConfig(sDirtyRegions);
            String debug = SystemProperties.get(HardwareRenderer.PRINT_CONFIG_PROPERTY, "");
            if ("all".equalsIgnoreCase(debug)) {
                sEgl.eglChooseConfig(sEglDisplay, configSpec, null, 0, configsCount);
                EGLConfig[] debugConfigs = new EGLConfig[configsCount[0]];
                sEgl.eglChooseConfig(sEglDisplay, configSpec, debugConfigs, configsCount[0], configsCount);
                for (EGLConfig config : debugConfigs) {
                    GlRenderer.printConfig(config);
                }
            }
            if (!sEgl.eglChooseConfig(sEglDisplay, configSpec, configs, 1, configsCount)) {
                throw new IllegalArgumentException("eglChooseConfig failed " + GLUtils.getEGLErrorString(sEgl.eglGetError()));
            }
            if (configsCount[0] > 0) {
                if ("choice".equalsIgnoreCase(debug)) {
                    GlRenderer.printConfig(configs[0]);
                }
                return configs[0];
            }
            return null;
        }

        private static void printConfig(EGLConfig config) {
            int[] value = new int[1];
            Log.d(HardwareRenderer.LOG_TAG, "EGL configuration " + config + ":");
            sEgl.eglGetConfigAttrib(sEglDisplay, config, 12324, value);
            Log.d(HardwareRenderer.LOG_TAG, "  RED_SIZE = " + value[0]);
            sEgl.eglGetConfigAttrib(sEglDisplay, config, 12323, value);
            Log.d(HardwareRenderer.LOG_TAG, "  GREEN_SIZE = " + value[0]);
            sEgl.eglGetConfigAttrib(sEglDisplay, config, 12322, value);
            Log.d(HardwareRenderer.LOG_TAG, "  BLUE_SIZE = " + value[0]);
            sEgl.eglGetConfigAttrib(sEglDisplay, config, 12321, value);
            Log.d(HardwareRenderer.LOG_TAG, "  ALPHA_SIZE = " + value[0]);
            sEgl.eglGetConfigAttrib(sEglDisplay, config, 12325, value);
            Log.d(HardwareRenderer.LOG_TAG, "  DEPTH_SIZE = " + value[0]);
            sEgl.eglGetConfigAttrib(sEglDisplay, config, 12326, value);
            Log.d(HardwareRenderer.LOG_TAG, "  STENCIL_SIZE = " + value[0]);
            sEgl.eglGetConfigAttrib(sEglDisplay, config, 12338, value);
            Log.d(HardwareRenderer.LOG_TAG, "  SAMPLE_BUFFERS = " + value[0]);
            sEgl.eglGetConfigAttrib(sEglDisplay, config, 12337, value);
            Log.d(HardwareRenderer.LOG_TAG, "  SAMPLES = " + value[0]);
            sEgl.eglGetConfigAttrib(sEglDisplay, config, 12339, value);
            Log.d(HardwareRenderer.LOG_TAG, "  SURFACE_TYPE = 0x" + Integer.toHexString(value[0]));
            sEgl.eglGetConfigAttrib(sEglDisplay, config, 12327, value);
            Log.d(HardwareRenderer.LOG_TAG, "  CONFIG_CAVEAT = 0x" + Integer.toHexString(value[0]));
        }

        GL createEglSurface(Surface surface) throws Surface.OutOfResourcesException {
            if (sEgl == null) {
                throw new RuntimeException("egl not initialized");
            }
            if (sEglDisplay == null) {
                throw new RuntimeException("eglDisplay not initialized");
            }
            if (sEglConfig == null) {
                throw new RuntimeException("eglConfig not initialized");
            }
            if (Thread.currentThread() != this.mEglThread) {
                throw new IllegalStateException("HardwareRenderer cannot be used from multiple threads");
            }
            this.destroySurface();
            if (!this.createSurface(surface)) {
                return null;
            }
            this.initCaches();
            return this.mEglContext.getGL();
        }

        private void enableDirtyRegions() {
            if (sDirtyRegions) {
                this.mDirtyRegionsEnabled = GlRenderer.preserveBackBuffer();
                if (!this.mDirtyRegionsEnabled) {
                    Log.w(HardwareRenderer.LOG_TAG, "Backbuffer cannot be preserved");
                }
            } else if (sDirtyRegionsRequested) {
                this.mDirtyRegionsEnabled = GlRenderer.isBackBufferPreserved();
            }
        }

        abstract void initCaches();

        abstract void initAtlas();

        EGLContext createContext(EGL10 egl, EGLDisplay eglDisplay, EGLConfig eglConfig) {
            int[] attribs = new int[]{12440, this.mGlVersion, 12344};
            EGLContext context = egl.eglCreateContext(eglDisplay, eglConfig, EGL10.EGL_NO_CONTEXT, (int[])(this.mGlVersion != 0 ? attribs : null));
            if (context == null || context == EGL10.EGL_NO_CONTEXT) {
                throw new IllegalStateException("Could not create an EGL context. eglCreateContext failed with error: " + GLUtils.getEGLErrorString(sEgl.eglGetError()));
            }
            return context;
        }

        void destroy(boolean full) {
            if (full && this.mCanvas != null) {
                this.mCanvas = null;
            }
            if (!this.isEnabled() || this.mDestroyed) {
                this.setEnabled(false);
                return;
            }
            this.destroySurface();
            this.setEnabled(false);
            this.mDestroyed = true;
            this.mGl = null;
        }

        void destroySurface() {
            if (this.mEglSurface != null && this.mEglSurface != EGL10.EGL_NO_SURFACE) {
                if (this.mEglSurface.equals(sEgl.eglGetCurrentSurface(12377))) {
                    sEgl.eglMakeCurrent(sEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                }
                sEgl.eglDestroySurface(sEglDisplay, this.mEglSurface);
                this.mEglSurface = null;
            }
        }

        void invalidate(Surface surface) {
            sEgl.eglMakeCurrent(sEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
            if (this.mEglSurface != null && this.mEglSurface != EGL10.EGL_NO_SURFACE) {
                sEgl.eglDestroySurface(sEglDisplay, this.mEglSurface);
                this.mEglSurface = null;
                this.setEnabled(false);
            }
            if (surface.isValid()) {
                if (!this.createSurface(surface)) {
                    return;
                }
                this.mUpdateDirtyRegions = true;
                if (this.mCanvas != null) {
                    this.setEnabled(true);
                }
            }
        }

        private boolean createSurface(Surface surface) {
            this.mEglSurface = sEgl.eglCreateWindowSurface(sEglDisplay, sEglConfig, surface, null);
            if (this.mEglSurface == null || this.mEglSurface == EGL10.EGL_NO_SURFACE) {
                int error = sEgl.eglGetError();
                if (error == 12299) {
                    Log.e(HardwareRenderer.LOG_TAG, "createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
                    return false;
                }
                throw new RuntimeException("createWindowSurface failed " + GLUtils.getEGLErrorString(error));
            }
            if (!sEgl.eglMakeCurrent(sEglDisplay, this.mEglSurface, this.mEglSurface, this.mEglContext)) {
                throw new IllegalStateException("eglMakeCurrent failed " + GLUtils.getEGLErrorString(sEgl.eglGetError()));
            }
            this.enableDirtyRegions();
            return true;
        }

        boolean validate() {
            return this.checkRenderContext() != 0;
        }

        void setup(int width, int height) {
            if (this.validate()) {
                this.mCanvas.setViewport(width, height);
                this.mWidth = width;
                this.mHeight = height;
            }
        }

        int getWidth() {
            return this.mWidth;
        }

        int getHeight() {
            return this.mHeight;
        }

        HardwareCanvas getCanvas() {
            return this.mCanvas;
        }

        void setName(String name) {
            this.mName = name;
        }

        boolean canDraw() {
            return this.mGl != null && this.mCanvas != null;
        }

        int onPreDraw(Rect dirty) {
            return 0;
        }

        void onPostDraw() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void draw(View view, View.AttachInfo attachInfo, HardwareDrawCallbacks callbacks, Rect dirty) {
            if (this.canDraw()) {
                if (!this.hasDirtyRegions()) {
                    dirty = null;
                }
                attachInfo.mIgnoreDirtyState = true;
                attachInfo.mDrawingTime = SystemClock.uptimeMillis();
                view.mPrivateFlags |= 0x20;
                int surfaceState = this.checkRenderContextUnsafe();
                if (surfaceState != 0) {
                    HardwareCanvas canvas;
                    attachInfo.mHardwareCanvas = canvas = this.mCanvas;
                    if (this.mProfileEnabled) {
                        this.mProfileLock.lock();
                    }
                    dirty = this.beginFrame(canvas, dirty, surfaceState);
                    DisplayList displayList = this.buildDisplayList(view, canvas);
                    if (this.checkRenderContextUnsafe() == 0) {
                        return;
                    }
                    int saveCount = 0;
                    int status = 0;
                    long start = GlRenderer.getSystemTime();
                    try {
                        status = this.prepareFrame(dirty);
                        saveCount = canvas.save();
                        callbacks.onHardwarePreDraw(canvas);
                        if (displayList != null) {
                            status |= this.drawDisplayList(attachInfo, canvas, displayList, status);
                        } else {
                            view.draw(canvas);
                        }
                    }
                    catch (Exception e) {
                        Log.e(HardwareRenderer.LOG_TAG, "An error has occurred while drawing:", e);
                    }
                    finally {
                        callbacks.onHardwarePostDraw(canvas);
                        canvas.restoreToCount(saveCount);
                        view.mRecreateDisplayList = false;
                        this.mDrawDelta = GlRenderer.getSystemTime() - start;
                        if (this.mDrawDelta > 0L) {
                            ++this.mFrameCount;
                            this.debugOverdraw(attachInfo, dirty, canvas, displayList);
                            this.debugDirtyRegions(dirty, canvas);
                            this.drawProfileData(attachInfo);
                        }
                    }
                    this.onPostDraw();
                    this.swapBuffers(status);
                    if (this.mProfileEnabled) {
                        this.mProfileLock.unlock();
                    }
                    attachInfo.mIgnoreDirtyState = false;
                }
            }
        }

        abstract void countOverdraw(HardwareCanvas var1);

        abstract float getOverdraw(HardwareCanvas var1);

        private void debugOverdraw(View.AttachInfo attachInfo, Rect dirty, HardwareCanvas canvas, DisplayList displayList) {
            if (this.mDebugOverdraw == 1) {
                if (this.mDebugOverdrawLayer == null) {
                    this.mDebugOverdrawLayer = this.createHardwareLayer(this.mWidth, this.mHeight, true);
                } else if (this.mDebugOverdrawLayer.getWidth() != this.mWidth || this.mDebugOverdrawLayer.getHeight() != this.mHeight) {
                    this.mDebugOverdrawLayer.resize(this.mWidth, this.mHeight);
                }
                if (!this.mDebugOverdrawLayer.isValid()) {
                    this.mDebugOverdraw = -1;
                    return;
                }
                HardwareCanvas layerCanvas = this.mDebugOverdrawLayer.start(canvas, dirty);
                this.countOverdraw(layerCanvas);
                int restoreCount = layerCanvas.save();
                layerCanvas.drawDisplayList(displayList, null, 1);
                layerCanvas.restoreToCount(restoreCount);
                this.mDebugOverdrawLayer.end(canvas);
                float overdraw = this.getOverdraw(layerCanvas);
                DisplayMetrics metrics = attachInfo.mRootView.getResources().getDisplayMetrics();
                this.drawOverdrawCounter(canvas, overdraw, metrics.density);
            }
        }

        private void drawOverdrawCounter(HardwareCanvas canvas, float overdraw, float density) {
            String text = String.format("%.2fx", Float.valueOf(overdraw));
            Paint paint = this.setupPaint(density);
            paint.setColor(Color.HSBtoColor(0.28f - 0.28f * overdraw / 3.5f, 0.8f, 1.0f));
            canvas.drawText(text, density * 4.0f, (float)this.mHeight - paint.getFontMetrics().bottom, paint);
        }

        private Paint setupPaint(float density) {
            if (this.mDebugOverdrawPaint == null) {
                this.mDebugOverdrawPaint = new Paint();
                this.mDebugOverdrawPaint.setAntiAlias(true);
                this.mDebugOverdrawPaint.setShadowLayer(density * 3.0f, 0.0f, 0.0f, -16777216);
                this.mDebugOverdrawPaint.setTextSize(density * 20.0f);
            }
            return this.mDebugOverdrawPaint;
        }

        private DisplayList buildDisplayList(View view, HardwareCanvas canvas) {
            if (this.mDrawDelta <= 0L) {
                return view.mDisplayList;
            }
            view.mRecreateDisplayList = (view.mPrivateFlags & Integer.MIN_VALUE) == Integer.MIN_VALUE;
            view.mPrivateFlags &= Integer.MAX_VALUE;
            long buildDisplayListStartTime = this.startBuildDisplayListProfiling();
            canvas.clearLayerUpdates();
            Trace.traceBegin(8L, "getDisplayList");
            DisplayList displayList = view.getDisplayList();
            Trace.traceEnd(8L);
            this.endBuildDisplayListProfiling(buildDisplayListStartTime);
            return displayList;
        }

        abstract void drawProfileData(View.AttachInfo var1);

        private Rect beginFrame(HardwareCanvas canvas, Rect dirty, int surfaceState) {
            if (surfaceState == 2) {
                dirty = null;
                GlRenderer.beginFrame(null);
            } else {
                int[] size = this.mSurfaceSize;
                GlRenderer.beginFrame(size);
                if (size[1] != this.mHeight || size[0] != this.mWidth) {
                    this.mWidth = size[0];
                    this.mHeight = size[1];
                    canvas.setViewport(this.mWidth, this.mHeight);
                    dirty = null;
                }
            }
            if (this.mDebugDataProvider != null) {
                dirty = null;
            }
            return dirty;
        }

        private long startBuildDisplayListProfiling() {
            if (this.mProfileEnabled) {
                this.mProfileCurrentFrame += 3;
                if (this.mProfileCurrentFrame >= this.mProfileData.length) {
                    this.mProfileCurrentFrame = 0;
                }
                return System.nanoTime();
            }
            return 0L;
        }

        private void endBuildDisplayListProfiling(long getDisplayListStartTime) {
            if (this.mProfileEnabled) {
                float total;
                long now = System.nanoTime();
                this.mProfileData[this.mProfileCurrentFrame] = total = (float)(now - getDisplayListStartTime) * 1.0E-6f;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int prepareFrame(Rect dirty) {
            int status;
            Trace.traceBegin(8L, "prepareFrame");
            try {
                status = this.onPreDraw(dirty);
            }
            finally {
                Trace.traceEnd(8L);
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int drawDisplayList(View.AttachInfo attachInfo, HardwareCanvas canvas, DisplayList displayList, int status) {
            long drawDisplayListStartTime = 0L;
            if (this.mProfileEnabled) {
                drawDisplayListStartTime = System.nanoTime();
            }
            Trace.traceBegin(8L, "drawDisplayList");
            try {
                status |= canvas.drawDisplayList(displayList, this.mRedrawClip, 1);
            }
            finally {
                Trace.traceEnd(8L);
            }
            if (this.mProfileEnabled) {
                float total;
                long now = System.nanoTime();
                this.mProfileData[this.mProfileCurrentFrame + 1] = total = (float)(now - drawDisplayListStartTime) * 1.0E-6f;
            }
            this.handleFunctorStatus(attachInfo, status);
            return status;
        }

        private void swapBuffers(int status) {
            if ((status & 4) == 4) {
                long eglSwapBuffersStartTime = 0L;
                if (this.mProfileEnabled) {
                    eglSwapBuffersStartTime = System.nanoTime();
                }
                sEgl.eglSwapBuffers(sEglDisplay, this.mEglSurface);
                if (this.mProfileEnabled) {
                    float total;
                    long now = System.nanoTime();
                    this.mProfileData[this.mProfileCurrentFrame + 2] = total = (float)(now - eglSwapBuffersStartTime) * 1.0E-6f;
                }
                this.checkEglErrors();
            }
        }

        private void debugDirtyRegions(Rect dirty, HardwareCanvas canvas) {
            if (this.mDebugDirtyRegions) {
                if (this.mDebugPaint == null) {
                    this.mDebugPaint = new Paint();
                    this.mDebugPaint.setColor(0x7FFF0000);
                }
                if (dirty != null && (this.mFrameCount & 1L) == 0L) {
                    canvas.drawRect(dirty, this.mDebugPaint);
                }
            }
        }

        private void handleFunctorStatus(View.AttachInfo attachInfo, int status) {
            if ((status & 1) != 0) {
                if (this.mRedrawClip.isEmpty()) {
                    attachInfo.mViewRootImpl.invalidate();
                } else {
                    attachInfo.mViewRootImpl.invalidateChildInParent(null, this.mRedrawClip);
                    this.mRedrawClip.setEmpty();
                }
            }
            if ((status & 2) != 0 || attachInfo.mHandler.hasCallbacks(this.mFunctorsRunnable)) {
                attachInfo.mHandler.removeCallbacks(this.mFunctorsRunnable);
                this.mFunctorsRunnable.attachInfo = attachInfo;
                attachInfo.mHandler.postDelayed(this.mFunctorsRunnable, 4L);
            }
        }

        void detachFunctor(int functor) {
            if (this.mCanvas != null) {
                this.mCanvas.detachFunctor(functor);
            }
        }

        boolean attachFunctor(View.AttachInfo attachInfo, int functor) {
            if (this.mCanvas != null) {
                this.mCanvas.attachFunctor(functor);
                this.mFunctorsRunnable.attachInfo = attachInfo;
                attachInfo.mHandler.removeCallbacks(this.mFunctorsRunnable);
                attachInfo.mHandler.postDelayed(this.mFunctorsRunnable, 0L);
                return true;
            }
            return false;
        }

        int checkRenderContext() {
            if (this.mEglThread != Thread.currentThread()) {
                throw new IllegalStateException("Hardware acceleration can only be used with a single UI thread.\nOriginal thread: " + this.mEglThread + "\n" + "Current thread: " + Thread.currentThread());
            }
            return this.checkRenderContextUnsafe();
        }

        private int checkRenderContextUnsafe() {
            if (!this.mEglSurface.equals(sEgl.eglGetCurrentSurface(12377)) || !this.mEglContext.equals(sEgl.eglGetCurrentContext())) {
                if (!sEgl.eglMakeCurrent(sEglDisplay, this.mEglSurface, this.mEglSurface, this.mEglContext)) {
                    Log.e(HardwareRenderer.LOG_TAG, "eglMakeCurrent failed " + GLUtils.getEGLErrorString(sEgl.eglGetError()));
                    this.fallback(true);
                    return 0;
                }
                if (this.mUpdateDirtyRegions) {
                    this.enableDirtyRegions();
                    this.mUpdateDirtyRegions = false;
                }
                return 2;
            }
            return 1;
        }

        private static int dpToPx(int dp, float density) {
            return (int)((float)dp * density + 0.5f);
        }

        static {
            sEglLock = new Object[0];
            sEglContextStorage = new ThreadLocal();
            String dirtyProperty = SystemProperties.get(HardwareRenderer.RENDER_DIRTY_REGIONS_PROPERTY, "true");
            sDirtyRegionsRequested = sDirtyRegions = "true".equalsIgnoreCase(dirtyProperty);
        }

        class DrawPerformanceDataProvider
        extends GraphDataProvider {
            private final int mGraphType;
            private int mVerticalUnit;
            private int mHorizontalUnit;
            private int mHorizontalMargin;
            private int mThresholdStroke;

            DrawPerformanceDataProvider(int graphType) {
                this.mGraphType = graphType;
            }

            void prepare(DisplayMetrics metrics) {
                float density = metrics.density;
                this.mVerticalUnit = GlRenderer.dpToPx(7, density);
                this.mHorizontalUnit = GlRenderer.dpToPx(3, density);
                this.mHorizontalMargin = GlRenderer.dpToPx(0, density);
                this.mThresholdStroke = GlRenderer.dpToPx(2, density);
            }

            int getGraphType() {
                return this.mGraphType;
            }

            int getVerticalUnitSize() {
                return this.mVerticalUnit;
            }

            int getHorizontalUnitSize() {
                return this.mHorizontalUnit;
            }

            int getHorizontaUnitMargin() {
                return this.mHorizontalMargin;
            }

            float[] getData() {
                return GlRenderer.this.mProfileData;
            }

            float getThreshold() {
                return 16.0f;
            }

            int getFrameCount() {
                return GlRenderer.this.mProfileData.length / 3;
            }

            int getElementCount() {
                return 3;
            }

            int getCurrentFrame() {
                return GlRenderer.this.mProfileCurrentFrame / 3;
            }

            void setupGraphPaint(Paint paint, int elementIndex) {
                paint.setColor(PROFILE_DRAW_COLORS[elementIndex]);
                if (this.mGraphType == 1) {
                    paint.setStrokeWidth(this.mThresholdStroke);
                }
            }

            void setupThresholdPaint(Paint paint) {
                paint.setColor(-10507699);
                paint.setStrokeWidth(this.mThresholdStroke);
            }

            void setupCurrentFramePaint(Paint paint) {
                paint.setColor(-815814067);
                if (this.mGraphType == 1) {
                    paint.setStrokeWidth(this.mThresholdStroke);
                }
            }
        }

        class FunctorsRunnable
        implements Runnable {
            View.AttachInfo attachInfo;

            FunctorsRunnable() {
            }

            public void run() {
                HardwareRenderer renderer = this.attachInfo.mHardwareRenderer;
                if (renderer == null || !renderer.isEnabled() || renderer != GlRenderer.this) {
                    return;
                }
                if (GlRenderer.this.checkRenderContext() != 0) {
                    int status = GlRenderer.this.mCanvas.invokeFunctors(GlRenderer.this.mRedrawClip);
                    GlRenderer.this.handleFunctorStatus(this.attachInfo, status);
                }
            }
        }
    }

    abstract class GraphDataProvider {
        public static final int GRAPH_TYPE_BARS = 0;
        public static final int GRAPH_TYPE_LINES = 1;

        GraphDataProvider() {
        }

        abstract int getGraphType();

        abstract void prepare(DisplayMetrics var1);

        abstract int getVerticalUnitSize();

        abstract int getHorizontalUnitSize();

        abstract int getHorizontaUnitMargin();

        abstract float getThreshold();

        abstract float[] getData();

        abstract int getFrameCount();

        abstract int getElementCount();

        abstract int getCurrentFrame();

        abstract void setupGraphPaint(Paint var1, int var2);

        abstract void setupThresholdPaint(Paint var1);

        abstract void setupCurrentFramePaint(Paint var1);
    }

    static interface HardwareDrawCallbacks {
        public void onHardwarePreDraw(HardwareCanvas var1);

        public void onHardwarePostDraw(HardwareCanvas var1);
    }
}

