/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.RectEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.transition.Transition;
import android.transition.TransitionValues;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOverlay;
import java.util.Map;

public class Crossfade
extends Transition {
    private static final String LOG_TAG = "Crossfade";
    private static final String PROPNAME_BITMAP = "android:crossfade:bitmap";
    private static final String PROPNAME_DRAWABLE = "android:crossfade:drawable";
    private static final String PROPNAME_BOUNDS = "android:crossfade:bounds";
    private static RectEvaluator sRectEvaluator = new RectEvaluator();
    private int mFadeBehavior = 1;
    private int mResizeBehavior = 1;
    public static final int FADE_BEHAVIOR_CROSSFADE = 0;
    public static final int FADE_BEHAVIOR_REVEAL = 1;
    public static final int FADE_BEHAVIOR_OUT_IN = 2;
    public static final int RESIZE_BEHAVIOR_NONE = 0;
    public static final int RESIZE_BEHAVIOR_SCALE = 1;

    public Crossfade setFadeBehavior(int fadeBehavior) {
        if (fadeBehavior >= 0 && fadeBehavior <= 2) {
            this.mFadeBehavior = fadeBehavior;
        }
        return this;
    }

    public int getFadeBehavior() {
        return this.mFadeBehavior;
    }

    public Crossfade setResizeBehavior(int resizeBehavior) {
        if (resizeBehavior >= 0 && resizeBehavior <= 1) {
            this.mResizeBehavior = resizeBehavior;
        }
        return this;
    }

    public int getResizeBehavior() {
        return this.mResizeBehavior;
    }

    public Animator createAnimator(ViewGroup sceneRoot, TransitionValues startValues, TransitionValues endValues) {
        if (startValues == null || endValues == null) {
            return null;
        }
        final boolean useParentOverlay = this.mFadeBehavior != 1;
        final View view = endValues.view;
        Map<String, Object> startVals = startValues.values;
        Map<String, Object> endVals = endValues.values;
        Rect startBounds = (Rect)startVals.get(PROPNAME_BOUNDS);
        Rect endBounds = (Rect)endVals.get(PROPNAME_BOUNDS);
        Bitmap startBitmap = (Bitmap)startVals.get(PROPNAME_BITMAP);
        Bitmap endBitmap = (Bitmap)endVals.get(PROPNAME_BITMAP);
        final BitmapDrawable startDrawable = (BitmapDrawable)startVals.get(PROPNAME_DRAWABLE);
        final BitmapDrawable endDrawable = (BitmapDrawable)endVals.get(PROPNAME_DRAWABLE);
        if (startDrawable != null && endDrawable != null && !startBitmap.sameAs(endBitmap)) {
            ViewOverlay overlay;
            ViewOverlay viewOverlay = overlay = useParentOverlay ? ((ViewGroup)view.getParent()).getOverlay() : view.getOverlay();
            if (this.mFadeBehavior == 1) {
                overlay.add(endDrawable);
            }
            overlay.add(startDrawable);
            ObjectAnimator anim2 = this.mFadeBehavior == 2 ? ObjectAnimator.ofInt(startDrawable, "alpha", 255, 0, 0) : ObjectAnimator.ofInt(startDrawable, "alpha", 0);
            anim2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    view.invalidate(startDrawable.getBounds());
                }
            });
            ObjectAnimator anim1 = null;
            if (this.mFadeBehavior == 2) {
                anim1 = ObjectAnimator.ofFloat(view, View.ALPHA, 0.0f, 0.0f, 1.0f);
            } else if (this.mFadeBehavior == 0) {
                anim1 = ObjectAnimator.ofFloat(view, View.ALPHA, 0.0f, 1.0f);
            }
            anim2.addListener(new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    ViewOverlay overlay = useParentOverlay ? ((ViewGroup)view.getParent()).getOverlay() : view.getOverlay();
                    overlay.remove(startDrawable);
                    if (Crossfade.this.mFadeBehavior == 1) {
                        overlay.remove(endDrawable);
                    }
                }
            });
            AnimatorSet set = new AnimatorSet();
            set.playTogether(anim2);
            if (anim1 != null) {
                set.playTogether(anim1);
            }
            if (this.mResizeBehavior == 1 && !startBounds.equals(endBounds)) {
                ObjectAnimator anim22 = ObjectAnimator.ofObject(startDrawable, "bounds", (TypeEvaluator)sRectEvaluator, startBounds, endBounds);
                set.playTogether(anim22);
                if (this.mResizeBehavior == 1) {
                    ObjectAnimator anim3 = ObjectAnimator.ofObject(endDrawable, "bounds", (TypeEvaluator)sRectEvaluator, startBounds, endBounds);
                    set.playTogether(anim3);
                }
            }
            return set;
        }
        return null;
    }

    private void captureValues(TransitionValues transitionValues) {
        View view = transitionValues.view;
        Rect bounds = new Rect(0, 0, view.getWidth(), view.getHeight());
        if (this.mFadeBehavior != 1) {
            bounds.offset(view.getLeft(), view.getTop());
        }
        transitionValues.values.put(PROPNAME_BOUNDS, bounds);
        Bitmap bitmap = Bitmap.createBitmap(view.getWidth(), view.getHeight(), Bitmap.Config.ARGB_8888);
        if (view instanceof TextureView) {
            bitmap = ((TextureView)view).getBitmap();
        } else {
            Canvas c = new Canvas(bitmap);
            view.draw(c);
        }
        transitionValues.values.put(PROPNAME_BITMAP, bitmap);
        BitmapDrawable drawable2 = new BitmapDrawable(bitmap);
        drawable2.setBounds(bounds);
        transitionValues.values.put(PROPNAME_DRAWABLE, drawable2);
    }

    public void captureStartValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    public void captureEndValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }
}

