/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.os.ConditionVariable;
import android.speech.tts.PlaybackQueueItem;
import android.speech.tts.TextToSpeechService;

class SilencePlaybackQueueItem
extends PlaybackQueueItem {
    private final ConditionVariable mCondVar = new ConditionVariable();
    private final long mSilenceDurationMs;

    SilencePlaybackQueueItem(TextToSpeechService.UtteranceProgressDispatcher dispatcher, Object callerIdentity, long silenceDurationMs) {
        super(dispatcher, callerIdentity);
        this.mSilenceDurationMs = silenceDurationMs;
    }

    public void run() {
        this.getDispatcher().dispatchOnStart();
        if (this.mSilenceDurationMs > 0L) {
            this.mCondVar.block(this.mSilenceDurationMs);
        }
        this.getDispatcher().dispatchOnDone();
    }

    void stop(boolean isError) {
        this.mCondVar.open();
    }
}

