/*
 * Decompiled with CFR 0.152.
 */
package android.speech.srec;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;

public final class Recognizer {
    private static String TAG;
    public static final String KEY_CONFIDENCE = "conf";
    public static final String KEY_LITERAL = "literal";
    public static final String KEY_MEANING = "meaning";
    private int mVocabulary = 0;
    private int mRecognizer = 0;
    private Grammar mActiveGrammar = null;
    private byte[] mPutAudioBuffer = null;
    public static final int EVENT_INVALID = 0;
    public static final int EVENT_NO_MATCH = 1;
    public static final int EVENT_INCOMPLETE = 2;
    public static final int EVENT_STARTED = 3;
    public static final int EVENT_STOPPED = 4;
    public static final int EVENT_START_OF_VOICING = 5;
    public static final int EVENT_END_OF_VOICING = 6;
    public static final int EVENT_SPOKE_TOO_SOON = 7;
    public static final int EVENT_RECOGNITION_RESULT = 8;
    public static final int EVENT_START_OF_UTTERANCE_TIMEOUT = 9;
    public static final int EVENT_RECOGNITION_TIMEOUT = 10;
    public static final int EVENT_NEED_MORE_AUDIO = 11;
    public static final int EVENT_MAX_SPEECH = 12;

    public static String getConfigDir(Locale locale) {
        String dir;
        if (locale == null) {
            locale = Locale.US;
        }
        if (new File(dir = "/system/usr/srec/config/" + locale.toString().replace('_', '.').toLowerCase(Locale.ROOT)).isDirectory()) {
            return dir;
        }
        return null;
    }

    public Recognizer(String configFile) throws IOException {
        Recognizer.PMemInit();
        Recognizer.SR_SessionCreate(configFile);
        this.mRecognizer = Recognizer.SR_RecognizerCreate();
        Recognizer.SR_RecognizerSetup(this.mRecognizer);
        this.mVocabulary = Recognizer.SR_VocabularyLoad();
    }

    public void start() {
        Recognizer.SR_RecognizerActivateRule(this.mRecognizer, this.mActiveGrammar.mGrammar, "trash", 1);
        Recognizer.SR_RecognizerStart(this.mRecognizer);
    }

    public int advance() {
        return Recognizer.SR_RecognizerAdvance(this.mRecognizer);
    }

    public int putAudio(byte[] buf, int offset, int length, boolean isLast) {
        return Recognizer.SR_RecognizerPutAudio(this.mRecognizer, buf, offset, length, isLast);
    }

    public void putAudio(InputStream audio) throws IOException {
        int nbytes;
        if (this.mPutAudioBuffer == null) {
            this.mPutAudioBuffer = new byte[512];
        }
        if ((nbytes = audio.read(this.mPutAudioBuffer)) == -1) {
            Recognizer.SR_RecognizerPutAudio(this.mRecognizer, this.mPutAudioBuffer, 0, 0, true);
        } else if (nbytes != Recognizer.SR_RecognizerPutAudio(this.mRecognizer, this.mPutAudioBuffer, 0, nbytes, false)) {
            throw new IOException("SR_RecognizerPutAudio failed nbytes=" + nbytes);
        }
    }

    public int getResultCount() {
        return Recognizer.SR_RecognizerResultGetSize(this.mRecognizer);
    }

    public String[] getResultKeys(int index) {
        return Recognizer.SR_RecognizerResultGetKeyList(this.mRecognizer, index);
    }

    public String getResult(int index, String key) {
        return Recognizer.SR_RecognizerResultGetValue(this.mRecognizer, index, key);
    }

    public void stop() {
        Recognizer.SR_RecognizerStop(this.mRecognizer);
        Recognizer.SR_RecognizerDeactivateRule(this.mRecognizer, this.mActiveGrammar.mGrammar, "trash");
    }

    public void resetAcousticState() {
        Recognizer.SR_AcousticStateReset(this.mRecognizer);
    }

    public void setAcousticState(String state) {
        Recognizer.SR_AcousticStateSet(this.mRecognizer, state);
    }

    public String getAcousticState() {
        return Recognizer.SR_AcousticStateGet(this.mRecognizer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            if (this.mVocabulary != 0) {
                Recognizer.SR_VocabularyDestroy(this.mVocabulary);
            }
        }
        finally {
            this.mVocabulary = 0;
            try {
                if (this.mRecognizer != 0) {
                    Recognizer.SR_RecognizerUnsetup(this.mRecognizer);
                }
            }
            finally {
                try {
                    if (this.mRecognizer != 0) {
                        Recognizer.SR_RecognizerDestroy(this.mRecognizer);
                    }
                }
                finally {
                    this.mRecognizer = 0;
                    try {
                        Recognizer.SR_SessionDestroy();
                    }
                    finally {
                        Recognizer.PMemShutdown();
                    }
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.mVocabulary != 0 || this.mRecognizer != 0) {
            this.destroy();
            throw new IllegalStateException("someone forgot to destroy Recognizer");
        }
    }

    private static native void PMemInit();

    private static native void PMemShutdown();

    private static native void SR_SessionCreate(String var0);

    private static native void SR_SessionDestroy();

    public static String eventToString(int event) {
        switch (event) {
            case 0: {
                return "EVENT_INVALID";
            }
            case 1: {
                return "EVENT_NO_MATCH";
            }
            case 2: {
                return "EVENT_INCOMPLETE";
            }
            case 3: {
                return "EVENT_STARTED";
            }
            case 4: {
                return "EVENT_STOPPED";
            }
            case 5: {
                return "EVENT_START_OF_VOICING";
            }
            case 6: {
                return "EVENT_END_OF_VOICING";
            }
            case 7: {
                return "EVENT_SPOKE_TOO_SOON";
            }
            case 8: {
                return "EVENT_RECOGNITION_RESULT";
            }
            case 9: {
                return "EVENT_START_OF_UTTERANCE_TIMEOUT";
            }
            case 10: {
                return "EVENT_RECOGNITION_TIMEOUT";
            }
            case 11: {
                return "EVENT_NEED_MORE_AUDIO";
            }
            case 12: {
                return "EVENT_MAX_SPEECH";
            }
        }
        return "EVENT_" + event;
    }

    private static native void SR_RecognizerStart(int var0);

    private static native void SR_RecognizerStop(int var0);

    private static native int SR_RecognizerCreate();

    private static native void SR_RecognizerDestroy(int var0);

    private static native void SR_RecognizerSetup(int var0);

    private static native void SR_RecognizerUnsetup(int var0);

    private static native boolean SR_RecognizerIsSetup(int var0);

    private static native String SR_RecognizerGetParameter(int var0, String var1);

    private static native int SR_RecognizerGetSize_tParameter(int var0, String var1);

    private static native boolean SR_RecognizerGetBoolParameter(int var0, String var1);

    private static native void SR_RecognizerSetParameter(int var0, String var1, String var2);

    private static native void SR_RecognizerSetSize_tParameter(int var0, String var1, int var2);

    private static native void SR_RecognizerSetBoolParameter(int var0, String var1, boolean var2);

    private static native void SR_RecognizerSetupRule(int var0, int var1, String var2);

    private static native boolean SR_RecognizerHasSetupRules(int var0);

    private static native void SR_RecognizerActivateRule(int var0, int var1, String var2, int var3);

    private static native void SR_RecognizerDeactivateRule(int var0, int var1, String var2);

    private static native void SR_RecognizerDeactivateAllRules(int var0);

    private static native boolean SR_RecognizerIsActiveRule(int var0, int var1, String var2);

    private static native boolean SR_RecognizerCheckGrammarConsistency(int var0, int var1);

    private static native int SR_RecognizerPutAudio(int var0, byte[] var1, int var2, int var3, boolean var4);

    private static native int SR_RecognizerAdvance(int var0);

    private static native boolean SR_RecognizerIsSignalClipping(int var0);

    private static native boolean SR_RecognizerIsSignalDCOffset(int var0);

    private static native boolean SR_RecognizerIsSignalNoisy(int var0);

    private static native boolean SR_RecognizerIsSignalTooQuiet(int var0);

    private static native boolean SR_RecognizerIsSignalTooFewSamples(int var0);

    private static native boolean SR_RecognizerIsSignalTooManySamples(int var0);

    private static native void SR_AcousticStateReset(int var0);

    private static native void SR_AcousticStateSet(int var0, String var1);

    private static native String SR_AcousticStateGet(int var0);

    private static native void SR_GrammarCompile(int var0);

    private static native void SR_GrammarAddWordToSlot(int var0, String var1, String var2, String var3, int var4, String var5);

    private static native void SR_GrammarResetAllSlots(int var0);

    private static native void SR_GrammarSetupVocabulary(int var0, int var1);

    private static native void SR_GrammarSetupRecognizer(int var0, int var1);

    private static native void SR_GrammarUnsetupRecognizer(int var0);

    private static native int SR_GrammarCreate();

    private static native void SR_GrammarDestroy(int var0);

    private static native int SR_GrammarLoad(String var0);

    private static native void SR_GrammarSave(int var0, String var1);

    private static native void SR_GrammarAllowOnly(int var0, String var1);

    private static native void SR_GrammarAllowAll(int var0);

    private static native int SR_VocabularyLoad();

    private static native void SR_VocabularyDestroy(int var0);

    private static native String SR_VocabularyGetPronunciation(int var0, String var1);

    private static native byte[] SR_RecognizerResultGetWaveform(int var0);

    private static native int SR_RecognizerResultGetSize(int var0);

    private static native int SR_RecognizerResultGetKeyCount(int var0, int var1);

    private static native String[] SR_RecognizerResultGetKeyList(int var0, int var1);

    private static native String SR_RecognizerResultGetValue(int var0, int var1, String var2);

    static {
        System.loadLibrary("srec_jni");
        TAG = "Recognizer";
    }

    public class Grammar {
        private int mGrammar = 0;

        public Grammar(String g2gFileName) throws IOException {
            this.mGrammar = Recognizer.SR_GrammarLoad(g2gFileName);
            Recognizer.SR_GrammarSetupVocabulary(this.mGrammar, Recognizer.this.mVocabulary);
        }

        public void resetAllSlots() {
            Recognizer.SR_GrammarResetAllSlots(this.mGrammar);
        }

        public void addWordToSlot(String slot, String word, String pron, int weight, String tag) {
            Recognizer.SR_GrammarAddWordToSlot(this.mGrammar, slot, word, pron, weight, tag);
        }

        public void compile() {
            Recognizer.SR_GrammarCompile(this.mGrammar);
        }

        public void setupRecognizer() {
            Recognizer.SR_GrammarSetupRecognizer(this.mGrammar, Recognizer.this.mRecognizer);
            Recognizer.this.mActiveGrammar = this;
        }

        public void save(String g2gFileName) throws IOException {
            Recognizer.SR_GrammarSave(this.mGrammar, g2gFileName);
        }

        public void destroy() {
            if (this.mGrammar != 0) {
                Recognizer.SR_GrammarDestroy(this.mGrammar);
                this.mGrammar = 0;
            }
        }

        protected void finalize() {
            if (this.mGrammar != 0) {
                this.destroy();
                throw new IllegalStateException("someone forgot to destroy Grammar");
            }
        }
    }
}

