/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.FieldPacker;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RenderScript;
import android.renderscript.Script;
import android.renderscript.ScriptIntrinsic;

public final class ScriptIntrinsicHistogram
extends ScriptIntrinsic {
    private Allocation mOut;

    private ScriptIntrinsicHistogram(int id2, RenderScript rs) {
        super(id2, rs);
    }

    public static ScriptIntrinsicHistogram create(RenderScript rs, Element e) {
        if (!(e.isCompatible(Element.U8_4(rs)) || e.isCompatible(Element.U8_3(rs)) || e.isCompatible(Element.U8_2(rs)) || e.isCompatible(Element.U8(rs)))) {
            throw new RSIllegalArgumentException("Unsuported element type.");
        }
        int id2 = rs.nScriptIntrinsicCreate(9, e.getID(rs));
        ScriptIntrinsicHistogram sib = new ScriptIntrinsicHistogram(id2, rs);
        return sib;
    }

    public void forEach(Allocation ain) {
        if (ain.getType().getElement().getVectorSize() < this.mOut.getType().getElement().getVectorSize()) {
            throw new RSIllegalArgumentException("Input vector size must be >= output vector size.");
        }
        if (ain.getType().getElement().isCompatible(Element.U8(this.mRS)) && ain.getType().getElement().isCompatible(Element.U8_4(this.mRS))) {
            throw new RSIllegalArgumentException("Output type must be U32 or I32.");
        }
        this.forEach(0, ain, null, null);
    }

    public void setDotCoefficients(float r, float g, float b, float a) {
        if (r < 0.0f || g < 0.0f || b < 0.0f || a < 0.0f) {
            throw new RSIllegalArgumentException("Coefficient may not be negative.");
        }
        if (r + g + b + a > 1.0f) {
            throw new RSIllegalArgumentException("Sum of coefficients must be 1.0 or less.");
        }
        FieldPacker fp = new FieldPacker(16);
        fp.addF32(r);
        fp.addF32(g);
        fp.addF32(b);
        fp.addF32(a);
        this.setVar(0, fp);
    }

    public void setOutput(Allocation aout) {
        this.mOut = aout;
        if (this.mOut.getType().getElement() != Element.U32(this.mRS) && this.mOut.getType().getElement() != Element.U32_2(this.mRS) && this.mOut.getType().getElement() != Element.U32_3(this.mRS) && this.mOut.getType().getElement() != Element.U32_4(this.mRS) && this.mOut.getType().getElement() != Element.I32(this.mRS) && this.mOut.getType().getElement() != Element.I32_2(this.mRS) && this.mOut.getType().getElement() != Element.I32_3(this.mRS) && this.mOut.getType().getElement() != Element.I32_4(this.mRS)) {
            throw new RSIllegalArgumentException("Output type must be U32 or I32.");
        }
        if (this.mOut.getType().getX() != 256 || this.mOut.getType().getY() != 0 || this.mOut.getType().hasMipmaps() || this.mOut.getType().getYuv() != 0) {
            throw new RSIllegalArgumentException("Output must be 1D, 256 elements.");
        }
        this.setVar(1, aout);
    }

    public void forEach_Dot(Allocation ain) {
        if (this.mOut.getType().getElement().getVectorSize() != 1) {
            throw new RSIllegalArgumentException("Output vector size must be one.");
        }
        if (ain.getType().getElement().isCompatible(Element.U8(this.mRS)) && ain.getType().getElement().isCompatible(Element.U8_4(this.mRS))) {
            throw new RSIllegalArgumentException("Output type must be U32 or I32.");
        }
        this.forEach(1, ain, null, null);
    }

    public Script.KernelID getKernelID_Separate() {
        return this.createKernelID(0, 3, null, null);
    }

    public Script.FieldID getFieldID_Input() {
        return this.createFieldID(1, null);
    }
}

