/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.content.pm.ProviderInfo;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.graphics.Point;
import android.net.Uri;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.provider.DocumentsContract;
import android.util.Log;
import java.io.FileNotFoundException;
import libcore.io.IoUtils;

public abstract class DocumentsProvider
extends ContentProvider {
    private static final String TAG = "DocumentsProvider";
    private static final int MATCH_ROOTS = 1;
    private static final int MATCH_ROOT = 2;
    private static final int MATCH_RECENT = 3;
    private static final int MATCH_SEARCH = 4;
    private static final int MATCH_DOCUMENT = 5;
    private static final int MATCH_CHILDREN = 6;
    private String mAuthority;
    private UriMatcher mMatcher;

    public void attachInfo(Context context, ProviderInfo info) {
        this.mAuthority = info.authority;
        this.mMatcher = new UriMatcher(-1);
        this.mMatcher.addURI(this.mAuthority, "root", 1);
        this.mMatcher.addURI(this.mAuthority, "root/*", 2);
        this.mMatcher.addURI(this.mAuthority, "root/*/recent", 3);
        this.mMatcher.addURI(this.mAuthority, "root/*/search", 4);
        this.mMatcher.addURI(this.mAuthority, "document/*", 5);
        this.mMatcher.addURI(this.mAuthority, "document/*/children", 6);
        if (!info.exported) {
            throw new SecurityException("Provider must be exported");
        }
        if (!info.grantUriPermissions) {
            throw new SecurityException("Provider must grantUriPermissions");
        }
        if (!"android.permission.MANAGE_DOCUMENTS".equals(info.readPermission) || !"android.permission.MANAGE_DOCUMENTS".equals(info.writePermission)) {
            throw new SecurityException("Provider must be protected by MANAGE_DOCUMENTS");
        }
        super.attachInfo(context, info);
    }

    public String createDocument(String parentDocumentId, String mimeType, String displayName) throws FileNotFoundException {
        throw new UnsupportedOperationException("Create not supported");
    }

    public void deleteDocument(String documentId) throws FileNotFoundException {
        throw new UnsupportedOperationException("Delete not supported");
    }

    public abstract Cursor queryRoots(String[] var1) throws FileNotFoundException;

    public Cursor queryRecentDocuments(String rootId, String[] projection) throws FileNotFoundException {
        throw new UnsupportedOperationException("Recent not supported");
    }

    public abstract Cursor queryDocument(String var1, String[] var2) throws FileNotFoundException;

    public abstract Cursor queryChildDocuments(String var1, String[] var2, String var3) throws FileNotFoundException;

    public Cursor queryChildDocumentsForManage(String parentDocumentId, String[] projection, String sortOrder) throws FileNotFoundException {
        throw new UnsupportedOperationException("Manage not supported");
    }

    public Cursor querySearchDocuments(String rootId, String query, String[] projection) throws FileNotFoundException {
        throw new UnsupportedOperationException("Search not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDocumentType(String documentId) throws FileNotFoundException {
        Cursor cursor = this.queryDocument(documentId, null);
        try {
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(cursor.getColumnIndexOrThrow("mime_type"));
                return string2;
            }
            String string3 = null;
            return string3;
        }
        finally {
            IoUtils.closeQuietly(cursor);
        }
    }

    public abstract ParcelFileDescriptor openDocument(String var1, String var2, CancellationSignal var3) throws FileNotFoundException;

    public AssetFileDescriptor openDocumentThumbnail(String documentId, Point sizeHint, CancellationSignal signal) throws FileNotFoundException {
        throw new UnsupportedOperationException("Thumbnails not supported");
    }

    public final Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        try {
            switch (this.mMatcher.match(uri)) {
                case 1: {
                    return this.queryRoots(projection);
                }
                case 3: {
                    return this.queryRecentDocuments(DocumentsContract.getRootId(uri), projection);
                }
                case 4: {
                    return this.querySearchDocuments(DocumentsContract.getRootId(uri), DocumentsContract.getSearchDocumentsQuery(uri), projection);
                }
                case 5: {
                    return this.queryDocument(DocumentsContract.getDocumentId(uri), projection);
                }
                case 6: {
                    if (DocumentsContract.isManageMode(uri)) {
                        return this.queryChildDocumentsForManage(DocumentsContract.getDocumentId(uri), projection, sortOrder);
                    }
                    return this.queryChildDocuments(DocumentsContract.getDocumentId(uri), projection, sortOrder);
                }
            }
            throw new UnsupportedOperationException("Unsupported Uri " + uri);
        }
        catch (FileNotFoundException e) {
            Log.w(TAG, "Failed during query", e);
            return null;
        }
    }

    public final String getType(Uri uri) {
        try {
            switch (this.mMatcher.match(uri)) {
                case 2: {
                    return "vnd.android.document/root";
                }
                case 5: {
                    return this.getDocumentType(DocumentsContract.getDocumentId(uri));
                }
            }
            return null;
        }
        catch (FileNotFoundException e) {
            Log.w(TAG, "Failed during getType", e);
            return null;
        }
    }

    public final Uri insert(Uri uri, ContentValues values) {
        throw new UnsupportedOperationException("Insert not supported");
    }

    public final int delete(Uri uri, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("Delete not supported");
    }

    public final int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("Update not supported");
    }

    public Bundle call(String method, String arg, Bundle extras) {
        Bundle out;
        block7: {
            boolean callerHasManage;
            Context context = this.getContext();
            if (!method.startsWith("android:")) {
                return super.call(method, arg, extras);
            }
            String documentId = extras.getString("document_id");
            Uri documentUri = DocumentsContract.buildDocumentUri(this.mAuthority, documentId);
            boolean bl = callerHasManage = context.checkCallingOrSelfPermission("android.permission.MANAGE_DOCUMENTS") == 0;
            if (!callerHasManage) {
                this.getContext().enforceCallingOrSelfUriPermission(documentUri, 2, method);
            }
            out = new Bundle();
            try {
                if ("android:createDocument".equals(method)) {
                    String mimeType = extras.getString("mime_type");
                    String displayName = extras.getString("_display_name");
                    String newDocumentId = this.createDocument(documentId, mimeType, displayName);
                    out.putString("document_id", newDocumentId);
                    if (!callerHasManage) {
                        Uri newDocumentUri = DocumentsContract.buildDocumentUri(this.mAuthority, newDocumentId);
                        context.grantUriPermission(this.getCallingPackage(), newDocumentUri, 67);
                    }
                    break block7;
                }
                if ("android:deleteDocument".equals(method)) {
                    this.deleteDocument(documentId);
                    context.revokeUriPermission(documentUri, 67);
                    break block7;
                }
                throw new UnsupportedOperationException("Method not supported " + method);
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Failed call " + method, e);
            }
        }
        return out;
    }

    public final ParcelFileDescriptor openFile(Uri uri, String mode) throws FileNotFoundException {
        return this.openDocument(DocumentsContract.getDocumentId(uri), mode, null);
    }

    public final ParcelFileDescriptor openFile(Uri uri, String mode, CancellationSignal signal) throws FileNotFoundException {
        return this.openDocument(DocumentsContract.getDocumentId(uri), mode, signal);
    }

    public final AssetFileDescriptor openTypedAssetFile(Uri uri, String mimeTypeFilter, Bundle opts) throws FileNotFoundException {
        if (opts != null && opts.containsKey("thumbnail_size")) {
            Point sizeHint = (Point)opts.getParcelable("thumbnail_size");
            return this.openDocumentThumbnail(DocumentsContract.getDocumentId(uri), sizeHint, null);
        }
        return super.openTypedAssetFile(uri, mimeTypeFilter, opts);
    }

    public final AssetFileDescriptor openTypedAssetFile(Uri uri, String mimeTypeFilter, Bundle opts, CancellationSignal signal) throws FileNotFoundException {
        if (opts != null && opts.containsKey("thumbnail_size")) {
            Point sizeHint = (Point)opts.getParcelable("thumbnail_size");
            return this.openDocumentThumbnail(DocumentsContract.getDocumentId(uri), sizeHint, signal);
        }
        return super.openTypedAssetFile(uri, mimeTypeFilter, opts, signal);
    }
}

