/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.BaseNetworkStateTracker;
import android.net.LinkCapabilities;
import android.net.LinkProperties;
import android.net.LinkQualityInfo;
import android.net.NetworkInfo;
import android.net.SamplingDataTracker;
import android.net.WifiLinkQualityInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Handler;
import android.os.Message;
import android.os.Messenger;
import android.util.Slog;
import java.util.concurrent.atomic.AtomicBoolean;

public class WifiStateTracker
extends BaseNetworkStateTracker {
    private static final String NETWORKTYPE = "WIFI";
    private static final String TAG = "WifiStateTracker";
    private static final boolean LOGV = true;
    private AtomicBoolean mTeardownRequested = new AtomicBoolean(false);
    private AtomicBoolean mPrivateDnsRouteSet = new AtomicBoolean(false);
    private AtomicBoolean mDefaultRouteSet = new AtomicBoolean(false);
    private NetworkInfo.State mLastState = NetworkInfo.State.UNKNOWN;
    private WifiInfo mWifiInfo;
    private Handler mCsHandler;
    private BroadcastReceiver mWifiStateReceiver;
    private WifiManager mWifiManager;
    private SamplingDataTracker mSamplingDataTracker = new SamplingDataTracker();

    public WifiStateTracker(int netType, String networkName) {
        this.mNetworkInfo = new NetworkInfo(netType, 0, networkName, "");
        this.mLinkProperties = new LinkProperties();
        this.mLinkCapabilities = new LinkCapabilities();
        this.mNetworkInfo.setIsAvailable(false);
        this.setTeardownRequested(false);
    }

    public void setTeardownRequested(boolean isRequested) {
        this.mTeardownRequested.set(isRequested);
    }

    public boolean isTeardownRequested() {
        return this.mTeardownRequested.get();
    }

    public void startMonitoring(Context context, Handler target) {
        this.mCsHandler = target;
        this.mContext = context;
        this.mWifiManager = (WifiManager)this.mContext.getSystemService("wifi");
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.wifi.STATE_CHANGE");
        filter.addAction("android.net.wifi.LINK_CONFIGURATION_CHANGED");
        this.mWifiStateReceiver = new WifiStateReceiver();
        this.mContext.registerReceiver(this.mWifiStateReceiver, filter);
    }

    public boolean teardown() {
        this.mTeardownRequested.set(true);
        this.mWifiManager.stopWifi();
        return true;
    }

    public boolean reconnect() {
        this.mTeardownRequested.set(false);
        this.mWifiManager.startWifi();
        return true;
    }

    public void captivePortalCheckComplete() {
        this.mWifiManager.captivePortalCheckComplete();
    }

    public void captivePortalCheckCompleted(boolean isCaptivePortal) {
    }

    public boolean setRadio(boolean turnOn) {
        this.mWifiManager.setWifiEnabled(turnOn);
        return true;
    }

    public boolean isAvailable() {
        return this.mNetworkInfo.isAvailable();
    }

    public void setUserDataEnable(boolean enabled) {
        Slog.w(TAG, "ignoring setUserDataEnable(" + enabled + ")");
    }

    public void setPolicyDataEnable(boolean enabled) {
    }

    public boolean isPrivateDnsRouteSet() {
        return this.mPrivateDnsRouteSet.get();
    }

    public void privateDnsRouteSet(boolean enabled) {
        this.mPrivateDnsRouteSet.set(enabled);
    }

    public NetworkInfo getNetworkInfo() {
        return new NetworkInfo(this.mNetworkInfo);
    }

    public LinkProperties getLinkProperties() {
        return new LinkProperties(this.mLinkProperties);
    }

    public LinkCapabilities getLinkCapabilities() {
        return new LinkCapabilities(this.mLinkCapabilities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkQualityInfo getLinkQualityInfo() {
        if (this.mNetworkInfo == null) {
            return null;
        }
        WifiLinkQualityInfo li = new WifiLinkQualityInfo();
        li.setNetworkType(this.mNetworkInfo.getType());
        Object object = this.mSamplingDataTracker.mSamplingDataLock;
        synchronized (object) {
            this.mSamplingDataTracker.setCommonLinkQualityInfoFields(li);
            li.setTxGood(this.mSamplingDataTracker.getSampledTxPacketCount());
            li.setTxBad(this.mSamplingDataTracker.getSampledTxPacketErrorCount());
        }
        if (this.mWifiInfo != null) {
            li.setBssid(this.mWifiInfo.getBSSID());
            int rssi = this.mWifiInfo.getRssi();
            li.setRssi(rssi);
            li.setNormalizedSignalStrength(WifiManager.calculateSignalLevel(rssi, 100));
        }
        return li;
    }

    public boolean isDefaultRouteSet() {
        return this.mDefaultRouteSet.get();
    }

    public void defaultRouteSet(boolean enabled) {
        this.mDefaultRouteSet.set(enabled);
    }

    public String getTcpBufferSizesPropName() {
        return "net.tcp.buffersize.wifi";
    }

    public void setDependencyMet(boolean met) {
    }

    public void addStackedLink(LinkProperties link) {
        this.mLinkProperties.addStackedLink(link);
    }

    public void removeStackedLink(LinkProperties link) {
        this.mLinkProperties.removeStackedLink(link);
    }

    public void supplyMessenger(Messenger messenger) {
    }

    public void startSampling(SamplingDataTracker.SamplingSnapshot s) {
        this.mSamplingDataTracker.startSampling(s);
    }

    public void stopSampling(SamplingDataTracker.SamplingSnapshot s) {
        this.mSamplingDataTracker.stopSampling(s);
    }

    private class WifiStateReceiver
    extends BroadcastReceiver {
        private WifiStateReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.net.wifi.STATE_CHANGE")) {
                WifiStateTracker.this.mNetworkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                WifiStateTracker.this.mLinkProperties = (LinkProperties)intent.getParcelableExtra("linkProperties");
                if (WifiStateTracker.this.mLinkProperties == null) {
                    WifiStateTracker.this.mLinkProperties = new LinkProperties();
                }
                WifiStateTracker.this.mLinkCapabilities = (LinkCapabilities)intent.getParcelableExtra("linkCapabilities");
                if (WifiStateTracker.this.mLinkCapabilities == null) {
                    WifiStateTracker.this.mLinkCapabilities = new LinkCapabilities();
                }
                WifiStateTracker.this.mWifiInfo = (WifiInfo)intent.getParcelableExtra("wifiInfo");
                NetworkInfo.State state = WifiStateTracker.this.mNetworkInfo.getState();
                if (WifiStateTracker.this.mLastState == state && WifiStateTracker.this.mNetworkInfo.getDetailedState() != NetworkInfo.DetailedState.CAPTIVE_PORTAL_CHECK) {
                    return;
                }
                WifiStateTracker.this.mLastState = state;
                WifiStateTracker.this.mSamplingDataTracker.resetSamplingData();
                Message msg = WifiStateTracker.this.mCsHandler.obtainMessage(458752, new NetworkInfo(WifiStateTracker.this.mNetworkInfo));
                msg.sendToTarget();
            } else if (intent.getAction().equals("android.net.wifi.LINK_CONFIGURATION_CHANGED")) {
                WifiStateTracker.this.mLinkProperties = (LinkProperties)intent.getParcelableExtra("linkProperties");
                Message msg = WifiStateTracker.this.mCsHandler.obtainMessage(458753, WifiStateTracker.this.mNetworkInfo);
                msg.sendToTarget();
            }
        }
    }
}

